/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core.phrase;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;

public class SimplePhraseModifier
extends PatternBasedElement {
    private final String delimiter;
    private final DocumentBuilder.SpanType spanType;

    public SimplePhraseModifier(String delimiter, DocumentBuilder.SpanType spanType) {
        this.delimiter = delimiter;
        this.spanType = spanType;
    }

    protected String getPattern(int groupOffset) {
        String quotedDelimiter = Pattern.quote(this.delimiter);
        return String.valueOf(quotedDelimiter) + " *" + "(.+?)" + " *" + quotedDelimiter;
    }

    protected int getPatternGroupCount() {
        return 1;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new CodePhraseModifierProcessor();
    }

    private class CodePhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private CodePhraseModifierProcessor() {
        }

        public void emit() {
            String content = this.group(1);
            this.getBuilder().beginSpan(SimplePhraseModifier.this.spanType, new Attributes());
            this.getMarkupLanguage().emitMarkupText(this.parser, this.state, content);
            this.getBuilder().endSpan();
        }
    }
}

