/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.processtreekiller;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.netbeans.processtreekiller.EnvVars;
import org.netbeans.processtreekiller.LinuxSystem;
import org.netbeans.processtreekiller.UnixProcess;

class LinuxProcess
extends UnixProcess<LinuxProcess> {
    private final int pid;
    private int ppid = -1;
    private EnvVars envVars;
    private List<String> arguments;

    LinuxProcess(LinuxSystem system, int pid) throws IOException {
        super(system);
        this.pid = pid;
        try (BufferedReader r = new BufferedReader(new FileReader(this.getFile("status")));){
            String line;
            while ((line = r.readLine()) != null) {
                if (!(line = line.toLowerCase(Locale.ENGLISH)).startsWith("ppid:")) continue;
                this.ppid = Integer.parseInt(line.substring(5).trim());
                break;
            }
        }
        if (this.ppid == -1) {
            throw new IOException("Failed to parse PPID from /proc/" + pid + "/status");
        }
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    public LinuxProcess getParent() {
        return (LinuxProcess)this.system.get(this.ppid);
    }

    @Override
    public synchronized List<String> getArguments() {
        if (this.arguments != null) {
            return this.arguments;
        }
        this.arguments = new ArrayList<String>();
        try {
            byte[] cmdline = Files.readAllBytes(this.getPath("cmdline"));
            int pos = 0;
            for (int i = 0; i < cmdline.length; ++i) {
                byte b = cmdline[i];
                if (b != 0) continue;
                this.arguments.add(new String(cmdline, pos, i - pos));
                pos = i + 1;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.arguments = Collections.unmodifiableList(this.arguments);
        return this.arguments;
    }

    @Override
    public synchronized EnvVars getEnvVars() {
        if (this.envVars != null) {
            return this.envVars;
        }
        this.envVars = new EnvVars();
        try {
            byte[] environ = Files.readAllBytes(this.getPath("environ"));
            int pos = 0;
            for (int i = 0; i < environ.length; ++i) {
                byte b = environ[i];
                if (b != 0) continue;
                this.envVars.addLine(new String(environ, pos, i - pos));
                pos = i + 1;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.envVars;
    }
}

