/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.ui.logicalview;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.karma.exec.KarmaServers;
import org.netbeans.modules.javascript.karma.exec.KarmaServersListener;
import org.netbeans.modules.javascript.karma.preferences.KarmaPreferences;
import org.netbeans.modules.javascript.karma.preferences.KarmaPreferencesValidator;
import org.netbeans.modules.javascript.karma.ui.logicalview.Bundle;
import org.netbeans.modules.javascript.karma.util.FileUtils;
import org.netbeans.modules.javascript.karma.util.KarmaUtils;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class KarmaChildrenList
implements NodeList<Node>,
PreferenceChangeListener {
    static final Logger LOGGER = Logger.getLogger(KarmaChildrenList.class.getName());
    private final Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public KarmaChildrenList(Project project) {
        assert (project != null);
        this.project = project;
    }

    public List<Node> keys() {
        if (KarmaPreferences.isEnabled(this.project)) {
            return Collections.singletonList(KarmaNode.create(this.project));
        }
        return Collections.emptyList();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public Node node(Node key) {
        return key;
    }

    public void addNotify() {
        KarmaPreferences.addPreferenceChangeListener(this.project, (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, KarmaPreferences.class));
    }

    public void removeNotify() {
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (!KarmaPreferences.isDebug(this.project)) {
            KarmaServers.getInstance().closeDebugUrl(this.project);
        }
        if (KarmaServers.getInstance().isServerRunning(this.project)) {
            ValidationResult result;
            KarmaServers.getInstance().stopServer(this.project, false);
            if (KarmaPreferences.isEnabled(this.project) && (result = new KarmaPreferencesValidator().validate(this.project).getResult()).isFaultless()) {
                KarmaServers.getInstance().startServer(this.project);
            }
        }
        this.changeSupport.fireChange();
    }

    private static abstract class BaseNodeAction
    extends NodeAction {
        private BaseNodeAction() {
        }

        protected abstract void performAction(Project var1);

        protected abstract boolean enable(Project var1);

        protected final void performAction(Node[] activatedNodes) {
            Project project = this.getProject(activatedNodes);
            if (project == null) {
                LOGGER.fine("No project found -> no karma action performed");
                return;
            }
            this.performAction(project);
        }

        protected final boolean enable(Node[] activatedNodes) {
            Project project = this.getProject(activatedNodes);
            if (project == null) {
                LOGGER.fine("No project found -> no karma action enabled");
                return false;
            }
            return this.enable(project);
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return false;
        }

        @CheckForNull
        private Project getProject(Node[] activatedNodes) {
            if (activatedNodes.length != 1) {
                return null;
            }
            Node node = activatedNodes[0];
            return (Project)node.getLookup().lookup(Project.class);
        }
    }

    private static final class CustomizeKarmaAction
    extends BaseNodeAction {
        @Override
        protected void performAction(Project project) {
            ((CustomizerProvider2)project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer("JS_TESTING", null);
        }

        @Override
        protected boolean enable(Project project) {
            return true;
        }

        public String getName() {
            return Bundle.CustomizeKarmaAction_name();
        }
    }

    private static final class ConfigMenu
    extends JMenu
    implements DynamicMenuContent,
    ActionListener {
        final Project project;

        private ConfigMenu(Lookup actionContext) {
            assert (actionContext != null);
            this.project = (Project)actionContext.lookup(Project.class);
            assert (this.project != null) : "Project expected in lookup: " + actionContext;
        }

        public static ConfigMenu create(Lookup actionContext) {
            ConfigMenu configMenu = new ConfigMenu(actionContext);
            Mnemonics.setLocalizedText((AbstractButton)configMenu, (String)Bundle.ActiveKarmaConfigAction_name());
            return configMenu;
        }

        public JComponent[] getMenuPresenters() {
            this.removeAll();
            File configDir = KarmaUtils.getKarmaConfigDir(this.project);
            List<File> configs = KarmaUtils.findKarmaConfigs(configDir);
            if (configs.isEmpty()) {
                configs = KarmaUtils.findJsFiles(configDir);
            }
            if (!(configs = FileUtils.sortFiles(configs)).isEmpty()) {
                String activeConfig = KarmaPreferences.getConfig(this.project);
                for (final File config : configs) {
                    boolean selected = config.getAbsolutePath().equals(activeConfig);
                    JRadioButtonMenuItem configItem = new JRadioButtonMenuItem(config.getName(), selected);
                    configItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            KarmaPreferences.setConfig(project, config.getAbsolutePath());
                        }
                    });
                    this.add(configItem);
                }
            } else {
                this.setEnabled(false);
            }
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }
    }

    private static final class ActiveKarmaConfigAction
    extends CallableSystemAction
    implements ContextAwareAction {
        public String getName() {
            return Bundle.ActiveKarmaConfigAction_name();
        }

        public void performAction() {
            assert (false);
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Action createContextAwareInstance(final Lookup actionContext) {
            class ActiveConfigAction
            extends AbstractAction
            implements Presenter.Popup {
                ActiveConfigAction() {
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    assert (false);
                }

                public JMenuItem getPopupPresenter() {
                    return ConfigMenu.create(actionContext);
                }
            }
            return new ActiveConfigAction();
        }
    }

    private static final class DebugKarmaServerAction
    extends CallableSystemAction
    implements ContextAwareAction {
        public String getName() {
            return Bundle.DebugKarmaServerAction_name();
        }

        public void performAction() {
            assert (false);
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            final class DebugAction
            extends AbstractAction
            implements Presenter.Popup {
                private final Project project;

                DebugAction(Lookup actionContext) {
                    this.project = (Project)actionContext.lookup(Project.class);
                    assert (this.project != null) : "Project expected in lookup: " + actionContext;
                    this.putValue("Name", Bundle.DebugKarmaServerAction_name());
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean originalDebug = KarmaPreferences.isDebug(this.project);
                    if (!originalDebug && !KarmaPreferences.isDebugBrowserIdSet(this.project)) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.DebugKarmaServerAction_browser_none()));
                        ((CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer("JS_TESTING", null);
                        return;
                    }
                    KarmaPreferences.setDebug(this.project, !originalDebug);
                }

                public JMenuItem getPopupPresenter() {
                    JCheckBoxMenuItem debugMenuItem = new JCheckBoxMenuItem(this);
                    debugMenuItem.setSelected(KarmaPreferences.isDebug(this.project));
                    return debugMenuItem;
                }
            }
            return new DebugAction(actionContext);
        }
    }

    private static final class RestartKarmaServerAction
    extends BaseNodeAction {
        @Override
        protected void performAction(Project project) {
            KarmaServers.getInstance().restartServer(project);
        }

        @Override
        protected boolean enable(Project project) {
            return KarmaServers.getInstance().isServerRunning(project);
        }

        public String getName() {
            return Bundle.RestartKarmaServerAction_name();
        }
    }

    private static final class StopKarmaServerAction
    extends BaseNodeAction {
        @Override
        protected void performAction(Project project) {
            KarmaServers.getInstance().stopServer(project, false);
        }

        @Override
        protected boolean enable(Project project) {
            return KarmaServers.getInstance().isServerRunning(project);
        }

        public String getName() {
            return Bundle.StopKarmaServerAction_name();
        }
    }

    private static final class StartKarmaServerAction
    extends BaseNodeAction {
        @Override
        protected void performAction(Project project) {
            KarmaServers.getInstance().startServer(project);
        }

        @Override
        protected boolean enable(Project project) {
            return !KarmaServers.getInstance().isServerRunning(project);
        }

        public String getName() {
            return Bundle.StartKarmaServerAction_name();
        }
    }

    private static final class KarmaNode
    extends AbstractNode
    implements KarmaServersListener {
        private static final String KARMA_ICON = "org/netbeans/modules/javascript/karma/ui/resources/karma.png";
        private static final String WAITING_BADGE = "org/netbeans/modules/javascript/karma/ui/resources/waiting.png";
        private static final String RUNNING_BADGE = "org/netbeans/modules/javascript/karma/ui/resources/running.png";
        private final Project project;

        private KarmaNode(Project project) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{project}));
            assert (project != null);
            this.project = project;
            this.setName("Karma");
            this.setDisplayName(Bundle.KarmaNode_displayName());
            this.setShortDescription(Bundle.KarmaNode_description());
            this.setIconBaseWithExtension(KARMA_ICON);
        }

        static KarmaNode create(Project project) {
            KarmaNode karmaNode = new KarmaNode(project);
            KarmaServers.getInstance().addKarmaServersListener(karmaNode);
            return karmaNode;
        }

        public void destroy() throws IOException {
            KarmaServers.getInstance().removeKarmaServersListener(this);
            super.destroy();
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get(StartKarmaServerAction.class), SystemAction.get(StopKarmaServerAction.class), SystemAction.get(RestartKarmaServerAction.class), null, SystemAction.get(DebugKarmaServerAction.class), null, SystemAction.get(ActiveKarmaConfigAction.class), null, SystemAction.get(CustomizeKarmaAction.class)};
        }

        public Image getIcon(int type) {
            return this.badgeIcon(super.getIcon(type));
        }

        public Image getOpenedIcon(int type) {
            return this.badgeIcon(super.getOpenedIcon(type));
        }

        private Image badgeIcon(Image origImg) {
            Image badge = null;
            if (KarmaServers.getInstance().isServerStarting(this.project)) {
                badge = ImageUtilities.loadImage((String)WAITING_BADGE);
            } else if (KarmaServers.getInstance().isServerStarted(this.project)) {
                badge = ImageUtilities.loadImage((String)RUNNING_BADGE);
            }
            return badge != null ? ImageUtilities.mergeImages((Image)origImg, (Image)badge, (int)15, (int)8) : origImg;
        }

        @Override
        public void serverStateChanged(Project project) {
            if (this.project.equals(project)) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
        }
    }
}

