/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.web.javascript.debugger.breakpoints.AbstractBreakpoint;
import org.openide.util.RequestProcessor;

public class PersistenceManager
extends DebuggerManagerAdapter
implements Runnable {
    public static final Logger LOGGER = Logger.getLogger(PersistenceManager.class.getName());
    private static final String DEBUGGER = "debugger";
    private static final String JAVASCRIPT = "javascript-debugger";
    private static final RequestProcessor RP = new RequestProcessor(PersistenceManager.class.getName());
    private RequestProcessor.Task saveTask;

    public Breakpoint[] initBreakpoints() {
        Properties p = Properties.getDefault().getProperties(DEBUGGER).getProperties("breakpoints");
        Breakpoint[] breakpoints = (Breakpoint[])p.getArray(JAVASCRIPT, (Object[])new Breakpoint[0]);
        ArrayList<Breakpoint> validBreakpoints = new ArrayList<Breakpoint>();
        for (Breakpoint breakpoint : breakpoints) {
            if (breakpoint != null) {
                breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                validBreakpoints.add(breakpoint);
                continue;
            }
            LOGGER.warning("null stored in the array obtained from \"javascript-debugger\" property");
        }
        return validBreakpoints.toArray(new Breakpoint[validBreakpoints.size()]);
    }

    public String[] getProperties() {
        return new String[]{"breakpointsInit", "breakpoints"};
    }

    private synchronized void scheduleSaveTask() {
        if (this.saveTask == null) {
            this.saveTask = RP.create((Runnable)new Store());
        }
        this.saveTask.schedule(500);
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.scheduleSaveTask();
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        this.scheduleSaveTask();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Breakpoint) {
            this.scheduleSaveTask();
        }
    }

    @Override
    public synchronized void run() {
        if (this.saveTask != null) {
            this.saveTask.waitFinished();
        }
    }

    private static class Store
    implements Runnable {
        private Properties properties = Properties.getDefault().getProperties("debugger").getProperties("breakpoints");

        private Store() {
        }

        @Override
        public void run() {
            this.properties.setArray(PersistenceManager.JAVASCRIPT, (Object[])this.getBreakpoints());
        }

        private Breakpoint[] getBreakpoints() {
            Breakpoint[] bpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
            ArrayList<Breakpoint> result = new ArrayList<Breakpoint>();
            for (Breakpoint breakpoint : bpoints) {
                if (!(breakpoint instanceof AbstractBreakpoint)) continue;
                result.add(breakpoint);
            }
            return result.toArray(new Breakpoint[result.size()]);
        }
    }
}

