/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.newproject;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.netbeans.modules.gradle.newproject.Bundle;
import org.netbeans.modules.gradle.newproject.SubProjectPanel;
import org.netbeans.modules.gradle.spi.newproject.BaseGradleWizardIterator;
import org.netbeans.modules.gradle.spi.newproject.TemplateOperation;
import org.openide.WizardDescriptor;

public class GradleMultiWizardIterator
extends BaseGradleWizardIterator {
    private static final long serialVersionUID = 1L;
    public static final String PROP_SUBPROJECTS = "subProjects";
    private static final String TEMPLATE_ROOT = "org/netbeans/modules/gradle/newproject/multi-root.gradle.template";
    private static final String TEMPLATE_SETTINGS = "org/netbeans/modules/gradle/newproject/multi-settings.gradle.template";
    private static final String TEMPLATE_BUILD = "org/netbeans/modules/gradle/newproject/multi-build.gradle.template";
    private static final String TEMPLATE_PROPS = "org/netbeans/modules/gradle/newproject/multi-gradle.properties.template";

    @Override
    protected List<? extends WizardDescriptor.Panel<WizardDescriptor>> createPanels() {
        return Arrays.asList(GradleMultiWizardIterator.createProjectAttributesPanel(null), new SubProjectPanel());
    }

    @Override
    protected String getTitle() {
        return Bundle.LBL_MultiProject();
    }

    @Override
    protected void collectOperations(TemplateOperation ops, Map<String, Object> params) {
        String name = (String)params.get("name");
        String packageBase = (String)params.get("packageBase");
        String sp = (String)params.get(PROP_SUBPROJECTS);
        Set<SubProject> subProjects = GradleMultiWizardIterator.parseSubProjects(sp);
        params.put(PROP_SUBPROJECTS, subProjects);
        File loc = (File)params.get("projdir");
        File root = new File(loc, name);
        ops.createFolder(root);
        ops.copyFromFile(TEMPLATE_PROPS, new File(root, "gradle.properties"), params);
        ops.copyFromFile(TEMPLATE_SETTINGS, new File(root, "settings.gradle"), params);
        ops.copyFromFile(TEMPLATE_ROOT, new File(root, "build.gradle"), params);
        for (SubProject subProject : subProjects) {
            HashMap<String, Object> subParams = new HashMap<String, Object>(params);
            subParams.put("subProject", subProject);
            File projectDir = new File(root, subProject.path);
            ops.createFolder(projectDir);
            ops.copyFromFile(TEMPLATE_BUILD, new File(projectDir, "build.gradle"), subParams);
            File mainJava = new File(projectDir, "src/main/java");
            if (packageBase.isEmpty()) continue;
            ops.createPackage(mainJava, packageBase + '.' + subProject.name);
        }
        ops.addProjectPreload(root);
        for (SubProject subProject : subProjects) {
            File projectDir = new File(root, subProject.path);
            ops.addProjectPreload(projectDir);
        }
        Boolean initWrapper = (Boolean)params.get("initWrapper");
        if (initWrapper != null && initWrapper.booleanValue()) {
            ops.addWrapperInit(root);
        }
    }

    private static Set<SubProject> parseSubProjects(String text) {
        LinkedHashSet<SubProject> ret = new LinkedHashSet<SubProject>();
        if (text != null) {
            String[] lines;
            for (String line : lines = text.split("\\n")) {
                if ((line = line.trim()).isEmpty()) continue;
                ret.add(new SubProject(line));
            }
        }
        return ret;
    }

    public static class SubProject {
        final String path;
        final String name;
        final String description;

        public SubProject(String definition) {
            String[] parts = definition.split("\\s+", 2);
            this.path = parts[0].replace('\\', '/');
            int pathSep = this.path.lastIndexOf(47);
            this.name = pathSep > 0 ? this.path.substring(pathSep + 1) : this.path;
            this.description = parts.length == 2 ? parts[1] : this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubProject other = (SubProject)obj;
            return Objects.equals(this.path, other.path);
        }
    }
}

