/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class PSR4Hint
extends HintRule {
    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = this.createVisitor(fileObject, context.doc);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getHints());
        }
    }

    abstract CheckVisitor createVisitor(FileObject var1, BaseDocument var2);

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    private static abstract class CheckVisitor
    extends DefaultVisitor {
        private final PSR4Hint psr4hint;
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final File file;
        private final List<Hint> hints;

        public CheckVisitor(PSR4Hint psr4hint, FileObject fileObject, BaseDocument baseDocument) {
            this.psr4hint = psr4hint;
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.file = FileUtil.toFile((FileObject)fileObject);
            this.hints = new ArrayList<Hint>();
        }

        public List<Hint> getHints() {
            return Collections.unmodifiableList(this.hints);
        }

        protected void createHint(ASTNode node, String message) {
            int endOffset = node.getEndOffset();
            this.createHint(node, message, endOffset);
        }

        protected void createHint(ASTNode node, String message, int endOffset) {
            OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), endOffset);
            if (this.psr4hint.showHint(offsetRange, this.baseDocument)) {
                this.hints.add(new Hint((Rule)this.psr4hint, Bundle.PSR4ViolationHintText(message), this.fileObject, offsetRange, null, 500));
            }
        }

        @CheckForNull
        protected File getFile() {
            return this.file;
        }
    }

    public static class TypeDeclarationHint
    extends PSR4Hint {
        private static final String HINT_ID = "PSR4.Hint.Type";

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new TypeVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.PSR4TypeHintDesc();
        }

        public String getDisplayName() {
            return Bundle.PSR4TypeHintDisp();
        }

        private static final class TypeVisitor
        extends CheckVisitor {
            private static final String PHP_FILE_EXTENSION = ".php";

            public TypeVisitor(PSR4Hint psr4hint, FileObject fileObject, BaseDocument baseDocument) {
                super(psr4hint, fileObject, baseDocument);
            }

            @Override
            public void visit(ClassDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processTypeDeclaration(node);
                super.visit(node);
            }

            @Override
            public void visit(InterfaceDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processTypeDeclaration(node);
                super.visit(node);
            }

            @Override
            public void visit(TraitDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processTypeDeclaration(node);
                super.visit(node);
            }

            private void processTypeDeclaration(TypeDeclaration node) {
                String currentTypeName;
                File file = this.getFile();
                if (file == null) {
                    return;
                }
                String filename = file.getName();
                if (!filename.equals((currentTypeName = CodeUtils.extractTypeName(node)) + PHP_FILE_EXTENSION)) {
                    Identifier name = node.getName();
                    this.createHint(name, Bundle.PSR4WrongTypeNameHintText());
                }
            }
        }
    }

    public static class NamespaceDeclarationHint
    extends PSR4Hint {
        private static final String HINT_ID = "PSR4.Hint.Namespace";

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new NamespaceVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.PSR4NamespaceHintDesc();
        }

        public String getDisplayName() {
            return Bundle.PSR4NamespaceHintDisp();
        }

        private static final class NamespaceVisitor
        extends CheckVisitor {
            public NamespaceVisitor(PSR4Hint psr4hint, FileObject fileObject, BaseDocument baseDocument) {
                super(psr4hint, fileObject, baseDocument);
            }

            @Override
            public void visit(NamespaceDeclaration node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                NamespaceName namespaceName = node.getName();
                if (namespaceName != null && this.getFile() != null) {
                    int endOffset = namespaceName.getEndOffset();
                    File currentDir = this.getFile().getParentFile();
                    ListIterator<Identifier> segmentsIterator = namespaceName.getSegments().listIterator(namespaceName.getSegments().size());
                    while (segmentsIterator.hasPrevious()) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        Identifier segment = segmentsIterator.previous();
                        if (!segment.getName().equals(currentDir.getName())) {
                            this.createHint(namespaceName, Bundle.PSR4WrongNamespaceNameHintText(), endOffset);
                            break;
                        }
                        endOffset -= currentDir.getName().length() + 1;
                        currentDir = currentDir.getParentFile();
                    }
                }
                super.visit(node);
            }
        }
    }
}

