/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrowFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.Dispatch;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MatchArm;
import org.netbeans.modules.php.editor.parser.astnodes.MatchExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamedArgument;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ThrowExpression;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public final class PHP80UnhandledError
extends UnhandledErrorRule {
    public String getDisplayName() {
        return Bundle.PHP80UnhandledError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && PHP80UnhandledError.appliesTo(fileObject)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            TokenSequence ts = phpParseResult.getSnapshot().getTokenHierarchy().tokenSequence(PHPTokenId.language());
            assert (ts != null);
            errors.addAll(checkVisitor.getErrors((TokenSequence<PHPTokenId>)ts));
        }
    }

    private static boolean appliesTo(FileObject fileObject) {
        return CodeUtils.isPhpVersionLessThan(fileObject, PhpVersion.PHP_80);
    }

    private static final class PHP80VersionError
    extends VerificationError {
        private static final String KEY = "Php.Version.80";

        private PHP80VersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.PHP80VersionError_displayName();
        }

        public String getDescription() {
            return Bundle.PHP80VersionError_description();
        }

        public String getKey() {
            return KEY;
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;
        private final List<ASTNode> lastParams = new ArrayList<ASTNode>();
        private final List<ASTNode> lastLexicalVariables = new ArrayList<ASTNode>();
        private boolean isSameAsThrowStatement = false;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<VerificationError> getErrors(TokenSequence<PHPTokenId> ts) {
            this.checkTrailingCommas(ts, this.lastParams);
            this.checkTrailingCommas(ts, this.lastLexicalVariables);
            return Collections.unmodifiableCollection(this.errors);
        }

        @Override
        public void visit(CatchClause node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkNonCapturingCatches(node);
            super.visit(node);
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.addLastParam(node.getFormalParameters());
            this.checkStaticReturnType(node.getReturnType());
            super.visit(node);
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.addLastParam(node.getFormalParameters());
            this.checkStaticReturnType(node.getReturnType());
            this.addLastLexicalVariable(node.getLexicalVariables());
            super.visit(node);
        }

        @Override
        public void visit(ArrowFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkStaticReturnType(node.getReturnType());
            super.visit(node);
        }

        @Override
        public void visit(ExpressionStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.getExpression() instanceof ThrowExpression) {
                this.isSameAsThrowStatement = true;
            }
            super.visit(node);
            this.isSameAsThrowStatement = false;
        }

        @Override
        public void visit(ThrowExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkThrowExpression(node);
            super.visit(node);
        }

        @Override
        public void visit(StaticConstantAccess node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkClassNameLiteralOnObject(node);
            super.visit(node);
        }

        @Override
        public void visit(MatchArm node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkMatchExpression(node);
            super.visit(node);
        }

        @Override
        public void visit(MatchExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkMatchExpression(node);
            super.visit(node);
        }

        @Override
        public void visit(UnionType node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkUnionType(node);
            super.visit(node);
        }

        @Override
        public void visit(FieldAccess node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkNullsafeOperator(node);
            super.visit(node);
        }

        @Override
        public void visit(MethodInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkNullsafeOperator(node);
            super.visit(node);
        }

        @Override
        public void visit(Attribute attribute) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkAttributeSyntax(attribute);
            super.visit(attribute);
        }

        @Override
        public void visit(FormalParameter node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkConstructorPropertyPromotion(node);
            super.visit(node);
        }

        @Override
        public void visit(NamedArgument node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkNamedArgument(node);
            super.visit(node);
        }

        private void addLastParam(List<FormalParameter> parameters) {
            if (!parameters.isEmpty()) {
                this.lastParams.add(parameters.get(parameters.size() - 1));
            }
        }

        private void addLastLexicalVariable(List<Expression> lexicalVariables) {
            if (!lexicalVariables.isEmpty()) {
                this.lastLexicalVariables.add(lexicalVariables.get(lexicalVariables.size() - 1));
            }
        }

        private void checkNonCapturingCatches(CatchClause node) {
            if (node.getVariable() == null) {
                this.createError(node);
            }
        }

        private void checkTrailingCommas(TokenSequence<PHPTokenId> ts, List<ASTNode> nodes) {
            if (!nodes.isEmpty()) {
                try {
                    nodes.forEach(node -> {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        Token<? extends PHPTokenId> token = this.findNextToken(ts, node.getEndOffset());
                        if (token != null && token.id() == PHPTokenId.PHP_TOKEN && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)",")) {
                            this.createError((ASTNode)node);
                        }
                    });
                }
                finally {
                    nodes.clear();
                }
            }
        }

        @CheckForNull
        private Token<? extends PHPTokenId> findNextToken(TokenSequence<PHPTokenId> ts, int startOffset) {
            ts.move(startOffset);
            if (!ts.moveNext()) {
                return null;
            }
            if (TokenUtilities.textEquals((CharSequence)ts.token().text(), (CharSequence)")")) {
                return null;
            }
            List<PHPTokenId> ignores = Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END);
            return LexUtilities.findNext(ts, ignores);
        }

        private void checkThrowExpression(Expression expression) {
            if (!this.isSameAsThrowStatement) {
                this.createError(expression);
            }
        }

        private void checkClassNameLiteralOnObject(StaticConstantAccess node) {
            Expression dispatcher;
            if ("class".equals(node.getConstantName().getName()) && !((dispatcher = node.getDispatcher()) instanceof NamespaceName) && !(dispatcher instanceof Identifier)) {
                this.createError(node);
            }
        }

        private void checkUnionType(UnionType node) {
            this.createError(node);
        }

        private void checkMatchExpression(MatchExpression node) {
            this.createError(node);
        }

        private void checkMatchExpression(MatchArm node) {
            this.createError(node);
        }

        private void checkStaticReturnType(Expression returnType) {
            Expression type = returnType;
            if (type instanceof NullableType) {
                type = ((NullableType)type).getType();
            }
            if (type instanceof Identifier && CheckVisitor.isStatic((Identifier)type)) {
                this.createError(returnType);
            }
        }

        private void checkNullsafeOperator(Dispatch dispatch) {
            if (dispatch.isNullsafe()) {
                this.createError(dispatch);
            }
        }

        private void checkAttributeSyntax(Attribute attribute) {
            this.createError(attribute);
        }

        private void checkConstructorPropertyPromotion(FormalParameter parameter) {
            if (parameter.getModifier() != 0) {
                this.createError(parameter);
            }
        }

        private void checkNamedArgument(NamedArgument namedArgument) {
            this.createError(namedArgument);
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add(new PHP80VersionError(this.fileObject, startOffset, endOffset));
        }

        private static boolean isStatic(Identifier identifier) {
            return "static".equals(identifier.getName());
        }
    }
}

