/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public abstract class BracesHint
extends HintRule {
    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = this.createVisitor(fileObject, context.doc);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            hints.addAll(checkVisitor.getHints());
        }
    }

    abstract CheckVisitor createVisitor(FileObject var1, BaseDocument var2);

    private static final class Fix
    implements HintFix {
        private final Statement node;
        private final Statement enclosingStatement;
        private final BaseDocument baseDocument;

        public Fix(Statement enclosingStatement, Statement node, BaseDocument baseDocument) {
            this.node = node;
            this.enclosingStatement = enclosingStatement;
            this.baseDocument = baseDocument;
        }

        public String getDescription() {
            return Bundle.AddBraces();
        }

        public void implement() throws Exception {
            int removeLength = this.enclosingStatement.getEndOffset() - this.enclosingStatement.getStartOffset();
            EditList editList = new EditList(this.baseDocument);
            editList.replace(this.enclosingStatement.getStartOffset(), removeLength, this.createReplaceText(), true, 0);
            editList.apply();
        }

        private String createReplaceText() throws BadLocationException {
            String leadingText = this.baseDocument.getText(this.enclosingStatement.getStartOffset(), this.node.getStartOffset() - this.enclosingStatement.getStartOffset());
            String middleText = this.baseDocument.getText(this.node.getStartOffset(), this.node.getEndOffset() - this.node.getStartOffset());
            String trailingText = this.baseDocument.getText(this.node.getEndOffset(), this.enclosingStatement.getEndOffset() - this.node.getEndOffset());
            return leadingText + "{\n" + middleText + "\n}" + trailingText;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static abstract class CheckVisitor
    extends DefaultVisitor {
        private final List<Hint> hints;
        private final BaseDocument baseDocument;
        private final FileObject fileObject;
        private final BracesHint bracesHint;

        private CheckVisitor(BracesHint bracesHint, FileObject fileObject, BaseDocument baseDocument) {
            this.bracesHint = bracesHint;
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.hints = new ArrayList<Hint>();
        }

        protected void addHint(Statement enclosingStatement, Statement node, String description) {
            OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (this.bracesHint.showHint(offsetRange, this.baseDocument)) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.hints.add(new Hint((Rule)this.bracesHint, description, this.fileObject, offsetRange, Collections.singletonList(new Fix(enclosingStatement, node, this.baseDocument)), 500));
            }
        }

        public List<Hint> getHints() {
            return this.hints;
        }
    }

    public static final class ForEachBracesHint
    extends BracesHint {
        private static final String HINT_ID = "ForEach.Braces.Hint";

        @Override
        protected CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new ForEachVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.ForEachBracesHintDesc();
        }

        public String getDisplayName() {
            return Bundle.ForEachBracesHintDisp();
        }

        private static final class ForEachVisitor
        extends CheckVisitor {
            public ForEachVisitor(BracesHint bracesHint, FileObject fileObject, BaseDocument baseDocument) {
                super(bracesHint, fileObject, baseDocument);
            }

            @Override
            public void visit(ForEachStatement node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                super.visit(node);
                Statement bodyStatement = node.getStatement();
                if (bodyStatement != null && !(bodyStatement instanceof Block)) {
                    this.addHint(node, bodyStatement, Bundle.ForEachBracesHintText());
                }
            }
        }
    }

    public static final class ForBracesHint
    extends BracesHint {
        private static final String HINT_ID = "For.Braces.Hint";

        @Override
        protected CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new ForVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.ForBracesHintDesc();
        }

        public String getDisplayName() {
            return Bundle.ForBracesHintDisp();
        }

        private static final class ForVisitor
        extends CheckVisitor {
            public ForVisitor(BracesHint bracesHint, FileObject fileObject, BaseDocument baseDocument) {
                super(bracesHint, fileObject, baseDocument);
            }

            @Override
            public void visit(ForStatement node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                super.visit(node);
                Statement bodyStatement = node.getBody();
                if (bodyStatement != null && !(bodyStatement instanceof Block)) {
                    this.addHint(node, bodyStatement, Bundle.ForBracesHintText());
                }
            }
        }
    }

    public static final class WhileBracesHint
    extends BracesHint {
        private static final String HINT_ID = "While.Braces.Hint";

        @Override
        protected CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new WhileVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.WhileBracesHintDesc();
        }

        public String getDisplayName() {
            return Bundle.WhileBracesHintDisp();
        }

        private static final class WhileVisitor
        extends CheckVisitor {
            public WhileVisitor(BracesHint bracesHint, FileObject fileObject, BaseDocument baseDocument) {
                super(bracesHint, fileObject, baseDocument);
            }

            @Override
            public void visit(WhileStatement node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                super.visit(node);
                Statement bodyStatement = node.getBody();
                if (bodyStatement != null && !(bodyStatement instanceof Block)) {
                    this.addHint(node, bodyStatement, Bundle.WhileBracesHintText());
                }
            }
        }
    }

    public static final class DoWhileBracesHint
    extends BracesHint {
        private static final String HINT_ID = "Do.While.Braces.Hint";

        @Override
        protected CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new DoWhileVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.DoWhileBracesHintDesc();
        }

        public String getDisplayName() {
            return Bundle.DoWhileBracesHintDisp();
        }

        private static final class DoWhileVisitor
        extends CheckVisitor {
            public DoWhileVisitor(BracesHint bracesHint, FileObject fileObject, BaseDocument baseDocument) {
                super(bracesHint, fileObject, baseDocument);
            }

            @Override
            public void visit(DoStatement node) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                super.visit(node);
                Statement bodyStatement = node.getBody();
                if (bodyStatement != null && !(bodyStatement instanceof Block)) {
                    this.addHint(node, bodyStatement, Bundle.DoWhileBracesHintText());
                }
            }
        }
    }

    public static final class IfBracesHint
    extends BracesHint {
        private static final String HINT_ID = "If.Braces.Hint";

        @Override
        protected CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new IfVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.IfBracesHintDesc();
        }

        public String getDisplayName() {
            return Bundle.IfBracesHintDisp();
        }

        private static final class IfVisitor
        extends CheckVisitor {
            public IfVisitor(BracesHint bracesHint, FileObject fileObject, BaseDocument baseDocument) {
                super(bracesHint, fileObject, baseDocument);
            }

            @Override
            public void visit(IfStatement node) {
                Statement falseStatement;
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                super.visit(node);
                Statement trueStatement = node.getTrueStatement();
                if (trueStatement != null && !(trueStatement instanceof Block)) {
                    this.addHint(node, trueStatement, Bundle.IfBracesHintText());
                }
                if ((falseStatement = node.getFalseStatement()) != null && !(falseStatement instanceof Block) && !(falseStatement instanceof IfStatement)) {
                    this.addHint(node, falseStatement, Bundle.IfBracesHintText());
                }
            }
        }
    }
}

