/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.nodes.ClassConstantDeclarationInfo;

class ClassConstantElementImpl
extends ModelElementImpl
implements ClassConstantElement {
    private String typeName;
    private final String value;

    ClassConstantElementImpl(Scope inScope, TypeConstantElement indexedConstant) {
        super(inScope, indexedConstant, PhpElementKind.TYPE_CONSTANT);
        assert (inScope instanceof TypeScope);
        String in = indexedConstant.getIn();
        this.typeName = in != null ? in : inScope.getName();
        this.value = indexedConstant.getValue();
    }

    ClassConstantElementImpl(Scope inScope, ClassConstantDeclarationInfo clsConst, boolean isDeprecated) {
        super(inScope, clsConst, clsConst.getAccessModifiers(), isDeprecated);
        this.typeName = inScope.getName();
        this.value = clsConst.getValue();
    }

    @Override
    public String getNormalizedName() {
        return this.typeName + super.getNormalizedName();
    }

    @Override
    public void addSelfToIndex(IndexDocument indexDocument) {
        indexDocument.addPair("clz.const", this.getIndexSignature(), true, true);
    }

    private String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append(';');
        sb.append(this.getName()).append(';');
        sb.append(this.getOffset()).append(';');
        sb.append(this.getValue() != null ? Signature.encodeItem(this.getValue()) : "?").append(';');
        sb.append(this.isDeprecated() ? 1 : 0).append(';');
        sb.append(this.getFilenameUrl()).append(';');
        sb.append(this.getPhpModifiers().toFlags()).append(';');
        return sb.toString();
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

