/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.completion.LatteUtils;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.spi.templates.completion.CompletionProvider;
import org.openide.filesystems.FileObject;

public class LatteControlCompletionProvider
implements CompletionProvider {
    private static final Logger LOGGER = Logger.getLogger(LatteControlCompletionProvider.class.getName());
    private static final String CREATE_COMPONENT_PREFIX = "createComponent";
    private Set<String> result;
    private String controlPrefix;

    public Set<String> getItems(FileObject sourceFile, String controlPrefix) {
        this.result = new HashSet<String>();
        if (LatteUtils.isView(sourceFile)) {
            this.controlPrefix = controlPrefix;
            this.processTemplateFile(sourceFile);
        }
        return this.result;
    }

    private void processTemplateFile(FileObject templateFile) {
        FileObject presenterFile = LatteUtils.getPresenterFile(templateFile);
        if (presenterFile != null) {
            try {
                this.parsePresenter(presenterFile);
            }
            catch (ParseException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
    }

    private void parsePresenter(FileObject presenterFile) throws ParseException {
        ParserManager.parse(Collections.singleton(Source.create((FileObject)presenterFile)), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                PHPParseResult parseResult = (PHPParseResult)resultIterator.getParserResult();
                if (parseResult != null) {
                    LatteControlCompletionProvider.this.findControls(parseResult);
                }
            }
        });
    }

    private void findControls(PHPParseResult parseResult) {
        Set<Object> controlFactories = new HashSet();
        String realPrefix = StringUtils.hasText((String)this.controlPrefix) ? CREATE_COMPONENT_PREFIX + StringUtils.capitalize((String)this.controlPrefix) : CREATE_COMPONENT_PREFIX;
        NameKind.Prefix nameKindPrefix = NameKind.prefix(realPrefix);
        Model model = parseResult.getModel(Model.Type.COMMON);
        Collection<? extends ClassScope> declaredClasses = ModelUtils.getDeclaredClasses(model.getFileScope());
        for (ClassScope classScope : declaredClasses) {
            Collection<? extends MethodScope> methods = classScope.getMethods();
            controlFactories = ElementFilter.forName(nameKindPrefix).filter(new HashSet<MethodScope>(methods));
        }
        for (MethodScope methodScope : controlFactories) {
            String methodName = methodScope.getName();
            String controlName = methodName.substring(CREATE_COMPONENT_PREFIX.length());
            this.result.add(StringUtils.decapitalize((String)controlName));
        }
    }
}

