/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.sun.source.tree.Scope;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeGenerator;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.openide.filesystems.FileObject;

public final class DelegateMethodGenerator
extends CodeGenerator {
    public static final String GENERATE_DELEGATE_METHOD = "java.generate.delegateMethod";
    private final Set<String> commands = Collections.singleton("java.generate.delegateMethod");
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(CompilationInfo info, CodeActionParams params) {
        TypeElement cls;
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("source")) {
            return Collections.emptyList();
        }
        int offset = DelegateMethodGenerator.getOffset(info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(offset);
        tp = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
        if (tp == null) {
            return Collections.emptyList();
        }
        TypeElement typeElement = (TypeElement)info.getTrees().getElement(tp);
        if (typeElement == null || !typeElement.getKind().isClass()) {
            return Collections.emptyList();
        }
        Elements elements = info.getElements();
        Trees trees = info.getTrees();
        ArrayList<QuickPickItem> fields = new ArrayList<QuickPickItem>();
        for (Scope scope = trees.getScope(tp); scope != null && (cls = scope.getEnclosingClass()) != null; scope = scope.getEnclosingScope()) {
            DeclaredType type = (DeclaredType)cls.asType();
            for (VariableElement field : ElementFilter.fieldsIn(elements.getAllMembers(cls))) {
                TypeMirror fieldType = field.asType();
                if ("<error>".contentEquals(field.getSimpleName()) || fieldType.getKind().isPrimitive() || fieldType.getKind() == TypeKind.ARRAY || fieldType.getKind() == TypeKind.DECLARED && ((DeclaredType)fieldType).asElement() == cls || !trees.isAccessible(scope, field, type)) continue;
                QuickPickItem item = new QuickPickItem(DelegateMethodGenerator.createLabel(info, field));
                item.setUserData(new CodeGenerator.ElementData(field));
                fields.add(item);
            }
        }
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        String uri = Utils.toUri(info.getFileObject());
        QuickPickItem typeItem = new QuickPickItem(DelegateMethodGenerator.createLabel(info, typeElement));
        typeItem.setUserData(new CodeGenerator.ElementData(typeElement));
        return Collections.singletonList(DelegateMethodGenerator.createCodeAction(Bundle.DN_GenerateDelegateMethod(), "source.generate", GENERATE_DELEGATE_METHOD, uri, offset, typeItem, fields));
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (arguments.size() > 3) {
            String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
            int offset = (Integer)this.gson.fromJson(this.gson.toJson(arguments.get(1)), Integer.class);
            QuickPickItem type = (QuickPickItem)this.gson.fromJson(this.gson.toJson(arguments.get(2)), QuickPickItem.class);
            List<Object> fields = Arrays.asList((Object[])this.gson.fromJson(this.gson.toJson(arguments.get(3)), QuickPickItem[].class));
            if (fields.size() == 1) {
                this.selectMethods(client, uri, offset, type, (QuickPickItem)fields.get(0));
            } else {
                client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectDelegateMethodField(), false, fields)).thenAccept(selected -> {
                    if (selected != null && !selected.isEmpty()) {
                        this.selectMethods(client, uri, offset, type, (QuickPickItem)selected.get(0));
                    }
                });
            }
        } else {
            client.logMessage(new MessageParams(MessageType.Error, String.format("Illegal number of arguments received for command: %s", command)));
        }
        return CompletableFuture.completedFuture(true);
    }

    private void selectMethods(NbCodeLanguageClient client, String uri, int offset, QuickPickItem type, QuickPickItem selectedField) {
        try {
            FileObject file = Utils.fromUri(uri);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                throw new IOException("Cannot get JavaSource for: " + uri);
            }
            js.runUserActionTask(info -> {
                info.toPhase(JavaSource.Phase.RESOLVED);
                final TypeElement origin = (TypeElement)((CodeGenerator.ElementData)this.gson.fromJson(this.gson.toJson(type.getUserData()), CodeGenerator.ElementData.class)).resolve((CompilationInfo)info);
                VariableElement field = (VariableElement)((CodeGenerator.ElementData)this.gson.fromJson(this.gson.toJson(selectedField.getUserData()), CodeGenerator.ElementData.class)).resolve((CompilationInfo)info);
                if (origin != null && field != null) {
                    final ElementUtilities eu = info.getElementUtilities();
                    final Trees trees = info.getTrees();
                    final Scope scope = info.getTreeUtilities().scopeFor(offset);
                    ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                        public boolean accept(Element e, TypeMirror type) {
                            if (e.getKind() == ElementKind.METHOD && trees.isAccessible(scope, e, (DeclaredType)type)) {
                                Element impl = eu.getImplementationOf((ExecutableElement)e, origin);
                                return impl == null || !impl.getModifiers().contains((Object)Modifier.FINAL) && impl.getEnclosingElement() != origin;
                            }
                            return false;
                        }
                    };
                    ArrayList<QuickPickItem> methods = new ArrayList<QuickPickItem>();
                    for (ExecutableElement method : ElementFilter.methodsIn(eu.getMembers(field.asType(), acceptor))) {
                        QuickPickItem item = new QuickPickItem(String.format("%s.%s", field.getSimpleName().toString(), DelegateMethodGenerator.createLabel((CompilationInfo)info, method)));
                        item.setUserData(new CodeGenerator.ElementData(method));
                        methods.add(item);
                    }
                    client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectDelegateMethods(), true, methods)).thenAccept(selected -> {
                        if (selected != null && !selected.isEmpty()) {
                            this.generate(client, uri, offset, selectedField, (List<QuickPickItem>)selected);
                        }
                    });
                }
            }, true);
        }
        catch (IOException | IllegalArgumentException ex) {
            client.logMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
    }

    private void generate(NbCodeLanguageClient client, String uri, int offset, QuickPickItem selectedField, List<QuickPickItem> selectedMethods) {
        try {
            FileObject file = Utils.fromUri(uri);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                throw new IOException("Cannot get JavaSource for: " + uri);
            }
            List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                wc.toPhase(JavaSource.Phase.RESOLVED);
                TreePath tp = wc.getTreeUtilities().pathFor(offset);
                tp = wc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
                if (tp != null) {
                    VariableElement field = (VariableElement)((CodeGenerator.ElementData)this.gson.fromJson(this.gson.toJson(selectedField.getUserData()), CodeGenerator.ElementData.class)).resolve((CompilationInfo)wc);
                    List methods = selectedMethods.stream().map(item -> {
                        CodeGenerator.ElementData data = (CodeGenerator.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeGenerator.ElementData.class);
                        return (ExecutableElement)data.resolve((CompilationInfo)wc);
                    }).collect(Collectors.toList());
                    org.netbeans.modules.java.editor.codegen.DelegateMethodGenerator.generateDelegatingMethods((WorkingCopy)wc, (TreePath)tp, (VariableElement)field, methods, (int)-1);
                }
            }));
            client.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(Collections.singletonMap(uri, edits))));
        }
        catch (IOException | IllegalArgumentException ex) {
            client.logMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
    }
}

