/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.options.ValidatorPHPStanParameter;
import org.netbeans.modules.php.analysis.ui.AnalysisDefaultDocumentListener;
import org.netbeans.modules.php.analysis.ui.PHPStanLevelListCellRenderer;
import org.netbeans.modules.php.analysis.ui.options.AnalysisCategoryPanel;
import org.netbeans.modules.php.analysis.ui.options.Bundle;
import org.netbeans.modules.php.analysis.util.AnalysisUiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PHPStanOptionsPanel
extends AnalysisCategoryPanel {
    private static final long serialVersionUID = 1199550925948622972L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton phpStanBrowseButton;
    private JLabel phpStanConfigurationInfoLabel;
    private JLabel phpStanConfigurationLabel;
    private JTextField phpStanConfigurationTextField;
    private JButton phpStanConfiturationBrowseButton;
    private JLabel phpStanHintLabel;
    private JLabel phpStanLabel;
    private JLabel phpStanLearnMoreLabel;
    private JComboBox<String> phpStanLevelComboBox;
    private JLabel phpStanLevelLabel;
    private JLabel phpStanMemoryLimitLabel;
    private JTextField phpStanMemoryLimitTextField;
    private JLabel phpStanMinVersionInfoLabel;
    private JLabel phpStanNoteLabel;
    private JButton phpStanSearchButton;
    private JTextField phpStanTextField;

    public PHPStanOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.phpStanHintLabel.setText(Bundle.PHPStanOptionsPanel_hint("phpstan", "phpstan.phar"));
        this.phpStanLevelComboBox.removeAllItems();
        this.phpStanLevelComboBox.addItem("");
        for (int i = AnalysisOptions.PHPSTAN_MIN_LEVEL; i <= AnalysisOptions.PHPSTAN_MAX_LEVEL; ++i) {
            this.phpStanLevelComboBox.addItem(String.valueOf(i));
        }
        this.phpStanLevelComboBox.addItem("max");
        this.phpStanLevelComboBox.setRenderer(new PHPStanLevelListCellRenderer(this.phpStanLevelComboBox.getRenderer()));
        AnalysisDefaultDocumentListener defaultDocumentListener = new AnalysisDefaultDocumentListener(() -> this.fireChange());
        this.phpStanTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.phpStanConfigurationTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.phpStanMemoryLimitTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.phpStanLevelComboBox.addActionListener(e -> this.fireChange());
    }

    private void initComponents() {
        this.phpStanLabel = new JLabel();
        this.phpStanTextField = new JTextField();
        this.phpStanBrowseButton = new JButton();
        this.phpStanSearchButton = new JButton();
        this.phpStanHintLabel = new JLabel();
        this.phpStanLevelLabel = new JLabel();
        this.phpStanLevelComboBox = new JComboBox();
        this.phpStanMemoryLimitLabel = new JLabel();
        this.phpStanMemoryLimitTextField = new JTextField();
        this.phpStanConfigurationLabel = new JLabel();
        this.phpStanConfigurationTextField = new JTextField();
        this.phpStanConfigurationInfoLabel = new JLabel();
        this.phpStanConfiturationBrowseButton = new JButton();
        this.phpStanNoteLabel = new JLabel();
        this.phpStanMinVersionInfoLabel = new JLabel();
        this.phpStanLearnMoreLabel = new JLabel();
        this.phpStanLabel.setLabelFor(this.phpStanTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpStanLabel, (String)NbBundle.getMessage(PHPStanOptionsPanel.class, (String)"PHPStanOptionsPanel.phpStanLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpStanBrowseButton, (String)NbBundle.getMessage(PHPStanOptionsPanel.class, (String)"PHPStanOptionsPanel.phpStanBrowseButton.text"));
        this.phpStanBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PHPStanOptionsPanel.this.phpStanBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.phpStanSearchButton, (String)NbBundle.getMessage(PHPStanOptionsPanel.class, (String)"PHPStanOptionsPanel.phpStanSearchButton.text"));
        this.phpStanSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PHPStanOptionsPanel.this.phpStanSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.phpStanHintLabel, (String)"HINT");
        this.phpStanLevelLabel.setLabelFor(this.phpStanLevelComboBox);
        Mnemonics.setLocalizedText((JLabel)this.phpStanLevelLabel, (String)NbBundle.getMessage(PHPStanOptionsPanel.class, (String)"PHPStanOptionsPanel.phpStanLevelLabel.text"));
        this.phpStanLevelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7"}));
        this.phpStanMemoryLimitLabel.setLabelFor(this.phpStanMemoryLimitTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpStanMemoryLimitLabel, (String)NbBundle.getMessage(PHPStanOptionsPanel.class, (String)"PHPStanOptionsPanel.phpStanMemoryLimitLabel.text"));
        this.phpStanConfigurationLabel.setLabelFor(this.phpStanConfigurationTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpStanConfigurationLabel, (String)NbBundle.getMessage(PHPStanOptionsPanel.class, (String)"PHPStanOptionsPanel.phpStanConfigurationLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpStanConfigurationInfoLabel, (String)NbBundle.getMessage(PHPStanOptionsPanel.class, (String)"PHPStanOptionsPanel.phpStanConfigurationInfoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpStanConfiturationBrowseButton, (String)NbBundle.getMessage(PHPStanOptionsPanel.class, (String)"PHPStanOptionsPanel.phpStanConfiturationBrowseButton.text"));
        this.phpStanConfiturationBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PHPStanOptionsPanel.this.phpStanConfiturationBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.phpStanNoteLabel, (String)NbBundle.getMessage(PHPStanOptionsPanel.class, (String)"PHPStanOptionsPanel.phpStanNoteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpStanMinVersionInfoLabel, (String)NbBundle.getMessage(PHPStanOptionsPanel.class, (String)"PHPStanOptionsPanel.phpStanMinVersionInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpStanLearnMoreLabel, (String)NbBundle.getMessage(PHPStanOptionsPanel.class, (String)"PHPStanOptionsPanel.phpStanLearnMoreLabel.text"));
        this.phpStanLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PHPStanOptionsPanel.this.phpStanLearnMoreLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PHPStanOptionsPanel.this.phpStanLearnMoreLabelMouseEntered(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpStanMinVersionInfoLabel).addComponent(this.phpStanLearnMoreLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpStanConfigurationLabel).addComponent(this.phpStanLabel).addComponent(this.phpStanLevelLabel).addComponent(this.phpStanNoteLabel, -2, -1, -2).addComponent(this.phpStanMemoryLimitLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpStanConfigurationInfoLabel).addComponent(this.phpStanLevelComboBox, -2, -1, -2).addComponent(this.phpStanMemoryLimitTextField, -2, 100, -2)).addGap(0, 24, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.phpStanConfigurationTextField).addComponent(this.phpStanTextField, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.phpStanHintLabel).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpStanBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpStanSearchButton)).addComponent(this.phpStanConfiturationBrowseButton))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpStanLabel).addComponent(this.phpStanTextField, -2, -1, -2).addComponent(this.phpStanBrowseButton).addComponent(this.phpStanSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpStanHintLabel).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpStanConfigurationLabel).addComponent(this.phpStanConfigurationTextField, -2, -1, -2).addComponent(this.phpStanConfiturationBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpStanConfigurationInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpStanLevelLabel).addComponent(this.phpStanLevelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpStanMemoryLimitLabel).addComponent(this.phpStanMemoryLimitTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.phpStanNoteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpStanMinVersionInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpStanLearnMoreLabel, -2, -1, -2)));
    }

    private void phpStanBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browsePHPStan();
        if (file != null) {
            this.phpStanTextField.setText(file.getAbsolutePath());
        }
    }

    private void phpStanSearchButtonActionPerformed(ActionEvent evt) {
        String phpStan = AnalysisUiUtils.searchPHPStan();
        if (phpStan != null) {
            this.phpStanTextField.setText(phpStan);
        }
    }

    private void phpStanLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void phpStanLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("https://github.com/phpstan/phpstan");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void phpStanConfiturationBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browsePHPStanConfiguration();
        if (file != null) {
            this.phpStanConfigurationTextField.setText(file.getAbsolutePath());
        }
    }

    @Override
    public String getCategoryName() {
        return Bundle.PHPStanOptionsPanel_category_name();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public void update() {
        AnalysisOptions options = AnalysisOptions.getInstance();
        this.setPHPStanPath(options.getPHPStanPath());
        this.setPHPStanConfigurationPath(options.getPHPStanConfigurationPath());
        this.setPHPStanLevel(options.getPHPStanLevel());
        this.setPHPStanMemoryLimit(options.getPHPStanMemoryLimit());
    }

    @Override
    public void applyChanges() {
        AnalysisOptions options = AnalysisOptions.getInstance();
        options.setPHPStanPath(this.getPHPStanPath());
        options.setPHPStanConfigurationPath(this.getPHPStanConfigurationPath());
        options.setPHPStanLevel(this.getPHPStanLevel());
        options.setPHPStanMemoryLimit(this.getPHPStanMemoryLimit());
    }

    @Override
    public boolean isChanged() {
        String currentString;
        String saved = AnalysisOptions.getInstance().getPHPStanPath();
        String current = this.getPHPStanPath();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = AnalysisOptions.getInstance().getPHPStanConfigurationPath();
        current = this.getPHPStanConfigurationPath();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        String savedString = AnalysisOptions.getInstance().getPHPStanLevel();
        return !savedString.equals(currentString = this.getPHPStanLevel());
    }

    @Override
    public ValidationResult getValidationResult() {
        return new AnalysisOptionsValidator().validatePHPStan(ValidatorPHPStanParameter.create(this)).getResult();
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    public String getPHPStanPath() {
        return this.phpStanTextField.getText().trim();
    }

    private void setPHPStanPath(String path) {
        this.phpStanTextField.setText(path);
    }

    public String getPHPStanConfigurationPath() {
        return this.phpStanConfigurationTextField.getText().trim();
    }

    private void setPHPStanConfigurationPath(String path) {
        this.phpStanConfigurationTextField.setText(path);
    }

    public String getPHPStanLevel() {
        return (String)this.phpStanLevelComboBox.getSelectedItem();
    }

    private void setPHPStanLevel(String level) {
        this.phpStanLevelComboBox.setSelectedItem(level);
    }

    public String getPHPStanMemoryLimit() {
        return this.phpStanMemoryLimitTextField.getText().trim();
    }

    private void setPHPStanMemoryLimit(String memoryLimit) {
        this.phpStanMemoryLimitTextField.setText(memoryLimit);
    }
}

