/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nu.validator.messages.MessageEmitterAdapter;
import nu.validator.servlet.Html5ConformanceCheckerTransaction;
import nu.validator.servlet.ParseTreePrinter;
import nu.validator.servlet.Statistics;
import nu.validator.servlet.VerifierServletTransaction;
import nu.validator.xml.PrudentHttpEntityResolver;
import org.apache.log4j.Logger;

public class VerifierServlet
extends HttpServlet {
    private static final long serialVersionUID = 7811043632732680935L;
    private static final Logger log4j = Logger.getLogger(VerifierServlet.class);
    static final String GENERIC_HOST = System.getProperty("nu.validator.servlet.host.generic", "");
    static final String HTML5_HOST = System.getProperty("nu.validator.servlet.host.html5", "");
    static final String PARSETREE_HOST = System.getProperty("nu.validator.servlet.host.parsetree", "");
    static final String GENERIC_PATH = System.getProperty("nu.validator.servlet.path.generic", "/");
    static final String HTML5_PATH = System.getProperty("nu.validator.servlet.path.html5", "/html5/");
    static final String PARSETREE_PATH = System.getProperty("nu.validator.servlet.path.parsetree", "/parsetree/");
    private static final byte[] GENERIC_ROBOTS_TXT;
    private static final byte[] HTML5_ROBOTS_TXT;
    private static final byte[] PARSETREE_ROBOTS_TXT;
    private static final byte[] STYLE_CSS;
    private static final byte[] SCRIPT_JS;
    private static final byte[] ICON_PNG;
    private static final byte[] ABOUT_HTML;

    private static byte[] buildRobotsTxt(String primaryHost, String primaryPath, String secondaryHost, String secondaryPath, String tertiaryHost, String tertiaryPath) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        builder.append("User-agent: *\nDisallow: ");
        builder.append(primaryPath);
        builder.append("?\n");
        if (primaryHost.equals(secondaryHost)) {
            builder.append("Disallow: ");
            builder.append(secondaryPath);
            builder.append("?\n");
        }
        if (primaryHost.equals(tertiaryHost)) {
            builder.append("Disallow: ");
            builder.append(tertiaryPath);
            builder.append("?\n");
        }
        return builder.toString().getBytes("UTF-8");
    }

    private static byte[] readFromClassLoaderIntoByteArray(String name) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (InputStream ios = VerifierServlet.class.getClassLoader().getResourceAsStream(name);){
                int b = ios.read();
                while (b != -1) {
                    baos.write(b);
                    b = ios.read();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private void writeResponse(byte[] buffer, String type, HttpServletResponse response) throws IOException {
        try {
            response.setContentType(type);
            response.setContentLength(buffer.length);
            response.setDateHeader("Expires", System.currentTimeMillis() + 43200000L);
            try (ServletOutputStream out = response.getOutputStream();){
                out.write(buffer);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("/robots.txt".equals(request.getPathInfo())) {
            String serverName = request.getServerName();
            byte[] robotsTxt = null;
            if (this.hostMatch(GENERIC_HOST, serverName)) {
                robotsTxt = GENERIC_ROBOTS_TXT;
            } else if (this.hostMatch(HTML5_HOST, serverName)) {
                robotsTxt = HTML5_ROBOTS_TXT;
            } else if (this.hostMatch(PARSETREE_HOST, serverName)) {
                robotsTxt = PARSETREE_ROBOTS_TXT;
            } else {
                response.sendError(404);
                return;
            }
            this.writeResponse(robotsTxt, "text/plain; charset=utf-8", response);
            return;
        }
        if ("/style.css".equals(request.getPathInfo())) {
            this.writeResponse(STYLE_CSS, "text/css; charset=utf-8", response);
            return;
        }
        if ("/script.js".equals(request.getPathInfo())) {
            this.writeResponse(SCRIPT_JS, "text/javascript; charset=utf-8", response);
            return;
        }
        if ("/icon.png".equals(request.getPathInfo())) {
            this.writeResponse(ICON_PNG, "image/png", response);
            return;
        }
        if ("/about.html".equals(request.getPathInfo())) {
            this.writeResponse(ABOUT_HTML, "text/html; charset=utf-8", response);
            return;
        }
        if (Statistics.STATISTICS != null && "/stats.html".equals(request.getPathInfo())) {
            Statistics.STATISTICS.writeToResponse(response);
            return;
        }
        this.doPost(request, response);
    }

    private boolean hostMatch(String reference, String host) {
        if ("".equals(reference)) {
            return true;
        }
        return reference.equalsIgnoreCase(host);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if ("*".equals(pathInfo)) {
            return;
        }
        if ("/robots.txt".equals(pathInfo)) {
            String serverName = request.getServerName();
            if (this.hostMatch(GENERIC_HOST, serverName) || this.hostMatch(HTML5_HOST, serverName) || this.hostMatch(PARSETREE_HOST, serverName)) {
                this.sendGetOnlyOptions(request, response);
                return;
            }
            response.sendError(404);
            return;
        }
        this.doPost(request, response);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getMethod();
        String pathInfo = request.getPathInfo();
        String referer = request.getHeader("Referer");
        String query = request.getQueryString();
        String serverName = request.getServerName();
        String ua = request.getHeader("User-Agent");
        boolean isOptions = "OPTIONS".equals(method);
        if (referer != null && referer.contains("http://validator.w3.org/check?uri=") && !referer.startsWith("http://validator.w3.org/check?uri=")) {
            response.sendError(403);
            return;
        }
        if (ua == null) {
            response.sendError(400, "Bad request. Valid requests must include a User-Agent header.");
            return;
        }
        if (!isOptions) {
            Object[] fields = new String[]{method, ua, query, referer};
            log4j.info((Object)String.format("%s\t%s\t%s\t%s", fields));
        }
        if (pathInfo == null) {
            pathInfo = "/";
        }
        if ("/robots.txt".equals(pathInfo)) {
            response.sendError(405);
            return;
        }
        log4j.debug((Object)("pathInfo: " + pathInfo));
        log4j.debug((Object)("serverName: " + serverName));
        if ("validator.nu".equals(serverName) && "/html5/".equals(pathInfo)) {
            response.setStatus(301);
            response.setHeader("Location", "http://html5.validator.nu/" + (query == null ? "" : "?" + query));
        } else if (this.hostMatch(GENERIC_HOST, serverName) && GENERIC_PATH.equals(pathInfo)) {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Headers", "content-type");
            if (isOptions) {
                this.sendOptions(request, response);
            } else {
                new VerifierServletTransaction(request, response).service();
            }
        } else if (this.hostMatch(HTML5_HOST, serverName) && HTML5_PATH.equals(pathInfo)) {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Headers", "content-type");
            if (isOptions) {
                this.sendOptions(request, response);
            } else {
                new Html5ConformanceCheckerTransaction(request, response).service();
            }
        } else if (this.hostMatch(PARSETREE_HOST, serverName) && PARSETREE_PATH.equals(pathInfo)) {
            if (isOptions) {
                this.sendGetOnlyOptions(request, response);
            } else {
                new ParseTreePrinter(request, response).service();
            }
        } else {
            response.sendError(404);
        }
    }

    private void sendGetOnlyOptions(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Allow", "GET, HEAD, OPTIONS");
        response.setHeader("Access-Control-Allow-Methods", "GET, HEAD, POST, OPTIONS");
        response.setContentType("application/octet-stream");
        response.setContentLength(0);
    }

    private void sendOptions(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Access-Control-Max-Age", "43200");
        response.setHeader("Allow", "GET, HEAD, POST, OPTIONS");
        response.setHeader("Access-Control-Allow-Methods", "GET, HEAD, POST, OPTIONS");
        response.setContentType("application/octet-stream");
        response.setContentLength(0);
    }

    static {
        try {
            GENERIC_ROBOTS_TXT = VerifierServlet.buildRobotsTxt(GENERIC_HOST, GENERIC_PATH, HTML5_HOST, HTML5_PATH, PARSETREE_HOST, PARSETREE_PATH);
            HTML5_ROBOTS_TXT = VerifierServlet.buildRobotsTxt(HTML5_HOST, HTML5_PATH, GENERIC_HOST, GENERIC_PATH, PARSETREE_HOST, PARSETREE_PATH);
            PARSETREE_ROBOTS_TXT = VerifierServlet.buildRobotsTxt(PARSETREE_HOST, PARSETREE_PATH, HTML5_HOST, HTML5_PATH, GENERIC_HOST, GENERIC_PATH);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        try {
            STYLE_CSS = VerifierServlet.readFromClassLoaderIntoByteArray("nu/validator/localentities/files/style.css");
            SCRIPT_JS = VerifierServlet.readFromClassLoaderIntoByteArray("nu/validator/localentities/files/script.js");
            ICON_PNG = VerifierServlet.readFromClassLoaderIntoByteArray("nu/validator/localentities/files/icon.png");
            ABOUT_HTML = VerifierServlet.readFromClassLoaderIntoByteArray("nu/validator/localentities/files/about.html");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PrudentHttpEntityResolver.setParams(Integer.parseInt(System.getProperty("nu.validator.servlet.connection-timeout", "5000")), Integer.parseInt(System.getProperty("nu.validator.servlet.socket-timeout", "5000")), Integer.parseInt(System.getProperty("nu.validator.servlet.max-requests", "100")));
        new VerifierServletTransaction(null, null);
        new MessageEmitterAdapter(null, null, false, null, 0, false, null);
    }
}

