/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.wizard;

import java.io.File;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerSupport;
import org.netbeans.modules.docker.ui.wizard.Bundle;
import org.netbeans.modules.docker.ui.wizard.DockerConnectionPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Utilities;

public class AddDockerInstanceWizard {
    public static final String DISPLAY_NAME_PROPERTY = "displayName";
    public static final String SOCKET_SELECTED_PROPERTY = "socketSelected";
    public static final String SOCKET_PROPERTY = "socket";
    public static final String URL_PROPERTY = "url";
    public static final String CERTIFICATE_PATH_PROPERTY = "certPath";
    public static final String DEFAULT_CA_FILE = "ca.pem";
    public static final String DEFAULT_CERT_FILE = "cert.pem";
    public static final String DEFAULT_KEY_FILE = "key.pem";
    private static final Logger LOGGER = Logger.getLogger(AddDockerInstanceWizard.class.getName());

    public DockerInstance show() {
        ArrayList<DockerConnectionPanel> panels = new ArrayList<DockerConnectionPanel>();
        panels.add(new DockerConnectionPanel());
        String[] steps = new String[panels.size()];
        for (int i = 0; i < panels.size(); ++i) {
            JComponent c = (JComponent)((WizardDescriptor.Panel)panels.get(i)).getComponent();
            steps[i] = c.getName();
            c.putClientProperty("WizardPanel_contentSelectedIndex", i);
            c.putClientProperty("WizardPanel_contentData", steps);
            c.putClientProperty("WizardPanel_autoWizardStyle", true);
            c.putClientProperty("WizardPanel_contentDisplayed", true);
            c.putClientProperty("WizardPanel_contentNumbered", true);
        }
        WizardDescriptor wiz = new WizardDescriptor((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(panels));
        wiz.setTitleFormat(new MessageFormat("{0}"));
        wiz.setTitle(Bundle.LBL_AddDockerInstance());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)wiz) == WizardDescriptor.FINISH_OPTION) {
            Boolean socketSelected = (Boolean)wiz.getProperty(SOCKET_SELECTED_PROPERTY);
            if (socketSelected.booleanValue()) {
                File file = (File)wiz.getProperty(SOCKET_PROPERTY);
                try {
                    DockerInstance instance = DockerInstance.getInstance((String)Utilities.toURI((File)file).toURL().toString(), (String)((String)wiz.getProperty(DISPLAY_NAME_PROPERTY)), null, null, null);
                    return DockerSupport.getDefault().addInstance(instance);
                }
                catch (MalformedURLException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
            } else {
                File caFile = null;
                File certFile = null;
                File keyFile = null;
                String strCertPath = (String)wiz.getProperty(CERTIFICATE_PATH_PROPERTY);
                if (strCertPath != null) {
                    File file = new File(strCertPath);
                    caFile = new File(file, DEFAULT_CA_FILE);
                    certFile = new File(file, DEFAULT_CERT_FILE);
                    keyFile = new File(file, DEFAULT_KEY_FILE);
                }
                DockerInstance instance = DockerInstance.getInstance((String)((String)wiz.getProperty(URL_PROPERTY)), (String)((String)wiz.getProperty(DISPLAY_NAME_PROPERTY)), (File)caFile, certFile, keyFile);
                return DockerSupport.getDefault().addInstance(instance);
            }
        }
        return null;
    }
}

