/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager;

import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.jaxwsmodelapi.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.manager.WebServiceManager;
import org.netbeans.modules.websvc.manager.api.WebServiceDescriptor;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.model.WebServiceGroup;
import org.netbeans.modules.websvc.manager.model.WebServiceListModel;
import org.netbeans.modules.websvc.manager.util.ManagerUtil;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class WebServicePersistenceManager
implements ExceptionListener {
    private File websvcDir = new File(WebServiceManager.WEBSVC_HOME);
    private File websvcRefFile = new File(this.websvcDir, "websvc_ref.xml");
    private List<WebServiceDescriptor> descriptorsToWrite = null;
    private boolean imported = true;

    public void setImported(boolean v) {
        this.imported = v;
    }

    public void load() {
        if (this.websvcRefFile.exists()) {
            try {
                int wsDataNums;
                SaasServicesModel model = SaasServicesModel.getInstance();
                XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(this.websvcRefFile)));
                ArrayList<WebServiceData> wsDatas = new ArrayList<WebServiceData>();
                List<String> partnerServices = WebServiceListModel.getInstance().getPartnerServices();
                Object firstObject = decoder.readObject();
                if (firstObject instanceof List) {
                    List loadedServices = (List)firstObject;
                    for (String url : loadedServices) {
                        partnerServices.add(url);
                    }
                    wsDataNums = (Integer)decoder.readObject();
                } else {
                    wsDataNums = (Integer)firstObject;
                }
                for (int i = 0; i < wsDataNums; ++i) {
                    WebServiceData wsData = null;
                    try {
                        wsData = (WebServiceData)decoder.readObject();
                    }
                    catch (Exception exc) {
                        ErrorManager.getDefault().notify((Throwable)exc);
                        decoder.close();
                    }
                    wsDatas.add(wsData);
                }
                int wsGroupSize = (Integer)decoder.readObject();
                HashMap<String, WebServiceGroup> groupByIds = new HashMap<String, WebServiceGroup>();
                for (int i = 0; i < wsGroupSize; ++i) {
                    try {
                        WebServiceGroup group = (WebServiceGroup)decoder.readObject();
                        groupByIds.put(group.getId(), group);
                        if (group.getName() == null) continue;
                        String trimmed = this.translateGroupName(group);
                        if (this.imported || model.getRootGroup().getChildGroup(group.getName()) != null || model.getRootGroup().getChildGroup(trimmed) != null || "default".equals(group.getName())) continue;
                        model.createTopGroup(group.getName());
                        continue;
                    }
                    catch (Exception exc) {
                        ErrorManager.getDefault().notify((Throwable)exc);
                        decoder.close();
                    }
                }
                decoder.close();
                for (WebServiceData wsData : wsDatas) {
                    if (this.imported) {
                        if (wsData.getJaxRpcDescriptorPath() != null) {
                            wsData.setJaxRpcDescriptor(this.loadDescriptorFile(this.websvcDir + File.separator + wsData.getJaxRpcDescriptorPath()));
                        }
                        if (wsData.getJaxWsDescriptorPath() != null) {
                            wsData.setJaxWsDescriptor(this.loadDescriptorFile(this.websvcDir + File.separator + wsData.getJaxWsDescriptorPath()));
                        }
                        try {
                            WsdlModel wsdlModel = WebServiceManager.getInstance().getWsdlModel(wsData);
                            wsData.setWsdlService(wsdlModel.getServiceByName(wsData.getName()));
                        }
                        catch (IOException ex) {
                            Logger.global.log(Level.INFO, ex.getLocalizedMessage(), ex);
                        }
                    } else {
                        String url;
                        wsData.reset();
                        WebServiceGroup group = (WebServiceGroup)groupByIds.get(wsData.getGroupId());
                        SaasGroup parent = null;
                        parent = group.getName() == null ? model.getRootGroup() : model.getRootGroup().getChildGroup(this.translateGroupName(group));
                        if (parent == null) {
                            parent = model.getRootGroup();
                        }
                        if (SaasUtil.getServiceByUrl((SaasGroup)parent, (String)(url = wsData.getOriginalWsdlUrl())) != null) continue;
                        String display = WsdlUtil.getServiceDirName((String)url);
                        WsdlSaas service = new WsdlSaas(parent, display, url, wsData.getPackageName());
                        parent.addService((Saas)service);
                        service.save();
                    }
                    WebServiceListModel.getInstance().addWebService(wsData);
                }
                try {
                    WebServiceGroup defaultGroup = (WebServiceGroup)groupByIds.get("default");
                    if (defaultGroup != null) {
                        WebServiceListModel.getInstance().addWebServiceGroup(defaultGroup);
                    }
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        WebServicePersistenceManager.loadPartnerServices();
    }

    private String translateGroupName(WebServiceGroup group) {
        String name = group.getName();
        if (name.endsWith(" Services")) {
            return name.substring(0, name.length() - 9);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        WebServiceListModel model = WebServiceListModel.getInstance();
        if (!model.isInitialized()) {
            return;
        }
        if (!this.websvcDir.exists()) {
            this.websvcDir.mkdirs();
        }
        if (this.websvcRefFile.exists()) {
            this.websvcRefFile.delete();
        }
        try (XMLEncoder encoder = null;){
            encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(this.websvcRefFile)));
            encoder.setExceptionListener(this);
            DefaultPersistenceDelegate delegate = new WebServiceDataPersistenceDelegate();
            encoder.setPersistenceDelegate(WSService.class, delegate);
            encoder.setPersistenceDelegate(WebServiceDescriptor.class, delegate);
            encoder.writeObject(model.getPartnerServices());
            List<WebServiceData> wsDataSet = model.getWebServiceSet();
            encoder.writeObject(wsDataSet.size());
            List<WebServiceData> list = wsDataSet;
            synchronized (list) {
                for (WebServiceData webServiceData : wsDataSet) {
                    encoder.writeObject(webServiceData);
                }
            }
            List<WebServiceGroup> wsGroupSet = model.getWebServiceGroupSet();
            encoder.writeObject(new Integer(wsGroupSet.size()));
            Iterator<WebServiceDescriptor> iterator = wsGroupSet;
            synchronized (iterator) {
                for (WebServiceGroup group : wsGroupSet) {
                    encoder.writeObject(group);
                }
            }
            encoder.flush();
            delegate = new DefaultPersistenceDelegate();
            encoder.setPersistenceDelegate(WSService.class, delegate);
            encoder.setPersistenceDelegate(WebServiceDescriptor.class, delegate);
            if (this.descriptorsToWrite != null) {
                for (WebServiceDescriptor webServiceDescriptor : this.descriptorsToWrite) {
                    this.saveWebServiceDescriptor(webServiceDescriptor);
                }
                this.descriptorsToWrite.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebServiceDescriptor loadDescriptorFile(String descriptorPath) {
        if (descriptorPath == null || descriptorPath.length() == 0) {
            return null;
        }
        try (XMLDecoder decoder = null;){
            decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(descriptorPath)));
            WebServiceDescriptor webServiceDescriptor = (WebServiceDescriptor)((Object)decoder.readObject());
            return webServiceDescriptor;
        }
    }

    public static void loadPartnerService(String serviceFolder, String partnerName) {
        FileObject folder = FileUtil.getConfigFile((String)serviceFolder);
        WebServicePersistenceManager.loadPartnerFromFolder(folder, partnerName, true);
    }

    public static void loadPartnerServices() {
        FileObject f = FileUtil.getConfigFile((String)"RestComponents");
        if (f != null && f.isFolder()) {
            Enumeration en = f.getFolders(false);
            while (en.hasMoreElements()) {
                FileObject nextFolder = (FileObject)en.nextElement();
                String groupName = ManagerUtil.getLocalizedName(nextFolder);
                WebServicePersistenceManager.loadPartnerFromFolder(nextFolder, groupName, false);
            }
        }
    }

    private static void loadPartnerFromFolder(FileObject folder, String groupName, boolean reloadIfExists) {
        if (folder == null || !folder.isFolder()) {
            return;
        }
        HashMap<String, String> currentUrls = new HashMap<String, String>();
        List<String> partnerUrls = WebServiceListModel.getInstance().getPartnerServices();
        FileObject[] contents = folder.getChildren();
        for (int i = 0; i < contents.length; ++i) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(contents[i].getInputStream());
                NodeList nodes = document.getElementsByTagName("method");
                for (int j = 0; j < nodes.getLength(); ++j) {
                    boolean addUrl;
                    NamedNodeMap attributes = nodes.item(j).getAttributes();
                    String type = attributes.getNamedItem("type").getNodeValue();
                    String url = attributes.getNamedItem("url").getNodeValue();
                    boolean bl = addUrl = !currentUrls.containsKey(url) && (reloadIfExists || !reloadIfExists && !partnerUrls.contains(url));
                    if (!"http://schemas.xmlsoap.org/wsdl/".equals(type) || !addUrl) continue;
                    String serviceName = attributes.getNamedItem("serviceName").getNodeValue();
                    currentUrls.put(url, serviceName);
                }
                continue;
            }
            catch (Exception ex) {
                String msg = NbBundle.getMessage(WebServicePersistenceManager.class, (String)"MSG_BadContent", (Object)contents[i].getPath());
                Throwable throwable = ErrorManager.getDefault().annotate((Throwable)ex, msg);
                ErrorManager.getDefault().notify(throwable);
            }
        }
        if (currentUrls.size() > 0) {
            WebServiceGroup newGroup = null;
            List<WebServiceGroup> webServiceGroups = WebServiceListModel.getInstance().getWebServiceGroupSet();
            for (WebServiceGroup webServiceGroup : webServiceGroups) {
                if (webServiceGroup.isUserDefined() || !webServiceGroup.getName().equals(groupName)) continue;
                newGroup = webServiceGroup;
                break;
            }
            if (newGroup == null) {
                newGroup = new WebServiceGroup(WebServiceListModel.getInstance().getUniqueWebServiceGroupId());
                newGroup.setName(groupName);
                newGroup.setUserDefined(false);
            }
            for (Map.Entry entry : currentUrls.entrySet()) {
                String url = (String)entry.getKey();
                if (!reloadIfExists || !partnerUrls.contains(url)) {
                    partnerUrls.add(url);
                    WebServiceData wsData = new WebServiceData(url, newGroup.getId());
                    WebServiceListModel.getInstance().addWebService(wsData);
                    newGroup.add(wsData.getId(), true);
                    continue;
                }
                WebServiceData existingData = null;
                List<WebServiceData> wsDatas = WebServiceListModel.getInstance().getWebServiceSet();
                for (WebServiceData wsData : wsDatas) {
                    if (!wsData.getOriginalWsdlUrl().equals(url)) continue;
                    existingData = wsData;
                    break;
                }
                if (existingData != null) {
                    WebServiceManager.getInstance().resetWebService(existingData);
                    existingData.setName((String)entry.getValue());
                    continue;
                }
                WebServiceData wsData = new WebServiceData(url, newGroup.getId());
                WebServiceListModel.getInstance().addWebService(wsData);
                newGroup.add(wsData.getId(), true);
            }
            WebServiceListModel.getInstance().addWebServiceGroup(newGroup);
        }
    }

    public void saveDescriptor(WebServiceDescriptor descriptor) throws IOException {
        XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(descriptor.getXmlDescriptor())));
        encoder.setExceptionListener(this);
        WebServiceDataPersistenceDelegate delegate = new WebServiceDataPersistenceDelegate();
        encoder.setPersistenceDelegate(WSService.class, delegate);
        encoder.writeObject((Object)descriptor);
        encoder.flush();
        encoder.close();
    }

    public void saveWebServiceDescriptor(WebServiceDescriptor descriptor) {
        try {
            this.saveDescriptor(descriptor);
        }
        catch (IOException ex) {
            this.exceptionThrown(ex);
        }
    }

    @Override
    public void exceptionThrown(Exception exc) {
        ErrorManager.getDefault().notify((Throwable)exc);
    }

    public static class WebServiceDataPersistenceDelegate
    extends DefaultPersistenceDelegate {
        @Override
        public void writeObject(Object oldInstance, Encoder out) {
            if (oldInstance instanceof WSService) {
                return;
            }
            if (oldInstance instanceof WebServiceDescriptor) {
                return;
            }
            super.writeObject(oldInstance, out);
        }
    }
}

