/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.matchers.ProfilingCharMatcher;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ProfilingCharMatcher.class)
public final class ProfilingCharMatcherNodeGen
extends ProfilingCharMatcher {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;

    private ProfilingCharMatcherNodeGen(CharMatcher byteMatcher, CharMatcher charMatcher) {
        super(byteMatcher, charMatcher);
    }

    @Override
    public boolean execute(char arg0Value, boolean arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && arg1Value) {
                return this.matchCompactString(arg0Value, arg1Value);
            }
            if ((state & 2) != 0 && !arg1Value && ProfilingCharMatcher.isByte(arg0Value)) {
                return this.matchByte(arg0Value, arg1Value);
            }
            if ((state & 4) != 0 && !arg1Value) {
                return this.matchChar(arg0Value, arg1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private boolean executeAndSpecialize(char arg0Value, boolean arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arg1Value) {
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.matchCompactString(arg0Value, arg1Value);
                return bl;
            }
            if (exclude == 0 && !arg1Value && ProfilingCharMatcher.isByte(arg0Value)) {
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = this.matchByte(arg0Value, arg1Value);
                return bl;
            }
            if (!arg1Value) {
                this.exclude_ = exclude |= 1;
                state &= 0xFFFFFFFD;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = this.matchChar(arg0Value, arg1Value);
                return bl;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{Character.valueOf(arg0Value), arg1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ProfilingCharMatcher create(CharMatcher byteMatcher, CharMatcher charMatcher) {
        return new ProfilingCharMatcherNodeGen(byteMatcher, charMatcher);
    }
}

