/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.zip.CRC32;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.openide.util.NbPreferences;

public class ProjectXMLKnownChecksums {
    private static final String KEY = "knownValidProjectXmlCRC32s";
    private static final Logger LOG = Logger.getLogger(ProjectXMLKnownChecksums.class.getName());
    private final List<Long> knownHashes = new ArrayList<Long>();
    private StringBuilder newKnownHashes;

    public ProjectXMLKnownChecksums() {
        String knownHashesS = this.prefs().get(KEY, null);
        LOG.log(Level.FINE, "knownHashesS={0}", knownHashesS);
        if (knownHashesS != null) {
            for (String knownHash : knownHashesS.split(",")) {
                try {
                    this.knownHashes.add(Long.valueOf(knownHash, 16));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean check(byte[] data) {
        CRC32 crc = new CRC32();
        crc.update(data);
        long hash = crc.getValue();
        if (this.knownHashes.contains(hash)) {
            return true;
        }
        this.newKnownHashes = new StringBuilder(Long.toString(hash, 16));
        for (int i = 0; i < this.knownHashes.size() && i < 100; ++i) {
            this.newKnownHashes.append(',');
            this.newKnownHashes.append(Long.toString(this.knownHashes.get(i), 16));
        }
        return false;
    }

    public void save() {
        LOG.log(Level.FINE, "knownHashesS:={0}", this.newKnownHashes);
        this.prefs().put(KEY, this.newKnownHashes.toString());
    }

    private Preferences prefs() {
        return NbPreferences.forModule(AntBasedProjectFactorySingleton.class);
    }
}

