/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.BreakableStatement;
import com.oracle.js.parser.ir.JoinPredecessorExpression;
import com.oracle.js.parser.ir.Label;
import com.oracle.js.parser.ir.LexicalContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class LoopNode
extends BreakableStatement {
    protected final Label continueLabel;
    protected final JoinPredecessorExpression test;
    protected final Block body;
    protected final boolean controlFlowEscapes;

    protected LoopNode(int n, long l, int n2, Block block, JoinPredecessorExpression joinPredecessorExpression, boolean bl) {
        super(n, l, n2, new Label("while_break"));
        this.continueLabel = new Label("while_continue");
        this.body = block;
        this.controlFlowEscapes = bl;
        this.test = joinPredecessorExpression;
    }

    protected LoopNode(LoopNode loopNode, JoinPredecessorExpression joinPredecessorExpression, Block block, boolean bl) {
        super(loopNode);
        this.continueLabel = new Label(loopNode.continueLabel);
        this.test = joinPredecessorExpression;
        this.body = block;
        this.controlFlowEscapes = bl;
    }

    @Override
    public boolean isTerminal() {
        if (!this.mustEnter()) {
            return false;
        }
        if (this.controlFlowEscapes) {
            return false;
        }
        if (this.body.isTerminal()) {
            return true;
        }
        return this.test == null;
    }

    public abstract boolean mustEnter();

    public Label getContinueLabel() {
        return this.continueLabel;
    }

    @Override
    public List<Label> getLabels() {
        return Collections.unmodifiableList(Arrays.asList(this.breakLabel, this.continueLabel));
    }

    @Override
    public boolean isLoop() {
        return true;
    }

    public abstract Block getBody();

    public abstract LoopNode setBody(LexicalContext var1, Block var2);

    public final JoinPredecessorExpression getTest() {
        return this.test;
    }

    public abstract LoopNode setTest(LexicalContext var1, JoinPredecessorExpression var2);

    public abstract LoopNode setControlFlowEscapes(LexicalContext var1, boolean var2);

    public abstract boolean hasPerIterationScope();
}

