/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.ECMAErrors;
import com.oracle.js.parser.ErrorManager;
import com.oracle.js.parser.JSErrorType;
import com.oracle.js.parser.Lexer;
import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.Source;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenKind;
import com.oracle.js.parser.TokenStream;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.LiteralNode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractParser {
    protected final Source source;
    protected final ErrorManager errors;
    protected TokenStream stream;
    protected int k;
    protected long previousToken;
    protected long token;
    protected TokenType type;
    protected TokenType last;
    protected int start;
    protected int finish;
    protected int line;
    protected int linePosition;
    protected Lexer lexer;
    protected boolean isStrictMode;
    protected boolean isStrongMode;
    protected boolean isModule;
    protected final int lineOffset;
    private final Map<String, String> canonicalNames = new HashMap<String, String>();
    private static final String SOURCE_URL_PREFIX = "sourceURL=";

    protected AbstractParser(Source source, ErrorManager errorManager, boolean bl, int n) {
        if (source.getLength() > 0xFFFFFFF) {
            throw new RuntimeException("Source exceeds size limit of 268435455 bytes");
        }
        this.source = source;
        this.errors = errorManager;
        this.k = -1;
        this.token = Token.toDesc(TokenType.EOL, 0, 1);
        this.type = TokenType.EOL;
        this.last = TokenType.EOL;
        this.isStrictMode = bl;
        this.lineOffset = n;
    }

    protected final long getToken(int n) {
        while (n > this.stream.last()) {
            if (this.stream.isFull()) {
                this.stream.grow();
            }
            this.lexer.lexify();
        }
        return this.stream.get(n);
    }

    protected final TokenType T(int n) {
        return Token.descType(this.getToken(n));
    }

    protected final TokenType next() {
        do {
            this.nextOrEOL();
        } while (this.type == TokenType.EOL || this.type == TokenType.COMMENT);
        return this.type;
    }

    protected final TokenType nextOrEOL() {
        do {
            this.nextToken();
            if (this.type != TokenType.DIRECTIVE_COMMENT) continue;
            this.checkDirectiveComment();
        } while (this.type == TokenType.COMMENT || this.type == TokenType.DIRECTIVE_COMMENT);
        return this.type;
    }

    private void checkDirectiveComment() {
        if (this.source.getExplicitURL() != null) {
            return;
        }
        String string = (String)this.lexer.getValueOf(this.token, this.isStrictMode);
        int n = string.length();
        if (n > 4 && string.substring(4).startsWith(SOURCE_URL_PREFIX)) {
            this.source.setExplicitURL(string.substring(4 + SOURCE_URL_PREFIX.length()));
        }
    }

    private TokenType nextToken() {
        if (this.type != TokenType.COMMENT) {
            this.last = this.type;
        }
        if (this.type != TokenType.EOF) {
            ++this.k;
            long l = this.token;
            this.previousToken = this.token;
            this.token = this.getToken(this.k);
            this.type = Token.descType(this.token);
            if (this.last != TokenType.EOL) {
                this.finish = this.start + Token.descLength(l);
            }
            if (this.type == TokenType.EOL) {
                this.line = Token.descLength(this.token);
                this.linePosition = Token.descPosition(this.token);
            } else {
                this.start = Token.descPosition(this.token);
            }
        }
        return this.type;
    }

    protected static String message(String string, String ... stringArray) {
        return ECMAErrors.getMessage("parser.error." + string, stringArray);
    }

    protected final ParserException error(String string, long l) {
        return this.error(JSErrorType.SyntaxError, string, l);
    }

    protected final ParserException error(JSErrorType jSErrorType, String string, long l) {
        int n = Token.descPosition(l);
        int n2 = this.source.getLine(n);
        int n3 = this.source.getColumn(n);
        String string2 = ErrorManager.format(string, this.source, n2, n3, l);
        return new ParserException(jSErrorType, string2, this.source, n2, n3, l);
    }

    protected final ParserException error(String string) {
        return this.error(JSErrorType.SyntaxError, string);
    }

    protected final ParserException error(JSErrorType jSErrorType, String string) {
        int n = Token.descPosition(this.token);
        int n2 = n - this.linePosition;
        String string2 = ErrorManager.format(string, this.source, this.line, n2, this.token);
        return new ParserException(jSErrorType, string2, this.source, this.line, n2, this.token);
    }

    protected final void warning(JSErrorType jSErrorType, String string, long l) {
        this.errors.warning(this.error(jSErrorType, string, l));
    }

    protected final String expectMessage(TokenType tokenType) {
        String string;
        String string2 = Token.toString(this.source, this.token);
        if (tokenType == null) {
            string = AbstractParser.message("expected.stmt", string2);
        } else {
            String string3 = tokenType.getNameOrType();
            string = AbstractParser.message("expected", string3, string2);
        }
        return string;
    }

    protected final void expect(TokenType tokenType) throws ParserException {
        this.expectDontAdvance(tokenType);
        this.next();
    }

    protected final void expectDontAdvance(TokenType tokenType) throws ParserException {
        if (this.type != tokenType) {
            throw this.error(this.expectMessage(tokenType));
        }
    }

    protected final Object expectValue(TokenType tokenType) throws ParserException {
        if (this.type != tokenType) {
            throw this.error(this.expectMessage(tokenType));
        }
        Object object = this.getValue();
        this.next();
        return object;
    }

    protected final Object getValue() {
        return this.getValue(this.token);
    }

    protected final Object getValue(long l) {
        try {
            return this.lexer.getValueOf(l, this.isStrictMode);
        }
        catch (ParserException parserException) {
            this.errors.error(parserException);
            return null;
        }
    }

    protected final boolean isNonStrictModeIdent() {
        return !this.isStrictMode && this.type.getKind() == TokenKind.FUTURESTRICT;
    }

    protected final IdentNode getIdent() {
        long l = this.token;
        if (this.isNonStrictModeIdent()) {
            l = Token.recast(this.token, TokenType.IDENT);
            String string = (String)this.getValue(l);
            this.next();
            return this.createIdentNode(l, this.finish, string).setIsFutureStrictName();
        }
        String string = (String)this.expectValue(TokenType.IDENT);
        if (string == null) {
            return null;
        }
        return this.createIdentNode(l, this.finish, string);
    }

    protected IdentNode createIdentNode(long l, int n, String string) {
        String string2 = this.canonicalNames.putIfAbsent(string, string);
        String string3 = string2 != null ? string2 : string;
        return new IdentNode(l, n, string3);
    }

    protected final boolean isIdentifierName(long l) {
        TokenType tokenType = Token.descType(l);
        TokenKind tokenKind = tokenType.getKind();
        if (tokenKind == TokenKind.KEYWORD || tokenKind == TokenKind.FUTURE || tokenKind == TokenKind.FUTURESTRICT) {
            return true;
        }
        if (tokenKind == TokenKind.LITERAL) {
            switch (tokenType) {
                case FALSE: 
                case NULL: 
                case TRUE: {
                    return true;
                }
            }
            return false;
        }
        long l2 = Token.recast(l, TokenType.IDENT);
        String string = (String)this.getValue(l2);
        return !string.isEmpty() && Character.isJavaIdentifierStart(string.charAt(0));
    }

    protected final IdentNode getIdentifierName() {
        if (this.type == TokenType.IDENT) {
            return this.getIdent();
        }
        if (this.isIdentifierName(this.token)) {
            long l = Token.recast(this.token, TokenType.IDENT);
            String string = (String)this.getValue(l);
            this.next();
            return this.createIdentNode(l, this.finish, string);
        }
        this.expect(TokenType.IDENT);
        return null;
    }

    protected final LiteralNode<?> getLiteral() throws ParserException {
        long l = this.token;
        Object object = this.getValue();
        this.next();
        LiteralNode<Object> literalNode = null;
        if (object == null) {
            literalNode = LiteralNode.newInstance(l, this.finish);
        } else if (object instanceof Number) {
            literalNode = LiteralNode.newInstance(l, this.finish, (Number)object, this.getNumberToStringConverter());
        } else if (object instanceof String) {
            literalNode = LiteralNode.newInstance(l, this.finish, (String)object);
        } else if (object instanceof Lexer.LexerToken) {
            this.validateLexerToken((Lexer.LexerToken)object);
            literalNode = LiteralNode.newInstance(l, this.finish, (Lexer.LexerToken)object);
        } else assert (false) : "unknown type for LiteralNode: " + object.getClass();
        return literalNode;
    }

    protected void validateLexerToken(Lexer.LexerToken lexerToken) {
    }

    protected Function<Number, String> getNumberToStringConverter() {
        return null;
    }
}

