/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.utils;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.java.j2seplatform.api.J2SEPlatformCreator;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.tooling.data.PayaraJavaSEConfig;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.server.config.ConfigBuilderProvider;
import org.netbeans.modules.payara.tooling.server.config.JavaSEPlatform;
import org.netbeans.modules.payara.tooling.utils.JavaUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public class JavaUtils {
    private static final Logger LOGGER = PayaraLogger.get(JavaUtils.class);
    private static final String PF_PLATFORM_DISPLAY_NAME_PREFIX = "JDK ";
    private static final String PF_PLATFORM_DISPLAY_NAME_SUFFIX = " (Payara)";
    public static final String JAVA_SE_SPECIFICATION_NAME = "j2se";

    public static JavaPlatform[] getInstalledJavaSEPlatforms() {
        return JavaPlatformManager.getDefault().getPlatforms(null, new Specification(JAVA_SE_SPECIFICATION_NAME, null));
    }

    public static boolean isJavaPlatformSupported(@NonNull PayaraInstance instance, @NonNull File javaHome) {
        JavaSEPlatform javaSEPlatform;
        Parameters.notNull((CharSequence)"instance", (Object)instance);
        Parameters.notNull((CharSequence)"javaHome", (Object)javaHome);
        PayaraJavaSEConfig javaSEConfig = ConfigBuilderProvider.getBuilder((PayaraServer)instance).getJavaSEConfig(instance.getVersion());
        Set supportedPlatforms = javaSEConfig.getPlatforms();
        JavaPlatform platform = JavaUtils.findInstalledPlatform(javaHome);
        if (platform != null && (javaSEPlatform = JavaSEPlatform.toValue((String)platform.getSpecification().getVersion().toString())) != null && supportedPlatforms.contains(javaSEPlatform)) {
            return true;
        }
        String javaExec = org.netbeans.modules.payara.tooling.utils.JavaUtils.javaVmExecutableFullPath((String)javaHome.getAbsolutePath());
        JavaUtils.JavaVersion version = org.netbeans.modules.payara.tooling.utils.JavaUtils.javaVmVersion((File)new File(javaExec));
        JavaSEPlatform javaSEPlatform2 = version != null ? version.toPlatform() : null;
        return javaSEPlatform2 != null && supportedPlatforms.contains(javaSEPlatform2);
    }

    public static JavaPlatform findInstalledPlatform(@NonNull File javaHome) {
        Parameters.notNull((CharSequence)"javaHome", (Object)javaHome);
        JavaPlatform[] platforms = JavaUtils.getInstalledJavaSEPlatforms();
        JavaPlatform javaPlatform = null;
        for (JavaPlatform platform : platforms) {
            for (FileObject fo : platform.getInstallFolders()) {
                if (!javaHome.equals(FileUtil.toFile((FileObject)fo))) continue;
                javaPlatform = platform;
                break;
            }
            if (javaPlatform != null) break;
        }
        return javaPlatform;
    }

    public static JavaPlatform findPlatformByJavaHome(@NonNull JavaPlatform[] javaPlatforms, @NonNull File javaHome) {
        Parameters.notNull((CharSequence)"javaPlatforms", (Object)javaPlatforms);
        Parameters.notNull((CharSequence)"javaHome", (Object)javaHome);
        JavaPlatform javaPlatform = null;
        for (JavaPlatform platform : javaPlatforms) {
            for (FileObject fo : platform.getInstallFolders()) {
                if (!javaHome.equals(FileUtil.toFile((FileObject)fo))) continue;
                javaPlatform = platform;
                break;
            }
            if (javaPlatform != null) break;
        }
        return javaPlatform;
    }

    public static JavaPlatform[] findSupportedPlatforms(@NonNull PayaraInstance instance) {
        Parameters.notNull((CharSequence)"instance", (Object)instance);
        LinkedList<JavaPlatform> platformsList = new LinkedList<JavaPlatform>();
        JavaPlatform[] allPlatforms = JavaUtils.getInstalledJavaSEPlatforms();
        PayaraJavaSEConfig javaSEConfig = ConfigBuilderProvider.getBuilder((PayaraServer)instance).getJavaSEConfig(instance.getVersion());
        Set supportedPlatforms = javaSEConfig.getPlatforms();
        if (supportedPlatforms == null || supportedPlatforms.isEmpty()) {
            return new JavaPlatform[0];
        }
        for (JavaPlatform platform : allPlatforms) {
            for (FileObject fo : platform.getInstallFolders()) {
                if (!supportedPlatforms.contains(JavaSEPlatform.toValue((String)platform.getSpecification().getVersion().toString()))) continue;
                platformsList.add(platform);
            }
        }
        JavaPlatform[] platforms = new JavaPlatform[platformsList.size()];
        int i = 0;
        for (JavaPlatform platform : platformsList) {
            platforms[i++] = platform;
        }
        return platforms;
    }

    public static String getJavaHome(JavaPlatform platform) {
        FileObject javaHomeFO;
        String javaHome = null;
        Iterator platformIterator = platform.getInstallFolders().iterator();
        if (platformIterator.hasNext() && (javaHomeFO = (FileObject)platformIterator.next()) != null) {
            javaHome = FileUtil.toFile((FileObject)javaHomeFO).getAbsolutePath();
        }
        return javaHome;
    }

    public static String getDefaultJavaHome() {
        return JavaUtils.getJavaHome(JavaPlatformManager.getDefault().getDefaultPlatform());
    }

    public static boolean checkAndRegisterJavaPlatform(String javaHome) {
        if (javaHome == null) {
            return false;
        }
        File javaHomeFile = new File(javaHome);
        if (javaHomeFile.isDirectory() && javaHomeFile.canRead()) {
            JavaUtils.JavaVersion javaVersion;
            if (JavaUtils.findInstalledPlatform(javaHomeFile) != null) {
                return true;
            }
            File javaVm = new File(org.netbeans.modules.payara.tooling.utils.JavaUtils.javaVmExecutableFullPath((String)javaHome));
            if (javaVm.canExecute() && (javaVersion = org.netbeans.modules.payara.tooling.utils.JavaUtils.javaVmVersion((File)javaVm)) != null) {
                String platformversion = javaVersion.toPlatform().toString();
                StringBuilder sb = new StringBuilder(PF_PLATFORM_DISPLAY_NAME_PREFIX.length() + PF_PLATFORM_DISPLAY_NAME_SUFFIX.length() + platformversion.length());
                sb.append(PF_PLATFORM_DISPLAY_NAME_PREFIX);
                sb.append(platformversion);
                sb.append(PF_PLATFORM_DISPLAY_NAME_SUFFIX);
                try {
                    J2SEPlatformCreator.createJ2SEPlatform((FileObject)FileUtil.toFileObject((File)javaHomeFile), (String)sb.toString());
                    return true;
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.INFO, "Unable to register Java platform {0}", javaHome);
                }
            }
        }
        return false;
    }
}

