/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.html.angular.AngularAttributeCompletionItem;
import org.netbeans.modules.html.angular.AngularCustomAttribute;
import org.netbeans.modules.html.angular.Utils;
import org.netbeans.modules.html.angular.model.AngularModel;
import org.netbeans.modules.html.angular.model.Directive;
import org.netbeans.modules.html.editor.api.gsf.CustomAttribute;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.spi.editor.completion.CompletionItem;

public class AngularHtmlExtension
extends HtmlExtension {
    public boolean isApplicationPiece(HtmlParserResult result) {
        return AngularModel.getModel(result).isAngularPage();
    }

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights(HtmlParserResult result, SchedulerEvent event) {
        HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        AngularModel model = AngularModel.getModel(result);
        for (Attribute ngAttr : model.getNgAttributes()) {
            OffsetRange dor = Utils.getValidDocumentOffsetRange(ngAttr.from(), ngAttr.from() + ngAttr.name().length(), result.getSnapshot());
            if (dor == null) continue;
            highlights.put(dor, ColoringAttributes.CONSTRUCTOR_SET);
        }
        return highlights;
    }

    public List<CompletionItem> completeAttributes(HtmlExtension.CompletionContext context) {
        AngularModel model = AngularModel.getModel(context.getResult());
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        Element element = context.getCurrentNode();
        if (element != null) {
            switch (element.type()) {
                case OPEN_TAG: {
                    OpenTag ot = (OpenTag)element;
                    String name = ot.unqualifiedName().toString();
                    Collection<CustomAttribute> customAttributes = AngularCustomAttribute.getCustomAttributes(model.getPrevailingAttributeConvention());
                    for (CustomAttribute ca : customAttributes) {
                        items.add((CompletionItem)new AngularAttributeCompletionItem(ca, context.getCCItemStartOffset(), model.isAngularPage()));
                    }
                    break;
                }
            }
        }
        if (context.getPrefix().length() > 0) {
            Iterator itr = items.iterator();
            while (itr.hasNext()) {
                CharSequence insertPrefix = ((CompletionItem)itr.next()).getInsertPrefix();
                if (insertPrefix == null || LexerUtils.startsWith((CharSequence)insertPrefix, (CharSequence)context.getPrefix(), (boolean)true, (boolean)false)) continue;
                itr.remove();
            }
        }
        return items;
    }

    public boolean isCustomAttribute(Attribute attribute, HtmlSource source) {
        return Directive.isAngularAttribute(attribute);
    }

    public Collection<CustomAttribute> getCustomAttributes(String elementName) {
        return AngularCustomAttribute.getCustomAttributes();
    }
}

