/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.runconfigs.RunConfigRemote;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.modules.php.project.ui.customizer.RunAsRemoteWeb;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class RunAsRemoteWeb
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = 857876755153456465L;
    private static final PhpProjectProperties.UploadFiles DEFAULT_UPLOAD_FILES = PhpProjectProperties.UploadFiles.ON_RUN;
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private final SourcesFolderProvider sourcesFolderProvider;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JButton manageRemoteConnectionButton;
    private JComboBox<RemoteConfiguration> remoteConnectionComboBox;
    private JLabel remoteConnectionHintLabel;
    private JLabel remoteConnectionLabel;
    private JComboBox<String> runAsComboBox;
    private JLabel runAsLabel;
    private JLabel uploadDirectoryLabel;
    private JTextField uploadDirectoryTextField;
    private JComboBox<PhpProjectProperties.UploadFiles> uploadFilesComboBox;
    private JLabel uploadFilesHintLabel;
    private JLabel uploadFilesLabel;
    private JLabel urlLabel;
    private JTextField urlTextField;

    public RunAsRemoteWeb(ConfigManager manager, SourcesFolderProvider sourcesFolderProvider) {
        super(manager);
        this.sourcesFolderProvider = sourcesFolderProvider;
        this.initComponents();
        this.labels = new JLabel[]{this.urlLabel, this.uploadDirectoryLabel, this.indexFileLabel};
        this.textFields = new JTextField[]{this.urlTextField, this.uploadDirectoryTextField, this.indexFileTextField};
        this.propertyNames = new String[]{"url", "remoteDirectory", "indexFile"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        this.populateRemoteConnectionComboBox();
        this.remoteConnectionComboBox.setRenderer(new RunAsRemoteWeb.RemoteConnectionRenderer());
        this.remoteConnectionComboBox.setKeySelectionManager(RemoteUtils.createRemoteConfigurationKeySelectionManager());
        for (PhpProjectProperties.UploadFiles uploadFiles : PhpProjectProperties.UploadFiles.values()) {
            this.uploadFilesComboBox.addItem(uploadFiles);
        }
        this.uploadFilesComboBox.setRenderer(new RunAsRemoteWeb.RemoteUploadRenderer());
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater dl = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(dl);
        }
        ComboBoxSelectedItemConvertor remoteConfigurationConvertor = new ComboBoxSelectedItemConvertor(){

            @Override
            public String convert(JComboBox comboBox) {
                RemoteConfiguration remoteConfiguration = (RemoteConfiguration)comboBox.getSelectedItem();
                assert (remoteConfiguration != null);
                return remoteConfiguration.getName();
            }
        };
        this.remoteConnectionComboBox.addActionListener(new ComboBoxUpdater("remoteConnection", this.remoteConnectionLabel, this.remoteConnectionComboBox, remoteConfigurationConvertor));
        ComboBoxSelectedItemConvertor remoteUploadConvertor = new ComboBoxSelectedItemConvertor(){

            @Override
            public String convert(JComboBox comboBox) {
                PhpProjectProperties.UploadFiles uploadFiles = (PhpProjectProperties.UploadFiles)((Object)comboBox.getSelectedItem());
                assert (uploadFiles != null);
                RunAsRemoteWeb.this.uploadFilesHintLabel.setText(uploadFiles.getDescription());
                return uploadFiles.name();
            }
        };
        this.uploadFilesComboBox.addActionListener(new ComboBoxUpdater("remoteUpload", this.uploadFilesLabel, this.uploadFilesComboBox, remoteUploadConvertor));
        this.runAsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunAsRemoteWeb.this.changeSupport.fireChange();
            }
        });
        this.remoteConnectionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RunAsRemoteWeb.this.updateRemoteConnectionHint();
                }
            }
        });
        this.uploadDirectoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                RunAsRemoteWeb.this.updateRemoteConnectionHint();
            }
        });
        this.updateRemoteConnectionHint();
    }

    @Override
    protected PhpProjectProperties.RunAsType getRunAsType() {
        return RunConfigRemote.getRunAsType();
    }

    @Override
    protected String getDisplayName() {
        return RunConfigRemote.getDisplayName();
    }

    @Override
    protected JComboBox<String> getRunAsCombo() {
        return this.runAsComboBox;
    }

    @Override
    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    @Override
    protected void loadFields() {
        for (int i = 0; i < this.textFields.length; ++i) {
            this.textFields[i].setText(this.getValue(this.propertyNames[i]));
        }
        this.selectRemoteConnection();
        PhpProjectProperties.UploadFiles uploadFiles = null;
        String remoteUpload = this.getValue("remoteUpload");
        if (remoteUpload == null) {
            uploadFiles = DEFAULT_UPLOAD_FILES;
        } else {
            try {
                uploadFiles = PhpProjectProperties.UploadFiles.valueOf(remoteUpload);
            }
            catch (IllegalArgumentException iae) {
                uploadFiles = DEFAULT_UPLOAD_FILES;
            }
        }
        this.uploadFilesComboBox.setSelectedItem((Object)uploadFiles);
    }

    @Override
    protected void validateFields() {
        this.changeSupport.fireChange();
    }

    public void addRunAsRemoteWebListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeRunAsRemoteWebListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void populateRemoteConnectionComboBox() {
        List<RemoteConfiguration> connections = RemoteConnections.get().getRemoteConfigurations();
        if (connections.isEmpty()) {
            connections = Arrays.asList(RunConfigRemote.NO_REMOTE_CONFIGURATION);
        }
        DefaultComboBoxModel<RemoteConfiguration> model = new DefaultComboBoxModel<RemoteConfiguration>(new Vector<RemoteConfiguration>(connections));
        this.remoteConnectionComboBox.setModel(model);
    }

    private void selectRemoteConnection() {
        String remoteConnection = this.getValue("remoteConnection");
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.remoteConnectionComboBox.getModel();
        if (remoteConnection == null && model.getIndexOf(RunConfigRemote.NO_REMOTE_CONFIGURATION) != -1) {
            this.remoteConnectionComboBox.setSelectedItem(RunConfigRemote.NO_REMOTE_CONFIGURATION);
            return;
        }
        int size = this.remoteConnectionComboBox.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            RemoteConfiguration rc = this.remoteConnectionComboBox.getItemAt(i);
            if (remoteConnection != null && !"no-config".equals(remoteConnection) && !remoteConnection.equals(rc.getName())) continue;
            this.remoteConnectionComboBox.setSelectedItem(rc);
            return;
        }
        if (model.getIndexOf(RunConfigRemote.NO_REMOTE_CONFIGURATION) == -1) {
            model.addElement(RunConfigRemote.NO_REMOTE_CONFIGURATION);
        }
        this.remoteConnectionComboBox.setSelectedItem(RunConfigRemote.NO_REMOTE_CONFIGURATION);
    }

    public RunConfigRemote createRunConfig() {
        return ((RunConfigRemote)((RunConfigRemote)((RunConfigRemote)RunConfigRemote.create().setUrl(this.urlTextField.getText().trim())).setIndexParentDir(this.sourcesFolderProvider.getSourcesFolder())).setIndexRelativePath(this.indexFileTextField.getText())).setRemoteConfiguration((RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem()).setUploadDirectory(this.uploadDirectoryTextField.getText().trim()).setUploadFilesType((PhpProjectProperties.UploadFiles)((Object)this.uploadFilesComboBox.getSelectedItem()));
    }

    public void setUrl(String url) {
        this.urlTextField.setText(url);
    }

    public void setRemoteConfiguration(RemoteConfiguration remoteConfiguration) {
        this.remoteConnectionComboBox.setSelectedItem(remoteConfiguration);
    }

    public void setUploadDirectory(String uploadDirectory) {
        this.uploadDirectoryTextField.setText(uploadDirectory);
    }

    public void setUploadFiles(PhpProjectProperties.UploadFiles uploadFiles) {
        this.uploadFilesComboBox.setSelectedItem((Object)uploadFiles);
    }

    public void setIndexFile(String indexFile) {
        this.indexFileTextField.setText(indexFile);
    }

    public void hideIndexFile() {
        this.indexFileLabel.setVisible(false);
        this.indexFileTextField.setVisible(false);
        this.indexFileBrowseButton.setVisible(false);
    }

    public void hideRunAs() {
        this.runAsLabel.setVisible(false);
        this.runAsComboBox.setVisible(false);
    }

    public void hideUploadFiles() {
        this.uploadFilesLabel.setVisible(false);
        this.uploadFilesComboBox.setVisible(false);
        this.uploadFilesHintLabel.setVisible(false);
    }

    void updateRemoteConnectionHint() {
        this.remoteConnectionHintLabel.setText(this.createRunConfig().getRemoteConnectionHint());
    }

    private void initComponents() {
        this.runAsLabel = new JLabel();
        this.runAsComboBox = new JComboBox();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.remoteConnectionLabel = new JLabel();
        this.remoteConnectionComboBox = new JComboBox();
        this.manageRemoteConnectionButton = new JButton();
        this.uploadDirectoryLabel = new JLabel();
        this.uploadDirectoryTextField = new JTextField();
        this.remoteConnectionHintLabel = new JLabel();
        this.uploadFilesLabel = new JLabel();
        this.uploadFilesComboBox = new JComboBox();
        this.uploadFilesHintLabel = new JLabel();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.runAsLabel.setLabelFor(this.runAsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_RunAs"));
        this.urlLabel.setLabelFor(this.urlTextField);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_ProjectUrl"));
        this.urlTextField.setColumns(20);
        this.remoteConnectionLabel.setLabelFor(this.remoteConnectionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.remoteConnectionLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_RemoteConnection"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageRemoteConnectionButton, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_Manage"));
        this.manageRemoteConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsRemoteWeb.this.manageRemoteConnectionButtonActionPerformed(evt);
            }
        });
        this.uploadDirectoryLabel.setLabelFor(this.uploadDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.uploadDirectoryLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_UploadDirectory"));
        this.uploadDirectoryTextField.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.remoteConnectionHintLabel, (String)"dummy");
        this.uploadFilesLabel.setLabelFor(this.uploadFilesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.uploadFilesLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_UploadFiles"));
        Mnemonics.setLocalizedText((JLabel)this.uploadFilesHintLabel, (String)"dummy");
        this.indexFileLabel.setLabelFor(this.indexFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_IndexFile"));
        this.indexFileTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsRemoteWeb.class, (String)"LBL_BrowseIndex"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsRemoteWeb.this.indexFileBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.remoteConnectionLabel).addComponent(this.uploadDirectoryLabel).addComponent(this.uploadFilesLabel).addComponent(this.urlLabel).addComponent(this.runAsLabel).addComponent(this.indexFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.remoteConnectionHintLabel).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.indexFileTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indexFileBrowseButton)).addComponent(this.urlTextField, GroupLayout.Alignment.TRAILING, -2, 1, Short.MAX_VALUE).addComponent(this.uploadFilesHintLabel).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.remoteConnectionComboBox, 0, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manageRemoteConnectionButton)).addComponent(this.uploadDirectoryTextField).addComponent(this.uploadFilesComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.runAsComboBox, 0, -1, Short.MAX_VALUE)))));
        layout.linkSize(0, this.indexFileBrowseButton, this.manageRemoteConnectionButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runAsLabel).addComponent(this.runAsComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.urlLabel).addComponent(this.urlTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.indexFileLabel).addComponent(this.indexFileTextField, -2, -1, -2).addComponent(this.indexFileBrowseButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.remoteConnectionLabel).addComponent(this.manageRemoteConnectionButton).addComponent(this.remoteConnectionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uploadDirectoryLabel).addComponent(this.uploadDirectoryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remoteConnectionHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uploadFilesLabel).addComponent(this.uploadFilesComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uploadFilesHintLabel)));
        this.runAsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsLabel.AccessibleContext.accessibleName"));
        this.runAsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsLabel.AccessibleContext.accessibleDescription"));
        this.runAsComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsComboBox.AccessibleContext.accessibleName"));
        this.runAsComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.runAsComboBox.AccessibleContext.accessibleDescription"));
        this.urlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlLabel.AccessibleContext.accessibleName"));
        this.urlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsLocalWeb.urlLabel.AccessibleContext.accessibleDescription"));
        this.urlTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlTextField.AccessibleContext.accessibleName"));
        this.urlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.urlTextField.AccessibleContext.accessibleDescription"));
        this.remoteConnectionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionLabel.AccessibleContext.accessibleName"));
        this.remoteConnectionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionLabel.AccessibleContext.accessibleDescription"));
        this.remoteConnectionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionComboBox.AccessibleContext.accessibleName"));
        this.remoteConnectionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionComboBox.AccessibleContext.accessibleDescription"));
        this.manageRemoteConnectionButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.manageRemoteConnectionButton.AccessibleContext.accessibleName"));
        this.manageRemoteConnectionButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.manageRemoteConnectionButton.AccessibleContext.accessibleDescription"));
        this.uploadDirectoryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryLabel.AccessibleContext.accessibleName"));
        this.uploadDirectoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryLabel.AccessibleContext.accessibleDescription"));
        this.uploadDirectoryTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryTextField.AccessibleContext.accessibleName"));
        this.uploadDirectoryTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadDirectoryTextField.AccessibleContext.accessibleDescription"));
        this.remoteConnectionHintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionHintLabel.AccessibleContext.accessibleName"));
        this.remoteConnectionHintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.remoteConnectionHintLabel.AccessibleContext.accessibleDescription"));
        this.uploadFilesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesLabel.AccessibleContext.accessibleName"));
        this.uploadFilesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesLabel.AccessibleContext.accessibleDescription"));
        this.uploadFilesComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesComboBox.AccessibleContext.accessibleName"));
        this.uploadFilesComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesComboBox.AccessibleContext.accessibleDescription"));
        this.uploadFilesHintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesHintLabel.AccessibleContext.accessibleName"));
        this.uploadFilesHintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.uploadFilesHintLabel.AccessibleContext.accessibleDescription"));
        this.indexFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileLabel.AccessibleContext.accessibleName"));
        this.indexFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileLabel.AccessibleContext.accessibleDescription"));
        this.indexFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileTextField.AccessibleContext.accessibleName"));
        this.indexFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileTextField.AccessibleContext.accessibleDescription"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileBrowseButton.AccessibleContext.accessibleName"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.indexFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsRemoteWeb.class, (String)"RunAsRemoteWeb.AccessibleContext.accessibleDescription"));
    }

    private void manageRemoteConnectionButtonActionPerformed(ActionEvent evt) {
        if (RemoteConnections.get().openManager((RemoteConfiguration)this.remoteConnectionComboBox.getSelectedItem())) {
            this.populateRemoteConnectionComboBox();
            this.selectRemoteConnection();
            this.updateRemoteConnectionHint();
        }
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent evt) {
        try {
            Utils.browseFolderFile(PhpVisibilityQuery.getDefault(), this.sourcesFolderProvider.getSourcesFolder(), this.indexFileTextField);
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private class ComboBoxUpdater
    implements ActionListener {
        private final JLabel label;
        private final JComboBox field;
        private final String propName;
        private final ComboBoxSelectedItemConvertor comboBoxConvertor;

        public ComboBoxUpdater(String propName, JLabel label, JComboBox field, ComboBoxSelectedItemConvertor comboBoxConvertor) {
            this.propName = propName;
            this.label = label;
            this.field = field;
            this.comboBoxConvertor = comboBoxConvertor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value = this.comboBoxConvertor.convert(this.field);
            RunAsRemoteWeb.this.putValue(this.propName, value);
            RunAsRemoteWeb.this.markAsModified(this.label, this.propName, value);
            RunAsRemoteWeb.this.validateFields();
        }
    }

    static interface ComboBoxSelectedItemConvertor {
        public String convert(JComboBox var1);
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String propName, JLabel label, JTextField field) {
            super(propName, label, field);
        }

        @Override
        protected String getPropValue() {
            String value = super.getPropValue();
            if (this.getPropName().equals("remoteDirectory")) {
                value = RemoteUtils.sanitizeUploadDirectory(value, true);
            }
            return value;
        }

        @Override
        protected final String getDefaultValue() {
            return RunAsRemoteWeb.this.getDefaultValue(this.getPropName());
        }
    }
}

