/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.UnionType;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.hints.errors.AddCatchFix;
import org.netbeans.modules.java.hints.errors.ErrorFixesFakeHint;
import org.netbeans.modules.java.hints.errors.MagicSurroundWithTryCatchFix;
import org.netbeans.modules.java.hints.errors.OrigSurroundWithTryCatchFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public final class UncaughtException
implements ErrorRule<Void> {
    private static final Object KEY_HANDLED_EXCEPTIONS = new Object();
    static boolean allowMagicSurround = false;
    static final String ERR_IMPLICIT_CLOSE = "compiler.err.unreported.exception.implicit.close";
    static final String ERR_UNREPORTED = "compiler.err.unreported.exception.need.to.catch.or.throw";
    private static final Set<String> ERRCODES = new HashSet<String>(Arrays.asList("compiler.err.unreported.exception.need.to.catch.or.throw", "compiler.err.unreported.exception.implicit.close"));
    private static final Set<ElementKind> EXECUTABLE_ELEMENTS = EnumSet.of(ElementKind.CONSTRUCTOR, ElementKind.METHOD);
    static final Set<Tree.Kind> STATEMENT_KINDS;

    private List<? extends TypeMirror> findUncaughtExceptions(CompilationInfo info, TreePath path, List<? extends TypeMirror> exceptions) {
        ArrayList<? extends TypeMirror> result = new ArrayList<TypeMirror>();
        result.addAll(exceptions);
        Tree lastTree = null;
        while (path != null) {
            TryTree tt;
            TypeMirror tm;
            Tree currentTree = path.getLeaf();
            if (currentTree.getKind() == Tree.Kind.METHOD && (tm = info.getTrees().getTypeMirror(path)) != null && tm.getKind() == TypeKind.EXECUTABLE) {
                for (TypeMirror typeMirror : ((ExecutableType)tm).getThrownTypes()) {
                    Iterator it = result.iterator();
                    while (it.hasNext()) {
                        if (!info.getTypes().isSameType((TypeMirror)it.next(), typeMirror)) continue;
                        it.remove();
                    }
                }
                break;
            }
            if (currentTree.getKind() == Tree.Kind.LAMBDA_EXPRESSION) break;
            if (currentTree.getKind() == Tree.Kind.TRY && (tt = (TryTree)currentTree).getBlock() == lastTree) {
                for (CatchTree catchTree : tt.getCatches()) {
                    TreePath catchPath = new TreePath(new TreePath(path, catchTree), catchTree.getParameter());
                    VariableElement variable = (VariableElement)info.getTrees().getElement(catchPath);
                    if (variable == null) continue;
                    TypeMirror variableType = variable.asType();
                    if (variableType.getKind() == TypeKind.UNION) {
                        result.removeAll(((UnionType)variableType).getAlternatives());
                        continue;
                    }
                    result.remove(variableType);
                }
            }
            lastTree = path.getLeaf();
            path = path.getParentPath();
        }
        ArrayList<TypeMirror> filtered = new ArrayList<TypeMirror>();
        Iterator sourceIt = result.iterator();
        block4: while (sourceIt.hasNext()) {
            TypeMirror sourceType = (TypeMirror)sourceIt.next();
            Iterator iterator = filtered.iterator();
            while (iterator.hasNext()) {
                TypeMirror filteredType = (TypeMirror)iterator.next();
                if (info.getTypes().isSubtype(sourceType, filteredType)) {
                    sourceIt.remove();
                    continue block4;
                }
                if (!info.getTypes().isSubtype(filteredType, sourceType)) continue;
                iterator.remove();
                break;
            }
            filtered.add(sourceType);
        }
        return filtered;
    }

    public Set<String> getCodes() {
        return ERRCODES;
    }

    /*
     * WARNING - void declaration
     */
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        HashSet<? extends TypeMirror> alreadyHandled;
        boolean disableSurroundWithTryCatch;
        List<? extends TypeMirror> uncaught;
        TreePath path;
        ArrayList<Fix> result;
        block41: {
            block40: {
                TypeMirror varClose;
                Element definedClose;
                result = new ArrayList<Fix>();
                path = info.getTreeUtilities().pathFor(offset + 1);
                uncaught = null;
                disableSurroundWithTryCatch = false;
                alreadyHandled = null;
                try {
                    int lineNumber = NbDocument.findLineNumber((StyledDocument)((StyledDocument)info.getDocument()), (int)info.getSnapshot().getOriginalOffset(offset));
                    HashMap<Integer, HashSet<? extends TypeMirror>> alreadyHandledMap = (HashMap<Integer, HashSet<? extends TypeMirror>>)info.getCachedValue(KEY_HANDLED_EXCEPTIONS);
                    if (alreadyHandledMap == null) {
                        alreadyHandledMap = new HashMap<Integer, HashSet<? extends TypeMirror>>();
                        info.putCachedValue(KEY_HANDLED_EXCEPTIONS, alreadyHandledMap, CompilationInfo.CacheClearPolicy.ON_TASK_END);
                    }
                    if ((alreadyHandled = (HashSet<? extends TypeMirror>)alreadyHandledMap.get(lineNumber)) == null) {
                        alreadyHandled = new HashSet<TypeMirror>();
                        alreadyHandledMap.put(lineNumber, alreadyHandled);
                    }
                }
                catch (IOException lineNumber) {
                    // empty catch block
                }
                if (!ERR_IMPLICIT_CLOSE.equals(diagnosticKey) || path.getLeaf().getKind() != Tree.Kind.VARIABLE) break block40;
                TypeMirror varType = info.getTrees().getTypeMirror(path);
                if (!Utilities.isValidType(varType) || varType.getKind() != TypeKind.DECLARED) break block41;
                DeclaredType decl = (DeclaredType)varType;
                Element jdkClose = info.getElementUtilities().findElement("java.lang.AutoCloseable.close()");
                if (jdkClose == null || jdkClose.getKind() != ElementKind.METHOD || (definedClose = info.getElementUtilities().getImplementationOf((ExecutableElement)jdkClose, (TypeElement)decl.asElement())) == null || !Utilities.isValidType(varClose = info.getTypes().asMemberOf(decl, definedClose)) || varClose.getKind() != TypeKind.EXECUTABLE) break block41;
                ExecutableType etype = (ExecutableType)varClose;
                uncaught = new ArrayList<TypeMirror>(etype.getThrownTypes());
                break block41;
            }
            block11: while (path != null) {
                Tree leaf = path.getLeaf();
                switch (leaf.getKind()) {
                    case METHOD_INVOCATION: {
                        String ident;
                        MethodInvocationTree mit = (MethodInvocationTree)leaf;
                        if (mit.getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && ("super".equals(ident = ((IdentifierTree)mit.getMethodSelect()).getName().toString()) || "this".equals(ident))) {
                            Element element = info.getTrees().getElement(path);
                            disableSurroundWithTryCatch = element != null && element.getKind() == ElementKind.CONSTRUCTOR;
                        }
                    }
                    case NEW_CLASS: {
                        Element el = info.getTrees().getElement(path);
                        if (!UncaughtException.isInsideMethodOrInitializer(path)) {
                            disableSurroundWithTryCatch = true;
                        }
                        if (this.isThisParameter(path)) {
                            boolean bl = disableSurroundWithTryCatch = el != null && (el.getKind() == ElementKind.CONSTRUCTOR || el.getKind() == ElementKind.METHOD);
                        }
                        if (el == null || !EXECUTABLE_ELEMENTS.contains((Object)el.getKind())) break block11;
                        TypeMirror uncaughtException = leaf.getKind() == Tree.Kind.NEW_CLASS ? info.getTrees().getTypeMirror(new TreePath(path, ((NewClassTree)leaf).getIdentifier())) : info.getTrees().getTypeMirror(new TreePath(path, ((MethodInvocationTree)leaf).getMethodSelect()));
                        if (uncaughtException != null && uncaughtException.getKind() == TypeKind.EXECUTABLE) {
                            uncaught = ((ExecutableType)uncaughtException).getThrownTypes();
                            break block11;
                        }
                        uncaught = ((ExecutableElement)el).getThrownTypes();
                        break block11;
                    }
                    case THROW: {
                        TypeMirror uncaughtException = info.getTrees().getTypeMirror(new TreePath(path, ((ThrowTree)leaf).getExpression()));
                        uncaught = uncaughtException.getKind() != TypeKind.UNION ? Collections.singletonList(uncaughtException) : ((UnionType)uncaughtException).getAlternatives();
                        break block11;
                    }
                    default: {
                        path = path.getParentPath();
                        continue block11;
                    }
                }
            }
        }
        if (uncaught != null) {
            ExecutableElement method;
            TreePath pathRec;
            uncaught = this.findUncaughtExceptions(info, path, uncaught);
            uncaught.removeAll(alreadyHandled);
            alreadyHandled.addAll(uncaught);
            for (pathRec = path; pathRec != null && pathRec.getLeaf().getKind() != Tree.Kind.METHOD; pathRec = pathRec.getParentPath()) {
                if (pathRec.getLeaf().getKind() != Tree.Kind.LAMBDA_EXPRESSION) continue;
                pathRec = null;
                break;
            }
            Tree inLast = null;
            boolean inResourceSection = false;
            block13: for (TreePath in = path; in != null; in = in.getParentPath()) {
                switch (in.getLeaf().getKind()) {
                    case TRY: {
                        if (((TryTree)in.getLeaf()).getResources().contains(inLast)) {
                            inResourceSection = true;
                        }
                    }
                    case METHOD: 
                    case ANNOTATION_TYPE: 
                    case CLASS: 
                    case ENUM: 
                    case INTERFACE: 
                    case LAMBDA_EXPRESSION: {
                        break block13;
                    }
                    default: {
                        inLast = in.getLeaf();
                        continue block13;
                    }
                }
            }
            ExecutableElement executableElement = method = pathRec != null ? (ExecutableElement)info.getTrees().getElement(pathRec) : null;
            if (method != null && !Utilities.isMethodHeaderInsideGuardedBlock(info, (MethodTree)pathRec.getLeaf())) {
                LinkedList eds = new LinkedList();
                TypeElement enclosingType = (TypeElement)method.getEnclosingElement();
                AnnotationType at = ComputeOverriding.detectOverrides((CompilationInfo)info, (TypeElement)enclosingType, (ExecutableElement)method, eds);
                Object var20_25 = null;
                if (at != null) {
                    LinkedList<? extends TypeMirror> linkedList = new LinkedList<TypeMirror>();
                    for (ElementDescription elementDescription : eds) {
                        ExecutableElement ee = (ExecutableElement)elementDescription.getHandle().resolve(info);
                        TypeMirror eType = info.getTypes().asMemberOf((DeclaredType)enclosingType.asType(), ee);
                        if (eType.getKind() != TypeKind.EXECUTABLE) continue;
                        ExecutableType executableType = (ExecutableType)eType;
                        LinkedList<? extends TypeMirror> thisDeclaredThrows = new LinkedList<TypeMirror>(executableType.getThrownTypes());
                        if (!thisDeclaredThrows.isEmpty()) {
                            Iterator dt = linkedList.iterator();
                            while (dt.hasNext()) {
                                Iterator tdt = thisDeclaredThrows.iterator();
                                while (tdt.hasNext()) {
                                    TypeMirror dtNext = (TypeMirror)dt.next();
                                    TypeMirror tdtNext = (TypeMirror)tdt.next();
                                    if (info.getTypes().isSubtype(tdtNext, dtNext)) {
                                        tdt.remove();
                                        continue;
                                    }
                                    if (info.getTypes().isSubtype(dtNext, tdtNext)) {
                                        dt.remove();
                                        continue;
                                    }
                                    tdt.remove();
                                    dt.remove();
                                }
                            }
                        }
                        linkedList.addAll(thisDeclaredThrows);
                    }
                }
                for (TypeMirror typeMirror : uncaught) {
                    void var20_27;
                    if (var20_27 != null) {
                        boolean found = false;
                        for (TypeMirror typeMirror2 : var20_27) {
                            if (!info.getTypes().isSubtype(typeMirror, typeMirror2)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                    if (typeMirror.getKind() == TypeKind.ERROR) continue;
                    result.add(new AddThrowsClauseHintImpl(info.getJavaSource(), org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)typeMirror, (boolean)true).toString(), TypeMirrorHandle.create((TypeMirror)typeMirror), (ElementHandle<ExecutableElement>)ElementHandle.create((Element)method)));
                }
            }
            if (!uncaught.isEmpty() && !disableSurroundWithTryCatch) {
                ArrayList<TypeMirrorHandle> thandles = new ArrayList<TypeMirrorHandle>();
                ArrayList<String> fqns = new ArrayList<String>();
                for (TypeMirror typeMirror : uncaught) {
                    if (typeMirror.getKind() == TypeKind.ERROR) continue;
                    thandles.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
                    fqns.add(org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)typeMirror, (boolean)true).toString());
                }
                if (ErrorFixesFakeHint.enabled(ErrorFixesFakeHint.FixKind.SURROUND_WITH_TRY_CATCH)) {
                    TreePath tryTree = MagicSurroundWithTryCatchFix.enclosingTry(path);
                    if (tryTree != null) {
                        result.add(new AddCatchFix(info, tryTree, thandles).toEditorFix());
                    }
                    if (!inResourceSection) {
                        boolean magic;
                        result.add(new OrigSurroundWithTryCatchFix(info.getJavaSource(), thandles, TreePathHandle.create((TreePath)path, (CompilationInfo)info), fqns));
                        TreePath treePath2 = this.findBlock(path);
                        boolean bl = magic = tryTree == null || allowMagicSurround;
                        if (treePath2 != null && treePath2.getLeaf().getKind() == Tree.Kind.BLOCK) {
                            magic &= ((BlockTree)treePath2.getLeaf()).getStatements().size() != 1;
                        }
                        if (magic) {
                            result.add(new MagicSurroundWithTryCatchFix(info.getJavaSource(), thandles, offset, (ElementHandle<ExecutableElement>)(method != null ? ElementHandle.create((Element)method) : null), fqns));
                        }
                    }
                }
            }
        }
        return result;
    }

    private TreePath findBlock(TreePath path) {
        while (path != null && path.getLeaf().getKind() != Tree.Kind.BLOCK) {
            path = path.getParentPath();
        }
        return path;
    }

    private boolean isThisParameter(TreePath path) {
        while (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()) && path.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            String id;
            MethodInvocationTree mi;
            if (path.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION && (mi = (MethodInvocationTree)path.getParentPath().getLeaf()).getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && ("super".equals(id = ((IdentifierTree)mi.getMethodSelect()).getName().toString()) || "this".equals(id))) {
                return true;
            }
            path = path.getParentPath();
        }
        return false;
    }

    private static boolean isInsideMethodOrInitializer(TreePath tp) {
        while (tp != null) {
            if (tp.getLeaf().getKind() == Tree.Kind.METHOD || tp.getLeaf().getKind() == Tree.Kind.BLOCK && TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getParentPath().getLeaf().getKind())) {
                return true;
            }
            tp = tp.getParentPath();
        }
        return false;
    }

    public void cancel() {
    }

    public String getId() {
        return UncaughtException.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UncaughtException.class, (String)"DN_AddThrowsClauseAndSurround");
    }

    public String getDescription() {
        return NbBundle.getMessage(UncaughtException.class, (String)"DESC_AddThrowsClauseAndSurround");
    }

    static {
        HashSet<Tree.Kind> kinds = new HashSet<Tree.Kind>();
        for (Tree.Kind k : Tree.Kind.values()) {
            Class<? extends Tree> c = k.asInterface();
            if (c == null || !StatementTree.class.isAssignableFrom(c)) continue;
            kinds.add(k);
        }
        STATEMENT_KINDS = Collections.unmodifiableSet(EnumSet.copyOf(kinds));
    }

    private static final class AddThrowsClauseHintImpl
    implements Fix {
        private JavaSource js;
        private String fqn;
        private TypeMirrorHandle thandle;
        private ElementHandle<ExecutableElement> method;

        public AddThrowsClauseHintImpl(JavaSource js, String fqn, TypeMirrorHandle thandle, ElementHandle<ExecutableElement> method) {
            this.js = js;
            this.fqn = fqn;
            this.thandle = thandle;
            this.method = method;
        }

        public String getText() {
            return NbBundle.getMessage(UncaughtException.class, (String)"FIX_AddThrowsClause", (Object[])new Object[]{String.valueOf(this.fqn)});
        }

        public ChangeInfo implement() throws IOException {
            this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    MethodTree tree = wc.getTrees().getTree((ExecutableElement)method.resolve((CompilationInfo)wc));
                    if (tree == null) {
                        Logger.getLogger(UncaughtException.class.getName()).log(Level.WARNING, "Cannot resolve Handle.fqn: " + fqn + "method: " + Arrays.asList(SourceUtils.getJVMSignature((ElementHandle)method)).toString());
                        return;
                    }
                    assert (tree.getKind() == Tree.Kind.METHOD);
                    MethodTree nue = wc.getTreeMaker().addMethodThrows(tree, (ExpressionTree)wc.getTreeMaker().Type(thandle.resolve((CompilationInfo)wc)));
                    wc.rewrite((Tree)tree, (Tree)nue);
                }
            }).commit();
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddThrowsClauseHintImpl other = (AddThrowsClauseHintImpl)obj;
            if (!(this.js == other.js || this.js != null && this.js.equals(other.js))) {
                return false;
            }
            if (this.fqn == null || !this.fqn.equals(other.fqn)) {
                return false;
            }
            return this.method == other.method || this.method != null && this.method.equals(other.method);
        }

        public int hashCode() {
            int hash = 7;
            hash = 13 * hash + (this.fqn != null ? this.fqn.hashCode() : 0);
            hash = 13 * hash + (this.method != null ? this.method.hashCode() : 0);
            return hash;
        }
    }
}

