/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.common.ClasspathUtil;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.common.ui.BrokenServerLibrarySupport;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WelcomeFileList;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.JsfPreferences;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.JsfComponentUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.Application;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.api.facesmodel.ViewHandler;
import org.netbeans.modules.web.jsf.palette.JSFPaletteUtilities;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentImplementation;
import org.netbeans.modules.web.jsf.wizards.JSFConfigurationPanel;
import org.netbeans.modules.web.project.api.WebPropertyEvaluator;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JSFFrameworkProvider
extends WebFrameworkProvider {
    private static final Logger LOGGER = Logger.getLogger(JSFFrameworkProvider.class.getName());
    private static String HANDLER = "com.sun.facelets.FaceletViewHandler";
    private static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    private static String WELCOME_JSF = "welcomeJSF.jsp";
    private static String WELCOME_XHTML = "index.xhtml";
    private static String WELCOME_XHTML_TEMPLATE = "/Templates/JSP_Servlet/JSP.xhtml";
    private static String FORWARD_JSF = "forwardToJSF.jsp";
    private static String RESOURCE_FOLDER = "/org/netbeans/modules/web/jsf/resources/";
    private static String DEFAULT_MAPPING = "/faces/*";
    private boolean createWelcome = true;
    private JSFConfigurationPanel panel;

    public void setCreateWelcome(boolean set) {
        this.createWelcome = set;
    }

    public JSFFrameworkProvider() {
        super(NbBundle.getMessage(JSFFrameworkProvider.class, (String)"JSF_Name"), NbBundle.getMessage(JSFFrameworkProvider.class, (String)"JSF_Description"));
    }

    public Set extendImpl(WebModule webModule, TreeMap<String, JsfComponentCustomizer> jsfComponentCustomizers) {
        HashSet<FileObject> result = new HashSet<FileObject>();
        Library jsfLibrary = null;
        Library jstlLibrary = null;
        JSFConfigurationPanel.LibraryType libraryType = this.panel.getLibraryType();
        if (libraryType == JSFConfigurationPanel.LibraryType.NEW) {
            String libraryName = this.panel.getNewLibraryName();
            File installResource = this.panel.getInstallResource();
            if (installResource != null && libraryName != null) {
                try {
                    JSFUtils.createJSFUserLibrary(installResource, libraryName);
                    jsfLibrary = LibraryManager.getDefault().getLibrary(libraryName);
                }
                catch (IOException exception) {
                    LOGGER.log(Level.WARNING, "Exception during extending an web project", exception);
                }
            }
        } else if (libraryType == JSFConfigurationPanel.LibraryType.USED && ((jsfLibrary = this.panel.getLibrary()).getName().equals("jsf12") || jsfLibrary.getName().equals("jsf20") || jsfLibrary.getName().equals("jsf1102"))) {
            jstlLibrary = LibraryManager.getDefault().getLibrary("jstl11");
        }
        try {
            FileObject fileObject;
            FileObject fileObject2 = webModule.getDocumentBase();
            FileObject[] javaSources = webModule.getJavaSources();
            if (jsfLibrary != null && javaSources.length > 0) {
                String serverInstanceId;
                Project prj;
                J2eeModuleProvider provider;
                Library[] libraries = jstlLibrary != null ? new Library[]{jsfLibrary, jstlLibrary} : new Library[]{jsfLibrary};
                boolean modified = false;
                Boolean isMaven = (Boolean)this.panel.getController().getProperties().getProperty("maven");
                if (isMaven != null && isMaven.booleanValue() && (provider = (J2eeModuleProvider)(prj = FileOwnerQuery.getOwner((FileObject)webModule.getDocumentBase())).getLookup().lookup(J2eeModuleProvider.class)) != null && ((serverInstanceId = provider.getServerInstanceID()) == null || "".equals(serverInstanceId) || "DEV-NULL".equals(serverInstanceId)) && !this.panel.packageJars()) {
                    ProjectClassPathModifier.addLibraries((Library[])libraries, (FileObject)javaSources[0], (String)"classpath/compile_only");
                    modified = true;
                }
                if (!modified) {
                    ProjectClassPathModifier.addLibraries((Library[])libraries, (FileObject)javaSources[0], (String)"classpath/compile");
                }
            }
            boolean isMyFaces = false;
            if (jsfLibrary != null) {
                List content = jsfLibrary.getContent("classpath");
                isMyFaces = ClasspathUtil.containsClass((List)content, (String)"org.apache.myfaces.webapp.StartupServletContextListener");
            } else {
                ClassPath cp = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/compile");
                if (cp != null) {
                    isMyFaces = cp.findResource("org.apache.myfaces.webapp.StartupServletContextListener".replace('.', '/') + ".class") != null;
                }
            }
            FileObject webInf = webModule.getWebInf();
            if (webInf == null) {
                webInf = FileUtil.createFolder((FileObject)webModule.getDocumentBase(), (String)"WEB-INF");
            }
            assert (webInf != null);
            ServerLibrary serverLibrary = this.panel.getServerLibrary();
            if (serverLibrary != null) {
                String implementationTitle = serverLibrary.getImplementationTitle();
                isMyFaces = implementationTitle != null && implementationTitle.contains("MyFaces");
                Project prj = FileOwnerQuery.getOwner((FileObject)webInf);
                if (prj != null) {
                    String libraryName = serverLibrary.getName();
                    J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)prj.getLookup().lookup(J2eeModuleProvider.class);
                    if (j2eeModuleProvider != null && libraryName != null) {
                        j2eeModuleProvider.getConfigSupport().configureLibrary(ServerLibraryDependency.minimalVersion((String)libraryName, (Version)serverLibrary.getSpecificationVersion(), (Version)serverLibrary.getImplementationVersion()));
                        Preferences prefs = ProjectUtils.getPreferences((Project)prj, ProjectUtils.class, (boolean)true);
                        prefs.put(BrokenServerLibrarySupport.OFFER_LIBRARY_DEPLOYMENT, Boolean.TRUE.toString());
                    }
                }
            }
            FileSystem fileSystem = webInf.getFileSystem();
            fileSystem.runAtomicAction((FileSystem.AtomicAction)new CreateFacesConfig(webModule, isMyFaces));
            StringBuilder jsfSuitesSB = new StringBuilder();
            for (JsfComponentImplementation jsfComponentImplementation : this.panel.getEnabledJsfDescriptors()) {
                result.addAll(jsfComponentImplementation.extend(webModule, jsfComponentCustomizers.get(jsfComponentImplementation.getName())));
                jsfSuitesSB.append(jsfComponentImplementation.getName()).append("|");
            }
            String statsString = jsfSuitesSB.toString();
            if (!statsString.isEmpty()) {
                statsString = statsString.substring(0, statsString.length() - 1);
                JSFUtils.logUsage(JSFFrameworkProvider.class, "USG_JSF_INCLUDED_SUITE", new Object[]{statsString});
            }
            FileObject fileObject3 = fileObject = this.panel.isEnableFacelets() ? webModule.getDocumentBase().getFileObject(WELCOME_XHTML) : webModule.getDocumentBase().getFileObject(WELCOME_JSF);
            if (fileObject != null) {
                result.add(fileObject);
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Exception during extending an web project", exception);
        }
        catch (ConfigurationException exception) {
            LOGGER.log(Level.WARNING, "Exception during extending an web project", exception);
        }
        this.createWelcome = true;
        return result;
    }

    public static String readResource(InputStream is, String encoding) throws IOException {
        StringBuilder sbuffer = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        String line = br.readLine();
        while (line != null) {
            sbuffer.append(line);
            sbuffer.append(lineSep);
            line = br.readLine();
        }
        br.close();
        return sbuffer.toString();
    }

    public File[] getConfigurationFiles(WebModule wm) {
        FileObject dd;
        if (wm != null && (dd = wm.getDeploymentDescriptor()) != null) {
            FileObject[] filesFO = ConfigurationUtils.getFacesConfigFiles(wm);
            File[] files = new File[filesFO.length];
            for (int i = 0; i < filesFO.length; ++i) {
                files[i] = FileUtil.toFile((FileObject)filesFO[i]);
            }
            if (files.length > 0) {
                return files;
            }
        }
        return null;
    }

    public WebModuleExtender createWebModuleExtender(WebModule webModule, ExtenderController controller) {
        boolean isFrameworkAddition = webModule == null || !this.isInWebModule(webModule);
        boolean isMaven = webModule == null ? false : JsfComponentUtils.isMavenBased(webModule);
        controller.getProperties().setProperty("maven", (Object)isMaven);
        if (webModule != null && webModule.getDocumentBase() != null) {
            ClassPath cp;
            FileObject docBase = webModule.getDocumentBase();
            Project project = FileOwnerQuery.getOwner((FileObject)docBase);
            JsfPreferences preferences = JsfPreferences.forProject(project);
            if (preferences.getPreferredLanguage() == null && JSFUtils.isFaceletsPresent(cp = ClassPath.getClassPath((FileObject)docBase, (String)"classpath/compile"))) {
                preferences.setPreferredLanguage(JSFConfigurationPanel.PreferredLanguage.Facelets);
            }
            this.panel = new JSFConfigurationPanel(this, controller, isFrameworkAddition, preferences, webModule);
        } else {
            if (webModule != null && webModule.getDocumentBase() == null) {
                controller.getProperties().setProperty("NoDocBase", (Object)true);
            }
            this.panel = new JSFConfigurationPanel(this, controller, isFrameworkAddition);
        }
        this.panel.setCreateExamples(this.createWelcome);
        if (!isFrameworkAddition && webModule != null) {
            String mapping;
            Servlet servlet = ConfigurationUtils.getFacesServlet(webModule);
            if (servlet != null) {
                this.panel.setServletName(servlet.getServletName());
            }
            if ((mapping = ConfigurationUtils.getFacesServletMapping(webModule)) == null) {
                mapping = DEFAULT_MAPPING;
            }
            this.panel.setURLPattern(mapping);
            FileObject dd = webModule.getDeploymentDescriptor();
            this.panel.setValidateXML(JSFConfigUtilities.validateXML(dd));
            this.panel.setVerifyObjects(JSFConfigUtilities.verifyObjects(dd));
            this.panel.setDebugFacelets(JSFUtils.debugFacelets(dd));
            this.panel.setSkipComments(JSFUtils.skipCommnets(dd));
        }
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInWebModule(WebModule webModule) {
        long time = System.currentTimeMillis();
        try {
            FileObject fo = webModule.getDocumentBase();
            if (fo != null) {
                boolean bl = JSFConfigUtilities.hasJsfFramework(fo);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            LOGGER.log(Level.INFO, "Total time spent={0} ms", System.currentTimeMillis() - time);
        }
    }

    public String getServletPath(FileObject file) {
        String url = null;
        if (file == null) {
            return url;
        }
        WebModule wm = WebModule.getWebModule((FileObject)file);
        if (wm != null) {
            String mapping;
            url = FileUtil.getRelativePath((FileObject)wm.getDocumentBase(), (FileObject)file);
            if (url == null) {
                return null;
            }
            if (url.charAt(0) != '/') {
                url = "/" + url;
            }
            if ((mapping = ConfigurationUtils.getFacesServletMapping(wm)) != null && !"".equals(mapping) && mapping.endsWith("/*")) {
                mapping = mapping.substring(0, mapping.length() - 2);
                url = mapping + url;
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(FileObject target, String content, String encoding) throws IOException {
        FileLock lock = target.lock();
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(target.getOutputStream(lock), encoding));
            bw.write(content);
            bw.close();
        }
        finally {
            lock.releaseLock();
        }
    }

    private class CreateFacesConfig
    implements FileSystem.AtomicAction {
        private static final String FACES_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";
        private static final String FACES_SERVLET_NAME = "Faces Servlet";
        private static final String MYFACES_STARTUP_LISTENER_CLASS = "org.apache.myfaces.webapp.StartupServletContextListener";
        WebModule webModule;
        boolean isMyFaces;

        public CreateFacesConfig(WebModule webModule, boolean isMyFaces) {
            this.webModule = webModule;
            this.isMyFaces = isMyFaces;
        }

        public void run() throws IOException {
            JSFConfigModel model;
            FacesConfig jsfConfig;
            FileObject[] files;
            FileObject target;
            JSFVersion jsfVersion;
            FileObject dd = this.webModule.getDeploymentDescriptor();
            if (dd == null) {
                dd = DDHelper.createWebXml((Profile)this.webModule.getJ2eeProfile(), (FileObject)this.webModule.getWebInf());
            }
            String facesMapping = JSFFrameworkProvider.this.panel == null ? DEFAULT_MAPPING : JSFFrameworkProvider.this.panel.getURLPattern();
            Library jsfLibrary = null;
            if (JSFFrameworkProvider.this.panel.getLibraryType() == JSFConfigurationPanel.LibraryType.USED) {
                jsfLibrary = JSFFrameworkProvider.this.panel.getLibrary();
            } else if (JSFFrameworkProvider.this.panel.getLibraryType() == JSFConfigurationPanel.LibraryType.NEW) {
                jsfLibrary = LibraryManager.getDefault().getLibrary(JSFFrameworkProvider.this.panel.getNewLibraryName());
            }
            if (jsfLibrary != null) {
                List content = jsfLibrary.getContent("classpath");
                jsfVersion = JSFVersion.forClasspath(content);
            } else {
                jsfVersion = JSFFrameworkProvider.this.panel.getLibraryType() == JSFConfigurationPanel.LibraryType.SERVER && JSFFrameworkProvider.this.panel.getServerLibrary() != null ? JSFVersion.forServerLibrary(JSFFrameworkProvider.this.panel.getServerLibrary()) : JSFVersion.forWebModule(this.webModule);
            }
            WebApp ddRoot = null;
            if (dd != null) {
                ddRoot = DDProvider.getDefault().getDDRoot(dd);
            }
            if (ddRoot != null && ddRoot.getStatus() == 0) {
                boolean shouldAddMappings = this.shouldAddMappings(this.webModule);
                try {
                    if (shouldAddMappings || !DEFAULT_MAPPING.equals(facesMapping)) {
                        boolean servletDefined = false;
                        if (ConfigurationUtils.getFacesServlet(this.webModule) != null) {
                            servletDefined = true;
                        }
                        if (!servletDefined) {
                            Servlet servlet = (Servlet)ddRoot.createBean("Servlet");
                            String servletName = JSFFrameworkProvider.this.panel == null ? FACES_SERVLET_NAME : JSFFrameworkProvider.this.panel.getServletName();
                            servlet.setServletName(servletName);
                            servlet.setServletClass(FACES_SERVLET_CLASS);
                            servlet.setLoadOnStartup(new BigInteger("1"));
                            ddRoot.addServlet(servlet);
                            ServletMapping25 mapping = (ServletMapping25)ddRoot.createBean("ServletMapping");
                            mapping.setServletName(servletName);
                            mapping.setUrlPatterns(new String[]{facesMapping});
                            ddRoot.addServletMapping((ServletMapping)mapping);
                        }
                    }
                    boolean faceletsEnabled = JSFFrameworkProvider.this.panel.isEnableFacelets();
                    if (jsfVersion != null && jsfVersion.isAtLeast(JSFVersion.JSF_2_0)) {
                        InitParam contextParam = (InitParam)ddRoot.createBean("InitParam");
                        contextParam.setParamName("javax.faces.PROJECT_STAGE");
                        contextParam.setParamValue("Development");
                        ddRoot.addContextParam(contextParam);
                    }
                    if (this.isMyFaces) {
                        boolean listenerDefined = false;
                        Listener[] listeners = ddRoot.getListener();
                        for (int i = 0; i < listeners.length; ++i) {
                            if (!MYFACES_STARTUP_LISTENER_CLASS.equals(listeners[i].getListenerClass().trim())) continue;
                            listenerDefined = true;
                            break;
                        }
                        if (!listenerDefined) {
                            Listener facesListener = (Listener)ddRoot.createBean("Listener");
                            facesListener.setListenerClass(MYFACES_STARTUP_LISTENER_CLASS);
                            ddRoot.addListener(facesListener);
                        }
                    }
                    WelcomeFileList welcomeFiles = ddRoot.getSingleWelcomeFileList();
                    ArrayList<String> welcomeFileList = new ArrayList<String>();
                    if (!faceletsEnabled) {
                        if (welcomeFiles == null) {
                            if (facesMapping.charAt(0) == '/') {
                                if (this.webModule.getDocumentBase().getFileObject(WELCOME_JSF) != null || JSFFrameworkProvider.this.createWelcome) {
                                    welcomeFileList.add(ConfigurationUtils.translateURI(facesMapping, WELCOME_JSF));
                                }
                            } else {
                                welcomeFileList.add(FORWARD_JSF);
                                if (facesMapping.charAt(0) != '/' && this.canCreateNewFile(this.webModule.getDocumentBase(), FORWARD_JSF)) {
                                    String content = JSFFrameworkProvider.readResource(this.getClass().getResourceAsStream(RESOURCE_FOLDER + FORWARD_JSF), "UTF-8");
                                    content = content.replace("__FORWARD__", ConfigurationUtils.translateURI(facesMapping, WELCOME_JSF));
                                    Charset encoding = FileEncodingQuery.getDefaultEncoding();
                                    content = content.replaceAll("__ENCODING__", encoding.name());
                                    FileObject target2 = FileUtil.createData((FileObject)this.webModule.getDocumentBase(), (String)FORWARD_JSF);
                                    JSFFrameworkProvider.createFile(target2, content, encoding.name());
                                    DataObject dob = DataObject.find((FileObject)target2);
                                    if (dob != null) {
                                        JSFPaletteUtilities.reformat(dob);
                                    }
                                }
                            }
                        }
                    } else {
                        String welcomeFileUri = ConfigurationUtils.translateURI(facesMapping, WELCOME_XHTML);
                        if (welcomeFiles == null || !Arrays.asList(welcomeFiles.getWelcomeFile()).contains(welcomeFileUri)) {
                            welcomeFileList.add(welcomeFileUri);
                        }
                    }
                    if (welcomeFiles != null) {
                        welcomeFileList.addAll(Arrays.asList(welcomeFiles.getWelcomeFile()));
                    }
                    if (!welcomeFileList.isEmpty()) {
                        welcomeFiles = (WelcomeFileList)ddRoot.createBean("WelcomeFileList");
                        ddRoot.setWelcomeFileList(welcomeFiles);
                        for (String fileName : welcomeFileList) {
                            welcomeFiles.addWelcomeFile(fileName);
                        }
                    }
                    ddRoot.write(dd);
                }
                catch (ClassNotFoundException cnfe) {
                    LOGGER.log(Level.WARNING, "Exception in JSFMoveClassPlugin", cnfe);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NotifyDescriptor.Message warningDialog = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JSFFrameworkProvider.class, (String)"WARN_UnknownDeploymentDescriptorText"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)warningDialog);
                    }
                });
            }
            File fileConfig = new File(FileUtil.toFile((FileObject)this.webModule.getWebInf()), "faces-config.xml");
            boolean createFacesConfig = false;
            if (!fileConfig.exists()) {
                String facesConfigTemplate = "faces-config.xml";
                if (ddRoot != null) {
                    Profile profile = this.webModule.getJ2eeProfile();
                    if (profile != null && profile.isAtLeast(Profile.JAVA_EE_5) && jsfVersion != null) {
                        facesConfigTemplate = jsfVersion.isAtLeast(JSFVersion.JSF_2_3) ? "faces-config_2_3.xml" : (jsfVersion.isAtLeast(JSFVersion.JSF_2_2) ? "faces-config_2_2.xml" : (jsfVersion.isAtLeast(JSFVersion.JSF_2_1) ? "faces-config_2_1.xml" : (jsfVersion.isAtLeast(JSFVersion.JSF_2_0) ? "faces-config_2_0.xml" : "faces-config_1_2.xml")));
                    }
                    if (!(profile == null || profile.isAtLeast(Profile.JAVA_EE_6_WEB) || jsfVersion != null && jsfVersion.isAtLeast(JSFVersion.JSF_2_0))) {
                        createFacesConfig = true;
                    }
                }
                if (createFacesConfig) {
                    String content = JSFFrameworkProvider.readResource(this.getClass().getResourceAsStream(RESOURCE_FOLDER + facesConfigTemplate), "UTF-8");
                    target = FileUtil.createData((FileObject)this.webModule.getWebInf(), (String)"faces-config.xml");
                    JSFFrameworkProvider.createFile(target, content, "UTF-8");
                }
            }
            if (JSFFrameworkProvider.this.panel.isEnableFacelets() && (files = ConfigurationUtils.getFacesConfigFiles(this.webModule)) != null && files.length > 0 && (jsfConfig = (model = ConfigurationUtils.getConfigModel(files[0], true)).getRootComponent()) != null) {
                Application application = null;
                boolean newApplication = false;
                List<Application> applications = jsfConfig.getApplications();
                if (applications != null && applications.size() > 0) {
                    List<ViewHandler> handlers = applications.get(0).getViewHandlers();
                    boolean alreadyDefined = false;
                    if (handlers != null) {
                        for (ViewHandler viewHandler : handlers) {
                            if (!HANDLER.equals(viewHandler.getFullyQualifiedClassType().trim())) continue;
                            alreadyDefined = true;
                            break;
                        }
                    }
                    if (!alreadyDefined) {
                        application = applications.get(0);
                    }
                } else {
                    application = model.getFactory().createApplication();
                    newApplication = true;
                }
                if (application != null) {
                    model.startTransaction();
                    if (newApplication) {
                        jsfConfig.addApplication(application);
                    }
                    if (jsfVersion != null && !jsfVersion.isAtLeast(JSFVersion.JSF_2_0) && !this.isMyFaces) {
                        ViewHandler viewHandler = model.getFactory().createViewHandler();
                        viewHandler.setFullyQualifiedClassType(HANDLER);
                        application.addViewHandler(viewHandler);
                    }
                    ClassPath cp = ClassPath.getClassPath((FileObject)this.webModule.getDocumentBase(), (String)"classpath/compile");
                    if (JSFFrameworkProvider.this.panel.getLibrary() != null && JSFFrameworkProvider.this.panel.getLibrary().getName().indexOf("facelets-icefaces") != -1 && cp != null && cp.findResource("com/icesoft/faces/facelets/D2DFaceletViewHandler.class") != null) {
                        ViewHandler iceViewHandler = model.getFactory().createViewHandler();
                        iceViewHandler.setFullyQualifiedClassType("com.icesoft.faces.facelets.D2DFaceletViewHandler");
                        application.addViewHandler(iceViewHandler);
                    }
                    try {
                        model.endTransaction();
                        model.sync();
                    }
                    catch (IllegalStateException ex) {
                        IOException io = new IOException("Cannot update faces-config.xml", ex);
                        throw (IOException)Exceptions.attachLocalizedMessage((Throwable)io, (String)NbBundle.getMessage(JSFFrameworkProvider.class, (String)"ERR_WRITE_FACES_CONFIG", (Object)Exceptions.findLocalizedMessage((Throwable)ex)));
                    }
                    DataEditorSupport editorSupport = (DataEditorSupport)DataObject.find((FileObject)files[0]).getLookup().lookup(DataEditorSupport.class);
                    editorSupport.saveDocument();
                }
            }
            if (JSFFrameworkProvider.this.panel.isEnableFacelets() && JSFFrameworkProvider.this.panel.isCreateExamples() && this.webModule.getDocumentBase().getFileObject(WELCOME_XHTML) == null) {
                FileObject target3 = FileUtil.createData((FileObject)this.webModule.getDocumentBase(), (String)WELCOME_XHTML);
                FileObject template = FileUtil.getConfigRoot().getFileObject(WELCOME_XHTML_TEMPLATE);
                HashMap<String, Object> params = new HashMap<String, Object>();
                if (jsfVersion != null) {
                    if (jsfVersion.isAtLeast(JSFVersion.JSF_2_2)) {
                        params.put("isJSF22", Boolean.TRUE);
                    } else {
                        params.put("isJSF20", Boolean.TRUE);
                    }
                }
                JSFPaletteUtilities.expandJSFTemplate(template, params, target3);
            }
            if (!JSFFrameworkProvider.this.panel.isEnableFacelets() && JSFFrameworkProvider.this.createWelcome && this.canCreateNewFile(this.webModule.getDocumentBase(), WELCOME_JSF)) {
                String content = JSFFrameworkProvider.readResource(this.getClass().getResourceAsStream(RESOURCE_FOLDER + WELCOME_JSF), "UTF-8");
                Charset encoding = FileEncodingQuery.getDefaultEncoding();
                content = content.replaceAll("__ENCODING__", encoding.name());
                target = FileUtil.createData((FileObject)this.webModule.getDocumentBase(), (String)WELCOME_JSF);
                JSFFrameworkProvider.createFile(target, content, encoding.name());
                DataObject dob = DataObject.find((FileObject)target);
                if (dob != null) {
                    JSFPaletteUtilities.reformat(dob);
                }
            }
        }

        private boolean shouldAddMappings(WebModule webModule) {
            Project project;
            WebPropertyEvaluator evaluator;
            assert (webModule != null);
            JSFVersion jsfVersion = JSFVersion.forWebModule(webModule);
            FileObject projectFO = JSFUtils.getFileObject(webModule);
            if (jsfVersion != null && projectFO != null && (evaluator = (WebPropertyEvaluator)(project = FileOwnerQuery.getOwner((FileObject)projectFO)).getLookup().lookup(WebPropertyEvaluator.class)) != null) {
                String serverInstanceID = evaluator.evaluator().getProperty(JSFFrameworkProvider.J2EE_SERVER_INSTANCE);
                if (jsfVersion.isAtLeast(JSFVersion.JSF_2_0) && this.isGlassFishv3(serverInstanceID) && JSFConfigUtilities.hasJsfFramework(webModule.getDocumentBase())) {
                    return false;
                }
            }
            return true;
        }

        private boolean isGlassFishv3(String serverInstanceID) {
            if (serverInstanceID == null || "".equals(serverInstanceID)) {
                return false;
            }
            try {
                String shortName = Deployment.getDefault().getServerInstance(serverInstanceID).getServerID();
                if ("gfv5ee8".equals(shortName) || "gfv5".equals(shortName) || "gfv3ee6".equals(shortName) || "gfv3".equals(shortName)) {
                    return true;
                }
            }
            catch (InstanceRemovedException ex) {
                LOGGER.log(Level.INFO, "Server Instance was removed", ex);
            }
            return false;
        }

        private boolean canCreateNewFile(FileObject parent, String name) {
            File fileToBe = new File(FileUtil.toFile((FileObject)parent), name);
            boolean create = true;
            if (fileToBe.exists()) {
                DialogDescriptor dialog = new DialogDescriptor((Object)NbBundle.getMessage(JSFFrameworkProvider.class, (String)"MSG_OverwriteFile", (Object)fileToBe.getAbsolutePath()), NbBundle.getMessage(JSFFrameworkProvider.class, (String)"TTL_OverwriteFile"), true, 0, DialogDescriptor.NO_OPTION, null);
                Dialog d = DialogDisplayer.getDefault().createDialog(dialog);
                d.setVisible(true);
                create = dialog.getValue() == DialogDescriptor.NO_OPTION;
            }
            return create;
        }
    }
}

