/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;

public class QueueTool
implements Outputable,
Timeoutable {
    private static final long WAIT_QUEUE_EMPTY_TIMEOUT = 180000L;
    private static final long QUEUE_CHECKING_DELTA = 10L;
    private static final long LOCK_TIMEOUT = 180000L;
    private static final long MAXIMUM_LOCKING_TIME = 180000L;
    private static final long INVOCATION_TIMEOUT = 180000L;
    private static JemmyQueue jemmyQueue = null;
    private TestOut output;
    private Timeouts timeouts;
    private Locker locker = new Locker();
    private Waiter lockWaiter = new Waiter(new Waitable(){

        @Override
        public Object actionProduced(Object obj) {
            return QueueTool.this.locker.isLocked() ? "" : null;
        }

        @Override
        public String getDescription() {
            return "Event queue to be locked";
        }
    });

    public QueueTool() {
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
    }

    public static EventQueue getQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    public static boolean isDispatchThread() {
        QueueTool.getQueue();
        return EventQueue.isDispatchThread();
    }

    public static boolean checkEmpty() {
        return QueueTool.getQueue().peekEvent() == null;
    }

    public static void processEvent(AWTEvent event) {
        if ((JemmyProperties.getCurrentDispatchingModel() & JemmyProperties.SHORTCUT_MODEL_MASK) != 0) {
            QueueTool.installQueue();
        }
        if ((JemmyProperties.getCurrentDispatchingModel() & JemmyProperties.SHORTCUT_MODEL_MASK) != 0 && QueueTool.isDispatchThread()) {
            QueueTool.shortcutEvent(event);
        } else {
            QueueTool.postEvent(event);
        }
    }

    public static void postEvent(AWTEvent event) {
        QueueTool.getQueue().postEvent(event);
    }

    public static void shortcutEvent(AWTEvent event) {
        QueueTool.installQueue();
        jemmyQueue.shortcutEvent(event);
    }

    public static void installQueue() {
        if (jemmyQueue == null) {
            jemmyQueue = new JemmyQueue();
        }
        jemmyQueue.install();
    }

    public static void uninstallQueue() {
        if (jemmyQueue != null) {
            jemmyQueue.uninstall();
        }
    }

    @Override
    public void setTimeouts(Timeouts ts) {
        this.timeouts = ts;
        this.lockWaiter.setTimeouts(this.getTimeouts().cloneThis());
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void setOutput(TestOut out) {
        this.output = out;
        this.lockWaiter.setOutput(this.output.createErrorOutput());
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    public void waitEmpty() {
        Waiter waiter = new Waiter(new Waitable(){

            @Override
            public Object actionProduced(Object obj) {
                if (QueueTool.checkEmpty()) {
                    return "Empty";
                }
                return null;
            }

            @Override
            public String getDescription() {
                return "Wait event queue empty";
            }
        });
        waiter.setTimeoutsToCloneOf(this.timeouts, "QueueTool.WaitQueueEmptyTimeout");
        waiter.setOutput(this.output);
        try {
            waiter.waitAction(null);
        }
        catch (TimeoutExpiredException e) {
            final AWTEvent event = QueueTool.getQueue().peekEvent();
            String eventToString = event == null ? "null" : (String)this.invokeSmoothly(new QueueAction("event.toString()"){

                @Override
                public Object launch() {
                    return event.toString();
                }
            });
            this.getOutput().printErrLine("Event at the top of stack: " + eventToString);
            throw e;
        }
        catch (InterruptedException e) {
            this.output.printStackTrace(e);
        }
    }

    public void waitEmpty(long emptyTime) {
        StayingEmptyWaiter waiter = new StayingEmptyWaiter(emptyTime);
        waiter.setTimeoutsToCloneOf(this.timeouts, "QueueTool.WaitQueueEmptyTimeout");
        waiter.setOutput(this.output);
        try {
            waiter.waitAction(null);
        }
        catch (TimeoutExpiredException e) {
            final AWTEvent event = QueueTool.getQueue().peekEvent();
            String eventToString = event == null ? "null" : (String)this.invokeSmoothly(new QueueAction("event.toString()"){

                @Override
                public Object launch() {
                    return event.toString();
                }
            });
            this.getOutput().printErrLine("Event at the top of stack: " + eventToString);
            throw e;
        }
        catch (InterruptedException e) {
            this.output.printStackTrace(e);
        }
    }

    public void invoke(QueueAction action) {
        this.output.printTrace("Invoking \"" + action.getDescription() + "\" action through event queue");
        EventQueue.invokeLater(action);
    }

    public QueueAction invoke(Runnable runnable) {
        RunnableRunnable result = new RunnableRunnable(runnable);
        this.invoke(result);
        return result;
    }

    public QueueAction invoke(Action action, Object param) {
        ActionRunnable result = new ActionRunnable(action, param);
        this.invoke(result);
        return result;
    }

    public Object invokeSmoothly(QueueAction action) {
        QueueTool.getQueue();
        if (!EventQueue.isDispatchThread()) {
            return this.invokeAndWait(action);
        }
        try {
            return action.launch();
        }
        catch (Exception e) {
            throw new JemmyException("Exception in " + action.getDescription(), e);
        }
    }

    public void invokeSmoothly(Runnable runnable) {
        QueueTool.getQueue();
        if (!EventQueue.isDispatchThread()) {
            this.invokeAndWait(runnable);
        } else {
            runnable.run();
        }
    }

    public Object invokeSmoothly(Action action, Object param) {
        QueueTool.getQueue();
        if (!EventQueue.isDispatchThread()) {
            return this.invokeAndWait(action, param);
        }
        return action.launch(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeAndWait(QueueAction action) {
        class JemmyInvocationLock {
            JemmyInvocationLock() {
            }
        }
        JemmyInvocationLock lock = new JemmyInvocationLock();
        JemmyInvocationEvent event = new JemmyInvocationEvent((Object)Toolkit.getDefaultToolkit(), (Runnable)action, lock, true);
        try {
            JemmyInvocationLock jemmyInvocationLock = lock;
            synchronized (jemmyInvocationLock) {
                QueueTool.getQueue().postEvent(event);
                lock.wait();
            }
        }
        catch (InterruptedException e) {
            throw new JemmyException("InterruptedException during " + action.getDescription() + " execution", e);
        }
        if (action.getException() != null) {
            throw new JemmyException("Exception in " + action.getDescription(), action.getException());
        }
        if (event.getException() != null) {
            throw new JemmyException("Exception in " + action.getDescription(), event.getException());
        }
        return action.getResult();
    }

    public void invokeAndWait(Runnable runnable) {
        this.invokeAndWait(new RunnableRunnable(runnable));
    }

    public Object invokeAndWait(Action action, Object param) {
        return this.invokeAndWait(new ActionRunnable(action, param));
    }

    public void lock() {
        this.output.printTrace("Locking queue.");
        this.invoke(this.locker);
        try {
            this.lockWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.timeouts.getTimeout("QueueTool.LockTimeout"));
            this.lockWaiter.getTimeouts().setTimeout("Waiter.TimeDelta", this.timeouts.getTimeout("QueueTool.QueueCheckingDelta"));
            this.lockWaiter.waitAction(null);
        }
        catch (InterruptedException e) {
            this.output.printStackTrace(e);
        }
    }

    public void unlock() {
        this.output.printTrace("Unlocking queue.");
        this.locker.setLocked(false);
    }

    public void lock(long time) {
        this.output.printTrace("Locking queue for " + Long.toString(time) + " milliseconds");
        this.lock();
        this.invoke(new UnlockPostponer(time));
    }

    public boolean wasLockingExpired() {
        return this.locker.expired;
    }

    static {
        Timeouts.initDefault("QueueTool.WaitQueueEmptyTimeout", 180000L);
        Timeouts.initDefault("QueueTool.QueueCheckingDelta", 10L);
        Timeouts.initDefault("QueueTool.LockTimeout", 180000L);
        Timeouts.initDefault("QueueTool.InvocationTimeout", 180000L);
        Timeouts.initDefault("QueueTool.MaximumLockingTime", 180000L);
    }

    private class UnlockPostponer
    implements Runnable {
        long time;

        public UnlockPostponer(long time) {
            this.time = time;
        }

        @Override
        public void run() {
            new Timeout("", this.time).sleep();
            QueueTool.this.unlock();
        }
    }

    private class Locker
    extends QueueAction {
        boolean locked;
        long wholeTime;
        long deltaTime;
        boolean expired;

        public Locker() {
            super("Event queue locking");
            this.locked = false;
        }

        @Override
        public Object launch() {
            this.wholeTime = QueueTool.this.timeouts.getTimeout("QueueTool.MaximumLockingTime");
            this.deltaTime = QueueTool.this.timeouts.getTimeout("QueueTool.QueueCheckingDelta");
            this.setLocked(true);
            this.expired = false;
            long startTime = System.currentTimeMillis();
            while (this.isLocked()) {
                try {
                    Thread.sleep(this.deltaTime);
                }
                catch (InterruptedException e) {
                    QueueTool.this.getOutput().printStackTrace(e);
                }
                if (System.currentTimeMillis() - startTime <= this.wholeTime) continue;
                QueueTool.this.getOutput().printLine("Locking has been expired!");
                this.expired = true;
                break;
            }
            return null;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        public boolean isLocked() {
            return this.locked;
        }
    }

    private class RunnableRunnable
    extends QueueAction {
        Runnable action;

        public RunnableRunnable(Runnable action) {
            super("Runnable");
            this.action = action;
        }

        @Override
        public Object launch() throws Exception {
            this.action.run();
            return null;
        }
    }

    private class ActionRunnable
    extends QueueAction {
        Action action;
        Object param;

        public ActionRunnable(Action action, Object param) {
            super(action.getDescription());
            this.action = action;
            this.param = param;
        }

        @Override
        public Object launch() throws Exception {
            return this.action.launch(this.param);
        }
    }

    private class StayingEmptyWaiter
    extends Waiter {
        long emptyTime;

        public StayingEmptyWaiter(long emptyTime) {
            this.emptyTime = emptyTime;
        }

        @Override
        public Object actionProduced(Object obj) {
            try {
                EventWaiter eventWaiter = new EventWaiter(this.emptyTime);
                EventQueue.invokeAndWait(eventWaiter);
                if (eventWaiter.empty && this.timeFromStart() <= super.getTimeouts().getTimeout("Waiter.WaitingTime")) {
                    return "Reached";
                }
            }
            catch (InterruptedException e) {
                QueueTool.this.output.printStackTrace(e);
            }
            catch (InvocationTargetException e) {
                QueueTool.this.output.printStackTrace(e);
            }
            return null;
        }

        @Override
        public String getDescription() {
            return "Wait event queue staying empty for " + Long.toString(this.emptyTime);
        }
    }

    private class EventWaiter
    implements Runnable {
        boolean empty = true;
        long emptyTime;

        public EventWaiter(long emptyTime) {
            this.emptyTime = emptyTime;
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            while ((this.empty = QueueTool.checkEmpty()) && System.currentTimeMillis() - startTime < this.emptyTime) {
                QueueTool.this.timeouts.sleep("QueueTool.QueueCheckingDelta");
            }
        }
    }

    private static class JemmyQueue
    extends EventQueue {
        private boolean installed = false;

        private JemmyQueue() {
        }

        public void shortcutEvent(AWTEvent event) {
            super.dispatchEvent(event);
        }

        @Override
        protected void dispatchEvent(AWTEvent event) {
            try {
                super.dispatchEvent(event);
            }
            catch (Exception e) {
                JemmyProperties.getCurrentOutput().printStackTrace(e);
            }
        }

        public synchronized void install() {
            if (!this.installed) {
                QueueTool.getQueue().push(this);
                this.installed = true;
            }
        }

        public synchronized void uninstall() {
            if (this.installed) {
                this.pop();
                this.installed = false;
            }
        }
    }

    public static abstract class QueueAction
    implements Runnable {
        private boolean finished;
        private Exception exception;
        private Object result;
        private String description;

        public QueueAction(String description) {
            this.description = description;
            this.finished = false;
            this.exception = null;
            this.result = null;
        }

        public abstract Object launch() throws Exception;

        @Override
        public final void run() {
            this.finished = false;
            this.exception = null;
            this.result = null;
            try {
                this.result = this.launch();
            }
            catch (Exception e) {
                this.exception = e;
            }
            this.finished = true;
        }

        public String getDescription() {
            return this.description;
        }

        public Object getResult() {
            return this.result;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean getFinished() {
            return this.finished;
        }
    }

    public static final class JemmyInvocationEvent
    extends InvocationEvent {
        public JemmyInvocationEvent(Object source, Runnable runnable, Object notifier, boolean catchThrowables) {
            super(source, runnable, notifier, catchThrowables);
        }
    }
}

