/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.versioning.core.Bundle;
import org.netbeans.modules.versioning.core.NoVCSMenuItem;
import org.netbeans.modules.versioning.core.Utils;
import org.netbeans.modules.versioning.core.VersioningConfig;
import org.netbeans.modules.versioning.core.VersioningManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSAnnotator;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class VersioningMainMenu
extends AbstractAction
implements DynamicMenuContent {
    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public JComponent[] getMenuPresenters() {
        return this.createMenu();
    }

    public JComponent[] synchMenuPresenters(JComponent[] items) {
        return this.createMenu();
    }

    private JComponent[] createMenu() {
        ArrayList<Object> items = new ArrayList<Object>(20);
        if (!VersioningManager.isInitialized()) {
            items.add(NoVCSMenuItem.createInitializingMenu(NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_MenuItem_VersioningMenu")));
            items.add(Utils.createJSeparator());
            items.add(NoVCSMenuItem.createInitializingMenu(NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_MenuItem_LocalHistory")));
        } else {
            VCSContext ctx = VCSContext.forNodes(TopComponent.getRegistry().getActivatedNodes());
            List<VCSSystemProvider.VersioningSystem> systems = Arrays.asList(VersioningManager.getInstance().getVersioningSystems());
            VCSSystemProvider.VersioningSystem[] vs = VersioningManager.getInstance().getOwners(ctx);
            Collection additionalItems = Lookups.forPath((String)"Actions/Versioning/Additional").lookupAll(Action.class);
            boolean ownerMenuDisplayed = false;
            if (vs.length == 1) {
                if (vs[0].getVCSAnnotator() != null) {
                    List<JComponent> systemItems = VersioningMainMenu.actionsToItems(vs[0].getVCSAnnotator().getActions(ctx, VCSAnnotator.ActionDestination.MainMenu));
                    items.addAll(systemItems);
                    ownerMenuDisplayed = true;
                    items.add(Utils.createJSeparator());
                }
                for (Object a : additionalItems) {
                    items.add(Utils.toMenuItem((Action)a));
                }
                items.addAll(VersioningMainMenu.actionsToItems(this.appendAdditionalActions(ctx, vs[0], new Action[0])));
            } else if (vs.length > 1) {
                JMenuItem dummy = new JMenuItem("<multiple systems>");
                dummy.setEnabled(false);
                items.add(dummy);
                for (Action a : additionalItems) {
                    items.add(Utils.toMenuItem(a));
                }
            } else {
                for (Object a : additionalItems) {
                    items.add(Utils.toMenuItem((Action)a));
                }
            }
            items.add(Utils.createJSeparator());
            Collections.sort(systems, new ByDisplayNameComparator());
            VCSSystemProvider.VersioningSystem localHistory = null;
            boolean accepted = false;
            ArrayList<JMenu> vcsSubmenus = new ArrayList<JMenu>(systems.size());
            for (VCSSystemProvider.VersioningSystem system : systems) {
                if (!system.accept(ctx) || vs.length == 1 && vs[0] == system) continue;
                if (system.isLocalHistory()) {
                    localHistory = system;
                    continue;
                }
                if ("".equals(system.getMenuLabel())) continue;
                accepted = true;
                JMenu menu = this.createVersioningSystemMenu(system, true);
                vcsSubmenus.add(menu);
            }
            if (ownerMenuDisplayed) {
                JMenu menu = new JMenu(Bundle.CTL_OtherVCS_menu());
                Mnemonics.setLocalizedText((AbstractButton)menu, (String)Bundle.CTL_OtherVCS_menu());
                for (JMenu submenu : vcsSubmenus) {
                    menu.add(submenu);
                }
                vcsSubmenus.clear();
                vcsSubmenus.add(menu);
            }
            items.addAll(vcsSubmenus);
            if (!(accepted |= ownerMenuDisplayed)) {
                items.add(NoVCSMenuItem.createNoVcsMenu(NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_MenuItem_VersioningMenu")));
                return items.toArray(new JComponent[items.size()]);
            }
            if (localHistory != null) {
                items.add(Utils.createJSeparator());
                items.add(this.createVersioningSystemMenu(localHistory, false));
            }
        }
        return items.toArray(new JComponent[items.size()]);
    }

    private JMenu createVersioningSystemMenu(final VCSSystemProvider.VersioningSystem system, final boolean isRegularVCS) {
        final JMenu menu = new JMenu();
        String menuText = VersioningManager.getInstance().isLocalHistory(system) ? NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_LocalHistoryMenuNameLoc") : system.getMenuLabel();
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)menuText);
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                if (menu.getItemCount() != 0) {
                    return;
                }
                VCSContext ctx = VCSContext.forNodes(TopComponent.getRegistry().getActivatedNodes());
                VersioningMainMenu.this.constructMenu(menu, system, ctx, isRegularVCS);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return menu;
    }

    private void constructMenu(JMenu menu, VCSSystemProvider.VersioningSystem system, VCSContext ctx, boolean isRegularVCS) {
        Action[] actions = null;
        if (system.getVCSAnnotator() != null) {
            actions = system.getVCSAnnotator().getActions(ctx, VCSAnnotator.ActionDestination.MainMenu);
        }
        if (isRegularVCS) {
            actions = this.appendAdditionalActions(ctx, system, actions);
        }
        if (actions != null && actions.length > 0) {
            List<JComponent> systemItems = VersioningMainMenu.actionsToItems(actions);
            for (JComponent systemItem : systemItems) {
                menu.add(systemItem);
            }
        }
    }

    private static List<JComponent> actionsToItems(Action[] actions) {
        ArrayList<JComponent> items = new ArrayList<JComponent>(actions.length);
        for (Action action : actions) {
            if (action == null) {
                items.add(Utils.createJSeparator());
                continue;
            }
            if (action instanceof DynamicMenuContent) {
                DynamicMenuContent dmc = (DynamicMenuContent)action;
                JComponent[] components = dmc.getMenuPresenters();
                items.addAll(Arrays.asList(components));
                continue;
            }
            JMenuItem item = Utils.toMenuItem(action);
            items.add(item);
        }
        return items;
    }

    private Action[] appendAdditionalActions(VCSContext ctx, VCSSystemProvider.VersioningSystem system, Action[] actions) {
        VCSFileProxy root;
        if (ctx.getRootFiles().size() == 1 && (root = system.getTopmostManagedAncestor(ctx.getRootFiles().iterator().next())) != null) {
            if (VersioningConfig.getDefault().isDisconnected(system, root)) {
                actions = new Action[]{new ConnectAction(system, root, null)};
            } else {
                actions = actions == null ? new Action[2] : Arrays.copyOf(actions, actions.length + 1);
                actions[actions.length - 1] = new DisconnectAction(system, root);
            }
        }
        return actions;
    }

    private static class DisconnectAction
    extends AbstractAction {
        private final VCSFileProxy root;
        private final VCSSystemProvider.VersioningSystem vs;

        public DisconnectAction(VCSSystemProvider.VersioningSystem vs, VCSFileProxy root) {
            super(NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_DisconnectAction.name"));
            this.vs = vs;
            this.root = root;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(VersioningMainMenu.class, (String)"MSG_ConnectAction.confirmation.text", (Object[])new Object[]{this.root.getName(), this.vs.getDisplayName()}), NbBundle.getMessage(VersioningMainMenu.class, (String)"LBL_ConnectAction.confirmation.title"), 2, 3);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
                VersioningConfig.getDefault().disconnectRepository(this.vs, this.root);
                VersioningManager.getInstance().versionedRootsChanged();
            }
        }
    }

    static class ConnectAction
    extends AbstractAction {
        private final VCSFileProxy root;
        private final VCSSystemProvider.VersioningSystem vs;

        public ConnectAction(VCSSystemProvider.VersioningSystem vs, VCSFileProxy root, String name) {
            super(name == null ? NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_ConnectAction.name") : name);
            this.vs = vs;
            this.root = root;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VersioningConfig.getDefault().connectRepository(this.vs, this.root);
            VersioningManager.getInstance().versionedRootsChanged();
        }
    }

    static final class ByDisplayNameComparator
    implements Comparator<VCSSystemProvider.VersioningSystem> {
        ByDisplayNameComparator() {
        }

        @Override
        public int compare(VCSSystemProvider.VersioningSystem a, VCSSystemProvider.VersioningSystem b) {
            return a.getDisplayName().compareTo(b.getDisplayName());
        }
    }
}

