/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.api.beans;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.beans.ConfigFileManagerAccessor;
import org.netbeans.modules.spring.beans.ConfigFileManagerImplementation;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

public final class ConfigFileManager {
    private final ConfigFileManagerImplementation impl;

    private ConfigFileManager(ConfigFileManagerImplementation impl) {
        this.impl = impl;
    }

    public Mutex mutex() {
        return this.impl.mutex();
    }

    public List<File> getConfigFiles() {
        return this.impl.getConfigFiles();
    }

    public List<ConfigFileGroup> getConfigFileGroups() {
        return this.impl.getConfigFileGroups();
    }

    public void putConfigFilesAndGroups(List<File> files, List<ConfigFileGroup> groups) {
        Parameters.notNull((CharSequence)"files", files);
        Parameters.notNull((CharSequence)"groups", groups);
        if (!this.mutex().isWriteAccess()) {
            throw new IllegalStateException("The putConfigFilesAndGroups() method should be called under mutex() write access");
        }
        this.impl.putConfigFilesAndGroups(files, groups);
    }

    public void save() throws IOException {
        if (!this.mutex().isWriteAccess()) {
            throw new IllegalStateException("The save() method should be called under mutex() write access");
        }
        this.impl.save();
    }

    void addChangeListener(ChangeListener listener) {
        this.impl.addChangeListener(listener);
    }

    static {
        ConfigFileManagerAccessor.setDefault(new ConfigFileManagerAccessor(){

            @Override
            public ConfigFileManager createConfigFileManager(ConfigFileManagerImplementation impl) {
                return new ConfigFileManager(impl);
            }
        });
    }
}

