/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.options;

import java.util.regex.Pattern;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.composer.commands.Composer;
import org.netbeans.modules.php.composer.options.Bundle;
import org.netbeans.modules.php.composer.options.ComposerOptions;

public final class ComposerOptionsValidator {
    private static final Pattern VENDOR_REGEX = Pattern.compile("^[a-z0-9-]+$");
    private static final Pattern EMAIL_REGEX = Pattern.compile("^\\w+[\\.\\w\\-]*@\\w+[\\.\\w\\-]*\\.[a-z]{2,}$", 2);
    private static final Pattern AUTHOR_NAME_REGEX = Pattern.compile("^[^\\d]+$");
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public ComposerOptionsValidator validate(ComposerOptions composerOptions) {
        return this.validate(composerOptions.getComposerPath(), composerOptions.getVendor(), composerOptions.getAuthorName(), composerOptions.getAuthorEmail());
    }

    public ComposerOptionsValidator validate(String composerPath, String vendor, String authorName, String authorEmail) {
        this.validateComposerPath(composerPath);
        this.validateVendor(vendor);
        this.validateAuthorName(authorName);
        this.validateAuthorEmail(authorEmail);
        return this;
    }

    private ComposerOptionsValidator validateComposerPath(String composerPath) {
        String warning = Composer.validate(composerPath);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"composerPath", warning));
        }
        return this;
    }

    ComposerOptionsValidator validateVendor(String vendor) {
        if (!VENDOR_REGEX.matcher(vendor).matches()) {
            this.result.addWarning(new ValidationResult.Message((Object)"vendor", Bundle.ComposerOptionsValidator_warning_invalidVendor()));
        }
        return this;
    }

    ComposerOptionsValidator validateAuthorName(String authorName) {
        if (!StringUtils.hasText((String)authorName)) {
            this.result.addWarning(new ValidationResult.Message((Object)"authorName", Bundle.ComposerOptionsValidator_warning_noAuthorName()));
        } else if (!AUTHOR_NAME_REGEX.matcher(authorName).matches()) {
            this.result.addWarning(new ValidationResult.Message((Object)"authorName", Bundle.ComposerOptionsValidator_warning_authorNameNumber()));
        }
        return this;
    }

    ComposerOptionsValidator validateAuthorEmail(String authorEmail) {
        if (!StringUtils.hasText((String)authorEmail) || !EMAIL_REGEX.matcher(authorEmail).matches()) {
            this.result.addWarning(new ValidationResult.Message((Object)"authorEmail", Bundle.ComposerOptionsValidator_warning_invalidAuthorEmail()));
        }
        return this;
    }
}

