/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.event.EventPublishingTestExecutionListener;
import org.springframework.test.context.jdbc.SqlScriptsTestExecutionListener;
import org.springframework.test.context.junit4.AbstractJUnit4SpringContextTests;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextBeforeModesTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.test.context.web.ServletTestExecutionListener;
import org.springframework.test.jdbc.JdbcTestUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@TestExecutionListeners(listeners={ServletTestExecutionListener.class, DirtiesContextBeforeModesTestExecutionListener.class, DependencyInjectionTestExecutionListener.class, DirtiesContextTestExecutionListener.class, TransactionalTestExecutionListener.class, SqlScriptsTestExecutionListener.class, EventPublishingTestExecutionListener.class}, inheritListeners=false)
@Transactional
public abstract class AbstractTransactionalJUnit4SpringContextTests
extends AbstractJUnit4SpringContextTests {
    protected final JdbcTemplate jdbcTemplate = new JdbcTemplate();
    @Nullable
    private String sqlScriptEncoding;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate.setDataSource(dataSource);
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    protected int countRowsInTable(String tableName) {
        return JdbcTestUtils.countRowsInTable(this.jdbcTemplate, tableName);
    }

    protected int countRowsInTableWhere(String tableName, String whereClause) {
        return JdbcTestUtils.countRowsInTableWhere(this.jdbcTemplate, tableName, whereClause);
    }

    protected int deleteFromTables(String ... names) {
        return JdbcTestUtils.deleteFromTables(this.jdbcTemplate, names);
    }

    protected int deleteFromTableWhere(String tableName, String whereClause, Object ... args) {
        return JdbcTestUtils.deleteFromTableWhere(this.jdbcTemplate, tableName, whereClause, args);
    }

    protected void dropTables(String ... names) {
        JdbcTestUtils.dropTables(this.jdbcTemplate, names);
    }

    protected void executeSqlScript(String sqlResourcePath, boolean continueOnError) throws DataAccessException {
        DataSource ds = this.jdbcTemplate.getDataSource();
        Assert.state((ds != null ? 1 : 0) != 0, (String)"No DataSource set");
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"No ApplicationContext set");
        Resource resource = this.applicationContext.getResource(sqlResourcePath);
        new ResourceDatabasePopulator(continueOnError, false, this.sqlScriptEncoding, new Resource[]{resource}).execute(ds);
    }
}

