/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public final class GradleCompilerOptionsQuery
implements CompilerOptionsQueryImplementation {
    final Project project;
    private final PropertyChangeListener listener;
    final Map<String, ResultImpl> cache = new HashMap<String, ResultImpl>();

    public GradleCompilerOptionsQuery(Project project) {
        this.project = project;
        NbGradleProject watcher = NbGradleProject.get((Project)project);
        this.listener = evt -> {
            if (watcher.isUnloadable()) {
                return;
            }
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                GradleCompilerOptionsQuery gradleCompilerOptionsQuery = this;
                synchronized (gradleCompilerOptionsQuery) {
                    for (ResultImpl res : this.cache.values()) {
                        res.support.fireChange();
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompilerOptionsQueryImplementation.Result getOptions(FileObject file) {
        GradleJavaSourceSet.SourceType sourceType;
        File f = FileUtil.toFile((FileObject)file);
        GradleJavaProject gjp = GradleJavaProject.get(this.project);
        GradleJavaSourceSet sourceSet = gjp.containingSourceSet(f);
        ResultImpl ret = null;
        if (sourceSet != null && (sourceType = sourceSet.getSourceType(f)) != GradleJavaSourceSet.SourceType.RESOURCES) {
            String key = sourceSet.getName() + "." + sourceType.name();
            GradleCompilerOptionsQuery gradleCompilerOptionsQuery = this;
            synchronized (gradleCompilerOptionsQuery) {
                ret = this.cache.get(key);
                if (ret == null) {
                    ret = new ResultImpl(sourceSet.getName(), sourceType);
                    this.cache.put(key, ret);
                }
            }
        }
        return ret;
    }

    final class ResultImpl
    extends CompilerOptionsQueryImplementation.Result {
        final String sourceSetName;
        final GradleJavaSourceSet.SourceType type;
        final ChangeSupport support;

        public ResultImpl(String sourceSetName, GradleJavaSourceSet.SourceType type) {
            this.sourceSetName = sourceSetName;
            this.type = type;
            this.support = new ChangeSupport((Object)this);
        }

        public List<? extends String> getArguments() {
            GradleJavaProject gjp = GradleJavaProject.get(GradleCompilerOptionsQuery.this.project);
            GradleJavaSourceSet ss = gjp.getSourceSets().get(this.sourceSetName);
            return ss.getCompilerArgs(this.type);
        }

        public void addChangeListener(ChangeListener listener) {
            this.support.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.support.removeChangeListener(listener);
        }
    }
}

