/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.util.TimeUtil;
import java.util.concurrent.atomic.AtomicLong;

public final class TimeProfiler {
    private static final String CLASS_NAME = "[" + TimeProfiler.class.getSimpleName() + "] ";
    private final AtomicLong counter = new AtomicLong();

    public TimeProfiler() {
        if (JSTruffleOptions.PrintCumulativeTime) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    System.out.println(CLASS_NAME + "cumulative: " + TimeUtil.format(TimeProfiler.this.counter.get()));
                }
            });
        }
    }

    public void printElapsed(long startTime, String event) {
        long elapsed = System.nanoTime() - startTime;
        this.counter.addAndGet(elapsed);
        System.out.println(CLASS_NAME + event + " took: " + TimeUtil.format(elapsed));
    }
}

