/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;

public class JSProperty {
    public static final int ACCESSOR = 8;
    public static final int PROXY = 16;
    public static final int CONST = 32;

    @CompilerDirectives.TruffleBoundary
    public String toString(Property property) {
        return "\"" + property.getKey() + "\"" + JSProperty.getAttributeString(property) + ":" + property.getLocation();
    }

    private static String getAttributeString(Property property) {
        String negative = JSProperty.getAttributeString(property, false);
        return negative.isEmpty() ? "" : "-" + negative;
    }

    protected static String getAttributeString(Property property, boolean positive) {
        return (JSProperty.isEnumerable(property) == positive ? "e" : "") + (JSProperty.isConfigurable(property) == positive ? "c" : "") + (JSProperty.isData(property) && JSProperty.isWritable(property) == positive ? "w" : "");
    }

    public static Object getValue(Property property, DynamicObject store, Object thisObj, boolean floatingCondition) {
        Object value = property.get(store, floatingCondition);
        if (JSProperty.isAccessor(property)) {
            return JSProperty.getValueAccessor(thisObj, value);
        }
        if (JSProperty.isProxy(property)) {
            return ((PropertyProxy)value).get(store);
        }
        assert (JSProperty.isData(property));
        return value;
    }

    private static Object getValueAccessor(Object thisObj, Object value) {
        DynamicObject getter = ((Accessor)value).getGetter();
        if (getter != Undefined.instance) {
            return JSRuntime.call(getter, thisObj, JSArguments.EMPTY_ARGUMENTS_ARRAY);
        }
        return Undefined.instance;
    }

    public static void setValue(Property property, DynamicObject store, Object thisObj, Object value, Shape shape, boolean isStrict) {
        if (JSProperty.isAccessor(property)) {
            JSProperty.setValueAccessor(property, store, thisObj, value, isStrict);
        } else if (JSProperty.isWritable(property)) {
            if (JSProperty.isProxy(property)) {
                boolean ret = ((PropertyProxy)property.get(store, false)).set(store, value);
                if (!ret && isStrict) {
                    throw Errors.createTypeErrorNotWritableProperty(property.getKey(), thisObj);
                }
            } else {
                assert (JSProperty.isData(property));
                property.setGeneric(store, value, shape);
            }
        } else if (isStrict) {
            throw Errors.createTypeErrorNotWritableProperty(property.getKey(), thisObj);
        }
    }

    private static void setValueAccessor(Property property, DynamicObject store, Object thisObj, Object value, boolean isStrict) {
        DynamicObject setter = ((Accessor)property.get(store, false)).getSetter();
        if (setter != Undefined.instance) {
            JSRuntime.call(setter, thisObj, new Object[]{value});
        } else if (isStrict) {
            throw Errors.createTypeErrorCannotSetAccessorProperty(property.getKey(), store);
        }
    }

    public static Property seal(Property property) {
        if (property.isHidden()) {
            return property;
        }
        if (JSProperty.isConfigurable(property)) {
            return property.copyWithFlags(property.getFlags() | 2);
        }
        return property;
    }

    public static Property freeze(Property property) {
        if (property.isHidden()) {
            return property;
        }
        if (JSProperty.isAccessor(property)) {
            return JSProperty.seal(property);
        }
        if (JSProperty.isConfigurable(property) || JSProperty.isWritable(property)) {
            return property.copyWithFlags(property.getFlags() | 2 | 4);
        }
        return property;
    }

    public static boolean isConfigurable(Property property) {
        return (property.getFlags() & 2) == 0;
    }

    public static boolean isEnumerable(Property property) {
        return (property.getFlags() & 1) == 0;
    }

    public static boolean isWritable(Property property) {
        return (property.getFlags() & 4) == 0;
    }

    public static boolean isProxy(Property property) {
        return (property.getFlags() & 0x10) != 0;
    }

    public static boolean isAccessor(Property property) {
        return (property.getFlags() & 8) != 0;
    }

    public static boolean isData(Property property) {
        return (property.getFlags() & 8) == 0;
    }

    public static boolean isConst(Property property) {
        return (property.getFlags() & 0x20) != 0;
    }

    public static PropertyProxy getConstantProxy(Property proxyProperty) {
        assert (JSProperty.isProxy(proxyProperty));
        return proxyProperty.getLocation().isConstant() ? (PropertyProxy)proxyProperty.get(null, false) : null;
    }
}

