/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.Objects;
import org.graalvm.collections.EconomicMap;

@ExportLibrary(value=InteropLibrary.class)
public final class JSMetaObject
implements TruffleObject {
    private final String type;
    private final String subtype;
    private final String className;
    private final TruffleLanguage.Env env;
    private EconomicMap<String, String> map;

    public JSMetaObject(String type, String subtype, String className, TruffleLanguage.Env env) {
        this.type = Objects.requireNonNull(type);
        this.subtype = subtype;
        this.className = className;
        this.env = env;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getClassName() {
        return this.className;
    }

    EconomicMap<String, String> getMap() {
        if (this.map == null) {
            this.map = EconomicMap.create();
            this.map.put((Object)"type", (Object)this.type);
            if (this.subtype != null) {
                this.map.put((Object)"subtype", (Object)this.subtype);
            }
            if (this.className != null) {
                this.map.put((Object)"className", (Object)this.className);
            }
        }
        return this.map;
    }

    static boolean isInstance(TruffleObject object) {
        return object instanceof JSMetaObject;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String key) throws UnknownIdentifierException {
        String value = (String)this.getMap().get((Object)key);
        if (value == null) {
            throw UnknownIdentifierException.create((String)key);
        }
        return value;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        String[] keys = new String[this.getMap().size()];
        int i = 0;
        for (String key : this.getMap().getKeys()) {
            keys[i++] = key;
        }
        return this.env.asGuestValue((Object)keys);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberReadable(String key) {
        return this.getMap().containsKey((Object)key);
    }
}

