/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.joni;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.runtime.joni.JoniCompiledRegex;
import com.oracle.truffle.js.runtime.joni.result.JoniNoMatchResult;
import com.oracle.truffle.js.runtime.joni.result.JoniRegexResult;
import com.oracle.truffle.js.runtime.joni.result.JoniSingleResult;
import com.oracle.truffle.js.runtime.joni.result.JoniStartsEndsIndexArrayResult;
import com.oracle.truffle.regex.nashorn.regexp.joni.Matcher;
import com.oracle.truffle.regex.nashorn.regexp.joni.Regex;
import com.oracle.truffle.regex.nashorn.regexp.joni.Region;

public abstract class JoniRegexExecRootNode
extends RootNode {
    private final SourceSection pseudoSource;
    private final boolean sticky;
    private static final FrameDescriptor SHARED_EMPTY_FRAMEDESCRIPTOR = new FrameDescriptor();

    public JoniRegexExecRootNode(TruffleLanguage<?> language, SourceSection pseudoSource, boolean sticky) {
        super(language, SHARED_EMPTY_FRAMEDESCRIPTOR);
        this.pseudoSource = pseudoSource;
        this.sticky = sticky;
    }

    public final JoniRegexResult execute(VirtualFrame frame) {
        Object[] args = frame.getArguments();
        assert (args.length == 3);
        JoniCompiledRegex compiledRegex = (JoniCompiledRegex)args[0];
        String input = (String)args[1];
        int fromIndex = (Integer)args[2];
        Regex impl = compiledRegex.getJoniRegex();
        Matcher matcher = this.sticky ? JoniRegexExecRootNode.match(impl, input, fromIndex) : JoniRegexExecRootNode.search(impl, input, fromIndex);
        return matcher != null ? this.getMatchResult(matcher) : JoniNoMatchResult.getInstance();
    }

    @CompilerDirectives.TruffleBoundary
    private static Matcher search(Regex regex, String input, int fromIndex) {
        Matcher matcher = regex.matcher(input);
        boolean isMatch = matcher.search(fromIndex, input.length(), regex.getOptions()) > -1;
        return isMatch ? matcher : null;
    }

    @CompilerDirectives.TruffleBoundary
    private static Matcher match(Regex regex, String input, int fromIndex) {
        Matcher matcher = regex.matcher(input);
        boolean isMatch = matcher.match(fromIndex, input.length(), regex.getOptions()) > -1;
        return isMatch ? matcher : null;
    }

    public SourceSection getSourceSection() {
        return this.pseudoSource;
    }

    public String toString() {
        return "joni regex " + this.pseudoSource;
    }

    protected abstract JoniRegexResult getMatchResult(Matcher var1);

    private static SourceSection createPseudoSource(String name) {
        String patternSrc = "/[" + name + "]/";
        return Source.newBuilder((String)"regex", (CharSequence)patternSrc, (String)patternSrc).build().createSection(0, patternSrc.length());
    }

    public static class Groups
    extends JoniRegexExecRootNode {
        public Groups(TruffleLanguage<?> language, boolean sticky) {
            super(language, JoniRegexExecRootNode.createPseudoSource("JONI_SINGLETON_ROOT_NODE_" + (sticky ? "STICKY_" : "") + "GROUPS"), sticky);
        }

        @Override
        protected JoniRegexResult getMatchResult(Matcher matcher) {
            Region reg = matcher.getRegion();
            return new JoniStartsEndsIndexArrayResult(reg.beg, reg.end);
        }
    }

    public static class Simple
    extends JoniRegexExecRootNode {
        public Simple(TruffleLanguage<?> language, boolean sticky) {
            super(language, JoniRegexExecRootNode.createPseudoSource("JONI_SINGLETON_ROOT_NODE_" + (sticky ? "STICKY_" : "") + "SIMPLE"), sticky);
        }

        @Override
        protected JoniRegexResult getMatchResult(Matcher matcher) {
            return new JoniSingleResult(matcher.getBegin(), matcher.getEnd());
        }
    }
}

