/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DirectByteBufferHelper;
import com.oracle.truffle.js.runtime.util.IteratorUtil;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;

public final class JSArrayBufferView
extends JSBuiltinObject {
    public static final String CLASS_NAME = "ArrayBufferView";
    public static final String PROTOTYPE_NAME = "ArrayBufferView.prototype";
    public static final String TYPED_ARRAY_CLASS_NAME = "TypedArray";
    public static final JSArrayBufferView INSTANCE = new JSArrayBufferView();
    private static final String BYTES_PER_ELEMENT = "BYTES_PER_ELEMENT";
    private static final String BYTE_LENGTH = "byteLength";
    private static final String LENGTH = "length";
    private static final String BUFFER = "buffer";
    private static final String BYTE_OFFSET = "byteOffset";
    private static final HiddenKey ARRAY_BUFFER_ID = new HiddenKey("arrayBuffer");
    private static final Property ARRAY_BUFFER_PROPERTY;
    private static final HiddenKey ARRAY_ID;
    private static final HiddenKey ARRAY_TYPE_ID;
    private static final HiddenKey OFFSET_ID;
    private static final HiddenKey LENGTH_ID;
    private static final HiddenKey SHAREABLE_ID;
    private static final Property BYTE_ARRAY_PROPERTY;
    private static final Property BYTE_BUFFER_PROPERTY;
    private static final Property ARRAY_TYPE_PROPERTY;
    private static final Property ARRAY_LENGTH_PROPERTY;
    private static final Property ARRAY_OFFSET_PROPERTY;
    private static final Property ARRAY_SHAREABLE;

    public static TypedArray typedArrayGetArrayType(DynamicObject thisObj) {
        return JSArrayBufferView.typedArrayGetArrayType(thisObj, JSArrayBufferView.isJSArrayBufferView(thisObj));
    }

    public static TypedArray typedArrayGetArrayType(DynamicObject thisObj, boolean condition) {
        assert (JSArrayBufferView.isJSArrayBufferView(thisObj));
        return (TypedArray)ARRAY_TYPE_PROPERTY.get(thisObj, condition);
    }

    public static void typedArraySetArrayType(DynamicObject thisObj, TypedArray arrayType) {
        ARRAY_TYPE_PROPERTY.setSafe(thisObj, (Object)arrayType, null);
    }

    public static int typedArrayGetLength(DynamicObject thisObj) {
        return JSArrayBufferView.typedArrayGetLength(thisObj, JSArrayBufferView.isJSArrayBufferView(thisObj));
    }

    public static int typedArrayGetLength(DynamicObject thisObj, boolean condition) {
        return (Integer)ARRAY_LENGTH_PROPERTY.get(thisObj, condition);
    }

    public static void typedArraySetLength(DynamicObject thisObj, int length) {
        ARRAY_LENGTH_PROPERTY.setSafe(thisObj, (Object)length, null);
    }

    public static int typedArrayGetOffset(DynamicObject thisObj) {
        return JSArrayBufferView.typedArrayGetOffset(thisObj, JSArrayBufferView.isJSArrayBufferView(thisObj));
    }

    public static int typedArrayGetOffset(DynamicObject thisObj, boolean condition) {
        return (Integer)ARRAY_OFFSET_PROPERTY.get(thisObj, condition);
    }

    public static void typedArraySetOffset(DynamicObject thisObj, int arrayOffset) {
        ARRAY_OFFSET_PROPERTY.setSafe(thisObj, (Object)arrayOffset, null);
    }

    public static byte[] typedArrayGetByteArray(DynamicObject thisObj) {
        return JSArrayBufferView.typedArrayGetByteArray(thisObj, JSArrayBufferView.isJSArrayBufferView(thisObj));
    }

    public static byte[] typedArrayGetByteArray(DynamicObject thisObj, boolean condition) {
        return (byte[])BYTE_ARRAY_PROPERTY.get(thisObj, condition);
    }

    public static void typedArraySetArray(DynamicObject thisObj, byte[] arrayOffset) {
        BYTE_ARRAY_PROPERTY.setSafe(thisObj, (Object)arrayOffset, null);
    }

    public static ByteBuffer typedArrayGetByteBuffer(DynamicObject thisObj, boolean condition) {
        return DirectByteBufferHelper.cast((ByteBuffer)BYTE_BUFFER_PROPERTY.get(thisObj, condition));
    }

    private static String typedArrayGetName(DynamicObject thisObj) {
        return JSArrayBufferView.typedArrayGetArrayType(thisObj).getName();
    }

    private JSArrayBufferView() {
    }

    public static DynamicObject getArrayBuffer(DynamicObject thisObj, boolean condition) {
        assert (JSArrayBufferView.isJSArrayBufferView(thisObj));
        return (DynamicObject)ARRAY_BUFFER_PROPERTY.get(thisObj, condition);
    }

    public static DynamicObject getArrayBuffer(DynamicObject thisObj) {
        return JSArrayBufferView.getArrayBuffer(thisObj, JSArrayBufferView.isJSArrayBufferView(thisObj));
    }

    public static int getByteLength(DynamicObject store, boolean condition, JSContext ctx) {
        assert (JSArrayBufferView.isJSArrayBufferView(store));
        if (JSArrayBufferView.hasDetachedBuffer(store, ctx)) {
            return 0;
        }
        TypedArray typedArray = JSArrayBufferView.typedArrayGetArrayType(store, condition);
        return typedArray.lengthInt(store, condition) * typedArray.bytesPerElement();
    }

    public static int getByteLength(DynamicObject store, boolean condition, JSContext ctx, ValueProfile profile) {
        assert (JSArrayBufferView.isJSArrayBufferView(store));
        if (JSArrayBufferView.hasDetachedBuffer(store, ctx)) {
            return 0;
        }
        TypedArray typedArray = (TypedArray)profile.profile((Object)JSArrayBufferView.typedArrayGetArrayType(store, condition));
        return typedArray.lengthInt(store, condition) * typedArray.bytesPerElement();
    }

    public static int getByteOffset(DynamicObject store, boolean condition, JSContext ctx) {
        assert (JSArrayBufferView.isJSArrayBufferView(store));
        if (JSArrayBufferView.hasDetachedBuffer(store, ctx)) {
            return 0;
        }
        return JSArrayBufferView.typedArrayGetOffset(store, condition);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getHelper(DynamicObject store, Object thisObj, long index) {
        return this.getOwnHelper(store, thisObj, index);
    }

    @Override
    public Object getOwnHelper(DynamicObject store, Object thisObj, long index) {
        JSArrayBufferView.checkDetachedView(store);
        return JSArrayBufferView.typedArrayGetArrayType(store).getElement(store, index);
    }

    @Override
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        JSArrayBufferView.checkDetachedView(thisObj);
        JSArrayBufferView.typedArrayGetArrayType(thisObj).setElement(thisObj, index, value, isStrict);
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        Object numericIndex;
        if (JSRuntime.isString(key) && (numericIndex = JSRuntime.canonicalNumericIndexString(key)) != Undefined.instance) {
            return JSRuntime.integerIndexedElementSet(thisObj, numericIndex, value);
        }
        return super.set(thisObj, key, value, receiver, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasProperty(DynamicObject thisObj, long index) {
        return this.hasOwnProperty(thisObj, index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasProperty(DynamicObject thisObj, Object key) {
        Object numericIndex;
        if (JSRuntime.isString(key) && (numericIndex = JSRuntime.canonicalNumericIndexString(key)) != Undefined.instance) {
            return JSArrayBufferView.hasNumericIndex(thisObj, numericIndex);
        }
        return super.hasProperty(thisObj, key);
    }

    @Override
    public boolean hasOwnProperty(DynamicObject thisObj, long index) {
        JSArrayBufferView.checkDetachedView(thisObj);
        return JSArrayBufferView.typedArrayGetArrayType(thisObj).hasElement(thisObj, index);
    }

    @Override
    public boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        Object numericIndex;
        if (JSRuntime.isString(key) && (numericIndex = JSRuntime.canonicalNumericIndexString(key)) != Undefined.instance) {
            return JSArrayBufferView.hasNumericIndex(thisObj, numericIndex);
        }
        return super.hasOwnProperty(thisObj, key);
    }

    private static boolean hasNumericIndex(DynamicObject thisObj, Object numericIndex) {
        DynamicObject buffer = JSArrayBufferView.getArrayBuffer(thisObj);
        JSArrayBufferView.checkDetachedBuffer(buffer);
        if (!JSRuntime.isInteger(numericIndex)) {
            return false;
        }
        double d = JSRuntime.doubleValue((Number)numericIndex);
        if (JSRuntime.isNegativeZero(d) || d < 0.0) {
            return false;
        }
        return d < (double)JSArrayBufferView.typedArrayGetLength(thisObj, JSArrayBufferView.isJSArrayBufferView(thisObj));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getHelper(DynamicObject store, Object thisObj, Object key) {
        Object numericIndex;
        if (JSRuntime.isString(key) && (numericIndex = JSRuntime.canonicalNumericIndexString(key)) != Undefined.instance) {
            return JSRuntime.integerIndexedElementGet(store, numericIndex);
        }
        return super.getHelper(store, thisObj, key);
    }

    public static DynamicObject createArrayBufferView(JSContext context, DynamicObject arrayBuffer, TypedArray arrayType, int offset, int length) {
        CompilerAsserts.partialEvaluationConstant((Object)arrayType);
        assert (JSArrayBuffer.isJSAbstractBuffer(arrayBuffer));
        if (!context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
            throw Errors.createTypeErrorDetachedBuffer();
        }
        JSObjectFactory objectFactory = arrayType.isDirect() ? context.getDirectArrayBufferViewFactory(arrayType.getFactory()) : context.getArrayBufferViewFactory(arrayType.getFactory());
        return JSArrayBufferView.createArrayBufferView(context, objectFactory, arrayBuffer, arrayType, offset, length);
    }

    public static DynamicObject createArrayBufferView(JSContext context, JSObjectFactory objectFactory, DynamicObject arrayBuffer, TypedArray arrayType, int offset, int length) {
        Object backingStorage = arrayType.isDirect() ? JSArrayBuffer.getDirectByteBuffer(arrayBuffer) : (Object)JSArrayBuffer.getByteArray(arrayBuffer);
        return JSArrayBufferView.createArrayBufferView(context, objectFactory, arrayBuffer, arrayType, offset, length, backingStorage, false);
    }

    private static DynamicObject createArrayBufferView(JSContext context, JSObjectFactory objectFactory, DynamicObject arrayBuffer, TypedArray arrayType, int offset, int length, Object backingStorage, boolean shareable) {
        assert (offset >= 0 && offset + length * arrayType.bytesPerElement() <= (arrayType.isDirect() ? ((ByteBuffer)backingStorage).limit() : ((byte[])backingStorage).length));
        assert (offset != 0 == arrayType.hasOffset());
        DynamicObject arrayBufferView = JSObject.create(context, objectFactory, backingStorage, arrayType, arrayBuffer, length, offset, shareable);
        assert (JSArrayBuffer.isJSAbstractBuffer(arrayBuffer));
        assert (JSArrayBufferView.isJSArrayBufferView(arrayBufferView));
        return arrayBufferView;
    }

    private static DynamicObject createArrayBufferViewPrototype(JSRealm realm, DynamicObject ctor, int bytesPerElement, TypedArrayFactory factory, DynamicObject taPrototype) {
        JSContext context = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, taPrototype, (JSClass)(context.getEcmaScriptVersion() < 6 ? INSTANCE : JSUserObject.INSTANCE));
        if (context.getEcmaScriptVersion() < 6) {
            byte[] byteArray = new byte[]{};
            DynamicObject arrayBuffer = context.getArrayBufferFactory().createWithRealm(realm, (Object)byteArray);
            JSObjectUtil.putHiddenProperty(prototype, BYTE_ARRAY_PROPERTY, byteArray);
            JSObjectUtil.putHiddenProperty(prototype, ARRAY_TYPE_PROPERTY, factory.createArrayType(false, false));
            JSObjectUtil.putHiddenProperty(prototype, ARRAY_BUFFER_PROPERTY, arrayBuffer);
            JSObjectUtil.putHiddenProperty(prototype, ARRAY_LENGTH_PROPERTY, 0);
            JSObjectUtil.putHiddenProperty(prototype, ARRAY_OFFSET_PROPERTY, 0);
            JSObjectUtil.putHiddenProperty(prototype, ARRAY_SHAREABLE, false);
        }
        JSObjectUtil.putDataProperty(context, prototype, BYTES_PER_ELEMENT, bytesPerElement, JSAttributes.notConfigurableNotEnumerableNotWritable());
        JSObjectUtil.putConstructorProperty(context, prototype, ctor);
        return prototype;
    }

    protected static void putArrayBufferViewPrototypeGetter(JSRealm realm, DynamicObject prototype, String key, JSContext.BuiltinFunctionKey functionKey, final ArrayBufferViewGetter getter) {
        JSFunctionData lengthGetterData = realm.getContext().getOrCreateBuiltinFunctionData(functionKey, c -> JSFunctionData.createCallOnly(c, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(c.getLanguage(), null, null){
            @Node.Child
            private ArrayBufferViewGetter getterNode;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference realmRef;
            {
                super(lang, sourceSection, frameDescriptor);
                this.getterNode = getter;
            }

            public Object execute(VirtualFrame frame) {
                DynamicObject view;
                boolean condition;
                Object obj = JSArguments.getThisObject(frame.getArguments());
                if (JSObject.isDynamicObject(obj) && (condition = JSArrayBufferView.isJSArrayBufferView(view = JSObject.castJSObject(obj)))) {
                    return getter.apply(view, condition);
                }
                if (this.realmRef == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.realmRef = this.lookupContextReference(JavaScriptLanguage.class);
                }
                throw Errors.createTypeError("method called on incompatible receiver").setRealm((JSRealm)this.realmRef.get());
            }
        }), 0, "get " + key));
        DynamicObject lengthGetter = JSFunction.create(realm, lengthGetterData);
        JSObjectUtil.putConstantAccessorProperty(realm.getContext(), prototype, key, lengthGetter, Undefined.instance);
    }

    public static Shape makeInitialArrayBufferViewShape(JSContext ctx, DynamicObject prototype, boolean direct) {
        Shape childTree = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        childTree = direct ? childTree.addProperty(BYTE_BUFFER_PROPERTY) : childTree.addProperty(BYTE_ARRAY_PROPERTY);
        childTree = childTree.addProperty(ARRAY_TYPE_PROPERTY);
        childTree = childTree.addProperty(ARRAY_BUFFER_PROPERTY);
        childTree = childTree.addProperty(ARRAY_LENGTH_PROPERTY);
        childTree = childTree.addProperty(ARRAY_OFFSET_PROPERTY);
        childTree = childTree.addProperty(ARRAY_SHAREABLE);
        return childTree;
    }

    public static JSConstructor createConstructor(JSRealm realm, TypedArrayFactory factory, JSConstructor taConstructor) {
        JSContext ctx = realm.getContext();
        DynamicObject arrayBufferViewConstructor = realm.lookupFunction("%Constructors%", factory.getName());
        JSObject.setPrototype(arrayBufferViewConstructor, taConstructor.getFunctionObject());
        DynamicObject arrayBufferViewPrototype = JSArrayBufferView.createArrayBufferViewPrototype(realm, arrayBufferViewConstructor, factory.getBytesPerElement(), factory, taConstructor.getPrototype());
        JSObjectUtil.putConstructorPrototypeProperty(ctx, arrayBufferViewConstructor, arrayBufferViewPrototype);
        JSObjectUtil.putDataProperty(ctx, arrayBufferViewConstructor, BYTES_PER_ELEMENT, factory.getBytesPerElement(), JSAttributes.notConfigurableNotEnumerableNotWritable());
        JSArrayBufferView.putConstructorSpeciesGetter(realm, arrayBufferViewConstructor);
        return new JSConstructor(arrayBufferViewConstructor, arrayBufferViewPrototype);
    }

    private static DynamicObject createTypedArrayPrototype(JSRealm realm, DynamicObject ctor) {
        final JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, PROTOTYPE_NAME);
        JSArrayBufferView.putArrayBufferViewPrototypeGetter(realm, prototype, LENGTH, JSContext.BuiltinFunctionKey.ArrayBufferViewLength, new ArrayBufferViewGetter(){

            @Override
            public Object apply(DynamicObject view, boolean condition) {
                if (JSArrayBufferView.hasDetachedBuffer(view, ctx)) {
                    return 0;
                }
                return JSArrayBufferView.typedArrayGetLength(view, condition);
            }
        });
        JSArrayBufferView.putArrayBufferViewPrototypeGetter(realm, prototype, BUFFER, JSContext.BuiltinFunctionKey.ArrayBufferViewBuffer, new ArrayBufferViewGetter(){

            @Override
            public Object apply(DynamicObject view, boolean condition) {
                return JSArrayBufferView.getArrayBuffer(view, condition);
            }
        });
        JSArrayBufferView.putArrayBufferViewPrototypeGetter(realm, prototype, BYTE_LENGTH, JSContext.BuiltinFunctionKey.ArrayBufferViewByteLength, new ArrayBufferViewGetter(){

            @Override
            public Object apply(DynamicObject view, boolean condition) {
                return JSArrayBufferView.getByteLength(view, condition, ctx);
            }
        });
        JSArrayBufferView.putArrayBufferViewPrototypeGetter(realm, prototype, BYTE_OFFSET, JSContext.BuiltinFunctionKey.ArrayBufferViewByteByteOffset, new ArrayBufferViewGetter(){

            @Override
            public Object apply(DynamicObject view, boolean condition) {
                return JSArrayBufferView.getByteOffset(view, condition, ctx);
            }
        });
        JSFunctionData toStringData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ArrayBufferViewToString, c -> JSFunctionData.createCallOnly(ctx, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(ctx.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                DynamicObject view;
                Object obj = JSArguments.getThisObject(frame.getArguments());
                if (JSObject.isDynamicObject(obj) && JSArrayBufferView.isJSArrayBufferView(view = JSObject.castJSObject(obj))) {
                    return JSArrayBufferView.typedArrayGetName(view);
                }
                return Undefined.instance;
            }
        }), 0, "get [Symbol.toStringTag]"));
        DynamicObject toStringTagGetter = JSFunction.create(realm, toStringData);
        JSObjectUtil.putConstantAccessorProperty(ctx, prototype, Symbol.SYMBOL_TO_STRING_TAG, toStringTagGetter, Undefined.instance);
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_ITERATOR, prototype.get((Object)"values"), JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(ctx, prototype, "toString", realm.getArrayPrototype().get((Object)"toString"), JSAttributes.getDefaultNotEnumerable());
        return prototype;
    }

    public static JSConstructor createTypedArrayConstructor(JSRealm realm) {
        JSContext ctx = realm.getContext();
        DynamicObject taConstructor = realm.lookupFunction("%Constructors%", TYPED_ARRAY_CLASS_NAME);
        DynamicObject taPrototype = JSArrayBufferView.createTypedArrayPrototype(realm, taConstructor);
        JSObjectUtil.putConstructorPrototypeProperty(ctx, taConstructor, taPrototype);
        JSObjectUtil.putFunctionsFromContainer(realm, taConstructor, CLASS_NAME);
        JSArrayBufferView.putConstructorSpeciesGetter(realm, taConstructor);
        return new JSConstructor(taConstructor, taPrototype);
    }

    @Override
    public String getClassName(DynamicObject object) {
        return JSArrayBufferView.typedArrayGetName(object);
    }

    public static boolean isJSArrayBufferView(Object obj) {
        return JSObject.isDynamicObject(obj) && JSArrayBufferView.isJSArrayBufferView((DynamicObject)obj);
    }

    public static boolean isJSArrayBufferView(DynamicObject obj) {
        return JSArrayBufferView.isInstance(obj, (JSClass)INSTANCE);
    }

    public static boolean isBigIntArrayBufferView(DynamicObject obj) {
        return JSArrayBufferView.typedArrayGetArrayType(obj) instanceof TypedArray.TypedBigIntArray;
    }

    public static boolean hasDetachedBuffer(DynamicObject obj, JSContext ctx) {
        assert (JSArrayBufferView.isJSArrayBufferView(obj));
        if (ctx.getTypedArrayNotDetachedAssumption().isValid()) {
            return false;
        }
        return JSArrayBufferView.hasDetachedBuffer(obj);
    }

    public static boolean hasDetachedBuffer(DynamicObject obj) {
        assert (JSArrayBufferView.isJSArrayBufferView(obj));
        return JSArrayBuffer.isDetachedBuffer(JSArrayBufferView.getArrayBuffer(obj));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        if (!strings) {
            return super.getOwnPropertyKeys(thisObj, strings, symbols);
        }
        List<Object> indices = JSArrayBufferView.typedArrayGetArrayType(thisObj).ownPropertyKeys(thisObj);
        List<Object> keys = JSArrayBufferView.ordinaryOwnPropertyKeys(thisObj, strings, symbols);
        return IteratorUtil.concatLists(indices, keys);
    }

    @Override
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor descriptor, boolean doThrow) {
        Object numericIndex;
        if (JSRuntime.isString(key) && (numericIndex = JSRuntime.canonicalNumericIndexString(key)) != Undefined.instance) {
            boolean success = JSArrayBufferView.defineOwnPropertyIndex(thisObj, numericIndex, descriptor);
            if (doThrow && !success) {
                throw Errors.createTypeError("Cannot defineOwnProperty on TypedArray");
            }
            return success;
        }
        return super.defineOwnProperty(thisObj, key, descriptor, doThrow);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean defineOwnPropertyIndex(DynamicObject thisObj, Object numericIndex, PropertyDescriptor desc) {
        if (!JSRuntime.isInteger(numericIndex)) {
            return false;
        }
        double dIndex = ((Number)numericIndex).doubleValue();
        if (JSRuntime.isNegativeZero(dIndex) || dIndex < 0.0) {
            return false;
        }
        if ((long)dIndex >= (long)JSArrayBufferView.typedArrayGetLength(thisObj)) {
            return false;
        }
        if (desc.isAccessorDescriptor()) {
            return false;
        }
        if (desc.hasConfigurable() && desc.getConfigurable()) {
            return false;
        }
        if (desc.hasEnumerable() && !desc.getEnumerable()) {
            return false;
        }
        if (desc.hasWritable() && !desc.getWritable()) {
            return false;
        }
        if (desc.hasValue()) {
            JSRuntime.integerIndexedElementSet(thisObj, (int)dIndex, desc.getValue());
        }
        return true;
    }

    @Override
    public boolean setIntegrityLevel(DynamicObject thisObj, boolean freeze) {
        this.preventExtensions(thisObj);
        if (freeze && JSArrayBufferView.typedArrayGetLength(thisObj) > 0) {
            JSArrayBufferView.throwCannotRedefine();
        }
        return true;
    }

    private static void throwCannotRedefine() {
        throw Errors.createTypeError("Cannot redefine a property of an object with external array elements");
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        long numericIndex;
        assert (JSRuntime.isPropertyKey(key));
        if (JSRuntime.isString(key) && (numericIndex = JSRuntime.propertyKeyToIntegerIndex(key)) >= 0L) {
            Object value = this.getOwnHelper(thisObj, (Object)thisObj, numericIndex);
            if (value == Undefined.instance) {
                return null;
            }
            return PropertyDescriptor.createData(value, true, true, false);
        }
        return JSArrayBufferView.ordinaryGetOwnProperty(thisObj, key);
    }

    private static void checkDetachedBuffer(DynamicObject thisObj) {
        if (JSArrayBuffer.isDetachedBuffer(thisObj)) {
            throw Errors.createTypeErrorDetachedBuffer();
        }
    }

    private static void checkDetachedView(DynamicObject thisObj) {
        if (JSArrayBufferView.hasDetachedBuffer(thisObj)) {
            throw Errors.createTypeErrorDetachedBuffer();
        }
    }

    @Override
    public String safeToString(DynamicObject obj, int depth) {
        if (JSTruffleOptions.NashornCompatibilityMode) {
            return this.defaultToString(obj);
        }
        return JSRuntime.objectToConsoleString(obj, JSArrayBufferView.typedArrayGetName(obj), depth);
    }

    @Override
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        Object numericIndex;
        if (JSRuntime.isString(key) && (numericIndex = JSRuntime.canonicalNumericIndexString(key)) != Undefined.instance) {
            if (JSArrayBufferView.hasNumericIndex(thisObj, numericIndex)) {
                if (isStrict) {
                    throw Errors.createTypeErrorNotConfigurableProperty(key);
                }
                return false;
            }
            return true;
        }
        return super.delete(thisObj, key, isStrict);
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }

    static {
        ARRAY_ID = new HiddenKey("array");
        ARRAY_TYPE_ID = new HiddenKey("arraytype");
        OFFSET_ID = new HiddenKey("offset");
        LENGTH_ID = new HiddenKey(LENGTH);
        SHAREABLE_ID = new HiddenKey("shareable");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        BYTE_ARRAY_PROPERTY = JSObjectUtil.makeHiddenProperty(ARRAY_ID, allocator.copy().locationForType(byte[].class, EnumSet.of(LocationModifier.NonNull)));
        BYTE_BUFFER_PROPERTY = JSObjectUtil.makeHiddenProperty(ARRAY_ID, allocator.locationForType(ByteBuffer.class, EnumSet.of(LocationModifier.NonNull)));
        ARRAY_TYPE_PROPERTY = JSObjectUtil.makeHiddenProperty(ARRAY_TYPE_ID, allocator.locationForType(TypedArray.class, EnumSet.of(LocationModifier.NonNull)));
        ARRAY_BUFFER_PROPERTY = JSObjectUtil.makeHiddenProperty(ARRAY_BUFFER_ID, allocator.locationForType(JSObject.CLASS, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        ARRAY_LENGTH_PROPERTY = JSObjectUtil.makeHiddenProperty(LENGTH_ID, allocator.locationForType(Integer.TYPE));
        ARRAY_OFFSET_PROPERTY = JSObjectUtil.makeHiddenProperty(OFFSET_ID, allocator.locationForType(Integer.TYPE));
        ARRAY_SHAREABLE = JSObjectUtil.makeHiddenProperty(SHAREABLE_ID, allocator.locationForType(Boolean.TYPE));
    }

    public static class DefaultJSArrayBufferViewComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object first, Object second) {
            return ((Comparable)first).compareTo(second);
        }
    }

    private static abstract class ArrayBufferViewGetter
    extends Node {
        private ArrayBufferViewGetter() {
        }

        public abstract Object apply(DynamicObject var1, boolean var2);
    }
}

