/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.SparseArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantEmptyArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class AbstractWritableArray
extends DynamicArray {
    protected static final SetSupportedProfileAccess SET_SUPPORTED_PROFILE_ACCESS = new SetSupportedProfileAccess(){};

    protected static final void setArrayProperties(DynamicObject object, Object array, long length, int usedLength, long indexOffset, int arrayOffset) {
        JSAbstractArray.arraySetArray(object, array);
        JSAbstractArray.arraySetLength(object, length);
        JSAbstractArray.arraySetUsedLength(object, usedLength);
        JSAbstractArray.arraySetIndexOffset(object, indexOffset);
        JSAbstractArray.arraySetArrayOffset(object, arrayOffset);
    }

    protected AbstractWritableArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    abstract AbstractWritableArray sameTypeHolesArray(DynamicObject var1, int var2, Object var3, long var4, int var6, int var7, int var8);

    abstract void fillWithHoles(Object var1, int var2, int var3);

    @Override
    public final boolean isInBoundsFast(DynamicObject object, long index, boolean condition) {
        return this.firstElementIndex(object, condition) <= index && index <= this.lastElementIndex(object, condition);
    }

    protected abstract int prepareInBoundsFast(DynamicObject var1, long var2, boolean var4);

    public final boolean isInBounds(DynamicObject object, int index) {
        return this.isInBounds(object, index, AbstractWritableArray.arrayCondition());
    }

    public final boolean isInBounds(DynamicObject object, int index, boolean condition) {
        return this.isSupported(object, index, condition) && this.rangeCheck(object, index, condition);
    }

    protected abstract int prepareInBounds(DynamicObject var1, int var2, boolean var3, ScriptArray.ProfileHolder var4);

    protected static void prepareInBoundsZeroBased(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        int usedLength;
        long length = JSAbstractArray.arrayGetLength(object, condition);
        if (SET_SUPPORTED_PROFILE_ACCESS.inBoundsZeroBasedSetLength(profile, (long)index >= length)) {
            JSAbstractArray.arraySetLength(object, length + 1L);
        }
        if (SET_SUPPORTED_PROFILE_ACCESS.inBoundsZeroBasedSetUsedLength(profile, index >= (usedLength = AbstractWritableArray.getUsedLength(object, condition)))) {
            JSAbstractArray.arraySetUsedLength(object, usedLength + 1);
        }
    }

    Object getArrayObject(DynamicObject object) {
        return JSAbstractArray.arrayGetArray(object, AbstractWritableArray.arrayCondition());
    }

    abstract int getArrayLength(Object var1);

    protected static int getUsedLength(DynamicObject object) {
        return JSAbstractArray.arrayGetUsedLength(object);
    }

    protected static int getUsedLength(DynamicObject object, boolean condition) {
        return JSAbstractArray.arrayGetUsedLength(object, condition);
    }

    protected final int prepareInBoundsContiguous(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        int internalIndex = this.ensureCapacityContiguous(object, this.prepareInBoundsFast(object, index, condition), condition, profile);
        this.updateContiguousState(object, internalIndex, condition, profile);
        return internalIndex;
    }

    protected final int prepareInBoundsHoles(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        int internalIndex = this.prepareInBoundsFast(object, index, condition);
        this.fillHoles(object, internalIndex, this.updateHolesState(object, internalIndex, condition, profile), profile);
        return internalIndex;
    }

    private boolean rangeCheck(DynamicObject object, int index, boolean condition) {
        int internalIndex = this.prepareInBoundsFast(object, index, condition);
        return internalIndex >= 0 && internalIndex < this.getArrayCapacity(object, condition);
    }

    public boolean containsHoles(DynamicObject object, long index, boolean condition) {
        return false;
    }

    public abstract boolean isSupported(DynamicObject var1, long var2, boolean var4);

    public static boolean isSupportedZeroBased(DynamicObject object, int index, boolean condition) {
        return index >= 0 && index <= AbstractWritableArray.getUsedLength(object, condition);
    }

    public final boolean isSupportedContiguous(DynamicObject object, long index, boolean condition) {
        return index >= this.firstElementIndex(object, condition) - 1L && index <= this.lastElementIndex(object, condition) + 1L;
    }

    public final boolean isSupportedHoles(DynamicObject object, long index, boolean condition) {
        return index >= this.firstElementIndex(object, condition) - (long)JSTruffleOptions.MaxArrayHoleSize && index <= this.lastElementIndex(object, condition) + (long)JSTruffleOptions.MaxArrayHoleSize;
    }

    protected abstract int prepareSupported(DynamicObject var1, int var2, boolean var3, ScriptArray.ProfileHolder var4);

    protected final void prepareSupportedZeroBased(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        this.ensureCapacity(object, index, 0L, condition, profile);
        AbstractWritableArray.prepareInBoundsZeroBased(object, index, condition, profile);
    }

    protected final int prepareSupportedContiguous(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        int internalIndex = this.ensureCapacityContiguous(object, this.prepareInBoundsFast(object, index, condition), condition, profile);
        this.updateContiguousState(object, internalIndex, condition, profile);
        return internalIndex;
    }

    protected final int prepareSupportedHoles(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        int internalIndex = this.prepareInBoundsFast(object, index, condition);
        internalIndex = this.ensureCapacityContiguous(object, internalIndex, condition, profile);
        this.fillHoles(object, internalIndex, this.updateHolesState(object, internalIndex, condition, profile), profile);
        return internalIndex;
    }

    protected void incrementHolesCount(DynamicObject object, int offset) {
        throw Errors.shouldNotReachHere();
    }

    protected abstract void setHoleValue(DynamicObject var1, int var2);

    protected abstract int getArrayCapacity(DynamicObject var1, boolean var2);

    protected int getArrayOffset(DynamicObject object) {
        return 0;
    }

    protected int getArrayOffset(DynamicObject object, boolean condition) {
        return 0;
    }

    protected void setArrayOffset(DynamicObject object, int value) {
        throw Errors.shouldNotReachHere();
    }

    protected long getIndexOffset(DynamicObject object) {
        throw Errors.shouldNotReachHere();
    }

    protected long getIndexOffset(DynamicObject object, boolean condition) {
        throw Errors.shouldNotReachHere();
    }

    protected void setIndexOffset(DynamicObject object, long value) {
        throw Errors.shouldNotReachHere();
    }

    private int ensureCapacity(DynamicObject object, int internalIndex, long indexOffset, boolean condition, ScriptArray.ProfileHolder profile) {
        assert (-indexOffset <= (long)internalIndex);
        int capacity = this.getArrayCapacity(object, condition);
        if (SET_SUPPORTED_PROFILE_ACCESS.ensureCapacityGrow(profile, internalIndex >= 0 && internalIndex < capacity)) {
            return 0;
        }
        long minCapacity = SET_SUPPORTED_PROFILE_ACCESS.ensureCapacityGrowLeft(profile, internalIndex < 0) ? (long)(-internalIndex) + (long)capacity : (long)internalIndex + 1L;
        long newCapacity = minCapacity << 1;
        if (newCapacity > 0x7FFFFFF7L) {
            if (0x7FFFFFF7L < minCapacity) {
                CompilerDirectives.transferToInterpreter();
                throw new OutOfMemoryError();
            }
            newCapacity = 0x7FFFFFF7L;
        }
        int offset = 0;
        if (internalIndex < 0 && indexOffset < (long)(offset = (int)newCapacity - capacity)) {
            offset = (int)indexOffset;
        }
        this.resizeArray(object, (int)newCapacity, capacity, offset, condition);
        return offset;
    }

    private int ensureCapacityContiguous(DynamicObject object, int internalIndex, boolean condition, ScriptArray.ProfileHolder profile) {
        int offset = this.ensureCapacity(object, internalIndex, this.getIndexOffset(object, condition), condition, profile);
        if (offset != 0) {
            this.setIndexOffset(object, this.getIndexOffset(object, condition) - (long)offset);
            this.setArrayOffset(object, this.getArrayOffset(object, condition) + offset);
        }
        return internalIndex + offset;
    }

    private void updateContiguousState(DynamicObject object, int internalIndex, boolean condition, ScriptArray.ProfileHolder profile) {
        int offset = this.getArrayOffset(object, condition);
        int used = AbstractWritableArray.getUsedLength(object, condition);
        if (SET_SUPPORTED_PROFILE_ACCESS.updateStatePrepend(profile, internalIndex < offset)) {
            JSAbstractArray.arraySetUsedLength(object, used + 1);
            this.setArrayOffset(object, offset - 1);
        } else if (SET_SUPPORTED_PROFILE_ACCESS.updateStateAppend(profile, internalIndex >= offset + used)) {
            JSAbstractArray.arraySetUsedLength(object, used + 1);
            long length = JSAbstractArray.arrayGetLength(object, condition);
            long calcLength = this.getIndexOffset(object, condition) + (long)offset + (long)used + 1L;
            if (SET_SUPPORTED_PROFILE_ACCESS.updateStateSetLength(profile, calcLength > length)) {
                JSAbstractArray.arraySetLength(object, calcLength);
            }
        }
    }

    private int updateHolesState(DynamicObject object, int internalIndex, boolean condition, ScriptArray.ProfileHolder profile) {
        int size;
        int offset = this.getArrayOffset(object, condition);
        int used = AbstractWritableArray.getUsedLength(object, condition);
        if (SET_SUPPORTED_PROFILE_ACCESS.updateStatePrepend(profile, internalIndex < offset)) {
            size = -(offset - internalIndex);
        } else if (SET_SUPPORTED_PROFILE_ACCESS.updateStateAppend(profile, internalIndex >= offset + used)) {
            if (used == 0) {
                offset = internalIndex;
            }
            size = internalIndex - (offset + used) + 1;
        } else {
            if (SET_SUPPORTED_PROFILE_ACCESS.updateHolesStateIsHole(profile, this.isHolePrepared(object, internalIndex, condition))) {
                this.incrementHolesCount(object, -1);
            }
            return 0;
        }
        if (size < 0) {
            used -= size;
            offset += size;
        } else {
            long length = JSAbstractArray.arrayGetLength(object, condition);
            long calcLength = this.getIndexOffset(object, condition) + (long)offset + (long)(used += size);
            if (SET_SUPPORTED_PROFILE_ACCESS.updateStateSetLength(profile, calcLength > length)) {
                JSAbstractArray.arraySetLength(object, calcLength);
            }
        }
        JSAbstractArray.arraySetUsedLength(object, used);
        this.setArrayOffset(object, offset);
        return size;
    }

    protected void fillHoles(DynamicObject object, int internalIndex, int grown, ScriptArray.ProfileHolder profile) {
        int end;
        int start;
        if (SET_SUPPORTED_PROFILE_ACCESS.fillHolesRight(profile, grown > 1)) {
            start = internalIndex - grown + 1;
            end = internalIndex;
        } else if (SET_SUPPORTED_PROFILE_ACCESS.fillHolesLeft(profile, grown < -1)) {
            start = internalIndex + 1;
            end = internalIndex - grown;
        } else {
            return;
        }
        this.incrementHolesCount(object, end - start);
        for (int i = start; i < end; ++i) {
            this.setHoleValue(object, i);
        }
    }

    public abstract AbstractWritableArray toDouble(DynamicObject var1, long var2, double var4, boolean var6);

    public abstract AbstractWritableArray toObject(DynamicObject var1, long var2, Object var4, boolean var5);

    public AbstractWritableArray toContiguous(DynamicObject object, long index, Object value, boolean condition) {
        return this;
    }

    public abstract AbstractWritableArray toHoles(DynamicObject var1, long var2, Object var4, boolean var5);

    public AbstractWritableArray toNonHoles(DynamicObject object, long index, Object value, boolean condition) {
        assert (!this.isHolesType());
        return this;
    }

    public final SparseArray toSparse(DynamicObject object, long index, Object value) {
        SparseArray newArray = SparseArray.makeSparseArray(object, this);
        if (JSTruffleOptions.TraceArrayTransitions) {
            AbstractWritableArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    protected abstract void resizeArray(DynamicObject var1, int var2, int var3, int var4, boolean var5);

    public final boolean isSparse(DynamicObject object, long index, boolean condition) {
        return !this.isSupportedHoles(object, index, condition);
    }

    @Override
    public boolean hasElement(DynamicObject object, long index, boolean condition) {
        return this.isInBoundsFast(object, index, condition);
    }

    @Override
    public long nextElementIndex(DynamicObject object, long index, boolean condition) {
        long firstI = this.firstElementIndex(object, condition);
        if (index < firstI) {
            return firstI;
        }
        long lastI = this.lastElementIndex(object, condition);
        if (index + 1L > lastI) {
            return JSRuntime.MAX_SAFE_INTEGER_LONG;
        }
        return index + 1L;
    }

    protected abstract boolean isHolePrepared(DynamicObject var1, int var2, boolean var3);

    protected final long nextElementIndexHoles(DynamicObject object, long index0, boolean condition) {
        long index = index0;
        long firstIdx = this.firstElementIndex(object, condition);
        if (index0 < firstIdx) {
            return firstIdx;
        }
        long lastI = this.lastElementIndex(object, condition);
        do {
            if (++index <= lastI) continue;
            return JSRuntime.MAX_SAFE_INTEGER_LONG;
        } while (this.isHolePrepared(object, this.prepareInBoundsFast(object, index, condition), condition));
        return index;
    }

    protected final long nextElementIndexZeroBased(DynamicObject object, long index, boolean condition) {
        assert (index >= -1L);
        long lastI = this.lastElementIndex(object, condition);
        if (index + 1L > lastI) {
            return JSRuntime.MAX_SAFE_INTEGER_LONG;
        }
        return index + 1L;
    }

    @Override
    public long previousElementIndex(DynamicObject object, long index, boolean condition) {
        long lastIdx = this.lastElementIndex(object, condition);
        if (index > lastIdx) {
            return lastIdx;
        }
        if (index - 1L < this.firstElementIndex(object, condition)) {
            return -1L;
        }
        return index - 1L;
    }

    protected final long previousElementIndexHoles(DynamicObject object, long index0, boolean condition) {
        long index = index0;
        long lastIdx = this.lastElementIndex(object, condition);
        if (index0 > lastIdx) {
            return lastIdx;
        }
        long firstIdx = this.firstElementIndex(object, condition);
        while (--index >= firstIdx && this.isHolePrepared(object, this.prepareInBoundsFast(object, index, condition), condition)) {
        }
        if (index < firstIdx) {
            return -1L;
        }
        return index;
    }

    @Override
    public final long length(DynamicObject object, boolean condition) {
        return JSAbstractArray.arrayGetLength(object, condition);
    }

    @Override
    public final int lengthInt(DynamicObject object, boolean condition) {
        return (int)this.length(object, condition);
    }

    @Override
    public final ScriptArray setLengthImpl(DynamicObject object, long length, boolean condition, ScriptArray.ProfileHolder profile) {
        if (SET_LENGTH_PROFILE.lengthZero(profile, length == 0L)) {
            JSAbstractArray.arraySetLength(object, length);
            return ConstantEmptyArray.createConstantEmptyArray();
        }
        if (SET_LENGTH_PROFILE.lengthLess(profile, length < this.length(object, condition))) {
            this.setLengthLess(object, length, condition, profile);
        } else {
            JSAbstractArray.arraySetLength(object, length);
        }
        return this;
    }

    protected abstract void setLengthLess(DynamicObject var1, long var2, boolean var4, ScriptArray.ProfileHolder var5);

    protected void setLengthLessZeroBased(DynamicObject object, long length, boolean condition, ScriptArray.ProfileHolder profile) {
        long oldLength = JSAbstractArray.arrayGetLength(object, condition);
        JSAbstractArray.arraySetLength(object, length);
        if (SET_LENGTH_PROFILE.zeroBasedSetUsedLength(profile, (long)AbstractWritableArray.getUsedLength(object, condition) > length)) {
            JSAbstractArray.arraySetUsedLength(object, (int)length);
        }
        if (SET_LENGTH_PROFILE.zeroBasedClearUnusedArea(profile, length < oldLength)) {
            this.clearUnusedArea(object, (int)length, (int)oldLength, 0, profile);
        }
    }

    protected final void setLengthLessContiguous(DynamicObject object, long length, boolean condition, ScriptArray.ProfileHolder profile) {
        long indexOffset = this.getIndexOffset(object, condition);
        int arrayOffset = this.getArrayOffset(object, condition);
        JSAbstractArray.arraySetLength(object, length);
        if (SET_LENGTH_PROFILE.contiguousZeroUsed(profile, length <= indexOffset)) {
            JSAbstractArray.arraySetUsedLength(object, 0);
            this.setIndexOffset(object, length - 1L);
            this.setArrayOffset(object, 0);
            long arrayCapacity = this.getArrayCapacity(object, condition);
            this.clearUnusedArea(object, 0, (int)arrayCapacity, 0, profile);
        } else {
            int oldUsed = AbstractWritableArray.getUsedLength(object, condition);
            int newUsed = Math.min(oldUsed, (int)(length - indexOffset - (long)arrayOffset));
            int newUsedLength = (int)(this.previousElementIndex(object, indexOffset + (long)arrayOffset + (long)newUsed) + 1L - (long)arrayOffset - indexOffset);
            if (SET_LENGTH_PROFILE.contiguousNegativeUsed(profile, newUsedLength < 0)) {
                newUsedLength = 0;
                this.setArrayOffset(object, 0);
                this.setIndexOffset(object, 0L);
            }
            JSAbstractArray.arraySetUsedLength(object, newUsedLength);
            if (SET_LENGTH_PROFILE.contiguousShrinkUsed(profile, newUsedLength < oldUsed)) {
                if (this.isHolesType()) {
                    this.incrementHolesCount(object, -this.countHolesPrepared(object, arrayOffset + newUsedLength, arrayOffset + oldUsed, condition));
                    assert (JSAbstractArray.arrayGetHoleCount(object, condition) == this.countHoles(object));
                }
                this.clearUnusedArea(object, newUsedLength, oldUsed, arrayOffset, profile);
            }
        }
    }

    protected void clearUnusedArea(DynamicObject object, int startIdx, int endIdx, int arrayOffset, ScriptArray.ProfileHolder profile) {
        int arrayCapacity = this.getArrayCapacity(object, AbstractWritableArray.arrayCondition());
        if (SET_LENGTH_PROFILE.clearUnusedArea(profile, startIdx < -1 || startIdx + arrayOffset >= arrayCapacity)) {
            return;
        }
        int start = startIdx + arrayOffset;
        int end = Math.min(endIdx + arrayOffset, arrayCapacity - 1);
        for (int i = start; i <= end; ++i) {
            this.setHoleValue(object, i);
        }
    }

    @Override
    public final Object getElement(DynamicObject object, long index, boolean condition) {
        if (this.isInBoundsFast(object, index, condition)) {
            return this.getInBoundsFast(object, (int)index, condition);
        }
        return Undefined.instance;
    }

    @Override
    public final Object getElementInBounds(DynamicObject object, long index, boolean condition) {
        assert (this.isInBoundsFast(object, index, condition));
        return this.getInBoundsFast(object, (int)index, condition);
    }

    protected final Object getInBoundsFast(DynamicObject object, int index) {
        return this.getInBoundsFast(object, index, AbstractWritableArray.arrayCondition());
    }

    public abstract Object getInBoundsFast(DynamicObject var1, int var2, boolean var3);

    public int getInBoundsFastInt(DynamicObject object, int index, boolean condition) throws UnexpectedResultException {
        Object value = this.getInBoundsFast(object, index, condition);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    public double getInBoundsFastDouble(DynamicObject object, int index, boolean condition) throws UnexpectedResultException {
        Object value = this.getInBoundsFast(object, index, condition);
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new UnexpectedResultException(value);
    }

    @Override
    public Object[] toArray(DynamicObject object) {
        long len = this.length(object);
        assert (JSRuntime.longIsRepresentableAsInt(len));
        Object[] objectArray = new Object[(int)len];
        long firstElement = this.firstElementIndex(object);
        long lastElement = this.lastElementIndex(object);
        int i = 0;
        while ((long)i < len) {
            objectArray[i] = (long)i >= firstElement && (long)i <= lastElement ? this.getInBoundsFast(object, i) : Undefined.instance;
            ++i;
        }
        return objectArray;
    }

    protected final Object[] toArrayZeroBased(DynamicObject object) {
        int newLength = AbstractWritableArray.getUsedLength(object);
        Object[] newArray = new Object[newLength];
        for (int i = 0; i < newLength; ++i) {
            newArray[i] = this.getInBoundsFast(object, i);
        }
        return newArray;
    }

    protected final ScriptArray deleteElementHoles(DynamicObject object, long index, boolean condition) {
        int preparedindex;
        if (this.isInBoundsFast(object, index, condition) && !this.isHolePrepared(object, preparedindex = this.prepareInBoundsFast(object, (int)index, condition), condition)) {
            int arrayOffset = this.getArrayOffset(object, condition);
            if (arrayOffset == preparedindex) {
                long nextNonHoles = this.nextElementIndexHoles(object, index, condition);
                if (nextNonHoles == JSRuntime.MAX_SAFE_INTEGER_LONG) {
                    this.setArrayOffset(object, 0);
                    JSAbstractArray.arraySetUsedLength(object, 0);
                    JSAbstractArray.arraySetHoleCount(object, 0);
                } else {
                    int preparedNextNonHoles = this.prepareInBoundsFast(object, (int)nextNonHoles, condition);
                    int delta = preparedNextNonHoles - preparedindex;
                    this.setArrayOffset(object, preparedindex + delta);
                    JSAbstractArray.arraySetUsedLength(object, JSAbstractArray.arrayGetUsedLength(object, condition) - delta);
                    this.incrementHolesCount(object, -this.countHolesPrepared(object, preparedindex, preparedNextNonHoles, condition));
                }
                this.setHoleValue(object, preparedindex);
            } else if (arrayOffset + JSAbstractArray.arrayGetUsedLength(object, condition) == preparedindex) {
                long previousNonHoles = this.previousElementIndexHoles(object, index, condition);
                assert (previousNonHoles >= 0L);
                int preparedPreviousNonHoles = this.prepareInBoundsFast(object, (int)previousNonHoles, condition);
                JSAbstractArray.arraySetUsedLength(object, JSAbstractArray.arrayGetUsedLength(object, condition) - preparedindex + preparedPreviousNonHoles);
                this.incrementHolesCount(object, -this.countHolesPrepared(object, preparedPreviousNonHoles, preparedindex, condition));
                this.setHoleValue(object, preparedindex);
            } else {
                this.incrementHolesCount(object, 1);
                this.setHoleValue(object, preparedindex);
            }
        }
        assert (JSAbstractArray.arrayGetHoleCount(object, condition) == this.countHoles(object));
        return this;
    }

    @CompilerDirectives.TruffleBoundary
    protected final void traceWriteValue(String access, int index, Object value) {
        AbstractWritableArray.traceWrite(this.getClass().getSimpleName() + "." + access, index, value);
    }

    public ScriptArray toNonContiguous(DynamicObject object, int index, Object value, boolean condition, ScriptArray.ProfileHolder profile) {
        return this;
    }

    @Override
    protected abstract AbstractWritableArray withIntegrityLevel(int var1);

    public abstract Object allocateArray(int var1);

    protected static <T> T arrayCast(Object value, Class<T> arrayClass, boolean condition) {
        return (T)value;
    }

    ScriptArray addRangeImplContiguous(DynamicObject object, long offset, int size) {
        int arrayLength;
        int arrayOffset;
        long indexOffset = this.getIndexOffset(object);
        if (offset <= indexOffset + (long)(arrayOffset = this.getArrayOffset(object))) {
            this.setIndexOffset(object, indexOffset + (long)size);
            return this;
        }
        Object array = this.getArrayObject(object);
        int usedLength = AbstractWritableArray.getUsedLength(object);
        if (arrayOffset + usedLength + size < (arrayLength = this.getArrayLength(array))) {
            int lastIndex = arrayOffset + usedLength;
            int effectiveOffset = (int)(offset - indexOffset);
            int copySize = lastIndex - effectiveOffset;
            if (copySize > 0) {
                System.arraycopy(array, effectiveOffset, array, effectiveOffset + size, copySize);
            }
            JSAbstractArray.arraySetUsedLength(object, usedLength + size);
            return this;
        }
        return this.addRangeGrow(object, array, arrayLength, usedLength, this.lengthInt(object), (int)(offset - indexOffset), size, arrayOffset, indexOffset);
    }

    private ScriptArray addRangeGrow(DynamicObject object, Object array, int arrayLength, int usedLength, int length, int offset, int size, int arrayOffset, long indexOffset) {
        Object newArray = this.allocateArray(AbstractWritableArray.nextPower(arrayLength + size));
        if (offset - arrayOffset > arrayLength) {
            System.arraycopy(array, arrayOffset, newArray, arrayOffset, arrayLength);
            this.fillWithHoles(newArray, usedLength, usedLength + size);
            return this.ensureHolesArray(object, length + size, newArray, indexOffset, arrayOffset, usedLength + size, JSAbstractArray.arrayGetHoleCount(object) + size);
        }
        System.arraycopy(array, arrayOffset, newArray, arrayOffset, offset - arrayOffset);
        int toCopy = arrayOffset + usedLength - offset;
        System.arraycopy(array, offset, newArray, offset + size, toCopy);
        JSAbstractArray.arraySetLength(object, length + size);
        JSAbstractArray.arraySetArray(object, newArray);
        JSAbstractArray.arraySetUsedLength(object, usedLength + size);
        return this;
    }

    private ScriptArray ensureHolesArray(DynamicObject object, int length, Object newArray, long indexOffset, int arrayOffset, int usedLength, int holesCount) {
        AbstractWritableArray newArrayObject = this.sameTypeHolesArray(object, length, newArray, indexOffset, arrayOffset, usedLength, holesCount);
        if (newArrayObject != this && JSTruffleOptions.TraceArrayTransitions) {
            AbstractWritableArray.traceArrayTransition(this, newArrayObject, 0L, null);
        }
        return newArrayObject;
    }

    ScriptArray addRangeImplZeroBased(DynamicObject object, long offset, int size) {
        int iOffset = (int)offset;
        Object array = this.getArrayObject(object);
        int arrayLength = this.getArrayLength(array);
        int length = this.lengthInt(object, AbstractWritableArray.arrayCondition());
        int usedLength = AbstractWritableArray.getUsedLength(object);
        if ((long)usedLength < offset) {
            JSAbstractArray.arraySetLength(object, length + size);
            return this;
        }
        if (size + usedLength <= arrayLength) {
            int toCopy = usedLength - iOffset;
            System.arraycopy(array, iOffset, array, iOffset + size, toCopy);
            JSAbstractArray.arraySetUsedLength(object, usedLength + size);
            return this;
        }
        return this.addRangeGrow(object, array, arrayLength, usedLength, arrayLength, iOffset, size, 0, 0L);
    }

    protected final ScriptArray removeRangeContiguous(DynamicObject object, long start, long end) {
        assert (start >= 0L && start <= end);
        int usedLength = AbstractWritableArray.getUsedLength(object);
        long indexOffset = this.getIndexOffset(object);
        int arrayOffset = this.getArrayOffset(object);
        int startIntl = (int)(start - indexOffset);
        int endIntl = (int)(end - indexOffset);
        int usedStartIntl = Math.max(arrayOffset, startIntl);
        int usedEndIntl = Math.min(arrayOffset + usedLength, endIntl);
        int usedDelta = usedEndIntl - usedStartIntl;
        int newUsedLength = usedLength - usedDelta;
        if (usedDelta > 0) {
            JSAbstractArray.arraySetUsedLength(object, newUsedLength);
            if (newUsedLength == 0) {
                this.setArrayOffset(object, 0);
                this.setIndexOffset(object, 0L);
                return this;
            }
        }
        if (startIntl < 0) {
            int indexOffsetDelta = endIntl - startIntl;
            long indexOffsetNew = Math.max(0L, indexOffset - (long)indexOffsetDelta);
            if (endIntl > 0) {
                int length = usedLength + arrayOffset - endIntl;
                if (length > 0) {
                    this.moveRangePrepared(object, endIntl, 0, length);
                }
                indexOffsetNew = start;
            }
            this.setIndexOffset(object, indexOffsetNew);
        } else {
            int length;
            if (startIntl < arrayOffset) {
                int arrayOffsetNew = Math.max(startIntl, arrayOffset - (endIntl - startIntl));
                this.setArrayOffset(object, arrayOffsetNew);
            }
            if ((length = usedLength + arrayOffset - endIntl) > 0) {
                this.moveRangePrepared(object, endIntl, startIntl, length);
            }
        }
        return this;
    }

    protected final ScriptArray removeRangeHoles(DynamicObject object, long start, long end) {
        assert (this.isHolesType());
        assert (start >= 0L && start <= end);
        int usedLength = AbstractWritableArray.getUsedLength(object);
        long indexOffset = this.getIndexOffset(object);
        int arrayOffset = this.getArrayOffset(object);
        int startIntl = (int)(start - indexOffset);
        int endIntl = (int)(end - indexOffset);
        if (endIntl > 0) {
            int actualStartIntl = Math.max(arrayOffset, startIntl);
            int actualEndIntl = Math.min(arrayOffset + usedLength, endIntl);
            for (int i = actualStartIntl; i < actualEndIntl; ++i) {
                if (!this.isHolePrepared(object, i, AbstractWritableArray.arrayCondition())) continue;
                this.incrementHolesCount(object, -1);
            }
        }
        this.removeRangeContiguous(object, start, end);
        return this;
    }

    protected final int countHoles(DynamicObject object) {
        assert (this.isHolesType());
        int arrayOffset = this.getArrayOffset(object);
        return this.countHolesPrepared(object, arrayOffset, arrayOffset + AbstractWritableArray.getUsedLength(object), AbstractWritableArray.arrayCondition());
    }

    private int countHolesPrepared(DynamicObject object, int start, int end, boolean condition) {
        assert (this.isHolesType());
        int holeCount = 0;
        for (int index = start; index < end; ++index) {
            if (!this.isHolePrepared(object, index, condition)) continue;
            ++holeCount;
        }
        return holeCount;
    }

    protected abstract void moveRangePrepared(DynamicObject var1, int var2, int var3, int var4);

    public static ScriptArray.ProfileHolder createSetSupportedProfile() {
        return ScriptArray.ProfileHolder.create(10, SetSupportedProfileAccess.class);
    }

    protected static interface SetSupportedProfileAccess
    extends ScriptArray.ProfileAccess {
        default public boolean ensureCapacityGrow(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 0, condition);
        }

        default public boolean ensureCapacityGrowLeft(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 1, condition);
        }

        default public boolean inBoundsZeroBasedSetLength(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 2, condition);
        }

        default public boolean inBoundsZeroBasedSetUsedLength(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 3, condition);
        }

        default public boolean updateStatePrepend(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 4, condition);
        }

        default public boolean updateStateAppend(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 5, condition);
        }

        default public boolean updateStateSetLength(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 6, condition);
        }

        default public boolean updateHolesStateIsHole(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 7, condition);
        }

        default public boolean fillHolesLeft(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 8, condition);
        }

        default public boolean fillHolesRight(ScriptArray.ProfileHolder profile, boolean condition) {
            return profile.profile(this, 9, condition);
        }
    }
}

