/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropCallNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNodeGen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSInteropExecuteNode.class)
public final class JSInteropExecuteNodeGen
extends JSInteropExecuteNode
implements Introspection.Provider {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private DefaultData default_cache;

    private JSInteropExecuteNodeGen() {
    }

    @Override
    public Object execute(DynamicObject arg0Value, Object arg1Value, Object[] arg2Value) throws UnsupportedMessageException {
        DefaultData s1_;
        int state = this.state_;
        if (state != 0 && (s1_ = this.default_cache) != null) {
            return this.doDefault(arg0Value, arg1Value, arg2Value, s1_.isCallableNode_, s1_.callNode_, s1_.importValueNode_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(DynamicObject arg0Value, Object arg1Value, Object[] arg2Value) throws UnsupportedMessageException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            DefaultData s1_ = (DefaultData)super.insert((Node)new DefaultData());
            s1_.isCallableNode_ = s1_.insertAccessor(IsCallableNode.create());
            s1_.callNode_ = s1_.insertAccessor(JSFunctionCallNode.createCall());
            s1_.importValueNode_ = s1_.insertAccessor(JSForeignToJSTypeNode.create());
            this.default_cache = s1_;
            this.state_ = state |= 1;
            lock.unlock();
            hasLock = false;
            Object object = this.doDefault(arg0Value, arg1Value, arg2Value, s1_.isCallableNode_, s1_.callNode_, s1_.importValueNode_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[2];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doDefault";
        if (state != 0) {
            s[1] = (byte)1;
            ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
            DefaultData s1_ = this.default_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{s1_.isCallableNode_, s1_.callNode_, s1_.importValueNode_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSInteropExecuteNode create() {
        return new JSInteropExecuteNodeGen();
    }

    public static JSInteropExecuteNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=JSInteropExecuteNode.class)
    private static final class Uncached
    extends JSInteropExecuteNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(DynamicObject arg0Value, Object arg1Value, Object[] arg2Value) throws UnsupportedMessageException {
            return this.doDefault(arg0Value, arg1Value, arg2Value, IsCallableNodeGen.getUncached(), JSInteropCallNode.getUncachedCall(), JSForeignToJSTypeNodeGen.getUncached());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=JSInteropExecuteNode.class)
    private static final class DefaultData
    extends Node {
        @Node.Child
        IsCallableNode isCallableNode_;
        @Node.Child
        JSFunctionCallNode callNode_;
        @Node.Child
        JSForeignToJSTypeNode importValueNode_;

        DefaultData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

