/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.AbstractFunctionArgumentsNode;
import com.oracle.truffle.js.nodes.function.JSFunctionArgumentsNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.function.JSNewNodeGen;
import com.oracle.truffle.js.nodes.instrumentation.JSInputGeneratingNodeWrapper;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.java.JavaAccess;
import com.oracle.truffle.js.runtime.java.JavaPackage;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.JSInteropUtil;
import java.lang.reflect.Modifier;
import java.util.Set;

@ImportStatic(value={JSProxy.class})
@ReportPolymorphism
public abstract class JSNewNode
extends JavaScriptNode {
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    private JSFunctionCallNode callNew;
    @Node.Child
    private JSFunctionCallNode callNewTarget;
    @Node.Child
    private AbstractFunctionArgumentsNode arguments;
    protected final JSContext context;

    protected JSNewNode(JSContext context, JavaScriptNode targetNode, AbstractFunctionArgumentsNode arguments) {
        this.context = context;
        this.targetNode = targetNode;
        this.arguments = arguments;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ObjectAllocationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        NodeObjectDescriptor descriptor = JSTags.createNodeObjectDescriptor();
        descriptor.addProperty("isNew", true);
        descriptor.addProperty("isInvoke", false);
        return descriptor;
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (this.materializationNeeded(materializedTags)) {
            JavaScriptNode newTarget = JSInputGeneratingNodeWrapper.create(this.getTarget());
            JSNewNode materialized = JSNewNodeGen.create(this.context, newTarget, this.arguments);
            this.arguments.materializeInstrumentableArguments();
            JSNewNode.transferSourceSectionAndTags(this, materialized);
            return materialized;
        }
        return this;
    }

    private boolean materializationNeeded(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.ObjectAllocationTag.class)) {
            return !this.getTarget().hasSourceSection() && !(this.getTarget() instanceof JSInputGeneratingNodeWrapper);
        }
        return false;
    }

    public static JSNewNode create(JSContext context, JavaScriptNode function, JavaScriptNode[] arguments) {
        return JSNewNodeGen.create(context, function, JSFunctionArgumentsNode.create(context, arguments));
    }

    public JavaScriptNode getTarget() {
        return this.targetNode;
    }

    @Specialization(guards={"isJSFunction(target)"})
    public Object doNewReturnThis(VirtualFrame frame, DynamicObject target) {
        int userArgumentCount = this.arguments.getCount(frame);
        Object[] args = JSArguments.createInitial(JSFunction.CONSTRUCT, target, userArgumentCount);
        args = this.arguments.executeFillObjectArray(frame, args, 2);
        return this.getCallNew().executeCall(args);
    }

    @Specialization(guards={"isJSAdapter(target)"})
    public Object doJSAdapter(VirtualFrame frame, DynamicObject target) {
        Object newFunction = JSObject.get(JSAdapter.getAdaptee(target), (Object)"__new__");
        if (JSFunction.isJSFunction(newFunction)) {
            Object[] args = this.getAbstractFunctionArguments(frame);
            return JSFunction.call((DynamicObject)newFunction, target, args);
        }
        return Undefined.instance;
    }

    @Specialization(guards={"isProxy(proxy)"})
    protected Object doNewJSProxy(VirtualFrame frame, DynamicObject proxy) {
        if (!JSRuntime.isConstructorProxy(proxy)) {
            throw Errors.createTypeErrorNotAFunction(proxy, this);
        }
        DynamicObject handler = JSProxy.getHandlerChecked(proxy);
        TruffleObject target = JSProxy.getTarget(proxy);
        TruffleObject trap = JSProxy.getTrapFromObject(handler, "construct");
        if (trap == Undefined.instance) {
            if (JSObject.isJSObject(target)) {
                int userArgumentCount = this.arguments.getCount(frame);
                Object[] args = JSArguments.createInitialWithNewTarget(JSFunction.CONSTRUCT, target, proxy, userArgumentCount);
                args = this.arguments.executeFillObjectArray(frame, args, 3);
                return this.getCallNewTarget().executeCall(args);
            }
            return JSInteropUtil.construct(target, this.getAbstractFunctionArguments(frame));
        }
        Object[] args = this.getAbstractFunctionArguments(frame);
        Object[] trapArgs = new Object[]{target, JSArray.createConstantObjectArray(this.context, args), proxy};
        Object result = JSRuntime.call(trap, handler, trapArgs);
        if (!JSRuntime.isObject(result)) {
            throw Errors.createTypeErrorNotAnObject(result, this);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isJavaPackage(target)"})
    public Object createClassNotFoundError(DynamicObject target) {
        throw Errors.createTypeErrorClassNotFound(JavaPackage.getPackageName(target));
    }

    @CompilerDirectives.TruffleBoundary
    private static void throwCannotExtendError(Class<?> target) {
        throw Errors.createTypeError("new cannot be used with non-public java type " + target.getTypeName() + ".");
    }

    @Specialization(guards={"isForeignObject(target)"})
    public Object doNewForeignObject(VirtualFrame frame, TruffleObject target, @CachedLibrary(limit="5") InteropLibrary interop, @Cached(value="create()") ExportValueNode convert, @Cached(value="create()") JSForeignToJSTypeNode toJSType, @Cached(value="createBinaryProfile()") ConditionProfile isHostClassProf, @Cached(value="createBinaryProfile()") ConditionProfile isAbstractProf) {
        TruffleObject newTarget = target;
        int count = this.arguments.getCount(frame);
        Object[] args = new Object[count];
        args = this.arguments.executeFillObjectArray(frame, args, 0);
        for (int i = 0; i < args.length; ++i) {
            args[i] = convert.execute(args[i]);
        }
        if (!JSTruffleOptions.SubstrateVM && this.context.isOptionNashornCompatibilityMode()) {
            Class javaType;
            TruffleLanguage.Env env = this.context.getRealm().getEnv();
            if (isHostClassProf.profile(count == 1 && env.isHostObject((Object)target) && env.asHostObject((Object)target) instanceof Class) && isAbstractProf.profile(Modifier.isAbstract((javaType = (Class)env.asHostObject((Object)target)).getModifiers()) && !javaType.isArray())) {
                newTarget = this.extend(javaType, env);
            }
        }
        try {
            return toJSType.executeWithTarget(interop.instantiate((Object)newTarget, args));
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw Errors.createTypeErrorInteropException(target, (InteropException)e, "instantiate", this);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private TruffleObject extend(Class<?> type, TruffleLanguage.Env env) {
        assert (!JSTruffleOptions.SubstrateVM);
        if (!Modifier.isPublic(type.getModifiers())) {
            JSNewNode.throwCannotExtendError(type);
        }
        JavaAccess.checkAccess(new Class[]{type}, this.context);
        Class<?> adapterClass = this.context.getJavaAdapterClassFor(type);
        return (TruffleObject)env.asHostSymbol(adapterClass);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!isJSFunction(target)", "!isJSAdapter(target)", "!isProxy(target)", "!isJavaPackage(target)", "!isForeignObject(target)"})
    public Object createFunctionTypeError(Object target) {
        Object targetForError;
        String targetStr = this.getTarget().expressionToString();
        Object object = targetForError = targetStr == null ? target : targetStr;
        if (this.context.isOptionNashornCompatibilityMode()) {
            throw Errors.createTypeErrorNotAFunction(targetForError, this);
        }
        throw Errors.createTypeErrorNotAConstructor(targetForError, this);
    }

    private Object[] getAbstractFunctionArguments(VirtualFrame frame) {
        Object[] args = new Object[this.arguments.getCount(frame)];
        args = this.arguments.executeFillObjectArray(frame, args, 0);
        return args;
    }

    private JSFunctionCallNode getCallNewTarget() {
        if (this.callNewTarget == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callNewTarget = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createNewTarget());
        }
        return this.callNewTarget;
    }

    private JSFunctionCallNode getCallNew() {
        if (this.callNew == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callNew = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createNew());
        }
        return this.callNew;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return JSNewNodeGen.create(this.context, JSNewNode.cloneUninitialized(this.getTarget()), AbstractFunctionArgumentsNode.cloneUninitialized(this.arguments));
    }
}

