/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.nodes.function.InternalCallNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=InternalCallNode.class)
public final class InternalCallNodeGen
extends InternalCallNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private DirectCallData directCall_cache;
    @Node.Child
    private IndirectCallNode indirectCall_indirectCallNode_;

    private InternalCallNodeGen() {
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public Object execute(CallTarget arg0Value, Object[] arg1Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                DirectCallData s1_ = this.directCall_cache;
                while (s1_ != null) {
                    if (arg0Value == s1_.cachedCallTarget_) {
                        return InternalCallNode.directCall(arg0Value, arg1Value, s1_.cachedCallTarget_, s1_.directCallNode_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return InternalCallNode.indirectCall(arg0Value, arg1Value, this.indirectCall_indirectCallNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(CallTarget arg0Value, Object[] arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            int count1_ = 0;
            DirectCallData s1_ = this.directCall_cache;
            if ((state & 1) != 0) {
                while (s1_ != null && arg0Value != s1_.cachedCallTarget_) {
                    s1_ = s1_.next_;
                    ++count1_;
                }
            }
            if (s1_ == null && count1_ < 3) {
                s1_ = (DirectCallData)super.insert((Node)new DirectCallData(this.directCall_cache));
                s1_.cachedCallTarget_ = arg0Value;
                s1_.directCallNode_ = s1_.insertAccessor(DirectCallNode.create((CallTarget)s1_.cachedCallTarget_));
                this.directCall_cache = s1_;
                this.state_ = state |= 1;
            }
            if (s1_ != null) {
                lock.unlock();
                hasLock = false;
                Object object = InternalCallNode.directCall(arg0Value, arg1Value, s1_.cachedCallTarget_, s1_.directCallNode_);
                return object;
            }
            this.indirectCall_indirectCallNode_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            Object object = InternalCallNode.indirectCall(arg0Value, arg1Value, this.indirectCall_indirectCallNode_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        DirectCallData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.directCall_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "directCall";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            DirectCallData s1_ = this.directCall_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedCallTarget_, s1_.directCallNode_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "indirectCall";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.indirectCall_indirectCallNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static InternalCallNode create() {
        return new InternalCallNodeGen();
    }

    @GeneratedBy(value=InternalCallNode.class)
    private static final class DirectCallData
    extends Node {
        @Node.Child
        DirectCallData next_;
        @CompilerDirectives.CompilationFinal
        CallTarget cachedCallTarget_;
        @Node.Child
        DirectCallNode directCallNode_;

        DirectCallData(DirectCallData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

