/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.AbstractFunctionArgumentsNode;
import com.oracle.truffle.js.nodes.function.EvalNodeGen;
import com.oracle.truffle.js.nodes.function.JSFunctionArgumentsNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class EvalNode
extends JavaScriptNode {
    private final JSContext context;
    @Node.Child
    @Executed
    protected JavaScriptNode functionNode;
    @Node.Child
    protected AbstractFunctionArgumentsNode arguments;
    @Node.Child
    protected DirectEvalNode directEvalNode;

    protected EvalNode(JSContext context, Object currEnv, JavaScriptNode function, JavaScriptNode[] args, JavaScriptNode thisObject) {
        this(context, function, JSFunctionArgumentsNode.create(context, args), DirectEvalNode.create(context, currEnv, thisObject));
    }

    protected EvalNode(JSContext context, JavaScriptNode functionNode, AbstractFunctionArgumentsNode arguments, DirectEvalNode directEvalNode) {
        this.context = context;
        this.functionNode = functionNode;
        this.arguments = arguments;
        this.directEvalNode = directEvalNode;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.EvalCallTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Specialization(guards={"!isEvalOverridden(evalFunction)"})
    protected Object evalNotOverridden(VirtualFrame frame, Object evalFunction) {
        int argCount = this.arguments.getCount(frame);
        Object[] args = new Object[argCount];
        DynamicObject source = (args = this.arguments.executeFillObjectArray(frame, args, 0)).length == 0 ? Undefined.instance : args[0];
        return this.directEvalNode.executeWithSource(frame, source);
    }

    @Specialization(guards={"isEvalOverridden(evalFunction)"})
    protected Object evalOverridden(VirtualFrame frame, Object evalFunction, @Cached(value="createCall()") JSFunctionCallNode redirectCall) {
        int argCount = this.arguments.getCount(frame);
        Object[] args = JSArguments.createInitial(Undefined.instance, evalFunction, argCount);
        args = this.arguments.executeFillObjectArray(frame, args, 2);
        return redirectCall.executeCall(args);
    }

    protected final boolean isEvalOverridden(Object function) {
        return function != this.context.getRealm().getEvalFunctionObject();
    }

    public static EvalNode create(JSContext context, Object env, JavaScriptNode functionNode, JavaScriptNode[] args, JavaScriptNode thisObject) {
        return EvalNodeGen.create(context, env, functionNode, args, thisObject);
    }

    @CompilerDirectives.TruffleBoundary
    private static String formatEvalOrigin(Node callNode) {
        if (callNode == null) {
            return null;
        }
        SourceSection sourceSection = callNode.getEncapsulatingSourceSection();
        String sourceName = sourceSection.getSource().getName();
        String callerName = callNode.getRootNode().getName();
        if (callerName == null || callerName.startsWith(":")) {
            callerName = JSError.ANONYMOUS_FUNCTION_NAME_STACK_TRACE;
        }
        if (sourceName.startsWith("eval at ")) {
            return "eval at " + callerName + " (" + sourceName + ")";
        }
        return "eval at " + callerName + " (" + sourceName + ":" + sourceSection.getStartLine() + ":" + sourceSection.getStartColumn() + ")";
    }

    @CompilerDirectives.TruffleBoundary
    public static String findAndFormatEvalOrigin(Node evalNode) {
        String evalOrigin = EvalNode.formatEvalOrigin(evalNode);
        if (evalOrigin != null) {
            return evalOrigin;
        }
        return (String)Truffle.getRuntime().iterateFrames(frameInstance -> EvalNode.formatEvalOrigin(frameInstance.getCallNode()));
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return EvalNodeGen.create(this.context, EvalNode.cloneUninitialized(this.functionNode), AbstractFunctionArgumentsNode.cloneUninitialized(this.arguments), this.directEvalNode.copyUninitialized());
    }

    protected static abstract class DirectEvalNode
    extends JavaScriptBaseNode {
        private final JSContext context;
        private final Object currEnv;
        private final JavaScriptNode thisNode;

        protected DirectEvalNode(JSContext context, Object currEnv, JavaScriptNode thisNode) {
            assert (currEnv != null);
            this.context = context;
            this.currEnv = currEnv;
            this.thisNode = thisNode;
        }

        protected static DirectEvalNode create(JSContext context, Object currEnv, JavaScriptNode thisNode) {
            return EvalNodeGen.DirectEvalNodeGen.create(context, currEnv, thisNode);
        }

        public abstract Object executeWithSource(VirtualFrame var1, Object var2);

        @Specialization
        protected int directEvalInt(int source) {
            return source;
        }

        @Specialization
        protected LargeInteger directEvalLargeInteger(LargeInteger source) {
            return source;
        }

        @Specialization
        protected long directEvalLong(long source) {
            return source;
        }

        @Specialization
        protected double directEvalDouble(double source) {
            return source;
        }

        @Specialization
        protected boolean directEvalBoolean(boolean source) {
            return source;
        }

        @Specialization
        protected Symbol directEvalSymbol(Symbol source) {
            return source;
        }

        @Specialization
        protected BigInt directEvalBigInt(BigInt source) {
            return source;
        }

        @Specialization(guards={"isJSType(source)"})
        protected DynamicObject directEvalJSType(DynamicObject source) {
            return source;
        }

        @Specialization
        protected Object directEvalCharSequence(VirtualFrame frame, CharSequence source) {
            return this.directEvalImpl(frame, source);
        }

        private Object directEvalImpl(VirtualFrame frame, CharSequence sourceCode) {
            Source source = this.sourceFromString(sourceCode);
            return this.context.getEvaluator().evaluate(this.context.getRealm(), this.getParent(), source, this.currEnv, frame.materialize(), this.thisNode.execute(frame));
        }

        @Specialization(guards={"isForeignObject(sourceCode)"}, limit="3")
        protected Object directEvalForeignObject(VirtualFrame frame, TruffleObject sourceCode, @CachedLibrary(value="sourceCode") InteropLibrary interop) {
            if (interop.isString((Object)sourceCode)) {
                try {
                    return this.directEvalImpl(frame, interop.asString((Object)sourceCode));
                }
                catch (UnsupportedMessageException ex) {
                    throw Errors.createTypeErrorInteropException(sourceCode, (InteropException)((Object)ex), "asString", this);
                }
            }
            return sourceCode;
        }

        @CompilerDirectives.TruffleBoundary
        private Source sourceFromString(CharSequence sourceCode) {
            String evalSourceName = null;
            if (this.context.isOptionV8CompatibilityMode()) {
                evalSourceName = EvalNode.formatEvalOrigin(this);
            }
            if (evalSourceName == null) {
                evalSourceName = "<eval>";
            }
            return Source.newBuilder((String)"js", (CharSequence)sourceCode.toString(), (String)evalSourceName).build();
        }

        protected DirectEvalNode copyUninitialized() {
            return DirectEvalNode.create(this.context, this.currEnv, JavaScriptNode.cloneUninitialized(this.thisNode));
        }
    }
}

