/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToDoubleNode.class)
public final class JSToDoubleNodeGen
extends JSToDoubleNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private JSStringToNumberNode stringDouble_stringToNumberNode_;
    @Node.Child
    private JSToPrimitiveNode jSObject_toPrimitiveNode_;
    @Node.Child
    private JSToPrimitiveNode foreignObject_toPrimitiveNode_;

    private JSToDoubleNodeGen() {
    }

    @Override
    public Object execute(Object arg0Value) {
        Object arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_2 = (Integer)arg0Value;
            return JSToDoubleNode.doInteger(arg0Value_2);
        }
        if ((state & 2) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_3 = (Boolean)arg0Value;
            return JSToDoubleNode.doBoolean(arg0Value_3);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x7800) >>> 11, arg0Value)) {
            double arg0Value_4 = JSTypesGen.asImplicitDouble((state & 0x7800) >>> 11, arg0Value);
            return JSToDoubleNode.doDouble(arg0Value_4);
        }
        if ((state & 8) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_5 = (BigInt)arg0Value;
            return this.doBigInt(arg0Value_5);
        }
        if ((state & 0x30) != 0) {
            if ((state & 0x10) != 0 && JSGuards.isJSNull(arg0Value)) {
                return JSToDoubleNode.doNull(arg0Value);
            }
            if ((state & 0x20) != 0 && JSGuards.isUndefined(arg0Value)) {
                return JSToDoubleNode.doUndefined(arg0Value);
            }
        }
        if ((state & 0x40) != 0 && JSTypesGen.isImplicitString((state & 0x78000) >>> 15, arg0Value)) {
            String arg0Value_6 = JSTypesGen.asImplicitString((state & 0x78000) >>> 15, arg0Value);
            return JSToDoubleNode.doStringDouble(arg0Value_6, this.stringDouble_stringToNumberNode_);
        }
        if ((state & 0x80) != 0 && JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
            return this.doJSObject((DynamicObject)arg0Value_, this.jSObject_toPrimitiveNode_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof Symbol) {
            arg0Value_ = (Symbol)arg0Value;
            return this.doSymbol((Symbol)arg0Value_);
        }
        if ((state & 0x200) != 0 && arg0Value instanceof TruffleObject && JSGuards.isForeignObject((TruffleObject)(arg0Value_ = (TruffleObject)arg0Value))) {
            return this.doForeignObject((TruffleObject)arg0Value_, this.foreignObject_toPrimitiveNode_);
        }
        if ((state & 0x400) != 0 && JSGuards.isJavaNumber(arg0Value)) {
            return JSToDoubleNode.doJavaNumber(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    @Override
    public double executeDouble(Object arg0Value) {
        Object arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_2 = (Integer)arg0Value;
            return JSToDoubleNode.doInteger(arg0Value_2);
        }
        if ((state & 2) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_3 = (Boolean)arg0Value;
            return JSToDoubleNode.doBoolean(arg0Value_3);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0x7800) >>> 11, arg0Value)) {
            double arg0Value_4 = JSTypesGen.asImplicitDouble((state & 0x7800) >>> 11, arg0Value);
            return JSToDoubleNode.doDouble(arg0Value_4);
        }
        if ((state & 8) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_5 = (BigInt)arg0Value;
            return this.doBigInt(arg0Value_5);
        }
        if ((state & 0x30) != 0) {
            if ((state & 0x10) != 0 && JSGuards.isJSNull(arg0Value)) {
                return JSToDoubleNode.doNull(arg0Value);
            }
            if ((state & 0x20) != 0 && JSGuards.isUndefined(arg0Value)) {
                return JSToDoubleNode.doUndefined(arg0Value);
            }
        }
        if ((state & 0x40) != 0 && JSTypesGen.isImplicitString((state & 0x78000) >>> 15, arg0Value)) {
            String arg0Value_6 = JSTypesGen.asImplicitString((state & 0x78000) >>> 15, arg0Value);
            return JSToDoubleNode.doStringDouble(arg0Value_6, this.stringDouble_stringToNumberNode_);
        }
        if ((state & 0x80) != 0 && JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
            return this.doJSObject((DynamicObject)arg0Value_, this.jSObject_toPrimitiveNode_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof Symbol) {
            arg0Value_ = (Symbol)arg0Value;
            return this.doSymbol((Symbol)arg0Value_);
        }
        if ((state & 0x200) != 0 && arg0Value instanceof TruffleObject && JSGuards.isForeignObject((TruffleObject)(arg0Value_ = (TruffleObject)arg0Value))) {
            return this.doForeignObject((TruffleObject)arg0Value_, this.foreignObject_toPrimitiveNode_);
        }
        if ((state & 0x400) != 0 && JSGuards.isJavaNumber(arg0Value)) {
            return JSToDoubleNode.doJavaNumber(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private double executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            TruffleObject arg0Value_;
            DynamicObject arg0Value_2;
            if (arg0Value instanceof Integer) {
                int arg0Value_3 = (Integer)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                double d = JSToDoubleNode.doInteger(arg0Value_3);
                return d;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_4 = (Boolean)arg0Value;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                double d = JSToDoubleNode.doBoolean(arg0Value_4);
                return d;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_5 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state |= doubleCast0 << 11;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                double d = JSToDoubleNode.doDouble(arg0Value_5);
                return d;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_6 = (BigInt)arg0Value;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                double arg0Value_5 = this.doBigInt(arg0Value_6);
                return arg0Value_5;
            }
            if (JSGuards.isJSNull(arg0Value)) {
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                double arg0Value_6 = JSToDoubleNode.doNull(arg0Value);
                return arg0Value_6;
            }
            if (JSGuards.isUndefined(arg0Value)) {
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                double arg0Value_6 = JSToDoubleNode.doUndefined(arg0Value);
                return arg0Value_6;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(arg0Value);
            if (stringCast0 != 0) {
                String arg0Value_7 = JSTypesGen.asImplicitString(stringCast0, arg0Value);
                this.stringDouble_stringToNumberNode_ = (JSStringToNumberNode)super.insert((Node)JSStringToNumberNode.create());
                state |= stringCast0 << 15;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                double d = JSToDoubleNode.doStringDouble(arg0Value_7, this.stringDouble_stringToNumberNode_);
                return d;
            }
            if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_2 = (DynamicObject)arg0Value)) {
                this.jSObject_toPrimitiveNode_ = (JSToPrimitiveNode)super.insert((Node)JSToPrimitiveNode.createHintNumber());
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                double d = this.doJSObject(arg0Value_2, this.jSObject_toPrimitiveNode_);
                return d;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_8 = (Symbol)arg0Value;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                double d = this.doSymbol(arg0Value_8);
                return d;
            }
            if (arg0Value instanceof TruffleObject && JSGuards.isForeignObject(arg0Value_ = (TruffleObject)arg0Value)) {
                this.foreignObject_toPrimitiveNode_ = (JSToPrimitiveNode)super.insert((Node)JSToPrimitiveNode.createHintNumber());
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                double d = this.doForeignObject(arg0Value_, this.foreignObject_toPrimitiveNode_);
                return d;
            }
            if (JSGuards.isJavaNumber(arg0Value)) {
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                double d = JSToDoubleNode.doJavaNumber(arg0Value);
                return d;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x7FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x7FF & (state & 0x7FF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<JavaScriptBaseNode>> cached;
        Object[] data = new Object[12];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doNull";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doStringDouble";
        if ((state & 0x40) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<JavaScriptBaseNode>>();
            cached.add(Arrays.asList(this.stringDouble_stringToNumberNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 0x80) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.jSObject_toPrimitiveNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x200) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.foreignObject_toPrimitiveNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doJavaNumber";
        s[1] = (state & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSToDoubleNode create() {
        return new JSToDoubleNodeGen();
    }
}

