/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetViewValueNode;
import com.oracle.truffle.js.nodes.access.SetViewValueNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class SetViewValueNode
extends JavaScriptNode {
    private final TypedArrayFactory factory;
    private final JSContext context;
    @Node.Child
    @Executed
    protected JavaScriptNode viewNode;
    @Node.Child
    @Executed
    protected JavaScriptNode requestIndexNode;
    @Node.Child
    @Executed
    protected JavaScriptNode isLittleEndianNode;
    @Node.Child
    @Executed
    protected JavaScriptNode valueNode;
    @Node.Child
    private JSToBooleanNode toBooleanNode;
    @Node.Child
    private JSToNumberNode toNumberNode;
    @Node.Child
    private JSToBigIntNode toBigIntNode;

    protected SetViewValueNode(JSContext context, String type, JavaScriptNode view, JavaScriptNode requestIndex, JavaScriptNode isLittleEndian, JavaScriptNode value) {
        this(context, GetViewValueNode.typedArrayFactoryFromType(type, context), view, requestIndex, isLittleEndian, value);
    }

    protected SetViewValueNode(JSContext context, TypedArrayFactory factory, JavaScriptNode view, JavaScriptNode requestIndex, JavaScriptNode isLittleEndian, JavaScriptNode value) {
        this.factory = factory;
        this.context = context;
        this.viewNode = view;
        this.requestIndexNode = requestIndex;
        this.isLittleEndianNode = isLittleEndian;
        this.valueNode = value;
        JSToBooleanNode jSToBooleanNode = this.toBooleanNode = factory.getBytesPerElement() == 1 ? null : JSToBooleanNode.create();
        if (JSRuntime.isTypedArrayBigIntFactory(factory)) {
            this.toBigIntNode = JSToBigIntNode.create();
        } else {
            this.toNumberNode = JSToNumberNode.create();
        }
    }

    public abstract Object execute(DynamicObject var1, Object var2, Object var3, Object var4);

    @Specialization
    protected final Object doSet(Object view, Object requestIndex, Object littleEndian, Object value, @Cached(value="create()") JSToIndexNode toIndexNode, @Cached(value="create()") BranchProfile errorBranch, @Cached(value="createClassProfile()") ValueProfile typeProfile) {
        boolean isLittleEndian;
        if (!JSDataView.isJSDataView(view)) {
            errorBranch.enter();
            throw Errors.createTypeErrorNotADataView();
        }
        DynamicObject dataView = (DynamicObject)view;
        DynamicObject buffer = JSDataView.getArrayBuffer(dataView);
        long getIndex = toIndexNode.executeLong(requestIndex);
        Object numberValue = JSRuntime.isTypedArrayBigIntFactory(this.factory) ? this.toBigIntNode.executeBigInteger(value) : this.toNumberNode.executeNumber(value);
        boolean bl = isLittleEndian = this.factory.getBytesPerElement() == 1 ? true : this.toBooleanNode.executeBoolean(littleEndian);
        if (!this.context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(buffer)) {
            errorBranch.enter();
            throw Errors.createTypeErrorDetachedBuffer();
        }
        int viewLength = JSDataView.typedArrayGetLength(dataView);
        int elementSize = this.factory.getBytesPerElement();
        if (getIndex + (long)elementSize > (long)viewLength) {
            errorBranch.enter();
            throw Errors.createRangeError("index + elementSize > viewLength");
        }
        int viewOffset = JSDataView.typedArrayGetOffset(dataView);
        assert (getIndex + (long)viewOffset <= Integer.MAX_VALUE);
        int bufferIndex = (int)(getIndex + (long)viewOffset);
        TypedArray strategy = (TypedArray)typeProfile.profile((Object)this.factory.createArrayType(JSArrayBuffer.isJSDirectOrSharedArrayBuffer(buffer), true));
        strategy.setBufferElement(buffer, bufferIndex, isLittleEndian, JSDataView.isJSDataView(view), numberValue);
        return Undefined.instance;
    }

    public static SetViewValueNode create(JSContext context, String type, JavaScriptNode view, JavaScriptNode requestIndex, JavaScriptNode isLittleEndian, JavaScriptNode value) {
        return SetViewValueNodeGen.create(context, type, view, requestIndex, isLittleEndian, value);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return SetViewValueNodeGen.create(this.context, this.factory, SetViewValueNode.cloneUninitialized(this.viewNode), SetViewValueNode.cloneUninitialized(this.requestIndexNode), SetViewValueNode.cloneUninitialized(this.isLittleEndianNode), SetViewValueNode.cloneUninitialized(this.valueNode));
    }
}

