/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.BooleanLocation;
import com.oracle.truffle.api.object.DoubleLocation;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IntLocation;
import com.oracle.truffle.api.object.LongLocation;
import com.oracle.truffle.api.object.ObjectLocation;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import com.oracle.truffle.js.nodes.access.JSProxyHasPropertyNode;
import com.oracle.truffle.js.nodes.access.JSProxyPropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertyCacheNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNodeFactory;
import com.oracle.truffle.js.nodes.array.ArrayLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.function.CreateMethodPropertyNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSNoSuchMethodAdapter;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.java.JavaImporter;
import com.oracle.truffle.js.runtime.java.JavaPackage;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TRegexUtil;

public class PropertyGetNode
extends PropertyCacheNode<GetCacheNode> {
    private final boolean isGlobal;
    private final boolean getOwnProperty;
    @CompilerDirectives.CompilationFinal
    private boolean isMethod;
    private boolean propertyAssumptionCheckEnabled = true;

    public static PropertyGetNode create(Object key, JSContext context) {
        return PropertyGetNode.create(key, false, context);
    }

    public static PropertyGetNode create(Object key, boolean isGlobal, JSContext context) {
        boolean getOwnProperty = false;
        return PropertyGetNode.createImpl(key, isGlobal, context, false);
    }

    private static PropertyGetNode createImpl(Object key, boolean isGlobal, JSContext context, boolean getOwnProperty) {
        return new PropertyGetNode(key, context, isGlobal, getOwnProperty);
    }

    public static PropertyGetNode createGetOwn(Object key, JSContext context) {
        boolean global = false;
        boolean getOwnProperty = true;
        return PropertyGetNode.createImpl(key, false, context, true);
    }

    public static PropertyGetNode createGetHidden(HiddenKey key, JSContext context) {
        return PropertyGetNode.createGetOwn(key, context);
    }

    protected PropertyGetNode(Object key, JSContext context, boolean isGlobal, boolean getOwnProperty) {
        super(key, context);
        this.isGlobal = isGlobal;
        this.getOwnProperty = getOwnProperty;
    }

    public final Object getValue(Object obj) {
        return this.getValue(obj, obj);
    }

    public final int getValueInt(Object obj) throws UnexpectedResultException {
        return this.getValueInt(obj, obj);
    }

    public final double getValueDouble(Object obj) throws UnexpectedResultException {
        return this.getValueDouble(obj, obj);
    }

    public final boolean getValueBoolean(Object obj) throws UnexpectedResultException {
        return this.getValueBoolean(obj, obj);
    }

    public final long getValueLong(Object obj) throws UnexpectedResultException {
        return this.getValueLong(obj, obj);
    }

    public final Object getValueOrDefault(Object obj, Object defaultValue) {
        return this.getValueOrDefault(obj, obj, defaultValue);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    protected Object getValue(Object thisObj, Object receiver) {
        GetCacheNode c = (GetCacheNode)this.cacheNode;
        while (c != null) {
            if (c.isGeneric()) {
                return c.getValue(thisObj, receiver, this, false);
            }
            if (!c.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                break;
            }
            boolean guard = c.accepts(thisObj);
            if (guard) {
                return c.getValue(thisObj, receiver, this, guard);
            }
            c = (GetCacheNode)c.next;
        }
        this.deoptimize();
        return ((GetCacheNode)((Object)this.specialize(thisObj))).getValue(thisObj, receiver, this, false);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    protected int getValueInt(Object thisObj, Object receiver) throws UnexpectedResultException {
        GetCacheNode c = (GetCacheNode)this.cacheNode;
        while (c != null) {
            if (c.isGeneric()) {
                return c.getValueInt(thisObj, receiver, this, false);
            }
            if (!c.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                break;
            }
            boolean guard = c.accepts(thisObj);
            if (guard) {
                return c.getValueInt(thisObj, receiver, this, guard);
            }
            c = (GetCacheNode)c.next;
        }
        this.deoptimize();
        return ((GetCacheNode)((Object)this.specialize(thisObj))).getValueInt(thisObj, receiver, this, false);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    protected double getValueDouble(Object thisObj, Object receiver) throws UnexpectedResultException {
        GetCacheNode c = (GetCacheNode)this.cacheNode;
        while (c != null) {
            if (c.isGeneric()) {
                return c.getValueDouble(thisObj, receiver, this, false);
            }
            if (!c.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                break;
            }
            boolean guard = c.accepts(thisObj);
            if (guard) {
                return c.getValueDouble(thisObj, receiver, this, guard);
            }
            c = (GetCacheNode)c.next;
        }
        this.deoptimize();
        return ((GetCacheNode)((Object)this.specialize(thisObj))).getValueDouble(thisObj, receiver, this, false);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    protected boolean getValueBoolean(Object thisObj, Object receiver) throws UnexpectedResultException {
        GetCacheNode c = (GetCacheNode)this.cacheNode;
        while (c != null) {
            if (c.isGeneric()) {
                return c.getValueBoolean(thisObj, receiver, this, false);
            }
            if (!c.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                break;
            }
            boolean guard = c.accepts(thisObj);
            if (guard) {
                return c.getValueBoolean(thisObj, receiver, this, guard);
            }
            c = (GetCacheNode)c.next;
        }
        this.deoptimize();
        return ((GetCacheNode)((Object)this.specialize(thisObj))).getValueBoolean(thisObj, receiver, this, false);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    protected long getValueLong(Object thisObj, Object receiver) throws UnexpectedResultException {
        GetCacheNode c = (GetCacheNode)this.cacheNode;
        while (c != null) {
            if (c.isGeneric()) {
                return c.getValueLong(thisObj, receiver, this, false);
            }
            if (!c.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                break;
            }
            boolean guard = c.accepts(thisObj);
            if (guard) {
                return c.getValueLong(thisObj, receiver, this, guard);
            }
            c = (GetCacheNode)c.next;
        }
        this.deoptimize();
        return ((GetCacheNode)((Object)this.specialize(thisObj))).getValueLong(thisObj, receiver, this, false);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    protected Object getValueOrDefault(Object thisObj, Object receiver, Object defaultValue) {
        GetCacheNode c = (GetCacheNode)this.cacheNode;
        while (c != null) {
            if (c.isGeneric()) {
                return c.getValueOrDefault(thisObj, receiver, defaultValue, this, false);
            }
            if (!c.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                break;
            }
            boolean guard = c.accepts(thisObj);
            if (guard) {
                return c.getValueOrDefault(thisObj, receiver, defaultValue, this, guard);
            }
            c = (GetCacheNode)c.next;
        }
        this.deoptimize();
        return ((GetCacheNode)((Object)this.specialize(thisObj))).getValueOrDefault(thisObj, receiver, defaultValue, this, false);
    }

    @Override
    protected GetCacheNode createCachedPropertyNode(Property property, Object thisObj, int depth, Object value, GetCacheNode currentHead) {
        assert (!this.isOwnProperty() || depth == 0);
        if (!JSObject.isDynamicObject(thisObj)) {
            return this.createCachedPropertyNodeNotJSObject(property, thisObj, depth);
        }
        Shape cacheShape = ((DynamicObject)thisObj).getShape();
        if ((JSProperty.isData(property) && !JSProperty.isProxy(property) || JSProperty.isAccessor(property)) && (property.getLocation().isFinal() || property.getLocation().isAssumedFinal())) {
            boolean isConstantObjectFinal = this.isPropertyAssumptionCheckEnabled();
            GetCacheNode cur = currentHead;
            while (cur != null) {
                if (PropertyGetNode.isFinalSpecialization(cur)) {
                    if (cur.receiverCheck instanceof PropertyCacheNode.ConstantObjectReceiverCheck) {
                        ((PropertyCacheNode.ConstantObjectReceiverCheck)((Object)cur.receiverCheck)).clearExpectedObject();
                        this.setPropertyAssumptionCheckEnabled(false);
                        return null;
                    }
                    assert (!(cur.receiverCheck instanceof PropertyCacheNode.ConstantObjectReceiverCheck) || ((PropertyCacheNode.ConstantObjectReceiverCheck)((Object)cur.receiverCheck)).getExpectedObject() == thisObj);
                }
                cur = (GetCacheNode)cur.next;
            }
            if (JSProperty.isData(property) && !JSProperty.isProxy(property)) {
                if (this.isEligibleForFinalSpecialization(cacheShape, (DynamicObject)thisObj, depth, isConstantObjectFinal)) {
                    return this.createFinalSpecialization(property, cacheShape, (DynamicObject)thisObj, depth, isConstantObjectFinal);
                }
            } else if (JSProperty.isAccessor(property) && this.isEligibleForFinalSpecialization(cacheShape, (DynamicObject)thisObj, depth, isConstantObjectFinal)) {
                return this.createFinalAccessorSpecialization(property, cacheShape, (DynamicObject)thisObj, depth, isConstantObjectFinal);
            }
        }
        PropertyCacheNode.AbstractShapeCheckNode shapeCheck = this.createShapeCheckNode(cacheShape, (DynamicObject)thisObj, depth, false, false);
        if (JSProperty.isData(property)) {
            return PropertyGetNode.createSpecializationFromDataProperty(property, shapeCheck, this.context);
        }
        assert (JSProperty.isAccessor(property));
        return new AccessorPropertyGetNode(property, shapeCheck);
    }

    private static boolean isFinalSpecialization(GetCacheNode existingNode) {
        return existingNode instanceof AbstractFinalDataPropertyGetNode || existingNode instanceof FinalAccessorPropertyGetNode;
    }

    private boolean isEligibleForFinalSpecialization(Shape cacheShape, DynamicObject thisObj, int depth, boolean isConstantObjectFinal) {
        return depth >= 1 ? PropertyGetNode.prototypesInShape(thisObj, depth) && this.propertyAssumptionsValid(thisObj, depth, isConstantObjectFinal) : JSTruffleOptions.SkipFinalShapeCheck && this.isPropertyAssumptionCheckEnabled() && JSShape.getPropertyAssumption(cacheShape, this.key).isValid();
    }

    private GetCacheNode createCachedPropertyNodeNotJSObject(Property property, Object thisObj, int depth) {
        PropertyCacheNode.ReceiverCheckNode receiverCheck;
        if (depth == 0) {
            GetCacheNode javaPropertyNode;
            if (this.isMethod() && thisObj instanceof String && this.context.isOptionNashornCompatibilityMode() && (javaPropertyNode = this.createJavaPropertyNodeMaybe(thisObj, depth)) != null) {
                return javaPropertyNode;
            }
            receiverCheck = new PropertyCacheNode.InstanceofCheckNode(thisObj.getClass(), this.context);
        } else {
            receiverCheck = this.createPrimitiveReceiverCheck(thisObj, depth);
        }
        if (JSProperty.isData(property)) {
            return PropertyGetNode.createSpecializationFromDataProperty(property, receiverCheck, this.context);
        }
        assert (JSProperty.isAccessor(property));
        return new AccessorPropertyGetNode(property, receiverCheck);
    }

    private static GetCacheNode createSpecializationFromDataProperty(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck, JSContext context) {
        Property dataProperty = property;
        if (property.getLocation() instanceof IntLocation) {
            return new IntPropertyGetNode(dataProperty, receiverCheck);
        }
        if (property.getLocation() instanceof DoubleLocation) {
            return new DoublePropertyGetNode(dataProperty, receiverCheck);
        }
        if (property.getLocation() instanceof BooleanLocation) {
            return new BooleanPropertyGetNode(dataProperty, receiverCheck);
        }
        if (property.getLocation() instanceof LongLocation) {
            return new LongPropertyGetNode(dataProperty, receiverCheck);
        }
        if (PropertyGetNode.isArrayLengthProperty(property)) {
            return new ArrayLengthPropertyGetNode(dataProperty, receiverCheck);
        }
        if (PropertyGetNode.isFunctionLengthProperty(property)) {
            return new FunctionLengthPropertyGetNode(dataProperty, receiverCheck);
        }
        if (PropertyGetNode.isFunctionNameProperty(property)) {
            return new FunctionNamePropertyGetNode(dataProperty, receiverCheck);
        }
        if (PropertyGetNode.isClassPrototypeProperty(property)) {
            return new ClassPrototypePropertyGetNode(dataProperty, receiverCheck, context);
        }
        if (PropertyGetNode.isStringLengthProperty(property)) {
            return new StringLengthPropertyGetNode(dataProperty, receiverCheck);
        }
        if (PropertyGetNode.isLazyRegexResultIndexProperty(property)) {
            return new LazyRegexResultIndexPropertyGetNode(dataProperty, receiverCheck);
        }
        if (PropertyGetNode.isLazyNamedCaptureGroupProperty(property)) {
            int groupIndex = ((JSRegExp.LazyNamedCaptureGroupProperty)JSProperty.getConstantProxy(property)).getGroupIndex();
            return new LazyNamedCaptureGroupPropertyGetNode(dataProperty, receiverCheck, context, groupIndex);
        }
        return new ObjectPropertyGetNode(dataProperty, receiverCheck);
    }

    private GetCacheNode createFinalSpecialization(Property property, Shape cacheShape, DynamicObject thisObj, int depth, boolean isConstantObjectFinal) {
        PropertyCacheNode.AbstractShapeCheckNode finalShapeCheckNode = this.createShapeCheckNode(cacheShape, thisObj, depth, isConstantObjectFinal, false);
        finalShapeCheckNode.adoptChildren();
        DynamicObject store = finalShapeCheckNode.getStore(thisObj);
        return PropertyGetNode.createFinalSpecializationImpl(property, finalShapeCheckNode, store);
    }

    private static GetCacheNode createFinalSpecializationImpl(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheckNode, DynamicObject store) {
        if (property.getLocation() instanceof IntLocation) {
            return new FinalIntPropertyGetNode(property, shapeCheckNode, ((IntLocation)property.getLocation()).getInt(store, false));
        }
        if (property.getLocation() instanceof DoubleLocation) {
            return new FinalDoublePropertyGetNode(property, shapeCheckNode, ((DoubleLocation)property.getLocation()).getDouble(store, false));
        }
        if (property.getLocation() instanceof BooleanLocation) {
            return new FinalBooleanPropertyGetNode(property, shapeCheckNode, ((BooleanLocation)property.getLocation()).getBoolean(store, false));
        }
        if (property.getLocation() instanceof LongLocation) {
            return new FinalLongPropertyGetNode(property, shapeCheckNode, ((LongLocation)property.getLocation()).getLong(store, false));
        }
        assert (property.getLocation() instanceof ObjectLocation);
        return new FinalObjectPropertyGetNode(property, shapeCheckNode, property.get(store, false));
    }

    private GetCacheNode createFinalAccessorSpecialization(Property property, Shape cacheShape, DynamicObject thisObj, int depth, boolean isConstantObjectFinal) {
        PropertyCacheNode.AbstractShapeCheckNode finalShapeCheckNode = this.createShapeCheckNode(cacheShape, thisObj, depth, isConstantObjectFinal, false);
        finalShapeCheckNode.adoptChildren();
        DynamicObject store = finalShapeCheckNode.getStore(thisObj);
        Accessor accessor = (Accessor)property.get(store, null);
        return new FinalAccessorPropertyGetNode(property, finalShapeCheckNode, accessor);
    }

    @Override
    protected GetCacheNode createJavaPropertyNodeMaybe(Object thisObj, int depth) {
        if (JavaPackage.isJavaPackage(thisObj)) {
            return new JavaPackagePropertyGetNode(new PropertyCacheNode.JSClassCheckNode(JSObject.getJSClass((DynamicObject)thisObj)));
        }
        if (JavaImporter.isJavaImporter(thisObj)) {
            return new UnspecializedPropertyGetNode(new PropertyCacheNode.JSClassCheckNode(JSObject.getJSClass((DynamicObject)thisObj)));
        }
        if (JSTruffleOptions.SubstrateVM) {
            return null;
        }
        if (this.context.isOptionNashornCompatibilityMode() && this.context.getRealm().isJavaInteropEnabled() && thisObj instanceof String && this.isMethod()) {
            return new JavaStringMethodGetNode(this.createPrimitiveReceiverCheck(thisObj, depth));
        }
        return null;
    }

    @Override
    protected GetCacheNode createUndefinedPropertyNode(Object thisObj, Object store, int depth, Object value) {
        GetCacheNode javaPropertyNode = this.createJavaPropertyNodeMaybe(thisObj, depth);
        if (javaPropertyNode != null) {
            return javaPropertyNode;
        }
        if (JSObject.isDynamicObject(thisObj)) {
            PropertyCacheNode.ReceiverCheckNode receiverCheck;
            DynamicObject jsobject = (DynamicObject)thisObj;
            Shape cacheShape = jsobject.getShape();
            PropertyCacheNode.AbstractShapeCheckNode shapeCheck = this.createShapeCheckNode(cacheShape, jsobject, depth, false, false);
            PropertyCacheNode.ReceiverCheckNode receiverCheckNode = receiverCheck = depth == 0 ? new PropertyCacheNode.JSClassCheckNode(JSObject.getJSClass(jsobject)) : shapeCheck;
            if (JSAdapter.isJSAdapter(store)) {
                return new JSAdapterPropertyGetNode(receiverCheck);
            }
            if (JSProxy.isProxy(store) && !(this.key instanceof HiddenKey)) {
                if (this.isRequired()) {
                    return new JSProxyDispatcherRequiredPropertyGetNode(this.context, this.key, receiverCheck, this.isMethod());
                }
                return new JSProxyDispatcherPropertyGetNode(this.context, this.key, receiverCheck, this.isMethod());
            }
            if (JSModuleNamespace.isJSModuleNamespace(store)) {
                return new UnspecializedPropertyGetNode(receiverCheck);
            }
            if (JSArrayBufferView.isJSArrayBufferView(store) && PropertyGetNode.isNonIntegerIndex(this.key)) {
                return new ArrayBufferViewNonIntegerIndexGetNode(shapeCheck);
            }
            return this.createUndefinedJSObjectPropertyNode(jsobject, depth);
        }
        if (JSProxy.isProxy(store)) {
            PropertyCacheNode.ReceiverCheckNode receiverCheck = this.createPrimitiveReceiverCheck(thisObj, depth);
            return new JSProxyDispatcherPropertyGetNode(this.context, this.key, receiverCheck, this.isMethod());
        }
        if (thisObj == null) {
            return new TypeErrorPropertyGetNode(new PropertyCacheNode.NullCheckNode());
        }
        PropertyCacheNode.ReceiverCheckNode receiverCheck = this.createPrimitiveReceiverCheck(thisObj, depth);
        return this.createUndefinedOrErrorPropertyNode(receiverCheck);
    }

    private GetCacheNode createUndefinedJSObjectPropertyNode(DynamicObject jsobject, int depth) {
        PropertyCacheNode.AbstractShapeCheckNode shapeCheck = this.createShapeCheckNode(jsobject.getShape(), jsobject, depth, false, false);
        if (JSRuntime.isObject(jsobject)) {
            if (this.context.isOptionNashornCompatibilityMode() && !(this.key instanceof Symbol) && (!this.context.getNoSuchMethodUnusedAssumption().isValid() && JSObject.hasProperty(jsobject, "__noSuchMethod__") || !this.context.getNoSuchPropertyUnusedAssumption().isValid() && JSObject.hasProperty(jsobject, "__noSuchProperty__"))) {
                return new CheckNoSuchPropertyNode(this.key, shapeCheck, this.context);
            }
            return this.createUndefinedOrErrorPropertyNode(shapeCheck);
        }
        return new TypeErrorPropertyGetNode(shapeCheck);
    }

    private GetCacheNode createUndefinedOrErrorPropertyNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
        if (this.isRequired()) {
            return new UndefinedPropertyErrorNode(receiverCheck);
        }
        return new UndefinedPropertyGetNode(receiverCheck);
    }

    @Override
    protected GetCacheNode createGenericPropertyNode() {
        return new GenericPropertyGetNode();
    }

    protected final boolean isRequired() {
        return this.isGlobal();
    }

    @Override
    protected final boolean isGlobal() {
        return this.isGlobal;
    }

    @Override
    protected final boolean isOwnProperty() {
        return this.getOwnProperty;
    }

    protected boolean isMethod() {
        return this.isMethod;
    }

    protected void setMethod() {
        CompilerAsserts.neverPartOfCompilation();
        this.isMethod = true;
    }

    @Override
    protected boolean isPropertyAssumptionCheckEnabled() {
        return this.propertyAssumptionCheckEnabled && this.getContext().isSingleRealm();
    }

    @Override
    protected void setPropertyAssumptionCheckEnabled(boolean value) {
        CompilerAsserts.neverPartOfCompilation();
        this.propertyAssumptionCheckEnabled = value;
    }

    @Override
    protected GetCacheNode createTruffleObjectPropertyNode(TruffleObject thisObject) {
        return new ForeignPropertyGetNode(this.key, this.isMethod(), this.isGlobal(), this.context);
    }

    public static final class LazyNamedCaptureGroupPropertyGetNode
    extends LinkedPropertyGetNode {
        private final int groupIndex;
        @Node.Child
        private PropertyGetNode getResultNode;
        @Node.Child
        private PropertyGetNode getOriginalInputNode;
        @Node.Child
        private TRegexUtil.TRegexMaterializeResultNode materializeNode = TRegexUtil.TRegexMaterializeResultNode.create();

        public LazyNamedCaptureGroupPropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck, JSContext context, int groupIndex) {
            super(receiverCheck);
            assert (PropertyCacheNode.isLazyNamedCaptureGroupProperty(property));
            this.groupIndex = groupIndex;
            this.getResultNode = PropertyGetNode.create(JSRegExp.GROUPS_RESULT_ID, false, context);
            this.getOriginalInputNode = PropertyGetNode.create(JSRegExp.GROUPS_ORIGINAL_INPUT_ID, false, context);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            DynamicObject store = this.receiverCheck.getStore(thisObj);
            TruffleObject regexResult = (TruffleObject)this.getResultNode.getValue(store);
            String input = (String)this.getOriginalInputNode.getValue(store);
            return this.materializeNode.materializeGroup(regexResult, this.groupIndex, input);
        }
    }

    public static final class LazyRegexResultIndexPropertyGetNode
    extends LinkedPropertyGetNode {
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode readStartNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();

        public LazyRegexResultIndexPropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
            assert (JSProperty.isData(property));
            assert (PropertyCacheNode.isLazyRegexResultIndexProperty(property));
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueInt(thisObj, receiver, root, guard);
        }

        @Override
        protected int getValueInt(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.readStartNode.execute(JSAbstractArray.arrayGetRegexResult(this.receiverCheck.getStore(thisObj), guard), "getStart", 0);
        }

        @Override
        protected double getValueDouble(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueInt(thisObj, receiver, root, guard);
        }
    }

    public static final class StringLengthPropertyGetNode
    extends LinkedPropertyGetNode {
        private final ValueProfile charSequenceClassProfile = ValueProfile.createClassProfile();

        public StringLengthPropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
            assert (JSProperty.isData(property));
            assert (PropertyCacheNode.isStringLengthProperty(property));
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueInt(thisObj, receiver, root, guard);
        }

        @Override
        protected int getValueInt(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            CharSequence charSequence = JSString.getCharSequence(this.receiverCheck.getStore(thisObj));
            return JSRuntime.length((CharSequence)this.charSequenceClassProfile.profile((Object)charSequence));
        }

        @Override
        protected double getValueDouble(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueInt(thisObj, receiver, root, guard);
        }
    }

    public static final class ClassPrototypePropertyGetNode
    extends LinkedPropertyGetNode {
        @CompilerDirectives.CompilationFinal
        private DynamicObject constantFunction;
        @Node.Child
        private CreateMethodPropertyNode setConstructor;
        @CompilerDirectives.CompilationFinal
        private int kind;
        private final JSContext context;
        private final ConditionProfile prototypeInitializedProfile = ConditionProfile.createCountingProfile();
        private static final int UNKNOWN = 0;
        private static final int CONSTRUCTOR = 1;
        private static final int GENERATOR = 2;
        private static final int ASYNC_GENERATOR = 3;
        private static final DynamicObject UNKNOWN_FUN = Undefined.instance;
        private static final DynamicObject GENERIC_FUN = null;

        public ClassPrototypePropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck, JSContext context) {
            super(receiverCheck);
            assert (JSProperty.isData(property) && PropertyCacheNode.isClassPrototypeProperty(property));
            this.context = context;
            this.constantFunction = context.isMultiContext() ? GENERIC_FUN : UNKNOWN_FUN;
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            DynamicObject functionObj = this.receiverCheck.getStore(thisObj);
            assert (JSFunction.isJSFunction(functionObj));
            DynamicObject constantFun = this.constantFunction;
            if (constantFun == UNKNOWN_FUN) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.constantFunction = functionObj;
                return JSFunction.getClassPrototype(functionObj);
            }
            if (constantFun != GENERIC_FUN) {
                if (constantFun == functionObj) {
                    return JSFunction.getClassPrototypeInitialized(constantFun);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.constantFunction = GENERIC_FUN;
            }
            if (this.prototypeInitializedProfile.profile(JSFunction.isClassPrototypeInitialized(functionObj))) {
                return JSFunction.getClassPrototypeInitialized(functionObj);
            }
            return this.getPrototypeNotInitialized(functionObj);
        }

        private Object getPrototypeNotInitialized(DynamicObject functionObj) {
            DynamicObject prototype;
            if (this.kind == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                JSFunctionData functionData = JSFunction.getFunctionData(functionObj);
                this.kind = functionData.isAsyncGenerator() ? 3 : (functionData.isGenerator() ? 2 : 1);
            }
            JSRealm realm = JSFunction.getRealm(functionObj, this.context);
            if (this.kind == 1) {
                assert (JSFunction.getFunctionData(functionObj).isConstructor());
                if (this.setConstructor == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setConstructor = (CreateMethodPropertyNode)this.insert(CreateMethodPropertyNode.create(this.context, "constructor"));
                }
                prototype = JSUserObject.create(this.context, realm);
                this.setConstructor.executeVoid(prototype, functionObj);
            } else if (this.kind == 2) {
                assert (JSFunction.getFunctionData(functionObj).isGenerator());
                prototype = JSObject.createWithRealm(this.context, this.context.getGeneratorObjectFactory(), realm, new Object[0]);
            } else {
                assert (this.kind == 3);
                assert (JSFunction.getFunctionData(functionObj).isAsyncGenerator());
                prototype = JSObject.createWithRealm(this.context, this.context.getAsyncGeneratorObjectFactory(), realm, new Object[0]);
            }
            JSFunction.setClassPrototype(functionObj, prototype);
            return prototype;
        }
    }

    public static final class FunctionNamePropertyGetNode
    extends LinkedPropertyGetNode {
        private final BranchProfile isBoundBranch = BranchProfile.create();
        private final JSFunction.FunctionNamePropertyProxy property;

        public FunctionNamePropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
            assert (JSProperty.isData(property));
            assert (PropertyCacheNode.isFunctionNameProperty(property));
            this.property = (JSFunction.FunctionNamePropertyProxy)JSProperty.getConstantProxy(property);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.property.getProfiled(this.receiverCheck.getStore(thisObj), this.isBoundBranch);
        }
    }

    public static final class FunctionLengthPropertyGetNode
    extends LinkedPropertyGetNode {
        private final BranchProfile isBoundBranch = BranchProfile.create();
        private final JSFunction.FunctionLengthPropertyProxy property;

        public FunctionLengthPropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
            assert (JSProperty.isData(property));
            assert (PropertyCacheNode.isFunctionLengthProperty(property));
            this.property = (JSFunction.FunctionLengthPropertyProxy)JSProperty.getConstantProxy(property);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueInt(thisObj, receiver, root, guard);
        }

        @Override
        protected int getValueInt(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.property.getProfiled(this.receiverCheck.getStore(thisObj), this.isBoundBranch);
        }

        @Override
        protected double getValueDouble(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueInt(thisObj, receiver, root, guard);
        }
    }

    public static final class ArrayLengthPropertyGetNode
    extends LinkedPropertyGetNode {
        @Node.Child
        private ArrayLengthNode.ArrayLengthReadNode arrayLengthRead;
        @CompilerDirectives.CompilationFinal
        private boolean longLength;

        public ArrayLengthPropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
            assert (JSProperty.isData(property));
            assert (PropertyCacheNode.isArrayLengthProperty(property));
            this.arrayLengthRead = ArrayLengthNode.ArrayLengthReadNode.create();
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            if (!this.longLength) {
                try {
                    return this.arrayLengthRead.executeInt(this.receiverCheck.getStore(thisObj), guard);
                }
                catch (UnexpectedResultException e) {
                    this.longLength = true;
                    return e.getResult();
                }
            }
            return this.arrayLengthRead.executeDouble(this.receiverCheck.getStore(thisObj), guard);
        }

        @Override
        protected int getValueInt(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) throws UnexpectedResultException {
            assert (this.assertIsArray(thisObj));
            return this.arrayLengthRead.executeInt(this.receiverCheck.getStore(thisObj), guard);
        }

        @Override
        protected double getValueDouble(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            assert (this.assertIsArray(thisObj));
            return this.arrayLengthRead.executeDouble(this.receiverCheck.getStore(thisObj), guard);
        }

        private boolean assertIsArray(Object thisObj) {
            DynamicObject store = this.receiverCheck.getStore(thisObj);
            assert (JSArray.isJSArray(store));
            return true;
        }
    }

    static abstract class GetPropertyFromJSObjectNode
    extends JavaScriptBaseNode {
        private final Object key;
        private final boolean isRequired;
        private final BranchProfile nullOrUndefinedBranch = BranchProfile.create();
        private final BranchProfile fallbackBranch = BranchProfile.create();

        GetPropertyFromJSObjectNode(Object key, boolean isRequired) {
            this.key = key;
            this.isRequired = isRequired;
        }

        public abstract Object executeWithJSObject(DynamicObject var1, Object var2, Object var3, PropertyGetNode var4);

        public static GetPropertyFromJSObjectNode create(Object key, boolean isRequired) {
            return PropertyGetNodeFactory.GetPropertyFromJSObjectNodeGen.create(key, isRequired);
        }

        @Specialization(limit="2", guards={"cachedClass == getJSClass(object)"})
        protected Object doJSObjectCached(DynamicObject object, Object receiver, Object defaultValue, PropertyGetNode root, @Cached(value="getJSClass(object)") JSClass cachedClass) {
            return this.getPropertyFromJSObjectIntl(cachedClass, object, receiver, defaultValue, root);
        }

        @Specialization(replaces={"doJSObjectCached"})
        protected Object doJSObjectDirect(DynamicObject object, Object receiver, Object defaultValue, PropertyGetNode root) {
            return this.getPropertyFromJSObjectIntl(JSObject.getJSClass(object), object, receiver, defaultValue, root);
        }

        protected JSClass getJSClass(DynamicObject object) {
            return JSObject.getJSClass(object);
        }

        private Object getPropertyFromJSObjectIntl(JSClass jsclass, DynamicObject object, Object receiver, Object defaultValue, PropertyGetNode root) {
            Object value;
            boolean isMethod = root.isMethod();
            assert (!(this.key instanceof HiddenKey));
            if (jsclass == Null.NULL_CLASS) {
                this.nullOrUndefinedBranch.enter();
                throw Errors.createTypeErrorCannotGetProperty(this.key, object, isMethod, this);
            }
            Object object2 = value = isMethod ? jsclass.getMethodHelper(object, receiver, this.key) : jsclass.getHelper(object, receiver, this.key);
            if (value != null) {
                return value;
            }
            this.fallbackBranch.enter();
            return this.getNoSuchProperty(object, defaultValue, root);
        }

        protected Object getNoSuchProperty(DynamicObject thisObj, Object defaultValue, PropertyGetNode root) {
            if (root.getContext().isOptionNashornCompatibilityMode() && (!root.getContext().getNoSuchPropertyUnusedAssumption().isValid() || root.isMethod() && !root.getContext().getNoSuchMethodUnusedAssumption().isValid())) {
                return this.getNoSuchPropertySlow(thisObj, defaultValue, root.isMethod());
            }
            return this.getFallback(defaultValue);
        }

        @CompilerDirectives.TruffleBoundary
        private Object getNoSuchPropertySlow(DynamicObject thisObj, Object defaultValue, boolean isMethod) {
            if (!(this.key instanceof Symbol) && JSRuntime.isObject(thisObj) && !JSAdapter.isJSAdapter(thisObj) && !JSProxy.isProxy(thisObj)) {
                Object function;
                if (isMethod && (function = JSObject.get(thisObj, (Object)"__noSuchMethod__")) != Undefined.instance) {
                    if (JSFunction.isJSFunction(function)) {
                        return this.callNoSuchHandler(thisObj, (DynamicObject)function, false);
                    }
                    return this.getFallback(defaultValue);
                }
                function = JSObject.get(thisObj, (Object)"__noSuchProperty__");
                if (JSFunction.isJSFunction(function)) {
                    return this.callNoSuchHandler(thisObj, (DynamicObject)function, true);
                }
            }
            return this.getFallback(defaultValue);
        }

        private Object callNoSuchHandler(DynamicObject thisObj, DynamicObject function, boolean noSuchProperty) {
            DynamicObject thisObject;
            DynamicObject dynamicObject = thisObject = this.isGlobal() ? Undefined.instance : thisObj;
            if (noSuchProperty) {
                return JSFunction.call(function, thisObject, new Object[]{this.key});
            }
            return new JSNoSuchMethodAdapter(function, this.key, thisObject);
        }

        protected boolean isGlobal() {
            return this.isRequired;
        }

        protected Object getFallback(Object defaultValue) {
            if (this.isRequired) {
                throw Errors.createReferenceErrorNotDefined(this.key, this);
            }
            return defaultValue;
        }
    }

    @NodeInfo(cost=NodeCost.MEGAMORPHIC)
    public static class GenericPropertyGetNode
    extends GetCacheNode {
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private ForeignPropertyGetNode foreignGetNode;
        @Node.Child
        private GetPropertyFromJSObjectNode getFromJSObjectNode;
        private final ConditionProfile isJSObject = ConditionProfile.createBinaryProfile();
        private final ConditionProfile isForeignObject = ConditionProfile.createBinaryProfile();
        private final BranchProfile notAJSObjectBranch = BranchProfile.create();
        private final BranchProfile fallbackBranch = BranchProfile.create();

        public GenericPropertyGetNode() {
            super(null);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueOrDefault(thisObj, receiver, Undefined.instance, root, guard);
        }

        @Override
        protected Object getValueOrDefault(Object thisObj, Object receiver, Object defaultValue, PropertyGetNode root, boolean guard) {
            if (this.isJSObject.profile(JSObject.isJSObject(thisObj))) {
                return this.getPropertyFromJSObject((DynamicObject)thisObj, receiver, defaultValue, root);
            }
            if (this.isForeignObject.profile(JSGuards.isForeignObject(thisObj))) {
                if (this.foreignGetNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.foreignGetNode = (ForeignPropertyGetNode)this.insert(new ForeignPropertyGetNode(root.getKey(), root.isMethod(), root.isGlobal(), root.getContext()));
                }
                return this.foreignGetNode.getValue(thisObj, receiver, root, guard);
            }
            if (this.toObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toObjectNode = (JSToObjectNode)this.insert(JSToObjectNode.createToObjectNoCheck(root.getContext()));
            }
            DynamicObject object = JSRuntime.expectJSObject(this.toObjectNode.executeTruffleObject(thisObj), this.notAJSObjectBranch);
            return this.getPropertyFromJSObject(object, receiver, defaultValue, root);
        }

        private Object getPropertyFromJSObject(DynamicObject thisObj, Object receiver, Object defaultValue, PropertyGetNode root) {
            if (root.getKey() instanceof HiddenKey) {
                Object result = thisObj.get(root.getKey());
                if (result != null) {
                    return result;
                }
                this.fallbackBranch.enter();
                return this.getFallback(thisObj, root);
            }
            if (this.getFromJSObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getFromJSObjectNode = (GetPropertyFromJSObjectNode)this.insert(GetPropertyFromJSObjectNode.create(root.getKey(), root.isRequired()));
            }
            return this.getFromJSObjectNode.executeWithJSObject(thisObj, receiver, defaultValue, root);
        }

        protected Object getFallback(DynamicObject thisObj, PropertyGetNode root) {
            if (root.isRequired()) {
                throw Errors.createReferenceErrorNotDefined(root.getKey(), this);
            }
            return Undefined.instance;
        }
    }

    public static final class ForeignPropertyGetNode
    extends LinkedPropertyGetNode {
        @Node.Child
        private JSForeignToJSTypeNode toJSTypeNode;
        @Node.Child
        private ForeignObjectPrototypeNode foreignObjectPrototypeNode;
        @Node.Child
        private PropertyGetNode getFromPrototypeNode;
        private final boolean isLength;
        private final boolean isMethod;
        private final boolean isGlobal;
        @CompilerDirectives.CompilationFinal
        private boolean optimistic = true;
        private final JSContext context;
        @Node.Child
        private InteropLibrary interop;
        @Node.Child
        private InteropLibrary getterInterop;

        public ForeignPropertyGetNode(Object key, boolean isMethod, boolean isGlobal, JSContext context) {
            super(new PropertyCacheNode.ForeignLanguageCheckNode());
            this.context = context;
            this.toJSTypeNode = JSForeignToJSTypeNodeGen.create();
            this.isLength = key.equals("length");
            this.isMethod = isMethod;
            this.isGlobal = isGlobal;
            this.interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        }

        private Object foreignGet(TruffleObject thisObj, PropertyGetNode root) {
            Object foreignResult;
            Object key = root.getKey();
            if (this.interop.isNull((Object)thisObj)) {
                throw Errors.createTypeErrorCannotGetProperty(key, thisObj, this.isMethod, this);
            }
            if (!(key instanceof String)) {
                return Undefined.instance;
            }
            String stringKey = (String)key;
            if (this.optimistic) {
                try {
                    foreignResult = this.interop.readMember((Object)thisObj, stringKey);
                }
                catch (UnknownIdentifierException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.optimistic = false;
                    if (this.context.isOptionNashornCompatibilityMode()) {
                        foreignResult = this.tryInvokeGetter(thisObj, root);
                    }
                    return this.maybeGetFromPrototype(thisObj, key);
                }
                catch (UnsupportedMessageException e) {
                    return this.maybeGetFromPrototype(thisObj, key);
                }
            } else if (this.interop.isMemberReadable((Object)thisObj, stringKey)) {
                try {
                    foreignResult = this.interop.readMember((Object)thisObj, stringKey);
                }
                catch (UnknownIdentifierException | UnsupportedMessageException e) {
                    return Undefined.instance;
                }
            } else if (this.context.isOptionNashornCompatibilityMode()) {
                foreignResult = this.tryInvokeGetter(thisObj, root);
            } else {
                return this.maybeGetFromPrototype(thisObj, key);
            }
            return this.toJSTypeNode.executeWithTarget(foreignResult);
        }

        private Object maybeGetFromPrototype(TruffleObject thisObj, Object key) {
            if (this.context.getContextOptions().hasForeignObjectPrototype()) {
                if (this.getFromPrototypeNode == null || this.foreignObjectPrototypeNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getFromPrototypeNode = (PropertyGetNode)this.insert(PropertyGetNode.create(key, this.context));
                    this.foreignObjectPrototypeNode = (ForeignObjectPrototypeNode)this.insert(ForeignObjectPrototypeNode.create());
                }
                assert (key.equals(this.getFromPrototypeNode.getKey()));
                DynamicObject prototype = this.foreignObjectPrototypeNode.executeDynamicObject(thisObj);
                return this.getFromPrototypeNode.getValue(prototype);
            }
            return Undefined.instance;
        }

        private Object tryInvokeGetter(TruffleObject thisObj, PropertyGetNode root) {
            assert (this.context.isOptionNashornCompatibilityMode());
            TruffleLanguage.Env env = this.context.getRealm().getEnv();
            if (env.isHostObject((Object)thisObj)) {
                Object result = this.tryGetResult(thisObj, "get", root);
                if (result != null) {
                    return result;
                }
                result = this.tryGetResult(thisObj, "is", root);
                if (result != null) {
                    return result;
                }
            }
            return this.maybeGetFromPrototype(thisObj, root.getKey());
        }

        private Object tryGetResult(TruffleObject thisObj, String prefix, PropertyGetNode root) {
            String getterKey = root.getAccessorKey(prefix);
            if (getterKey == null) {
                return null;
            }
            if (this.getterInterop == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getterInterop = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(3));
            }
            if (!this.getterInterop.isMemberInvocable((Object)thisObj, getterKey)) {
                return null;
            }
            try {
                return this.getterInterop.invokeMember((Object)thisObj, getterKey, JSArguments.EMPTY_ARGUMENTS_ARRAY);
            }
            catch (UnknownIdentifierException e) {
                return null;
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                return Undefined.instance;
            }
        }

        private Object getSize(TruffleObject thisObj) {
            try {
                return JSRuntime.longToIntOrDouble(this.interop.getArraySize((Object)thisObj));
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(thisObj, (InteropException)((Object)e), "getArraySize", this);
            }
        }

        @Override
        protected Object getValue(Object object, Object receiver, PropertyGetNode root, boolean guard) {
            TruffleObject thisObj = (TruffleObject)object;
            if (this.isMethod && !this.isGlobal) {
                return thisObj;
            }
            if (this.isLength && this.interop.hasArrayElements((Object)thisObj)) {
                return this.getSize(thisObj);
            }
            return this.foreignGet(thisObj, root);
        }
    }

    public static final class UnspecializedPropertyGetNode
    extends LinkedPropertyGetNode {
        public UnspecializedPropertyGetNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return JSObject.get((DynamicObject)thisObj, root.getKey());
        }
    }

    public static final class JSAdapterPropertyGetNode
    extends LinkedPropertyGetNode {
        public JSAdapterPropertyGetNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            Object key = root.getKey();
            if (root.isMethod()) {
                return JSObject.getMethod((DynamicObject)thisObj, key);
            }
            return JSObject.get((DynamicObject)thisObj, key);
        }
    }

    public static final class JSProxyDispatcherRequiredPropertyGetNode
    extends LinkedPropertyGetNode {
        @Node.Child
        private JSProxyPropertyGetNode proxyGet;
        @Node.Child
        private JSProxyHasPropertyNode proxyHas;

        public JSProxyDispatcherRequiredPropertyGetNode(JSContext context, Object key, PropertyCacheNode.ReceiverCheckNode receiverCheck, boolean isMethod) {
            super(receiverCheck);
            this.proxyGet = JSProxyPropertyGetNode.create(context);
            this.proxyHas = JSProxyHasPropertyNode.create(context);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            Object key = root.getKey();
            DynamicObject proxy = this.receiverCheck.getStore(thisObj);
            if (this.proxyHas.executeWithTargetAndKeyBoolean(proxy, key)) {
                return this.proxyGet.executeWithReceiver(proxy, receiver, key);
            }
            throw Errors.createReferenceErrorNotDefined(key, this);
        }
    }

    public static final class JSProxyDispatcherPropertyGetNode
    extends LinkedPropertyGetNode {
        @Node.Child
        private JSProxyPropertyGetNode proxyGet;

        public JSProxyDispatcherPropertyGetNode(JSContext context, Object key, PropertyCacheNode.ReceiverCheckNode receiverCheck, boolean isMethod) {
            super(receiverCheck);
            this.proxyGet = JSProxyPropertyGetNode.create(context);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.proxyGet.executeWithReceiver(this.receiverCheck.getStore(thisObj), receiver, root.getKey());
        }
    }

    public static class JavaStringMethodGetNode
    extends LinkedPropertyGetNode {
        @Node.Child
        private InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);

        public JavaStringMethodGetNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            String thisStr = (String)thisObj;
            if (root.getKey() instanceof String) {
                Object boxedString = root.getContext().getRealm().getEnv().asBoxedGuestValue((Object)thisStr);
                try {
                    return this.interop.readMember(boxedString, (String)root.getKey());
                }
                catch (UnknownIdentifierException | UnsupportedMessageException throwable) {
                    // empty catch block
                }
            }
            return Undefined.instance;
        }
    }

    public static final class JavaPackagePropertyGetNode
    extends LinkedPropertyGetNode {
        public JavaPackagePropertyGetNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            Object key = root.getKey();
            if (key instanceof String) {
                return JavaPackage.getJavaClassOrConstructorOrSubPackage(root.getContext(), (DynamicObject)thisObj, (String)key);
            }
            return Undefined.instance;
        }
    }

    public static final class TypeErrorPropertyGetNode
    extends LinkedPropertyGetNode {
        public TypeErrorPropertyGetNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            assert (thisObj == Undefined.instance || thisObj == Null.instance || thisObj == null) : thisObj;
            throw Errors.createTypeErrorCannotGetProperty(root.getKey(), thisObj, root.isMethod(), this);
        }
    }

    public static final class CheckNoSuchPropertyNode
    extends LinkedPropertyGetNode {
        private final JSContext context;
        @Node.Child
        private PropertyGetNode getNoSuchPropertyNode;
        @Node.Child
        private PropertyGetNode getNoSuchMethodNode;
        @Node.Child
        private JSHasPropertyNode hasPropertyNode;
        @Node.Child
        private JSFunctionCallNode callNoSuchNode;

        public CheckNoSuchPropertyNode(Object key, PropertyCacheNode.ReceiverCheckNode receiverCheck, JSContext context) {
            super(receiverCheck);
            this.context = context;
            assert (!(key instanceof Symbol));
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            if (JSRuntime.isObject(thisObj) && !JSAdapter.isJSAdapter(thisObj) && !JSProxy.isProxy(thisObj)) {
                Object function;
                if (!this.context.getNoSuchMethodUnusedAssumption().isValid() && root.isMethod() && this.getHasProperty().executeBoolean(thisObj, "__noSuchMethod__") && (function = this.getNoSuchMethod().getValue(thisObj)) != Undefined.instance) {
                    if (JSFunction.isJSFunction(function)) {
                        return this.callNoSuchHandler((DynamicObject)thisObj, (DynamicObject)function, root, false);
                    }
                    return this.getFallback(root);
                }
                if (!this.context.getNoSuchPropertyUnusedAssumption().isValid() && JSFunction.isJSFunction(function = this.getNoSuchProperty().getValue(thisObj))) {
                    return this.callNoSuchHandler((DynamicObject)thisObj, (DynamicObject)function, root, true);
                }
            }
            return this.getFallback(root);
        }

        private Object callNoSuchHandler(DynamicObject thisObj, DynamicObject function, PropertyGetNode root, boolean noSuchProperty) {
            DynamicObject thisObject;
            DynamicObject dynamicObject = thisObject = root.isGlobal() ? Undefined.instance : thisObj;
            if (noSuchProperty) {
                return this.getCallNoSuch().executeCall(JSArguments.createOneArg(thisObject, function, root.getKey()));
            }
            return new JSNoSuchMethodAdapter(function, root.getKey(), thisObject);
        }

        private Object getFallback(PropertyGetNode root) {
            if (root.isGlobal()) {
                throw Errors.createReferenceErrorNotDefined(root.getKey(), this);
            }
            return Undefined.instance;
        }

        public PropertyGetNode getNoSuchProperty() {
            if (this.getNoSuchPropertyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getNoSuchPropertyNode = (PropertyGetNode)this.insert(PropertyGetNode.create("__noSuchProperty__", this.context));
            }
            return this.getNoSuchPropertyNode;
        }

        public PropertyGetNode getNoSuchMethod() {
            if (this.getNoSuchMethodNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getNoSuchMethodNode = (PropertyGetNode)this.insert(PropertyGetNode.create("__noSuchMethod__", this.context));
            }
            return this.getNoSuchMethodNode;
        }

        public JSHasPropertyNode getHasProperty() {
            if (this.hasPropertyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hasPropertyNode = (JSHasPropertyNode)this.insert(JSHasPropertyNode.create());
            }
            return this.hasPropertyNode;
        }

        public JSFunctionCallNode getCallNoSuch() {
            if (this.callNoSuchNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callNoSuchNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            }
            return this.callNoSuchNode;
        }
    }

    public static final class ArrayBufferViewNonIntegerIndexGetNode
    extends LinkedPropertyGetNode {
        public ArrayBufferViewNonIntegerIndexGetNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            if (JSArrayBufferView.hasDetachedBuffer((DynamicObject)thisObj)) {
                throw Errors.createTypeErrorDetachedBuffer();
            }
            return Undefined.instance;
        }
    }

    public static final class UndefinedPropertyErrorNode
    extends LinkedPropertyGetNode {
        public UndefinedPropertyErrorNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            throw Errors.createReferenceErrorNotDefined(root.getKey(), this);
        }
    }

    public static final class UndefinedPropertyGetNode
    extends LinkedPropertyGetNode {
        public UndefinedPropertyGetNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return Undefined.instance;
        }

        @Override
        protected Object getValueOrDefault(Object thisObj, Object receiver, Object defaultValue, PropertyGetNode root, boolean guard) {
            return defaultValue;
        }
    }

    public static final class FinalAccessorPropertyGetNode
    extends LinkedPropertyGetNode {
        @Node.Child
        private JSFunctionCallNode callNode;
        private final BranchProfile undefinedGetterBranch = BranchProfile.create();
        private final Accessor finalAccessor;
        private final Assumption finalAssumption;

        public FinalAccessorPropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck, Accessor finalAccessor) {
            super(receiverCheck);
            assert (JSProperty.isAccessor(property));
            this.callNode = JSFunctionCallNode.createCall();
            this.finalAccessor = finalAccessor;
            this.finalAssumption = property.getLocation().isFinal() ? null : property.getLocation().getFinalAssumption();
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            DynamicObject getter = this.finalAccessor.getGetter();
            if (getter != Undefined.instance) {
                return this.callNode.executeCall(JSArguments.createZeroArg(receiver, getter));
            }
            this.undefinedGetterBranch.enter();
            return Undefined.instance;
        }

        @Override
        protected boolean isValid() {
            return super.isValid() && (this.finalAssumption == null || this.finalAssumption.isValid());
        }
    }

    public static final class AccessorPropertyGetNode
    extends LinkedPropertyGetNode {
        private final Property property;
        @Node.Child
        private JSFunctionCallNode callNode;
        private final BranchProfile undefinedGetterBranch = BranchProfile.create();

        public AccessorPropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
            assert (JSProperty.isAccessor(property));
            this.property = property;
            this.callNode = JSFunctionCallNode.createCall();
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            DynamicObject store = this.receiverCheck.getStore(thisObj);
            Accessor accessor = (Accessor)this.property.get(store, guard);
            DynamicObject getter = accessor.getGetter();
            if (getter != Undefined.instance) {
                return this.callNode.executeCall(JSArguments.createZeroArg(receiver, getter));
            }
            this.undefinedGetterBranch.enter();
            return Undefined.instance;
        }
    }

    public static final class FinalLongPropertyGetNode
    extends AbstractFinalDataPropertyGetNode {
        private final long finalValue;

        public FinalLongPropertyGetNode(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheck, long value) {
            super(property, shapeCheck);
            assert (JSProperty.isData(property));
            this.finalValue = value;
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueLong(thisObj, receiver, root, guard);
        }

        @Override
        protected long getValueLong(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            assert (this.assertFinalValue(this.finalValue, thisObj, root));
            return this.finalValue;
        }
    }

    public static final class LongPropertyGetNode
    extends LinkedPropertyGetNode {
        private final LongLocation location;

        public LongPropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
            assert (JSProperty.isData(property));
            this.location = (LongLocation)property.getLocation();
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.location.getLong(this.receiverCheck.getStore(thisObj), guard);
        }

        @Override
        protected long getValueLong(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.location.getLong(this.receiverCheck.getStore(thisObj), guard);
        }
    }

    public static final class FinalBooleanPropertyGetNode
    extends AbstractFinalDataPropertyGetNode {
        private final boolean finalValue;

        public FinalBooleanPropertyGetNode(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheck, boolean value) {
            super(property, shapeCheck);
            assert (JSProperty.isData(property));
            this.finalValue = value;
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueBoolean(thisObj, receiver, root, guard);
        }

        @Override
        protected boolean getValueBoolean(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            assert (this.assertFinalValue(this.finalValue, thisObj, root));
            return this.finalValue;
        }
    }

    public static final class BooleanPropertyGetNode
    extends LinkedPropertyGetNode {
        private final BooleanLocation location;

        public BooleanPropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
            assert (JSProperty.isData(property));
            this.location = (BooleanLocation)property.getLocation();
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueBoolean(thisObj, receiver, root, guard);
        }

        @Override
        protected boolean getValueBoolean(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.location.getBoolean(this.receiverCheck.getStore(thisObj), guard);
        }
    }

    public static final class FinalDoublePropertyGetNode
    extends AbstractFinalDataPropertyGetNode {
        private final double finalValue;

        public FinalDoublePropertyGetNode(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheck, double value) {
            super(property, shapeCheck);
            assert (JSProperty.isData(property));
            this.finalValue = value;
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueDouble(thisObj, receiver, root, guard);
        }

        @Override
        protected double getValueDouble(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            assert (this.assertFinalValue(this.finalValue, thisObj, root));
            return this.finalValue;
        }
    }

    public static final class DoublePropertyGetNode
    extends LinkedPropertyGetNode {
        private final DoubleLocation location;

        public DoublePropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
            assert (JSProperty.isData(property));
            this.location = (DoubleLocation)property.getLocation();
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.location.getDouble(this.receiverCheck.getStore(thisObj), guard);
        }

        @Override
        protected double getValueDouble(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.location.getDouble(this.receiverCheck.getStore(thisObj), guard);
        }
    }

    public static final class FinalIntPropertyGetNode
    extends AbstractFinalDataPropertyGetNode {
        private final int finalValue;

        public FinalIntPropertyGetNode(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheck, int value) {
            super(property, shapeCheck);
            assert (JSProperty.isData(property));
            this.finalValue = value;
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueInt(thisObj, receiver, root, guard);
        }

        @Override
        protected int getValueInt(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            assert (this.assertFinalValue(this.finalValue, thisObj, root));
            return this.finalValue;
        }

        @Override
        protected double getValueDouble(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.getValueInt(thisObj, receiver, root, guard);
        }
    }

    public static final class IntPropertyGetNode
    extends LinkedPropertyGetNode {
        private final IntLocation location;

        public IntPropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
            assert (JSProperty.isData(property));
            this.location = (IntLocation)property.getLocation();
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.location.getInt(this.receiverCheck.getStore(thisObj), guard);
        }

        @Override
        protected int getValueInt(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.location.getInt(this.receiverCheck.getStore(thisObj), guard);
        }

        @Override
        protected double getValueDouble(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return this.location.getInt(this.receiverCheck.getStore(thisObj), guard);
        }
    }

    public static final class FinalObjectPropertyGetNode
    extends AbstractFinalDataPropertyGetNode {
        private final Object finalValue;

        public FinalObjectPropertyGetNode(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheck, Object value) {
            super(property, shapeCheck);
            assert (JSProperty.isData(property));
            this.finalValue = value;
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            assert (this.assertFinalValue(this.finalValue, thisObj, root));
            return this.finalValue;
        }
    }

    protected static abstract class AbstractFinalDataPropertyGetNode
    extends LinkedPropertyGetNode {
        private final Assumption finalAssumption;

        protected AbstractFinalDataPropertyGetNode(Property property, PropertyCacheNode.AbstractShapeCheckNode shapeCheck) {
            super(shapeCheck);
            this.finalAssumption = property.getLocation().isFinal() ? null : property.getLocation().getFinalAssumption();
        }

        @Override
        protected boolean isValid() {
            return super.isValid() && (this.finalAssumption == null || this.finalAssumption.isValid());
        }

        protected final boolean assertFinalValue(Object finalValue, Object thisObj, PropertyGetNode root) {
            if (!JSTruffleOptions.AssertFinalPropertySpecialization) {
                return true;
            }
            int depth = ((PropertyCacheNode.AbstractShapeCheckNode)this.receiverCheck).getDepth();
            DynamicObject store = (DynamicObject)thisObj;
            for (int i = 0; i < depth; ++i) {
                store = JSObject.getPrototype(store);
            }
            return finalValue.equals(store.get(root.getKey()));
        }
    }

    public static final class ObjectPropertyGetNode
    extends LinkedPropertyGetNode {
        private final Property property;

        public ObjectPropertyGetNode(Property property, PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
            assert (JSProperty.isData(property));
            this.property = property;
        }

        @Override
        protected Object getValue(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) {
            return JSProperty.getValue(this.property, this.receiverCheck.getStore(thisObj), receiver, guard);
        }
    }

    public static abstract class LinkedPropertyGetNode
    extends GetCacheNode {
        protected LinkedPropertyGetNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }
    }

    public static abstract class GetCacheNode
    extends PropertyCacheNode.CacheNode<GetCacheNode> {
        protected GetCacheNode(PropertyCacheNode.ReceiverCheckNode receiverCheck) {
            super(receiverCheck);
        }

        protected abstract Object getValue(Object var1, Object var2, PropertyGetNode var3, boolean var4);

        protected Object getValueOrDefault(Object thisObj, Object receiver, Object defaultValue, PropertyGetNode root, boolean guard) {
            return this.getValue(thisObj, receiver, root, guard);
        }

        protected int getValueInt(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) throws UnexpectedResultException {
            return JSTypesGen.expectInteger(this.getValue(thisObj, receiver, root, guard));
        }

        protected double getValueDouble(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) throws UnexpectedResultException {
            return JSTypesGen.expectDouble(this.getValue(thisObj, receiver, root, guard));
        }

        protected boolean getValueBoolean(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) throws UnexpectedResultException {
            return JSTypesGen.expectBoolean(this.getValue(thisObj, receiver, root, guard));
        }

        protected long getValueLong(Object thisObj, Object receiver, PropertyGetNode root, boolean guard) throws UnexpectedResultException {
            return JSTypesGen.expectLong(this.getValue(thisObj, receiver, root, guard));
        }
    }
}

