/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteCurrentFrameSlotNodeGen;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.LargeInteger;

abstract class JSWriteCurrentFrameSlotNode
extends JSWriteFrameSlotNode {
    @Node.Child
    @Executed
    JavaScriptNode rhsNode;

    protected JSWriteCurrentFrameSlotNode(FrameSlot frameSlot, JavaScriptNode rhsNode) {
        super(frameSlot);
        this.rhsNode = rhsNode;
    }

    @Specialization(guards={"isBooleanKind(frame)"})
    protected final boolean doBoolean(VirtualFrame frame, boolean value) {
        frame.setBoolean(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"isIntegerKind(frame)"})
    protected final int doInteger(VirtualFrame frame, int value) {
        frame.setInt(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"isLongKind(frame)"})
    protected final int doLargeIntegerInt(VirtualFrame frame, int value) {
        frame.setLong(this.frameSlot, (long)value);
        return value;
    }

    @Specialization(guards={"isLongKind(frame)"})
    protected final LargeInteger doLargeInteger(VirtualFrame frame, LargeInteger value) {
        frame.setLong(this.frameSlot, value.longValue());
        return value;
    }

    @Specialization(guards={"ensureObjectKind(frame)"})
    protected final long doLong(VirtualFrame frame, long value) {
        frame.setObject(this.frameSlot, (Object)value);
        return value;
    }

    @Specialization(guards={"isDoubleKind(frame)"}, replaces={"doInteger", "doLargeInteger", "doLargeIntegerInt"})
    protected final double doDouble(VirtualFrame frame, double value) {
        frame.setDouble(this.frameSlot, value);
        return value;
    }

    @Specialization(guards={"ensureObjectKind(frame)"}, replaces={"doBoolean", "doInteger", "doDouble", "doLargeInteger", "doLargeIntegerInt", "doLong"})
    protected final Object doObject(VirtualFrame frame, Object value) {
        frame.setObject(this.frameSlot, value);
        return value;
    }

    @Override
    public final Object executeWithFrame(Frame frame, Object value) {
        return this.executeEvaluated((VirtualFrame)frame, value);
    }

    abstract Object executeEvaluated(VirtualFrame var1, Object var2);

    @Override
    public final Object executeWrite(VirtualFrame frame, Object value) {
        return this.executeEvaluated(frame, value);
    }

    @Override
    public JavaScriptNode getRhs() {
        return this.rhsNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return JSWriteCurrentFrameSlotNodeGen.create(this.frameSlot, JSWriteCurrentFrameSlotNode.cloneUninitialized(this.getRhs()));
    }

    @Override
    public ScopeFrameNode getLevelFrameNode() {
        return ScopeFrameNode.create(0);
    }
}

