/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IteratorGetNextValueNode;
import com.oracle.truffle.js.nodes.access.IteratorToArrayNodeGen;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import java.util.ArrayList;

public abstract class IteratorToArrayNode
extends JavaScriptNode {
    private final JSContext context;
    @Node.Child
    @Executed
    JavaScriptNode iteratorNode;
    @Node.Child
    private IteratorGetNextValueNode iteratorStepNode;

    protected IteratorToArrayNode(JSContext context, JavaScriptNode iteratorNode, IteratorGetNextValueNode iteratorStepNode) {
        this.context = context;
        this.iteratorNode = iteratorNode;
        this.iteratorStepNode = iteratorStepNode;
    }

    public static IteratorToArrayNode create(JSContext context, JavaScriptNode iterator) {
        IteratorGetNextValueNode iteratorStep = IteratorGetNextValueNode.create(context, null, JSConstantNode.create(null), true);
        return IteratorToArrayNodeGen.create(context, iterator, iteratorStep);
    }

    @Specialization
    protected Object doIterator(VirtualFrame frame, IteratorRecord iteratorRecord) {
        Object value;
        ArrayList elements = new ArrayList();
        while ((value = this.iteratorStepNode.execute(frame, iteratorRecord)) != null) {
            Boundaries.listAdd(elements, value);
        }
        return JSArray.createZeroBasedObjectArray(this.context, Boundaries.listToArray(elements));
    }

    public abstract Object execute(VirtualFrame var1, IteratorRecord var2);

    @Override
    protected JavaScriptNode copyUninitialized() {
        return IteratorToArrayNodeGen.create(this.context, IteratorToArrayNode.cloneUninitialized(this.iteratorNode), IteratorToArrayNode.cloneUninitialized(this.iteratorStepNode));
    }
}

