/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.model.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class Utils {
    private static final String VALUE = "value";

    public static String getUriTemplate(Element element) {
        return Utils.getAnnotationValue(element, "javax.ws.rs.Path", VALUE);
    }

    public static String getConsumeMime(Element element) {
        return Utils.getAnnotationValue(element, "javax.ws.rs.Consumes", VALUE);
    }

    public static String getProduceMime(Element element) {
        return Utils.getAnnotationValue(element, "javax.ws.rs.Produces", VALUE);
    }

    static void fillQueryParams(Map<String, String> queryParams, Element element) {
        if (!(element instanceof ExecutableElement)) {
            return;
        }
        ExecutableElement method = (ExecutableElement)element;
        List<? extends VariableElement> parameters = method.getParameters();
        for (VariableElement variableElement : parameters) {
            String paramName = null;
            if (Utils.hasAnnotationType(variableElement, "javax.ws.rs.QueryParam")) {
                paramName = Utils.getAnnotationValue(variableElement, "javax.ws.rs.QueryParam", VALUE);
            }
            String defaultValue = null;
            if (Utils.hasAnnotationType(variableElement, "javax.ws.rs.DefaultValue")) {
                defaultValue = Utils.getAnnotationValue(variableElement, "javax.ws.rs.DefaultValue", VALUE);
            }
            if (paramName == null) continue;
            queryParams.put(paramName, defaultValue);
        }
    }

    public static String getApplicationPath(Element element) {
        return Utils.getAnnotationValue(element, "javax.ws.rs.ApplicationPath", VALUE);
    }

    public static String getHttpMethod(Element element) {
        if (Utils.hasAnnotationType(element, "javax.ws.rs.GET")) {
            return "GET";
        }
        if (Utils.hasAnnotationType(element, "javax.ws.rs.POST")) {
            return "POST";
        }
        if (Utils.hasAnnotationType(element, "javax.ws.rs.PUT")) {
            return "PUT";
        }
        if (Utils.hasAnnotationType(element, "javax.ws.rs.DELETE")) {
            return "DELETE";
        }
        return null;
    }

    public static boolean hasUriTemplate(Element element) {
        return Utils.hasAnnotationType(element, "javax.ws.rs.Path");
    }

    public static boolean hasHttpMethod(Element element) {
        return element.getKind() == ElementKind.METHOD && (Utils.hasAnnotationType(element, "javax.ws.rs.GET") || Utils.hasAnnotationType(element, "javax.ws.rs.POST") || Utils.hasAnnotationType(element, "javax.ws.rs.PUT") || Utils.hasAnnotationType(element, "javax.ws.rs.DELETE"));
    }

    public static boolean hasConsumeMime(Element element) {
        return Utils.hasAnnotationType(element, "javax.ws.rs.Consumes");
    }

    public static boolean hasProduceMime(Element element) {
        return Utils.hasAnnotationType(element, "javax.ws.rs.Produces");
    }

    private static String getAnnotationValue(Element element, String annotationType, String paramName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationType)) continue;
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!executableElement.getSimpleName().toString().equals(paramName)) continue;
                String value = annotationMirror.getElementValues().get(executableElement).toString();
                value = Utils.stripQuotes(value);
                return value;
            }
        }
        return "";
    }

    private static boolean hasAnnotationType(Element element, String annotationType) {
        if (element == null) {
            return false;
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    private static String stripQuotes(String value) {
        int lastIndex;
        int index = value.indexOf(34);
        if (index != -1 && (lastIndex = value.lastIndexOf(34)) != -1 && index != lastIndex) {
            return value.substring(index + 1, lastIndex);
        }
        return value;
    }

    static void checkForJsr311Bootstrap(TypeElement element, Project project, AnnotationModelHelper helper) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport == null || restSupport.isRestSupportOn()) {
            return;
        }
        if (Utils.isRest(element, helper)) {
            FileObject sourceFile = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)element), (ClasspathInfo)helper.getClasspathInfo());
            if (sourceFile == null) {
                return;
            }
            try {
                restSupport.ensureRestDevelopmentReady(RestSupport.RestConfig.IDE);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    static boolean isRest(TypeElement type, AnnotationModelHelper helper) {
        boolean isRest = false;
        if (type.getKind() != ElementKind.INTERFACE && !type.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            if (helper.hasAnnotation(type.getAnnotationMirrors(), "javax.ws.rs.Path")) {
                isRest = true;
            } else {
                for (Element element : type.getEnclosedElements()) {
                    if (!Utils.hasHttpMethod(element)) continue;
                    isRest = true;
                    break;
                }
            }
        }
        return isRest;
    }

    static boolean isProvider(TypeElement type, AnnotationModelHelper helper) {
        return type.getKind() != ElementKind.INTERFACE && helper.hasAnnotation(type.getAnnotationMirrors(), "javax.ws.rs.ext.Provider");
    }

    static boolean isRestApplication(TypeElement type, AnnotationModelHelper helper) {
        boolean isRest = false;
        if (type != null && type.getKind() != ElementKind.INTERFACE && helper.hasAnnotation(type.getAnnotationMirrors(), "javax.ws.rs.ApplicationPath")) {
            isRest = true;
        }
        return isRest;
    }
}

