//
//  MODCursor.h
//  MongoObjCDriver
//
//  Created by Jérôme Lebel on 11/09/2011.
//

#import <Foundation/Foundation.h>

@class MODCursor;
@class MODSortedMutableDictionary;

@interface MODCursor : NSObject
{
    MODCollection                       *_mongoCollection;
    MODSortedMutableDictionary          *_query;
    NSArray                             *_fields;
    uint32_t                            _skip;
    uint32_t                            _limit;
    uint32_t                            _batchSize;
    MODSortedMutableDictionary          *_sort;
    NSError                             *_internalError;

    void                                *_mongocCursor;
    BOOL                                _tailable;
}

@property (nonatomic, readonly, strong) NSError *error;

- (MODQuery *)forEachDocumentWithCallbackDocumentCallback:(BOOL (^)(uint64_t index, MODSortedMutableDictionary *document))documentCallback endCallback:(void (^)(uint64_t documentCounts, BOOL cursorStopped, MODQuery *mongoQuery))endCallback;

@property(nonatomic, readonly, retain) MODCollection *mongoCollection;
@property(nonatomic, readonly, retain) MODSortedMutableDictionary *query;
@property(nonatomic, readonly, retain) NSArray *fields;
@property(nonatomic, readonly, assign) uint32_t skip;
@property(nonatomic, readonly, assign) uint32_t limit;
@property(nonatomic, readonly, retain) MODSortedMutableDictionary * sort;
@property(nonatomic, readwrite, assign) BOOL tailable;

@end
