/*
  Copyright (C) 2006, 2007 Sony Computer Entertainment Inc.
  All rights reserved.

  Redistribution and use in source and binary forms,
  with or without modification, are permitted provided that the
  following conditions are met:
   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the Sony Computer Entertainment Inc nor the names
     of its contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
*/

#define _VECTORMATH_SOA_TEST

#include "vectormath_soa.h"
#include "test.h"

int iteration = 0;

void
Matrix3_methods_test()
{
    VmathSoaMatrix3 a_Matrix3, b_Matrix3;
    VmathSoaMatrix4 a_Matrix4, b_Matrix4;
    VmathSoaTransform3 a_Transform3, b_Transform3;
    VmathSoaVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3;
    VmathSoaVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4;
    VmathSoaPoint3 a_Point3, b_Point3, c_Point3, d_Point3;
    VmathSoaQuat a_Quat, b_Quat, c_Quat, d_Quat, tmpQ_0;
    VmathSoaVector3 tmpV3_0, tmpV3_1, tmpV3_2, tmpV3_3, tmpV3_4, tmpV3_5, tmpV3_6, tmpV3_7, tmpV3_8, tmpV3_9, tmpV3_10, tmpV3_11, tmpV3_12, tmpV3_13;
    vec_float4 rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaV3MakeFromElems( &b_Vector3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &c_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &d_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathSoaV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &c_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &d_Vector3, "set Vector3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaV4MakeFromElems( &b_Vector4, rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &c_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &d_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &c_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &d_Vector4, "set Vector4 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaP3MakeFromElems( &b_Point3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &c_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &d_Point3, rndflt1, rndflt2, rndflt3 );
    vmathSoaP3Prints( &a_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &b_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &c_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &d_Point3, "set Point3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaQMakeFromElems( &b_Quat, rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &c_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &d_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaQPrints( &a_Quat, "set Quat with floats" );
    vmathSoaQPrints( &b_Quat, "set Quat with floats" );
    vmathSoaQPrints( &c_Quat, "set Quat with floats" );
    vmathSoaQPrints( &d_Quat, "set Quat with floats" );
    vmathSoaM3MakeFromCols( &a_Matrix3, &a_Vector3, &b_Vector3, &c_Vector3 );
    vmathSoaM3MakeFromCols( &b_Matrix3, &d_Vector3, &a_Vector3, &b_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "set Matrix3 columns" );
    vmathSoaM3Prints( &b_Matrix3, "set Matrix3 columns" );
    vmathSoaM4MakeFromCols( &a_Matrix4, &a_Vector4, &b_Vector4, &c_Vector4, &d_Vector4 );
    vmathSoaM4MakeFromCols( &b_Matrix4, &d_Vector4, &a_Vector4, &b_Vector4, &c_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "set Matrix4 columns" );
    vmathSoaM4Prints( &b_Matrix4, "set Matrix4 columns" );
    vmathSoaT3MakeFromCols( &a_Transform3, &a_Vector3, &b_Vector3, &c_Vector3, &d_Vector3 );
    vmathSoaT3MakeFromCols( &b_Transform3, &d_Vector3, &a_Vector3, &b_Vector3, &c_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "set Transform3 columns" );
    vmathSoaT3Prints( &b_Transform3, "set Transform3 columns" );
    vmathSoaQNormalize( &tmpQ_0, &a_Quat );
    vmathSoaM3MakeFromQ( &a_Matrix3, &tmpQ_0 );
    vmathSoaM3Prints( &a_Matrix3, "construct Matrix3 with Quat" );
    vmathSoaQMakeFromM3( &a_Quat, &a_Matrix3 );
    vmathSoaQPrints( &a_Quat, "construct Quat with Matrix3" );
    vmathSoaM3Copy( &a_Matrix3, &b_Matrix3 );
    vmathSoaM3Prints( &a_Matrix3, "assign to Matrix3 from Matrix3" );
    vmathSoaM3MakeFromScalar( &a_Matrix3, randfloat() );
    vmathSoaM3Prints( &a_Matrix3, "set Matrix3 with float" );
    vmathSoaM3MakeFromScalar( &a_Matrix3, randfloat() );
    vmathSoaM3Prints( &a_Matrix3, "set Matrix3 with float" );
    vmathSoaM3MakeFromScalar( &a_Matrix3, (vec_float4){0.0f} );
    vmathSoaM3Prints( &a_Matrix3, "set elements to zero" );
    vmathSoaM3MakeIdentity( &a_Matrix3 );
    vmathSoaM3Prints( &a_Matrix3, "set to identity" );
    vmathSoaM3MakeRotationX( &a_Matrix3, randfloat() );
    vmathSoaM3Prints( &a_Matrix3, "set to rotationX" );
    vmathSoaM3MakeRotationY( &a_Matrix3, randfloat() );
    vmathSoaM3Prints( &a_Matrix3, "set to rotationY" );
    vmathSoaM3MakeRotationZ( &a_Matrix3, randfloat() );
    vmathSoaM3Prints( &a_Matrix3, "set to rotationZ" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &tmpV3_0, rndflt3, rndflt2, rndflt1 );
    vmathSoaM3MakeRotationZYX( &a_Matrix3, &tmpV3_0 );
    vmathSoaM3Prints( &a_Matrix3, "set to rotation from Z,Y,X angles" );
    vmathSoaV3Normalize( &tmpV3_1, &a_Vector3 );
    vmathSoaM3MakeRotationAxis( &a_Matrix3, randfloat(), &tmpV3_1 );
    vmathSoaM3Prints( &a_Matrix3, "set to rotation from axis angle" );
    vmathSoaM3SetCol0( &a_Matrix3, &a_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "Matrix3 set col 0" );
    vmathSoaM3SetCol1( &a_Matrix3, &a_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "Matrix3 set col 1" );
    vmathSoaM3SetCol2( &a_Matrix3, &a_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "Matrix3 set col 2" );
    vmathSoaM3GetCol0( &tmpV3_2, &a_Matrix3 );
    vmathSoaV3Prints( &tmpV3_2, "Matrix3 get col 0" );
    vmathSoaM3GetCol1( &tmpV3_3, &a_Matrix3 );
    vmathSoaV3Prints( &tmpV3_3, "Matrix3 get col 1" );
    vmathSoaM3GetCol2( &tmpV3_4, &a_Matrix3 );
    vmathSoaV3Prints( &tmpV3_4, "Matrix3 get col 2" );
    vmathSoaM3SetCol( &a_Matrix3, 0, &b_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "Matrix3 set col 0" );
    vmathSoaM3SetCol( &a_Matrix3, 1, &b_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "Matrix3 set col 1" );
    vmathSoaM3SetCol( &a_Matrix3, 2, &b_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "Matrix3 set col 2" );
    vmathSoaM3GetCol( &tmpV3_5, &a_Matrix3, 0 );
    vmathSoaV3Prints( &tmpV3_5, "Matrix3 get col 0" );
    vmathSoaM3GetCol( &tmpV3_6, &a_Matrix3, 1 );
    vmathSoaV3Prints( &tmpV3_6, "Matrix3 get col 1" );
    vmathSoaM3GetCol( &tmpV3_7, &a_Matrix3, 2 );
    vmathSoaV3Prints( &tmpV3_7, "Matrix3 get col 2" );
    vmathSoaM3SetRow( &a_Matrix3, 0, &a_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "Matrix3 set row 0" );
    vmathSoaM3SetRow( &a_Matrix3, 1, &a_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "Matrix3 set row 1" );
    vmathSoaM3SetRow( &a_Matrix3, 2, &a_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "Matrix3 set row 2" );
    vmathSoaM3GetRow( &tmpV3_8, &a_Matrix3, 0 );
    vmathSoaV3Prints( &tmpV3_8, "Matrix3 get row 0" );
    vmathSoaM3GetRow( &tmpV3_9, &a_Matrix3, 1 );
    vmathSoaV3Prints( &tmpV3_9, "Matrix3 get row 1" );
    vmathSoaM3GetRow( &tmpV3_10, &a_Matrix3, 2 );
    vmathSoaV3Prints( &tmpV3_10, "Matrix3 get row 2" );
    vmathSoaM3SetCol( &a_Matrix3, 0, &a_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "set " );
    vmathSoaM3SetCol( &a_Matrix3, 1, &a_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "set " );
    vmathSoaM3SetCol( &a_Matrix3, 2, &a_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "set " );
    vmathSoaM3GetCol( &tmpV3_11, &a_Matrix3, 0 );
    vmathSoaV3Prints( &tmpV3_11, "get " );
    vmathSoaM3GetCol( &tmpV3_12, &a_Matrix3, 1 );
    vmathSoaV3Prints( &tmpV3_12, "get " );
    vmathSoaM3GetCol( &tmpV3_13, &a_Matrix3, 2 );
    vmathSoaV3Prints( &tmpV3_13, "get " );
    vmathSoaM3SetElem( &a_Matrix3, 0, 0, randfloat() );
    vmathSoaM3SetElem( &a_Matrix3, 0, 1, randfloat() );
    vmathSoaM3SetElem( &a_Matrix3, 0, 2, randfloat() );
    vmathSoaM3SetElem( &a_Matrix3, 1, 0, randfloat() );
    vmathSoaM3SetElem( &a_Matrix3, 1, 1, randfloat() );
    vmathSoaM3SetElem( &a_Matrix3, 1, 2, randfloat() );
    vmathSoaM3SetElem( &a_Matrix3, 2, 0, randfloat() );
    vmathSoaM3SetElem( &a_Matrix3, 2, 1, randfloat() );
    vmathSoaM3SetElem( &a_Matrix3, 2, 2, randfloat() );
    vmathSoaM3Prints( &a_Matrix3, "Matrix3 set elements" );
    printf("%f\n", getfloat(vmathSoaM3GetElem( &a_Matrix3, 0, 0 )) );
    printf("%f\n", getfloat(vmathSoaM3GetElem( &a_Matrix3, 0, 1 )) );
    printf("%f\n", getfloat(vmathSoaM3GetElem( &a_Matrix3, 0, 2 )) );
    printf("%f\n", getfloat(vmathSoaM3GetElem( &a_Matrix3, 1, 0 )) );
    printf("%f\n", getfloat(vmathSoaM3GetElem( &a_Matrix3, 1, 1 )) );
    printf("%f\n", getfloat(vmathSoaM3GetElem( &a_Matrix3, 1, 2 )) );
    printf("%f\n", getfloat(vmathSoaM3GetElem( &a_Matrix3, 2, 0 )) );
    printf("%f\n", getfloat(vmathSoaM3GetElem( &a_Matrix3, 2, 1 )) );
    printf("%f\n", getfloat(vmathSoaM3GetElem( &a_Matrix3, 2, 2 )) );
}

void
Matrix4_methods_test()
{
    VmathSoaMatrix3 a_Matrix3, b_Matrix3;
    VmathSoaMatrix4 a_Matrix4, b_Matrix4;
    VmathSoaTransform3 a_Transform3, b_Transform3;
    VmathSoaVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3;
    VmathSoaVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4;
    VmathSoaPoint3 a_Point3, b_Point3, c_Point3, d_Point3;
    VmathSoaQuat a_Quat, b_Quat, c_Quat, d_Quat;
    VmathSoaVector3 tmpV3_0, tmpV3_1;
    VmathSoaVector4 tmpV4_0, tmpV4_1, tmpV4_2, tmpV4_3, tmpV4_4, tmpV4_5, tmpV4_6, tmpV4_7, tmpV4_8, tmpV4_9, tmpV4_10, tmpV4_11, tmpV4_12, tmpV4_13, tmpV4_14, tmpV4_15;
    vec_float4 rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaV3MakeFromElems( &b_Vector3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &c_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &d_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathSoaV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &c_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &d_Vector3, "set Vector3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaV4MakeFromElems( &b_Vector4, rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &c_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &d_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &c_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &d_Vector4, "set Vector4 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaP3MakeFromElems( &b_Point3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &c_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &d_Point3, rndflt1, rndflt2, rndflt3 );
    vmathSoaP3Prints( &a_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &b_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &c_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &d_Point3, "set Point3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaQMakeFromElems( &b_Quat, rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &c_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &d_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaQPrints( &a_Quat, "set Quat with floats" );
    vmathSoaQPrints( &b_Quat, "set Quat with floats" );
    vmathSoaQPrints( &c_Quat, "set Quat with floats" );
    vmathSoaQPrints( &d_Quat, "set Quat with floats" );
    vmathSoaM3MakeFromCols( &a_Matrix3, &a_Vector3, &b_Vector3, &c_Vector3 );
    vmathSoaM3MakeFromCols( &b_Matrix3, &d_Vector3, &a_Vector3, &b_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "set Matrix3 columns" );
    vmathSoaM3Prints( &b_Matrix3, "set Matrix3 columns" );
    vmathSoaM4MakeFromCols( &a_Matrix4, &a_Vector4, &b_Vector4, &c_Vector4, &d_Vector4 );
    vmathSoaM4MakeFromCols( &b_Matrix4, &d_Vector4, &a_Vector4, &b_Vector4, &c_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "set Matrix4 columns" );
    vmathSoaM4Prints( &b_Matrix4, "set Matrix4 columns" );
    vmathSoaT3MakeFromCols( &a_Transform3, &a_Vector3, &b_Vector3, &c_Vector3, &d_Vector3 );
    vmathSoaT3MakeFromCols( &b_Transform3, &d_Vector3, &a_Vector3, &b_Vector3, &c_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "set Transform3 columns" );
    vmathSoaT3Prints( &b_Transform3, "set Transform3 columns" );
    vmathSoaM4MakeFromT3( &a_Matrix4, &a_Transform3 );
    vmathSoaM4Prints( &a_Matrix4, "construct Matrix4 with Transform3" );
    vmathSoaM4MakeFromM3V3( &a_Matrix4, &a_Matrix3, &a_Vector3 );
    vmathSoaM4Prints( &a_Matrix4, "construct Matrix4 with Matrix3 and Vector3" );
    vmathSoaM4MakeFromQV3( &a_Matrix4, &a_Quat, &a_Vector3 );
    vmathSoaM4Prints( &a_Matrix4, "construct Matrix4 with Quat and Vector3" );
    vmathSoaM4Copy( &a_Matrix4, &b_Matrix4 );
    vmathSoaM4Prints( &a_Matrix4, "assign to Matrix4 from Matrix4" );
    vmathSoaM4MakeFromScalar( &a_Matrix4, randfloat() );
    vmathSoaM4Prints( &a_Matrix4, "set Matrix4 with float" );
    vmathSoaM4MakeFromScalar( &a_Matrix4, randfloat() );
    vmathSoaM4Prints( &a_Matrix4, "set Matrix4 with float" );
    vmathSoaM4MakeFromScalar( &a_Matrix4, (vec_float4){0.0f} );
    vmathSoaM4Prints( &a_Matrix4, "set elements to zero" );
    vmathSoaM4MakeIdentity( &a_Matrix4 );
    vmathSoaM4Prints( &a_Matrix4, "set to identity" );
    vmathSoaM4MakeRotationX( &a_Matrix4, randfloat() );
    vmathSoaM4Prints( &a_Matrix4, "set to rotationX" );
    vmathSoaM4MakeRotationY( &a_Matrix4, randfloat() );
    vmathSoaM4Prints( &a_Matrix4, "set to rotationY" );
    vmathSoaM4MakeRotationZ( &a_Matrix4, randfloat() );
    vmathSoaM4Prints( &a_Matrix4, "set to rotationZ" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &tmpV3_0, rndflt3, rndflt2, rndflt1 );
    vmathSoaM4MakeRotationZYX( &a_Matrix4, &tmpV3_0 );
    vmathSoaM4Prints( &a_Matrix4, "set to rotation from Z,Y,X angles" );
    vmathSoaV3Normalize( &tmpV3_1, &a_Vector3 );
    vmathSoaM4MakeRotationAxis( &a_Matrix4, randfloat(), &tmpV3_1 );
    vmathSoaM4Prints( &a_Matrix4, "set to rotation from axis angle" );
    vmathSoaM4MakeTranslation( &a_Matrix4, &a_Vector3 );
    vmathSoaM4Prints( &a_Matrix4, "set to translation" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaM4MakePerspective( &a_Matrix4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaM4Prints( &a_Matrix4, "set to perspective matrix" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaM4MakeFrustum( &a_Matrix4, rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6 );
    vmathSoaM4Prints( &a_Matrix4, "set to frustum matrix" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaM4MakeOrthographic( &a_Matrix4, rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6 );
    vmathSoaM4Prints( &a_Matrix4, "set to orthographic matrix" );
    vmathSoaM4MakeLookAt( &a_Matrix4, &a_Point3, &b_Point3, &a_Vector3 );
    vmathSoaM4Prints( &a_Matrix4, "set to look-at matrix" );
    vmathSoaM4SetCol0( &a_Matrix4, &a_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set col 0" );
    vmathSoaM4SetCol1( &a_Matrix4, &a_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set col 1" );
    vmathSoaM4SetCol2( &a_Matrix4, &a_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set col 2" );
    vmathSoaM4SetCol3( &a_Matrix4, &a_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set col 3" );
    vmathSoaM4GetCol0( &tmpV4_0, &a_Matrix4 );
    vmathSoaV4Prints( &tmpV4_0, "Matrix4 get col 0" );
    vmathSoaM4GetCol1( &tmpV4_1, &a_Matrix4 );
    vmathSoaV4Prints( &tmpV4_1, "Matrix4 get col 1" );
    vmathSoaM4GetCol2( &tmpV4_2, &a_Matrix4 );
    vmathSoaV4Prints( &tmpV4_2, "Matrix4 get col 2" );
    vmathSoaM4GetCol3( &tmpV4_3, &a_Matrix4 );
    vmathSoaV4Prints( &tmpV4_3, "Matrix4 get col 3" );
    vmathSoaM4SetCol( &a_Matrix4, 0, &b_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set col 0" );
    vmathSoaM4SetCol( &a_Matrix4, 1, &b_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set col 1" );
    vmathSoaM4SetCol( &a_Matrix4, 2, &b_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set col 2" );
    vmathSoaM4SetCol( &a_Matrix4, 3, &b_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set col 3" );
    vmathSoaM4GetCol( &tmpV4_4, &a_Matrix4, 0 );
    vmathSoaV4Prints( &tmpV4_4, "Matrix4 get col 0" );
    vmathSoaM4GetCol( &tmpV4_5, &a_Matrix4, 1 );
    vmathSoaV4Prints( &tmpV4_5, "Matrix4 get col 1" );
    vmathSoaM4GetCol( &tmpV4_6, &a_Matrix4, 2 );
    vmathSoaV4Prints( &tmpV4_6, "Matrix4 get col 2" );
    vmathSoaM4GetCol( &tmpV4_7, &a_Matrix4, 3 );
    vmathSoaV4Prints( &tmpV4_7, "Matrix4 get col 3" );
    vmathSoaM4SetRow( &a_Matrix4, 0, &a_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set row 0" );
    vmathSoaM4SetRow( &a_Matrix4, 1, &a_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set row 1" );
    vmathSoaM4SetRow( &a_Matrix4, 2, &a_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set row 2" );
    vmathSoaM4SetRow( &a_Matrix4, 3, &a_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set row 3" );
    vmathSoaM4GetRow( &tmpV4_8, &a_Matrix4, 0 );
    vmathSoaV4Prints( &tmpV4_8, "Matrix4 get row 0" );
    vmathSoaM4GetRow( &tmpV4_9, &a_Matrix4, 1 );
    vmathSoaV4Prints( &tmpV4_9, "Matrix4 get row 1" );
    vmathSoaM4GetRow( &tmpV4_10, &a_Matrix4, 2 );
    vmathSoaV4Prints( &tmpV4_10, "Matrix4 get row 2" );
    vmathSoaM4GetRow( &tmpV4_11, &a_Matrix4, 3 );
    vmathSoaV4Prints( &tmpV4_11, "Matrix4 get row 3" );
    vmathSoaM4SetCol( &a_Matrix4, 0, &a_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "set " );
    vmathSoaM4SetCol( &a_Matrix4, 1, &a_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "set " );
    vmathSoaM4SetCol( &a_Matrix4, 2, &a_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "set " );
    vmathSoaM4SetCol( &a_Matrix4, 3, &a_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "set " );
    vmathSoaM4GetCol( &tmpV4_12, &a_Matrix4, 0 );
    vmathSoaV4Prints( &tmpV4_12, "get " );
    vmathSoaM4GetCol( &tmpV4_13, &a_Matrix4, 1 );
    vmathSoaV4Prints( &tmpV4_13, "get " );
    vmathSoaM4GetCol( &tmpV4_14, &a_Matrix4, 2 );
    vmathSoaV4Prints( &tmpV4_14, "get " );
    vmathSoaM4GetCol( &tmpV4_15, &a_Matrix4, 3 );
    vmathSoaV4Prints( &tmpV4_15, "get " );
    vmathSoaM4SetElem( &a_Matrix4, 0, 0, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 0, 1, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 0, 2, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 0, 3, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 1, 0, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 1, 1, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 1, 2, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 1, 3, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 2, 0, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 2, 1, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 2, 2, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 2, 3, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 3, 0, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 3, 1, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 3, 2, randfloat() );
    vmathSoaM4SetElem( &a_Matrix4, 3, 3, randfloat() );
    vmathSoaM4Prints( &a_Matrix4, "Matrix4 set elements" );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 0, 0 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 0, 1 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 0, 2 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 0, 3 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 1, 0 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 1, 1 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 1, 2 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 1, 3 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 2, 0 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 2, 1 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 2, 2 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 2, 3 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 3, 0 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 3, 1 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 3, 2 )) );
    printf("%f\n", getfloat(vmathSoaM4GetElem( &a_Matrix4, 3, 3 )) );
}

void
Transform3_methods_test()
{
    VmathSoaMatrix3 a_Matrix3, b_Matrix3;
    VmathSoaMatrix4 a_Matrix4, b_Matrix4;
    VmathSoaTransform3 a_Transform3, b_Transform3;
    VmathSoaVector3 a_Vector3, b_Vector3, c_Vector3, d_Vector3;
    VmathSoaVector4 a_Vector4, b_Vector4, c_Vector4, d_Vector4;
    VmathSoaPoint3 a_Point3, b_Point3, c_Point3, d_Point3;
    VmathSoaQuat a_Quat, b_Quat, c_Quat, d_Quat;
    VmathSoaVector3 tmpV3_0, tmpV3_1, tmpV3_2, tmpV3_3, tmpV3_4, tmpV3_5, tmpV3_6, tmpV3_7, tmpV3_8, tmpV3_9;
    VmathSoaVector4 tmpV4_0, tmpV4_1, tmpV4_2;
    VmathSoaVector3 tmpV3_10, tmpV3_11, tmpV3_12, tmpV3_13;
    vec_float4 rndflt1, rndflt2, rndflt3, rndflt4, rndflt5, rndflt6;
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &a_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaV3MakeFromElems( &b_Vector3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &c_Vector3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &d_Vector3, rndflt1, rndflt2, rndflt3 );
    vmathSoaV3Prints( &a_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &b_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &c_Vector3, "set Vector3 with floats" );
    vmathSoaV3Prints( &d_Vector3, "set Vector3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &a_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaV4MakeFromElems( &b_Vector4, rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &c_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaV4MakeFromElems( &d_Vector4, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaV4Prints( &a_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &b_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &c_Vector4, "set Vector4 with floats" );
    vmathSoaV4Prints( &d_Vector4, "set Vector4 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &a_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaP3MakeFromElems( &b_Point3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &c_Point3, rndflt1, rndflt2, rndflt3 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaP3MakeFromElems( &d_Point3, rndflt1, rndflt2, rndflt3 );
    vmathSoaP3Prints( &a_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &b_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &c_Point3, "set Point3 with floats" );
    vmathSoaP3Prints( &d_Point3, "set Point3 with floats" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &a_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    rndflt5 = randfloat();
    rndflt6 = randfloat();
    vmathSoaQMakeFromElems( &b_Quat, rndflt3, rndflt4, rndflt5, rndflt6 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &c_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    rndflt4 = randfloat();
    vmathSoaQMakeFromElems( &d_Quat, rndflt1, rndflt2, rndflt3, rndflt4 );
    vmathSoaQPrints( &a_Quat, "set Quat with floats" );
    vmathSoaQPrints( &b_Quat, "set Quat with floats" );
    vmathSoaQPrints( &c_Quat, "set Quat with floats" );
    vmathSoaQPrints( &d_Quat, "set Quat with floats" );
    vmathSoaM3MakeFromCols( &a_Matrix3, &a_Vector3, &b_Vector3, &c_Vector3 );
    vmathSoaM3MakeFromCols( &b_Matrix3, &d_Vector3, &a_Vector3, &b_Vector3 );
    vmathSoaM3Prints( &a_Matrix3, "set Matrix3 columns" );
    vmathSoaM3Prints( &b_Matrix3, "set Matrix3 columns" );
    vmathSoaM4MakeFromCols( &a_Matrix4, &a_Vector4, &b_Vector4, &c_Vector4, &d_Vector4 );
    vmathSoaM4MakeFromCols( &b_Matrix4, &d_Vector4, &a_Vector4, &b_Vector4, &c_Vector4 );
    vmathSoaM4Prints( &a_Matrix4, "set Matrix4 columns" );
    vmathSoaM4Prints( &b_Matrix4, "set Matrix4 columns" );
    vmathSoaT3MakeFromCols( &a_Transform3, &a_Vector3, &b_Vector3, &c_Vector3, &d_Vector3 );
    vmathSoaT3MakeFromCols( &b_Transform3, &d_Vector3, &a_Vector3, &b_Vector3, &c_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "set Transform3 columns" );
    vmathSoaT3Prints( &b_Transform3, "set Transform3 columns" );
    vmathSoaT3MakeFromM3V3( &a_Transform3, &a_Matrix3, &a_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "construct Transform3 with Matrix3 and Vector3" );
    vmathSoaT3MakeFromQV3( &a_Transform3, &a_Quat, &a_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "construct Transform3 with Quat and Vector3" );
    vmathSoaT3Copy( &a_Transform3, &b_Transform3 );
    vmathSoaT3Prints( &a_Transform3, "assign to Transform3 from Transform3" );
    vmathSoaT3MakeFromScalar( &a_Transform3, randfloat() );
    vmathSoaT3Prints( &a_Transform3, "set Transform3 with float" );
    vmathSoaT3MakeFromScalar( &a_Transform3, randfloat() );
    vmathSoaT3Prints( &a_Transform3, "set Transform3 with float" );
    vmathSoaT3MakeFromScalar( &a_Transform3, (vec_float4){0.0f} );
    vmathSoaT3Prints( &a_Transform3, "set elements to zero" );
    vmathSoaT3MakeIdentity( &a_Transform3 );
    vmathSoaT3Prints( &a_Transform3, "set to identity" );
    vmathSoaT3MakeRotationX( &a_Transform3, randfloat() );
    vmathSoaT3Prints( &a_Transform3, "set to rotationX" );
    vmathSoaT3MakeRotationY( &a_Transform3, randfloat() );
    vmathSoaT3Prints( &a_Transform3, "set to rotationY" );
    vmathSoaT3MakeRotationZ( &a_Transform3, randfloat() );
    vmathSoaT3Prints( &a_Transform3, "set to rotationZ" );
    rndflt1 = randfloat();
    rndflt2 = randfloat();
    rndflt3 = randfloat();
    vmathSoaV3MakeFromElems( &tmpV3_0, rndflt3, rndflt2, rndflt1 );
    vmathSoaT3MakeRotationZYX( &a_Transform3, &tmpV3_0 );
    vmathSoaT3Prints( &a_Transform3, "set to rotation from Z,Y,X angles" );
    vmathSoaV3Normalize( &tmpV3_1, &a_Vector3 );
    vmathSoaT3MakeRotationAxis( &a_Transform3, randfloat(), &tmpV3_1 );
    vmathSoaT3Prints( &a_Transform3, "set to rotation from axis angle" );
    vmathSoaT3MakeTranslation( &a_Transform3, &a_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "set to translation" );
    vmathSoaT3SetCol0( &a_Transform3, &a_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "Transform3 set col 0" );
    vmathSoaT3SetCol1( &a_Transform3, &a_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "Transform3 set col 1" );
    vmathSoaT3SetCol2( &a_Transform3, &a_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "Transform3 set col 2" );
    vmathSoaT3SetCol3( &a_Transform3, &a_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "Transform3 set col 3" );
    vmathSoaT3GetCol0( &tmpV3_2, &a_Transform3 );
    vmathSoaV3Prints( &tmpV3_2, "Transform3 get col 0" );
    vmathSoaT3GetCol1( &tmpV3_3, &a_Transform3 );
    vmathSoaV3Prints( &tmpV3_3, "Transform3 get col 1" );
    vmathSoaT3GetCol2( &tmpV3_4, &a_Transform3 );
    vmathSoaV3Prints( &tmpV3_4, "Transform3 get col 2" );
    vmathSoaT3GetCol3( &tmpV3_5, &a_Transform3 );
    vmathSoaV3Prints( &tmpV3_5, "Transform3 get col 3" );
    vmathSoaT3SetCol( &a_Transform3, 0, &b_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "Transform3 set col 0" );
    vmathSoaT3SetCol( &a_Transform3, 1, &b_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "Transform3 set col 1" );
    vmathSoaT3SetCol( &a_Transform3, 2, &b_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "Transform3 set col 2" );
    vmathSoaT3SetCol( &a_Transform3, 3, &b_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "Transform3 set col 3" );
    vmathSoaT3GetCol( &tmpV3_6, &a_Transform3, 0 );
    vmathSoaV3Prints( &tmpV3_6, "Transform3 get col 0" );
    vmathSoaT3GetCol( &tmpV3_7, &a_Transform3, 1 );
    vmathSoaV3Prints( &tmpV3_7, "Transform3 get col 1" );
    vmathSoaT3GetCol( &tmpV3_8, &a_Transform3, 2 );
    vmathSoaV3Prints( &tmpV3_8, "Transform3 get col 2" );
    vmathSoaT3GetCol( &tmpV3_9, &a_Transform3, 3 );
    vmathSoaV3Prints( &tmpV3_9, "Transform3 get col 3" );
    vmathSoaT3SetRow( &a_Transform3, 0, &a_Vector4 );
    vmathSoaT3Prints( &a_Transform3, "Transform3 set row 0" );
    vmathSoaT3SetRow( &a_Transform3, 1, &a_Vector4 );
    vmathSoaT3Prints( &a_Transform3, "Transform3 set row 1" );
    vmathSoaT3SetRow( &a_Transform3, 2, &a_Vector4 );
    vmathSoaT3Prints( &a_Transform3, "Transform3 set row 2" );
    vmathSoaT3GetRow( &tmpV4_0, &a_Transform3, 0 );
    vmathSoaV4Prints( &tmpV4_0, "Transform3 get row 0" );
    vmathSoaT3GetRow( &tmpV4_1, &a_Transform3, 1 );
    vmathSoaV4Prints( &tmpV4_1, "Transform3 get row 1" );
    vmathSoaT3GetRow( &tmpV4_2, &a_Transform3, 2 );
    vmathSoaV4Prints( &tmpV4_2, "Transform3 get row 2" );
    vmathSoaT3SetCol( &a_Transform3, 0, &a_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "set " );
    vmathSoaT3SetCol( &a_Transform3, 1, &a_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "set " );
    vmathSoaT3SetCol( &a_Transform3, 2, &a_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "set " );
    vmathSoaT3SetCol( &a_Transform3, 3, &a_Vector3 );
    vmathSoaT3Prints( &a_Transform3, "set " );
    vmathSoaT3GetCol( &tmpV3_10, &a_Transform3, 0 );
    vmathSoaV3Prints( &tmpV3_10, "get " );
    vmathSoaT3GetCol( &tmpV3_11, &a_Transform3, 1 );
    vmathSoaV3Prints( &tmpV3_11, "get " );
    vmathSoaT3GetCol( &tmpV3_12, &a_Transform3, 2 );
    vmathSoaV3Prints( &tmpV3_12, "get " );
    vmathSoaT3GetCol( &tmpV3_13, &a_Transform3, 3 );
    vmathSoaV3Prints( &tmpV3_13, "get " );
    vmathSoaT3SetElem( &a_Transform3, 0, 0, randfloat() );
    vmathSoaT3SetElem( &a_Transform3, 0, 1, randfloat() );
    vmathSoaT3SetElem( &a_Transform3, 0, 2, randfloat() );
    vmathSoaT3SetElem( &a_Transform3, 1, 0, randfloat() );
    vmathSoaT3SetElem( &a_Transform3, 1, 1, randfloat() );
    vmathSoaT3SetElem( &a_Transform3, 1, 2, randfloat() );
    vmathSoaT3SetElem( &a_Transform3, 2, 0, randfloat() );
    vmathSoaT3SetElem( &a_Transform3, 2, 1, randfloat() );
    vmathSoaT3SetElem( &a_Transform3, 2, 2, randfloat() );
    vmathSoaT3SetElem( &a_Transform3, 3, 0, randfloat() );
    vmathSoaT3SetElem( &a_Transform3, 3, 1, randfloat() );
    vmathSoaT3SetElem( &a_Transform3, 3, 2, randfloat() );
    vmathSoaT3Prints( &a_Transform3, "Transform3 set elements" );
    printf("%f\n", getfloat(vmathSoaT3GetElem( &a_Transform3, 0, 0 )) );
    printf("%f\n", getfloat(vmathSoaT3GetElem( &a_Transform3, 0, 1 )) );
    printf("%f\n", getfloat(vmathSoaT3GetElem( &a_Transform3, 0, 2 )) );
    printf("%f\n", getfloat(vmathSoaT3GetElem( &a_Transform3, 1, 0 )) );
    printf("%f\n", getfloat(vmathSoaT3GetElem( &a_Transform3, 1, 1 )) );
    printf("%f\n", getfloat(vmathSoaT3GetElem( &a_Transform3, 1, 2 )) );
    printf("%f\n", getfloat(vmathSoaT3GetElem( &a_Transform3, 2, 0 )) );
    printf("%f\n", getfloat(vmathSoaT3GetElem( &a_Transform3, 2, 1 )) );
    printf("%f\n", getfloat(vmathSoaT3GetElem( &a_Transform3, 2, 2 )) );
    printf("%f\n", getfloat(vmathSoaT3GetElem( &a_Transform3, 3, 0 )) );
    printf("%f\n", getfloat(vmathSoaT3GetElem( &a_Transform3, 3, 1 )) );
    printf("%f\n", getfloat(vmathSoaT3GetElem( &a_Transform3, 3, 2 )) );
}

int main()
{
    int i;
    printf("\n __begin__ \n");
    for ( i = 0; i < 2; i++ ) {
        Matrix3_methods_test();
        Matrix4_methods_test();
        Transform3_methods_test();
    }
    printf("\n __end__ \n");
    return 0;
}
