/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.spelling.CachingWordListLoader;
import org.languagetool.rules.spelling.SpellingCheckRule;

public class WordListValidatorTest {
    private static final String VALID_CHARS = "[ 0-9a-zA-Z\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df\u00eb\u00e7\u00e8\u00e9\u00e1\u00e0\u00f3\u00f2\u00c8\u00c9\u00c1\u00c0\u00d3\u00d2\u00cd\u00e3\u00f1\u00ed\u00ee\u015e\u015f&*_:\\\\___INSERT___\u0152\u20ac\u016b\u03b1\u0391\u03b2\u0392\u03b3\u0263\u0393\u03b4\u0394\u03b5\u0395\u03b6\u0396\u03b7\u0397\u03b8\u0398\u03b9\u0399\u03ba\u039a\u03bb\u039b\u03bc\u039c\u03bd\u039d\u03be\u039e\u03bf\u039f\u03c0\u03a0\u03c1\u03a1\u03c3\u03a3\u03c4\u03a4\u03c5\u03a5\u03c6\u03a6\u03c7\u03a7\u03c8\u03a8\u03c9\u03a9\u03ac\u0386\u03ad\u0388\u03af\u038a\u03ae\u0389\u03cd\u038e\u03ca\u03cb\u03b0\u0390\u0153\u0163\u0142\u0144\u015a\u015b\u014c\u014d\u017c\u00fa\u00ef\u00ce\u00f4\u00ea\u00e2\u00fb\u00c7\u00c3\u00d5\u00da\u00ca\u00c2\u00d4'\u2019./%-]+|[khmcd\u00b5]?m[\u00b2\u00b3]|\u00b0[CFR]|C?O\u2082-?.*|mc\u00b2";
    private static final Set<String> VALID_WORDS = new HashSet<String>(Arrays.asList("H\u00e1\u010dek", "Vara\u017edin/S", "B\u0119dzin", "Ayd\u0131n", "Pore\u010d", "\u010ceferin", "\u010ceferin/S", "Peri\u0161i\u0107", "Peri\u0161i\u0107/S", "Modri\u0107", "Modri\u0107/S", "Mi\u0142osz", "Arnautovi\u0107/S", "Bhagavad-g\u012bt\u0101", "S\u00f8nderjylland/S", "Ut\u00f8ya/S", "Bo\u017eena/S", "Br\u0103ila/S", "Timi\u0219oara/S", "Troms\u00f8/S", "Solidarno\u015b\u0107", "Salihamid\u017ei\u0107/S", "Poro\u0161enko", "Poro\u0161enko/S", "Dar\u02bf\u0101", "veni, vidi, vici", "Food+Tech Connect", "comme ci, comme \u00e7a", "Robinson + Yu", "her\u00f5on", "her\u00f5ons", "V\u00f5ro", "\u0141ukasz", "\u010cakavian", "Erdo\u011fan", "R\u0103dulescu", "\u0160tokavian", "Veliko T\u0103rnovo", "Br\u0101hma\u1e47a", "Forl\u00ec-Cesena", "H\u00e1rbar\u00f0slj\u00f3\u00f0", "Hass\u0101n\u012bya", "Hyndlulj\u00f3\u00f0", "Kazanl\u01cek", "Kes\u00e4ranta", "Kri\u0161j\u0101nis", "K\u016drdzhali", "Malko T\u016drnovo", "R\u00edgs\u00feula", "Savit\u1e5b", "Vaf\u00fer\u00fa\u00f0nism\u00e1l", "V\u00f6lundarkvi\u00f0a", "K\u1e5b\u1e63\u1e47a", "art.\u00ba", "Klaip\u0117da", "Mondel\u0113z", "chef-d\u2019\u0153uvre", "chefs-d\u2019\u0153uvre", "Bra\u010d", "Forl\u00ec", "Qur\u2019an", "Kari\u0146\u0161", "Djuve\u010d", "Djuve\u010dreis", "\u00c7avu\u015fo\u011flu", "\u00c7avu\u015fo\u011flu/S", "Hidsch\u0101b/S", "Dvo\u0159\u00e1k/S", "Constan\u021ba", "Constan\u021ba/S", "Paul Erd\u0151s", "Erdo\u011fan/S", "S\u00f8rensen/S", "S\u00f8rensen", "S\u00f8ren/S", "S\u00f8ren", "Rados\u0142aw", "Rados\u0142aw/S", "Jaros\u0142aw", "Jaros\u0142aw/S", "W\u0142adys\u0142aw/S", "\u015eahin/S", "U\u011fur/S", "J\u00f8rgensen/S", "J\u00f8rgensen", "\u00c5ngstr\u00f6m", "\u00e5ngstr\u00f6m", "\u00e5ngstr\u00f6ms", "'Ndrangheta", "H\u1ed3 Ch\u00ed Minh", "McDonald's", "Bahr\u0101m", "K\u0119stutis", "\u00b5m", "\u00b5g", "\u00b5l", "CD&V", "C&A", "P&O", "S&P", "\u010cSSR", "V&D", "Lo\u00efc/S", "\u0130lkay", "G\u00fcndo\u011fan", "Tu\u011frul", "K\u012blauea", "M\u0101ori", "Chi\u0219in\u0103u", "Chi\u0219in\u0103u/S", "Terzi\u0107", "J\u016bjutsu/S", "\u00d1u\u00f1oa", "Stevanovi\u0107", "B\u00f8rge", "B\u00f8rge/S", "Bj\u00f8rn Gulden/S", "Sn\u00e6fellsj\u00f6kull/S", "Vi\u0161egrad/S", "Cle\u0301ment/S", "Sn\u00e6fellsj\u00f6kull", "Sk\u00e5neland", "\u00d8resund", "Joki\u0107", "Ibi\u0161evi\u0107", "Fr\u00ed\u00f0ur", "\u0141\u00f3d\u017a", "\u00d8rsted", "Sams\u00f8/S", "K\u0131l\u0131\u00e7daro\u011flu/S", "Vlahovi\u0107/S", "S\u00f8nderborg/S", "S\u00f8nderborg", "Miroti\u0107", "Suboti\u0107", "P\u00ffur", "Suba\u0161i\u0107", "Wa\u0142\u0119sa", "celebryt\u0119", "antybiotykoterapi\u0119", "elektromobilno\u015b\u0107", "kryptowalut\u0119", "fotowoltaik\u0119", "insulinooporno\u015b\u0107", "infografik\u0119", "dt\u00aa", "dt\u00ba", "\u00aa", "\u00ba", "\u0109i", "R$", "\u0391", "\u0392", "\u0393", "\u0394", "\u0395", "\u0396", "\u0397", "\u0398", "\u0399", "\u039a", "\u039b", "\u039c", "\u039d", "\u039e", "\u039f", "\u03a0", "\u03a1", "\u03a3", "\u03a4", "\u03a5", "\u03a6", "\u03a7", "\u03a8", "\u03a9", "\u03b1", "\u03b2", "\u03b3", "\u03b4", "\u03b5", "\u03b6", "\u03b7", "\u03b8", "\u03b9", "\u03ba", "\u03bb", "\u03bc", "\u03bd", "\u03be", "\u03bf", "\u03c0", "\u03c1", "\u03c3", "\u03c4", "\u03c5", "\u03c6", "\u03c7", "\u03c8", "\u03c9"));
    private final String additionalValidationChars;

    public WordListValidatorTest() {
        this("");
    }

    public WordListValidatorTest(String additionalValidationChars) {
        this.additionalValidationChars = additionalValidationChars;
    }

    public void testWordListValidity(Language lang) {
        if (lang.getShortCode().equals("ru")) {
            return;
        }
        HashSet<String> checked = new HashSet<String>();
        JLanguageTool lt = new JLanguageTool(lang);
        List rules = lt.getAllActiveRules();
        for (Rule rule : rules) {
            if (!(rule instanceof SpellingCheckRule)) continue;
            SpellingCheckRule sRule = (SpellingCheckRule)rule;
            String file = sRule.getSpellingFileName();
            if (!JLanguageTool.getDataBroker().resourceExists(file) || checked.contains(file)) continue;
            System.out.println("Checking validity of word list file " + file);
            CachingWordListLoader loader = new CachingWordListLoader();
            List words = loader.loadWords(file);
            this.validateWords(words, file);
            checked.add(file);
        }
    }

    private void validateWords(List<String> words, String spellingFileName) {
        ArrayList<String> failures = new ArrayList<String>();
        String validChars = VALID_CHARS.replace("___INSERT___", this.additionalValidationChars);
        Pattern validPattern = Pattern.compile(validChars);
        for (String word : words) {
            if (VALID_WORDS.contains(word) || VALID_WORDS.contains(word.trim()) || validPattern.matcher(word).matches()) continue;
            failures.add("Word '" + word + "' from " + spellingFileName + " doesn't match regex: " + validChars + " - please fix the word or add the character to the language's " + WordListValidatorTest.class.getName() + " if it's valid");
        }
        if (failures.size() > 0) {
            TestCase.fail((String)String.join((CharSequence)"\n\n", failures));
        }
    }
}

