/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import com.google.common.base.Strings;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Experimental;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.rules.spelling.CachingWordListLoader;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrderer;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrdererFeatureExtractor;
import org.languagetool.rules.spelling.suggestions.SuggestionsRanker;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tools.StringTools;

public abstract class SpellingCheckRule
extends Rule {
    public static final float HIGH_CONFIDENCE = 0.99f;
    public static final String LANGUAGETOOL = "LanguageTool";
    public static final String LANGUAGETOOLER = "LanguageTooler";
    public static final int MAX_TOKEN_LENGTH = 200;
    protected final Language language;
    @Nullable
    protected LanguageModel languageModel;
    protected final CachingWordListLoader wordListLoader = new CachingWordListLoader();
    private static final String SPELLING_IGNORE_FILE = "/hunspell/ignore.txt";
    private static final String SPELLING_FILE = "/hunspell/spelling.txt";
    private static final String CUSTOM_SPELLING_FILE = "/hunspell/spelling_custom.txt";
    private static final String GLOBAL_SPELLING_FILE = "spelling_global.txt";
    private static final String SPELLING_PROHIBIT_FILE = "/hunspell/prohibit.txt";
    private static final String CUSTOM_SPELLING_PROHIBIT_FILE = "/hunspell/prohibit_custom.txt";
    private static final String SPELLING_FILE_VARIANT = null;
    private final Set<String> wordsToBeProhibited = new THashSet();
    private volatile String[] wordsToBeIgnoredDictionary = null;
    private volatile String[] wordsToBeIgnoredDictionaryIgnoreCase = null;
    private List<DisambiguationPatternRule> antiPatterns = new ArrayList<DisambiguationPatternRule>();
    private boolean considerIgnoreWords = true;
    private boolean convertsCase = false;
    protected final Set<String> wordsToBeIgnored = new THashSet();
    protected int ignoreWordsWithLength = 0;
    private final Pattern pHasNoLetterLatin = Pattern.compile("^[^\\p{script=latin}]+$");
    private final Pattern pHasNoLetter = Pattern.compile("^[^\\p{L}]+$");

    public SpellingCheckRule(ResourceBundle messages, Language language, UserConfig userConfig) {
        this(messages, language, userConfig, Collections.emptyList());
    }

    public SpellingCheckRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) {
        this(messages, language, userConfig, altLanguages, null);
    }

    public SpellingCheckRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages, @Nullable LanguageModel languageModel) {
        super(messages);
        this.language = language;
        this.languageModel = languageModel;
        if (userConfig != null) {
            this.wordsToBeIgnored.addAll(userConfig.getAcceptedWords());
        }
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
    }

    protected static void addSuggestionsToRuleMatch(String word, List<SuggestedReplacement> userCandidatesList, List<SuggestedReplacement> candidatesList, @Nullable SuggestionsOrderer orderer, RuleMatch match) {
        AnalyzedSentence sentence = match.getSentence();
        List<String> userCandidates = userCandidatesList.stream().map(SuggestedReplacement::getReplacement).collect(Collectors.toList());
        List<String> candidates = candidatesList.stream().map(SuggestedReplacement::getReplacement).collect(Collectors.toList());
        int startPos = match.getFromPos();
        if (orderer != null && orderer.isMlAvailable()) {
            if (orderer instanceof SuggestionsRanker) {
                SuggestionsRanker ranker = (SuggestionsRanker)orderer;
                List<SuggestedReplacement> defaultSuggestions = ranker.orderSuggestions(candidates, word, sentence, startPos);
                if (!defaultSuggestions.isEmpty()) {
                    if (userCandidates.isEmpty()) {
                        match.setAutoCorrect(ranker.shouldAutoCorrect(defaultSuggestions));
                        match.setSuggestedReplacementObjects(defaultSuggestions);
                    } else {
                        ArrayList<SuggestedReplacement> combinedSuggestions = new ArrayList<SuggestedReplacement>();
                        for (String wordFromUserDict : userCandidates) {
                            SuggestedReplacement s = new SuggestedReplacement(wordFromUserDict);
                            combinedSuggestions.add(s);
                        }
                        combinedSuggestions.addAll(defaultSuggestions);
                        match.setSuggestedReplacementObjects(combinedSuggestions);
                        match.setAutoCorrect(false);
                    }
                }
            } else if (orderer instanceof SuggestionsOrdererFeatureExtractor) {
                if (userCandidates.size() != 0) {
                    throw new IllegalStateException("SuggestionsOrdererFeatureExtractor does not support suggestions from personal dictionaries at the moment.");
                }
                SuggestionsOrdererFeatureExtractor featureExtractor = (SuggestionsOrdererFeatureExtractor)orderer;
                Pair<List<SuggestedReplacement>, SortedMap<String, Float>> suggestions = featureExtractor.computeFeatures(candidates, word, sentence, startPos);
                match.setSuggestedReplacementObjects((List)suggestions.getLeft());
                match.setFeatures((SortedMap)suggestions.getRight());
            } else {
                ArrayList<SuggestedReplacement> combinedSuggestions = new ArrayList<SuggestedReplacement>();
                combinedSuggestions.addAll(orderer.orderSuggestions(userCandidates, word, sentence, startPos));
                combinedSuggestions.addAll(orderer.orderSuggestions(candidates, word, sentence, startPos));
                match.setSuggestedReplacementObjects(combinedSuggestions);
            }
        } else {
            ArrayList<SuggestedReplacement> combinedSuggestions = new ArrayList<SuggestedReplacement>(match.getSuggestedReplacementObjects());
            combinedSuggestions.addAll(userCandidatesList);
            combinedSuggestions.addAll(candidatesList);
            match.setSuggestedReplacementObjects(combinedSuggestions);
        }
    }

    protected RuleMatch createWrongSplitMatch(AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar, int pos, String coveredWord, String suggestion1, String suggestion2, int prevPos) {
        RuleMatch prevMatch;
        if (ruleMatchesSoFar.size() > 0 && (prevMatch = ruleMatchesSoFar.get(ruleMatchesSoFar.size() - 1)).getFromPos() == prevPos) {
            ruleMatchesSoFar.remove(ruleMatchesSoFar.size() - 1);
        }
        RuleMatch ruleMatch = new RuleMatch(this, sentence, prevPos, pos + coveredWord.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
        ruleMatch.setSuggestedReplacement((suggestion1 + " " + suggestion2).trim());
        return ruleMatch;
    }

    @Override
    public abstract String getId();

    @Override
    public abstract String getDescription();

    @Override
    public abstract RuleMatch[] match(AnalyzedSentence var1) throws IOException;

    @Experimental
    public abstract boolean isMisspelled(String var1) throws IOException;

    @Override
    public boolean isDictionaryBasedSpellingRule() {
        return true;
    }

    public void addIgnoreTokens(List<String> tokens) {
        this.wordsToBeIgnored.addAll(tokens);
    }

    private void updateIgnoredWordDictionary() {
        this.wordsToBeIgnoredDictionaryIgnoreCase = null;
        this.wordsToBeIgnoredDictionary = null;
    }

    public void setConsiderIgnoreWords(boolean considerIgnoreWords) {
        this.considerIgnoreWords = considerIgnoreWords;
    }

    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        ArrayList<String> moreSuggestions = new ArrayList<String>();
        if (("Languagetool".equals(word) || "languagetool".equals(word)) && suggestions.stream().noneMatch(k -> k.getReplacement().equals(LANGUAGETOOL))) {
            moreSuggestions.add(LANGUAGETOOL);
        }
        if (("Languagetooler".equals(word) || "languagetooler".equals(word)) && suggestions.stream().noneMatch(k -> k.getReplacement().equals(LANGUAGETOOLER))) {
            moreSuggestions.add(LANGUAGETOOLER);
        }
        return SuggestedReplacement.convert(moreSuggestions);
    }

    protected List<SuggestedReplacement> getOnlySuggestions(String word) {
        return Collections.emptyList();
    }

    protected List<SuggestedReplacement> getAdditionalSuggestions(List<SuggestedReplacement> suggestions, String word) {
        return Collections.emptyList();
    }

    protected boolean ignoreToken(AnalyzedTokenReadings[] tokens, int idx) throws IOException {
        ArrayList<String> words = new ArrayList<String>();
        for (AnalyzedTokenReadings token : tokens) {
            words.add(token.getToken());
        }
        return this.ignoreWord(words, idx);
    }

    protected boolean ignoreWord(String word) throws IOException {
        if (word.length() > 200) {
            return true;
        }
        if (!this.considerIgnoreWords) {
            return false;
        }
        Matcher mHasNoLetter = this.isLatinScript() ? this.pHasNoLetterLatin.matcher(word) : this.pHasNoLetter.matcher(word);
        if (mHasNoLetter.matches()) {
            return true;
        }
        if (word.endsWith(".") && !this.isInIgnoredSet(word)) {
            return this.isIgnoredNoCase(word.substring(0, word.length() - 1));
        }
        return this.isIgnoredNoCase(word);
    }

    protected boolean isInIgnoredSet(String word) {
        return this.wordsToBeIgnored.contains(word);
    }

    protected boolean isIgnoredNoCase(String word) {
        return this.isInIgnoredSet(word) || this.convertsCase && this.isInIgnoredSet(word.toLowerCase(this.language.getLocale())) || this.ignoreWordsWithLength > 0 && word.length() <= this.ignoreWordsWithLength;
    }

    protected boolean ignoreWord(List<String> words, int idx) throws IOException {
        return this.ignoreWord(words.get(idx));
    }

    public void setConvertsCase(boolean convertsCase) {
        this.convertsCase = convertsCase;
    }

    protected static boolean isUrl(String token) {
        return WordTokenizer.isUrl(token);
    }

    protected static boolean isEMail(String token) {
        return WordTokenizer.isEMail(token);
    }

    protected static <T> List<T> filterDupes(List<T> words) {
        return words.stream().distinct().collect(Collectors.toList());
    }

    protected synchronized void init() throws IOException {
        for (String ignoreWord : this.wordListLoader.loadWords(this.getIgnoreFileName())) {
            this.addIgnoreWords(ignoreWord);
        }
        if (this.getSpellingFileName() != null) {
            for (String ignoreWord : this.wordListLoader.loadWords(this.getSpellingFileName())) {
                this.addIgnoreWords(ignoreWord);
            }
        }
        for (String fileName : this.getAdditionalSpellingFileNames()) {
            if (!JLanguageTool.getDataBroker().resourceExists(fileName)) continue;
            for (String ignoreWord : this.wordListLoader.loadWords(fileName)) {
                this.addIgnoreWords(ignoreWord);
            }
        }
        this.updateIgnoredWordDictionary();
        for (String prohibitedWord : this.wordListLoader.loadWords(this.getProhibitFileName())) {
            this.addProhibitedWords(this.expandLine(prohibitedWord));
        }
        for (String fileName : this.getAdditionalProhibitFileNames()) {
            for (String prohibitedWord : this.wordListLoader.loadWords(fileName)) {
                this.addProhibitedWords(this.expandLine(prohibitedWord));
            }
        }
    }

    protected String getIgnoreFileName() {
        return this.language.getShortCode() + SPELLING_IGNORE_FILE;
    }

    public String getSpellingFileName() {
        return this.language.getShortCode() + SPELLING_FILE;
    }

    public List<String> getAdditionalSpellingFileNames() {
        return Arrays.asList(this.language.getShortCode() + CUSTOM_SPELLING_FILE, GLOBAL_SPELLING_FILE);
    }

    public String getLanguageVariantSpellingFileName() {
        return SPELLING_FILE_VARIANT;
    }

    protected String getProhibitFileName() {
        return this.language.getShortCode() + SPELLING_PROHIBIT_FILE;
    }

    protected List<String> getAdditionalProhibitFileNames() {
        return Collections.singletonList(this.language.getShortCode() + CUSTOM_SPELLING_PROHIBIT_FILE);
    }

    protected boolean isProhibited(String word) {
        return this.wordsToBeProhibited.contains(word);
    }

    protected List<SuggestedReplacement> filterSuggestions(List<SuggestedReplacement> suggestions) {
        suggestions.removeIf(suggestion -> this.isProhibited(suggestion.getReplacement()));
        ArrayList<SuggestedReplacement> newSuggestions = new ArrayList();
        for (SuggestedReplacement suggestion2 : suggestions) {
            String suggestionWithoutS;
            String replacement = suggestion2.getReplacement();
            String string = suggestionWithoutS = replacement.length() > 3 ? replacement.substring(0, replacement.length() - 2) : "";
            if (replacement.endsWith(" s") && this.isProperNoun(suggestionWithoutS)) {
                SuggestedReplacement sugg1 = new SuggestedReplacement(suggestionWithoutS);
                sugg1.setType(SuggestedReplacement.SuggestionType.Curated);
                newSuggestions.add(0, sugg1);
                SuggestedReplacement sugg2 = new SuggestedReplacement(suggestionWithoutS + "'s");
                sugg2.setType(SuggestedReplacement.SuggestionType.Curated);
                newSuggestions.add(0, sugg2);
                continue;
            }
            newSuggestions.add(suggestion2);
        }
        newSuggestions = SpellingCheckRule.filterDupes(newSuggestions);
        newSuggestions = this.filterNoSuggestWords(newSuggestions);
        return newSuggestions;
    }

    protected List<SuggestedReplacement> filterNoSuggestWords(List<SuggestedReplacement> l) {
        return l;
    }

    private boolean isProperNoun(String wordWithoutS) {
        try {
            List<AnalyzedTokenReadings> tags = this.language.getTagger().tag(Collections.singletonList(wordWithoutS));
            return tags.stream().anyMatch(k -> k.hasPosTag("NNP"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addIgnoreWords(String line) {
        if (!this.tokenizeNewWords()) {
            this.wordsToBeIgnored.add(line);
        } else {
            List<String> tokens = this.language.getWordTokenizer().tokenize(line);
            if (tokens.size() > 1) {
                ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>(tokens.size());
                for (String token : tokens) {
                    if (token.trim().isEmpty()) continue;
                    patternTokens.add(new PatternToken(token, true, false, false));
                }
                this.antiPatterns.add(new DisambiguationPatternRule("INTERNAL_ANTIPATTERN", "(no description)", this.language, patternTokens, null, null, DisambiguationPatternRule.DisambiguatorAction.IGNORE_SPELLING));
            } else {
                this.wordsToBeIgnored.add(line);
            }
        }
    }

    protected void addProhibitedWords(List<String> words) {
        this.wordsToBeProhibited.addAll(words);
    }

    protected List<String> expandLine(String line) {
        return Collections.singletonList(line);
    }

    public void acceptPhrases(List<String> phrases) {
        ArrayList<List<PatternToken>> antiPatterns = new ArrayList<List<PatternToken>>();
        for (String phrase : phrases) {
            String[] parts = phrase.split(" ");
            ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>();
            int i = 0;
            boolean startsLowercase = false;
            for (String part : parts) {
                if (i == 0 && !part.equals(StringTools.uppercaseFirstChar(part))) {
                    startsLowercase = true;
                }
                patternTokens.add(new PatternTokenBuilder().csToken(part).build());
                ++i;
            }
            antiPatterns.add(patternTokens);
            if (!startsLowercase) continue;
            antiPatterns.add(SpellingCheckRule.getTokensForSentenceStart(parts));
        }
        this.antiPatterns = SpellingCheckRule.makeAntiPatterns(antiPatterns, this.language);
    }

    private static List<PatternToken> getTokensForSentenceStart(String[] parts) {
        ArrayList<PatternToken> ucPatternTokens = new ArrayList<PatternToken>();
        int j = 0;
        for (String part : parts) {
            if (j == 0) {
                String uppercased = StringTools.uppercaseFirstChar(part);
                ucPatternTokens.add(new PatternTokenBuilder().posRegex("SENT_START").build());
                ucPatternTokens.add(new PatternTokenBuilder().csToken(uppercased).build());
            } else {
                ucPatternTokens.add(new PatternTokenBuilder().csToken(part).build());
            }
            ++j;
        }
        return ucPatternTokens;
    }

    @Override
    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns;
    }

    protected int startsWithIgnoredWord(String word, boolean caseSensitive) {
        int result;
        String[] array;
        if (word.length() < 4) {
            return 0;
        }
        Comparator comparator = caseSensitive ? Comparator.naturalOrder() : String.CASE_INSENSITIVE_ORDER;
        String[] stringArray = array = caseSensitive ? this.wordsToBeIgnoredDictionary : this.wordsToBeIgnoredDictionaryIgnoreCase;
        if (array == null) {
            array = (String[])this.wordsToBeIgnored.stream().sorted(comparator).toArray(String[]::new);
            if (caseSensitive) {
                this.wordsToBeIgnoredDictionary = array;
            } else {
                this.wordsToBeIgnoredDictionaryIgnoreCase = array;
            }
        }
        while (!word.isEmpty() && (result = Arrays.binarySearch(array, word, comparator)) < 0) {
            String commonPrefix;
            int prev = -result - 2;
            if (prev < 0) {
                return 0;
            }
            String string = commonPrefix = caseSensitive ? Strings.commonPrefix((CharSequence)word, (CharSequence)array[prev]) : Strings.commonPrefix((CharSequence)word.toLowerCase(Locale.ROOT), (CharSequence)array[prev].toLowerCase(Locale.ROOT));
            assert (commonPrefix.length() < word.length());
            word = caseSensitive ? commonPrefix : word.substring(0, commonPrefix.length());
        }
        return word.length();
    }

    protected boolean tokenizeNewWords() {
        return true;
    }

    protected boolean isLatinScript() {
        return true;
    }
}

